/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-1995, William Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell derivative works of
 * "tgif", and the right to distribute "tgif" for a fee) are
 * reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /u/multimedia/william/X11/TGIF2/RCS/names.c,v 2.133 1995/07/10 01:46:15 william Exp $";
#endif

#include <sys/types.h>
#ifdef VMS
#include "vms_compat.h"
#define DIR_ENTRY struct dirent
#else
#ifdef ibm
#include <sys/dir.h>
#define DIR_ENTRY struct direct
#else
#ifdef apollo
#include <sys/dir.h>
#define DIR_ENTRY struct direct
#else
#ifdef NeXT
#include <sys/dir.h>
#define DIR_ENTRY struct direct
#else
#ifdef luna88k
#include <sys/dir.h>
#define DIR_ENTRY struct direct
#else
#ifdef sequent
#include <sys/dir.h>
#define DIR_ENTRY struct direct
#else
#include <dirent.h>
#define DIR_ENTRY struct dirent
#endif
#endif
#endif
#endif
#endif
#endif
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include "const.h"
#include "types.h"

#include "auxtext.e"
#include "box.e"
#include "button.e"
#include "copypaste.e"
#include "cursor.e"
#include "dialog.e"
#include "drawing.e"
#include "file.e"
#include "font.e"
#include "mainloop.e"
#include "mainmenu.e"
#include "menu.e"
#include "msg.e"
#ifndef _NO_EXTERN
#include "names.e"
#endif
#include "navigate.e"
#include "raster.e"
#include "rect.e"
#include "remote.e"
#include "setup.e"
#include "xpixmap.e"

#ifndef XK_KP_Left
#define XK_KP_Left	0xFF96
#define XK_KP_Up	0xFF97
#define XK_KP_Right	0xFF98
#define XK_KP_Down	0xFF99
#endif /* ~XK_KP_LEFT */

extern char	* getenv ARGS_DECL((char *));
extern int	atoi ARGS_DECL((char *));

char	curDomainName[MAXPATHLENGTH+1];
char	curDomainPath[MAXPATHLENGTH+1];
char	curDir[MAXPATHLENGTH+1];
char	curLocalDir[MAXPATHLENGTH+1];
char	curImportDir[MAXPATHLENGTH+1];
char	curSymDir[MAXPATHLENGTH+1];

int	doubleClickInterval;
int	importFromLibrary=FALSE;
int	curDirIsLocal=TRUE;

Window		nameBaseWin;
Window		nameDspWin;
Window		nameScrollWin;
int		nameEntries;
char		* * nameDspPtr;
int		nameFirst;
int		nameMarked;
struct BBRec	buttonBBox[MAXBUTTONS];
int		numButtons = 2;
char		buttonStr[MAXBUTTONS][8];

int	nameDspH;		/* height of display area */
int	nameDspW;		/* width of display area */
int	nameDspWinH;		/* height of display window */
int	nameDspWinW;		/* width of display window */

int	justClicked=FALSE;
int	domainInResource=TRUE;

int	ignoreDirectoryFlag=FALSE;

static int	nameScrollAreaH;	/* heighr of the grey scroll area */

static GC	nameGC;
static GC	revNameGC;

static DspList	* symbolList = NULL;
static int	numSymbols;
static DspList	* dirList = NULL;
static int	numDirEntries;

static DspList	* topOfSymLinkList = NULL;
static DspList	* topOfDirLinkList = NULL;

static XComposeStatus	c_stat;

static
char * ReadPath (path_str, dir_str)
   char * path_str, * dir_str;
{
   register char        * s1, * s2;

   s1 = path_str;
   while (*s1==' ' || *s1=='\t' || *s1=='\n') s1++;
   if (*s1 == '~')
   {
      strcpy (dir_str, homeDir);
      s2 = &dir_str[strlen(dir_str)];
      s1++;
   }
   else
      s2 = dir_str;

   for ( ; *s1 != '\0' && *s1 != ':'; s1++)
      if (*s1 == '\\')
         strcpy (s1, s1+1);
      else
         *s2++ = *s1;

   *s2 = '\0';
   if (*s1 == ':') s1++;
   return (s1);
}

static
void CleanUpSymPath()
{
   register int i;

   if (symPath != NULL) {
      for (i=0; i < symPathNumEntries; i++) {
         if (symPath[i] != NULL) {
            cfree(symPath[i]);
         }
      }
      if (symPath != NULL) cfree(symPath);
      symPath = NULL;
   }
}

void ParseSymPath (path_str)
   char * path_str;
{
   register char        * s;
   register int         i;
   int			path_len=0;
   char                 dir_str[MAXPATHLENGTH];

   CleanUpSymPath();

   for (i = 0, s = path_str; *s != '\0'; )
   {
      s = ReadPath (s, dir_str);
      if (dir_str != '\0') i++;
   }
   symPath = (char * *) calloc (i, sizeof (char *));
   symPathNumEntries = i;
   *curDomainPath = '\0';
   for (i = 0, s = path_str; *s != '\0'; )
   {
      s = ReadPath (s, dir_str);
      if (dir_str != '\0')
      {
         symPath[i] = (char *) calloc (MAXPATHLENGTH+1, sizeof (char));
         strcpy (symPath[i], dir_str);
         if (path_len == 0)
         {
            sprintf (&curDomainPath[path_len], "%s", dir_str);
            path_len += strlen (dir_str);
         }
         else
         {
            sprintf (&curDomainPath[path_len], ":%s", dir_str);
            path_len += strlen (dir_str)+1;
         }
         i++;
      }
   }
}

static
int LargerStr (S1, S2)
   register char	* S1, * S2;
   /* returns TRUE if S1 > S2 */
{
   while (*S1 == *S2 && *S1 != '\0' && *S2 != '\0') { S1++; S2++; }

   return (*S1 > *S2);
}

static
DspList * SymbolListing ()
{
   int			len, path_index, count = 0, reject, sym_ext_len;
   char			path[MAXPATHLENGTH], sym_ext_str[MAXSTRING];
   DspList		* dsp_ptr, * head_ptr, * tail_ptr, * p, * p1;
   DIR			* dirp;
   DIR_ENTRY		* d;

   head_ptr = tail_ptr = NULL;

   sprintf (sym_ext_str, ".%s", SYM_FILE_EXT);
   sym_ext_len = strlen (sym_ext_str);
   for (path_index = 0; path_index < symPathNumEntries; path_index++)
   {
      strcpy (path, symPath[path_index]);
      if (strcmp (".", path) == 0)
      {
         if (curDirIsLocal)
            strcpy (path, curDir);
         else
            strcpy (path, curLocalDir);
      }

      if ((dirp = opendir (path)) == NULL)
         continue;

      while ((d = readdir (dirp)) != NULL)
      {
         len = strlen (d->d_name);
         if (len > sym_ext_len &&
               (strcmp (sym_ext_str, &d->d_name[len-sym_ext_len]) == 0))
            d->d_name[len-sym_ext_len] = '\0';
         else
            continue;

         if (head_ptr == NULL)
         {
            head_ptr = tail_ptr = (DspList *) calloc (1, sizeof(DspList));
            strcpy (head_ptr->itemstr, d->d_name);
            strcpy (head_ptr->pathstr, path);
         }
         else
         {
            p1 = NULL;
            reject = FALSE;
            for (p = head_ptr; p != NULL; p = p->next)
            {
               if (strcmp (d->d_name, p->itemstr) == 0)
               {
                  reject = TRUE;
                  break;
               }
               else if (LargerStr (d->d_name, p->itemstr))
                  p1 = p;
               else
                  break;
            }
            if (reject) continue;
   
            dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
            dsp_ptr->next = p;
            strcpy (dsp_ptr->itemstr, d->d_name);
            strcpy (dsp_ptr->pathstr, path);

            if (p == NULL)
            {  /* dsp_ptr has the largest element */
               tail_ptr->next = dsp_ptr;
               tail_ptr = dsp_ptr;
            }
            else if (p1 == NULL)
               head_ptr = dsp_ptr;
            else
               p1->next = dsp_ptr;
         }
         count++;
      }
      closedir (dirp);
   }
   numSymbols = count;
   return (head_ptr);
}

static
void BuildSymbolList ()
{
   register int		i;
   register DspList	* dsp_ptr, * next_dsp;

   if (symbolList != NULL) cfree (symbolList);

   symbolList = (DspList *) calloc (numSymbols, sizeof (DspList));
   dsp_ptr = topOfSymLinkList;
   for (i = 0; i < numSymbols; i++, dsp_ptr = next_dsp)
   {
      next_dsp = dsp_ptr->next;
      strcpy (symbolList[i].itemstr, dsp_ptr->itemstr);
      strcpy (symbolList[i].pathstr, dsp_ptr->pathstr);
      symbolList[i].next = &symbolList[i+1];
      cfree (dsp_ptr);
   }
   symbolList[numSymbols-1].next = NULL;
   topOfSymLinkList = NULL;
}

static
int ExtensionMatch (Spec, DirName)
   char * Spec, * DirName;
{
   register char	* c_ptr;
   char			other_ext_str[MAXSTRING];
   int			len;

   if (*Spec == '\0') return FALSE;
   len = strlen(DirName);
   strcpy (other_ext_str, Spec);
   for (c_ptr=strtok(other_ext_str,";"); c_ptr != NULL; c_ptr=strtok(NULL, ";"))
   {
      int	other_ext_len=strlen(c_ptr);

      if (len > other_ext_len &&
            UtilStrICmp (c_ptr, &DirName[len-other_ext_len]) == 0)
         return TRUE;
   }
   return FALSE;
}

static
DspList * DirListing (Path, ExtStr, OtherExtStr)
   char	* Path, * ExtStr, * OtherExtStr;
{
   DspList		* dsp_ptr, * head_ptr, * tail_ptr, * p, * p1;
   DIR			* dirp;
   DIR_ENTRY		* d;
   int			len, ext_len, count = 0;
   char			path[MAXPATHLENGTH], s[MAXPATHLENGTH];
   char			ext_str[MAXSTRING];
   struct stat		stat_buf;

   if (*Path == '\0')
   {
      strcpy (path, "/");
      if ((dirp = opendir (path)) == NULL) return (NULL);
   }
   else
   {
      strcpy (path, Path);
      if ((dirp = opendir (path)) == NULL) return (NULL);
      strcat (path, "/");
   }

   if (ExtStr != NULL)
   {
      sprintf (ext_str, ".%s", ExtStr);
      ext_len = strlen (ext_str);
   }
   else
   {
      *ext_str = '\0';
      ext_len = 0;
   }

#ifdef VMS
   /* Fake the .. entry for VMS */
   head_ptr = tail_ptr = (DspList *) calloc (1, sizeof(DspList));
   head_ptr->directory = TRUE;
   strcpy (head_ptr->itemstr, "../");
   head_ptr->next = NULL;
   count = 1;
#else
   head_ptr = tail_ptr = NULL;
#endif /* VMS */

   while ((d = readdir (dirp)) != NULL)
   {
      len = strlen (d->d_name);
      if (ext_len == 0)
      {
#ifdef VMS
         if (len > 4 && (strcmp (".dir", &d->d_name[len-4]) == 0))
         {
            d->d_name[len-4] = '/';
            d->d_name[len-4+1] = '\0';
            dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
            dsp_ptr->directory = TRUE;
            strcpy (dsp_ptr->itemstr, d->d_name);
         }
         else if (strcmp (d->d_name, ".") == 0)
#else
         if (strcmp (d->d_name, ".") == 0)
#endif /* VMS */
            continue;
         else
         {
            sprintf (s, "%s%s", path, d->d_name);
            stat (s, &stat_buf);
            dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
            if (stat_buf.st_mode & S_IFDIR)
            {
               dsp_ptr->directory = TRUE;
               strcat (d->d_name, "/");
            }
            else
               dsp_ptr->directory = FALSE;
            strcpy (dsp_ptr->itemstr, d->d_name);
         }
      }
      else if ((len > ext_len &&
            UtilStrICmp (ext_str,&d->d_name[len-ext_len]) == 0) ||
            ExtensionMatch(OtherExtStr, d->d_name))
      {
         dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
         dsp_ptr->directory = FALSE;
         strcpy (dsp_ptr->itemstr, d->d_name);
      }
#ifdef VMS
      else if (len > 4 && (strcmp (".dir", &d->d_name[len-4]) == 0))
      {
         d->d_name[len-4] = '/';
         d->d_name[len-4+1] = '\0';
         dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
         dsp_ptr->directory = TRUE;
         strcpy (dsp_ptr->itemstr, d->d_name);
      }
#endif /* VMS */
      else if (strcmp (d->d_name, ".") == 0)
         continue;
      else
      {
         sprintf (s, "%s%s", path, d->d_name);
         stat (s, &stat_buf);
         if (stat_buf.st_mode & S_IFDIR)
         {
            dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
            dsp_ptr->directory = TRUE;
            strcat (d->d_name, "/");
            strcpy (dsp_ptr->itemstr, d->d_name);
         }
         else
            continue;
      }
      if (head_ptr == NULL)
         head_ptr = tail_ptr = dsp_ptr;
      else
      {
         p1 = NULL;
         for (p = head_ptr; p != NULL; p = p->next)
            if (LargerStr (d->d_name, p->itemstr))
               p1 = p;
            else
               break;

         dsp_ptr->next = p;
         if (p == NULL)
         {  /* dsp_ptr has the largest element */
            tail_ptr->next = dsp_ptr;
            tail_ptr = dsp_ptr;
         }
         else if (p1 == NULL)
            head_ptr = dsp_ptr;
         else
            p1->next = dsp_ptr;
      }
      count++;
   }

   closedir (dirp);
   numDirEntries = count;
   return (head_ptr);
}

static
void BuildDirList ()
{
   register int		i;
   register DspList	* dsp_ptr, * next_dsp;

   if (topOfDirLinkList != NULL)
   {
      if (dirList != NULL) cfree (dirList);

      dirList = (DspList *) calloc (numDirEntries, sizeof (DspList));
      dsp_ptr = topOfDirLinkList;
      for (i = 0; i < numDirEntries; i++, dsp_ptr = next_dsp)
      {
         next_dsp = dsp_ptr->next;
         strcpy (dirList[i].itemstr, dsp_ptr->itemstr);
         strcpy (dirList[i].pathstr, dsp_ptr->pathstr);
         dirList[i].directory = dsp_ptr->directory;
         dirList[i].next = &dirList[i+1];
         cfree (dsp_ptr);
      }
      dirList[numDirEntries-1].next = NULL;
      topOfDirLinkList = NULL;
   }
}

static
void ConvertToUpperCase (InStr, OutStr)
   register char	* InStr, * OutStr;
{
   for ( ; *InStr != '\0'; InStr++, OutStr++)
      *OutStr = (*InStr>='a' && *InStr<='z') ? *InStr-'a'+'A' : *InStr;
   *OutStr = '\0';
}

void InitNames ()
{
   int		default_found = FALSE;
   char		* c_ptr, domain_str[20], sym_path[80], cap_tool_name[MAXSTRING];
   XGCValues	values;

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.fill_style = FillSolid;
   values.font = defaultFontPtr->fid;
   nameGC = XCreateGC (mainDisplay, rootWindow,
         GCForeground | GCBackground | GCFillStyle | GCFont, &values);

   values.foreground = myBgPixel;
   values.background = myFgPixel;
   revNameGC = XCreateGC (mainDisplay, rootWindow,
         GCForeground | GCBackground | GCFillStyle | GCFont, &values);

   nameDspW = ITEM_LEN * defaultFontWidth;
   nameDspH = ITEM_DSPED * ROW_HEIGHT;
   nameDspWinW = nameDspW + 2 * brdrW;
   nameDspWinH = nameDspH + 2 * brdrW;
   nameScrollAreaH = nameDspH;

   ignoreDirectoryFlag = FALSE;

   *curDomainName = '\0';
   *curDomainPath = '\0';
   *curSymDir = '\0';
   strcpy (curDir, bootDir);
   strcpy (curImportDir, bootDir);

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "DoubleClickInterval")) !=
         NULL)
      doubleClickInterval = atoi (c_ptr);
   else
      doubleClickInterval = 300;

   warpToWinCenter = TRUE;
   if ((c_ptr = XGetDefault (mainDisplay,TOOL_NAME,"WarpToWinCenter")) != NULL)
      if ((strcmp (c_ptr, "false") == 0) || (strcmp (c_ptr, "False") == 0))
         warpToWinCenter = FALSE;

   importFromLibrary = FALSE;
   if ((c_ptr = XGetDefault(mainDisplay,TOOL_NAME,"ImportFromLibrary")) != NULL)
      if ((strcmp (c_ptr, "true") == 0) || (strcmp (c_ptr, "True") == 0))
         importFromLibrary = TRUE;

   domainInResource = TRUE;
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "DefaultDomain")) != NULL)
   {
      int	default_domain=atoi (c_ptr);

      sprintf (domain_str, "DomainPath%1d", default_domain);
      if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, domain_str)) != NULL)
      {
         char	* c_ptr1;

         while (*c_ptr==' ' || *c_ptr=='\t' || *c_ptr=='\n') c_ptr++;
         if (*c_ptr != '\0' && (c_ptr1=strchr (c_ptr, ':')) != NULL)
         {
            int	len=c_ptr1-c_ptr;

            strncpy (curDomainName, c_ptr, len);
            curDomainName[len] = '\0';
            c_ptr = (++c_ptr1);
            default_found = TRUE;
         }
      }
      else
      {
         sprintf (domain_str, "Domain%1d", default_domain);
         if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, domain_str)) != NULL)
         {
            if (*c_ptr != '\0')
            {
               ConvertToUpperCase (TOOL_NAME, cap_tool_name);
               strcpy (curDomainName, c_ptr);
               sprintf (sym_path, "%s_%s", cap_tool_name, c_ptr);
               default_found = TRUE;
               domainInResource = FALSE;
            }
         }
      }
   }
   if (default_found)
   {
      if (domainInResource)
         ParseSymPath (c_ptr);
      else if ((c_ptr=getenv (sym_path)) == NULL ||
            ((int) strlen (c_ptr)) >= MAXPATHLENGTH-1)
         ParseSymPath (".");
      else
         ParseSymPath (c_ptr);
   }
   else
      ParseSymPath (".");

/* if (!default_found || (c_ptr = getenv (sym_path)) == NULL)
      ParseSymPath (".");
   else
      if (strlen (c_ptr) >= MAXPATHLENGTH-1)
         ParseSymPath (".");
      else 
         ParseSymPath (c_ptr); */
   if ((topOfSymLinkList = SymbolListing ()) != NULL) BuildSymbolList ();
}

void UpdateDirInfo ()
{
   SetWatchCursor (drawWindow);
   SetWatchCursor (mainWindow);
   if (curDirIsLocal)
   {
      if ((topOfDirLinkList = DirListing (curDir, OBJ_FILE_EXT, "")) != NULL)
         BuildDirList ();
   }
   else if ((topOfDirLinkList = DirListing (curLocalDir, OBJ_FILE_EXT, "")) !=
         NULL)
      BuildDirList ();
   SetDefaultCursor (mainWindow);
   SetDefaultCursor (drawWindow);
}

void UpdateSymInfo ()
{
   SetWatchCursor (drawWindow);
   SetWatchCursor (mainWindow);
   if ((topOfSymLinkList = SymbolListing ()) != NULL) BuildSymbolList ();
   SetDefaultCursor (mainWindow);
   SetDefaultCursor (drawWindow);
}

void CleanUpNames ()
{
   CleanUpSymPath();

   XFreeGC (mainDisplay, nameGC);
   XFreeGC (mainDisplay, revNameGC);

   if (symbolList != NULL) cfree (symbolList);
   if (dirList != NULL) cfree (dirList);
   symbolList = dirList = NULL;
   ignoreDirectoryFlag = FALSE;
}

void RedrawNameScrollWin ()
{
   double       frac, start_frac;
   int          block_h, block_start;
   XGCValues	values;

   start_frac = (nameEntries > 0) ?
         (double)((double)(nameFirst)/(double)(nameEntries)) : ((double)0.0);
   block_start = (int)(nameScrollAreaH * start_frac); /* starting pixel */

   if (nameEntries > ITEM_DSPED)
      frac = (double)((double)ITEM_DSPED / (double)(nameEntries));
   else
      frac = 1.0;

   if (nameFirst+ITEM_DSPED >= nameEntries)
      block_h = nameScrollAreaH - block_start;
   else
      block_h = (int)(nameScrollAreaH * frac);

   values.foreground = myBgPixel;
   values.background = myFgPixel;
   values.function = GXcopy;
   values.fill_style = FillSolid;
   XChangeGC (mainDisplay, patGC,
         GCForeground | GCBackground | GCFunction | GCFillStyle, &values);
   XFillRectangle (mainDisplay, nameScrollWin, patGC, 0, 0,
         scrollBarW, nameScrollAreaH);

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.fill_style = FillOpaqueStippled;
   values.stipple = patPixmap[SCROLLPAT];
   XChangeGC (mainDisplay, patGC,
         GCForeground | GCBackground | GCFillStyle | GCStipple, &values);
   XFillRectangle (mainDisplay, nameScrollWin, patGC, 0, block_start,
         scrollBarW, block_h);
}

void RedrawDspWindow ()
{
   register int	i;
   int		top, len, end;

   top = defaultFontAsc+1;

   if (nameFirst+ITEM_DSPED > nameEntries)
      end = nameEntries;
   else
      end = nameFirst + ITEM_DSPED;

   XFillRectangle (mainDisplay, nameDspWin, revNameGC, 0, 0,
         ITEM_LEN*defaultFontWidth, ITEM_DSPED*ROW_HEIGHT);

   for (i = nameFirst; i < end; i++)
   {
      len = strlen (nameDspPtr[i]);
      if (i == nameMarked)
      {
         XFillRectangle (mainDisplay, nameDspWin, nameGC,
               0, (i-nameFirst)*ROW_HEIGHT, ITEM_LEN*defaultFontWidth,
               ROW_HEIGHT);
         XDrawString (mainDisplay, nameDspWin, revNameGC,
               0, (i-nameFirst)*ROW_HEIGHT+top, nameDspPtr[i], len);
      }
      else
      {
         XFillRectangle (mainDisplay, nameDspWin, revNameGC,
               0, (i-nameFirst)*ROW_HEIGHT, ITEM_LEN*defaultFontWidth,
               ROW_HEIGHT);
         XDrawString (mainDisplay, nameDspWin, nameGC,
               0, (i-nameFirst)*ROW_HEIGHT+top, nameDspPtr[i], len);
      }
   }
}

void RedrawNamePath (Path, X, Y)
   char	* Path;
   int	X, Y;
{
   int	len = strlen (Path), cursor_x, cursor_y;
   char	* c_ptr;

   cursor_y = Y-defaultFontAsc;

   XClearArea (mainDisplay, nameBaseWin, X, Y-defaultFontAsc,
         ITEM_LEN*defaultFontWidth+4, defaultFontHeight+4, False);
   XDrawRectangle (mainDisplay, nameBaseWin, nameGC, X, cursor_y-2,
         ITEM_LEN*defaultFontWidth+8, defaultFontHeight+4);

   if (len > ITEM_LEN)
   {
      c_ptr = &(Path[len-ITEM_LEN]);
      len = ITEM_LEN;
   }
   else
      c_ptr = Path;

   cursor_x = X+2+len*defaultFontWidth;
   XDrawString (mainDisplay, nameBaseWin, nameGC, X+2, Y, c_ptr, len);
   XDrawLine (mainDisplay, nameBaseWin, nameGC, cursor_x,
         cursor_y, cursor_x, cursor_y+defaultFontHeight);
}

void RedrawNameBaseWindow (Str, Path, str_start, path_start, button_start, W, H)
   char	* Str, * Path;
   int	str_start, path_start, button_start, W, H;
{
   int	i, top = defaultFontAsc+2, left;

   XDrawRectangle (mainDisplay, nameBaseWin, nameGC, 0, 0, W-1, H-1);
   XDrawString (mainDisplay, nameBaseWin, nameGC, str_start,
         ROW_HEIGHT+top, Str, strlen(Str));
   RedrawNamePath (Path, path_start, 3*ROW_HEIGHT+top);

   left = button_start;
   for (i = 0; i < numButtons; i++)
   {
      buttonBBox[i].lty = (ITEM_DSPED+6) * ROW_HEIGHT;
      buttonBBox[i].ltx = left;
      DisplayButton (nameBaseWin, buttonStr[i], 8, &(buttonBBox[i]),
            BUTTON_NORMAL);
      left = buttonBBox[i].rbx + 1 + defaultFontWidth;
   }
}

char * * MakeNameDspItemArray (Entries, DLPtr)
   int		Entries;
   DspList	* DLPtr;
{
   register int	i, j, len;
   char		* * dsp_ptr, * c_ptr;

   if (Entries == 0) return (NULL);

   dsp_ptr = (char * *) calloc (Entries, sizeof(char *));
   c_ptr = (char *) calloc (Entries*(MAXPATHLENGTH+1), sizeof(char));
   for (i = 0; i < Entries; i++, DLPtr = DLPtr->next)
   {
      dsp_ptr[i] = c_ptr;
      len = strlen (DLPtr->itemstr);
      if (!ignoreDirectoryFlag && !DLPtr->directory)
      {
         for (j = len; j >= 0 && DLPtr->itemstr[j] != '/'; j--) ;
         if (j >= 0)
            strcpy (c_ptr, (&(DLPtr->itemstr[j]))+1);
         else
            strcpy (c_ptr, DLPtr->itemstr);
      }
      else
         strcpy (c_ptr, DLPtr->itemstr);

      c_ptr += MAXPATHLENGTH;
   }
   return (dsp_ptr);
}

static int	lengthOfLongestItem=INVALID;

static
char * * MakeLongNameDspItemArray (Entries, DLPtr)
   int		Entries;
   DspList	* DLPtr;
{
   register int	i, len;
   char		* * dsp_ptr, * c_ptr;

   lengthOfLongestItem = INVALID;

   if (Entries == 0) return (NULL);

   dsp_ptr = (char * *) calloc (Entries, sizeof(char *));
   c_ptr = (char *) calloc (Entries*(MAXPATHLENGTH+1), sizeof(char));
   for (i = 0; i < Entries; i++, DLPtr = DLPtr->next)
   {
      dsp_ptr[i] = c_ptr;
      len = strlen (DLPtr->itemstr);
      strcpy (c_ptr, DLPtr->itemstr);
      if (len > lengthOfLongestItem) lengthOfLongestItem = len;

      c_ptr += MAXPATHLENGTH;
   }
   return (dsp_ptr);
}

static
int GetNameEntryNum (RowOffset)
   int		RowOffset;
{
   register int	index;

   index = nameFirst + RowOffset;
   if (index >= nameEntries) return (INVALID);
   return (index);
}

void NameScrollHandler (button_ev)
   XButtonEvent	* button_ev;
{
   double	frac, start_frac;
   int		block_h, block_start;

   if (button_ev->button == Button3)
   {
      if (nameFirst == 0) return;

      if (button_ev->state & (ShiftMask | ControlMask))
      {
         nameFirst -= ITEM_DSPED;
         if (nameFirst < 0) nameFirst = 0;
      }
      else
         nameFirst--;
   }
   else if (button_ev->button == Button1)
   {
      if (nameEntries <= ITEM_DSPED || nameFirst+ITEM_DSPED == nameEntries)
         return;

      if (button_ev->state & (ShiftMask | ControlMask))
      {
         nameFirst += ITEM_DSPED;
         if (nameFirst+ITEM_DSPED >= nameEntries)
            nameFirst = nameEntries-ITEM_DSPED;
      }
      else
         nameFirst++;
   }
   else if (button_ev->button == Button2)
   {
      int	done=FALSE;
      XEvent	ev;

      if (nameEntries <= ITEM_DSPED) return;

      frac = (double)((double)ITEM_DSPED / (double)(nameEntries));
      block_h = (int)(nameScrollAreaH * frac);
      block_start = button_ev->y;
      start_frac = (double)((double)(block_start)/(double)(nameScrollAreaH));
      if (block_start+block_h >= nameScrollAreaH)
         nameFirst = nameEntries - ITEM_DSPED;
      else
         nameFirst = (int)(nameEntries * start_frac);

      RedrawNameScrollWin ();
      RedrawDspWindow ();

      XGrabPointer (mainDisplay, nameScrollWin, False,
            PointerMotionMask | ButtonReleaseMask, GrabModeAsync,
            GrabModeAsync, None, handCursor, CurrentTime);

      while (!done)
      {
         XNextEvent (mainDisplay, &ev);

         if (ev.type == Expose || ev.type == VisibilityNotify)
            ExposeEventHandler (&ev, TRUE);
         else if (ev.type == ButtonRelease)
         {
            XUngrabPointer (mainDisplay, CurrentTime);
            done = TRUE;
         }
         else if (ev.type == MotionNotify)
         {
            int	new_name_first, y=ev.xmotion.y;

            start_frac = (double)(((double)y) / ((double)nameScrollAreaH));

            if (y <= 0)
               new_name_first = 0;
            else if (y+block_h >= nameScrollAreaH)
               new_name_first = nameEntries - ITEM_DSPED;
            else
               new_name_first = (int)(nameEntries * start_frac);

            if (nameFirst != new_name_first)
            {
               nameFirst = new_name_first;
               RedrawNameScrollWin ();
               RedrawDspWindow ();
            }
            while (XCheckMaskEvent (mainDisplay, PointerMotionMask, &ev)) ;
         }
      }
      return;
   }
   RedrawNameScrollWin ();
   RedrawDspWindow ();
}

static Time	lastClickTime;
static int	lastNameMarked;

int NameDspHandler (button_ev)
   XButtonEvent	* button_ev;
{
   int	row_offset, len, top;
   Time	click_time;

   top = defaultFontAsc+1;

   row_offset = (int)(button_ev->y / ROW_HEIGHT);

   if (nameMarked != INVALID &&
         nameMarked >= nameFirst && nameMarked < nameFirst+ITEM_DSPED)
   {
      len = strlen (nameDspPtr[nameMarked]);
      XFillRectangle (mainDisplay, nameDspWin, revNameGC, 0,
            (nameMarked - nameFirst)*ROW_HEIGHT,
            ITEM_LEN*defaultFontWidth, ROW_HEIGHT);
      XDrawString (mainDisplay, nameDspWin, nameGC, 0,
            (nameMarked - nameFirst)*ROW_HEIGHT+top,
            nameDspPtr[nameMarked], len);
   }

   nameMarked = GetNameEntryNum (row_offset);
   if (nameMarked != INVALID)
   {
      len = strlen (nameDspPtr[nameMarked]);
      XFillRectangle (mainDisplay, nameDspWin, nameGC, 0,
            (nameMarked - nameFirst)*ROW_HEIGHT,
            ITEM_LEN*defaultFontWidth, ROW_HEIGHT);
      XDrawString (mainDisplay, nameDspWin, revNameGC, 0,
            (nameMarked - nameFirst)*ROW_HEIGHT+top,
            nameDspPtr[nameMarked], len);
   }

   click_time = button_ev->time;
   if (justClicked && nameMarked != INVALID && lastNameMarked == nameMarked &&
         (click_time-lastClickTime) < doubleClickInterval)
      return (TRUE);

   justClicked = TRUE;
   lastClickTime = click_time;
   lastNameMarked = nameMarked;
   return (INVALID);
}

int ControlChar (key_ev, key_sym)
   XKeyEvent	* key_ev;
   KeySym	key_sym;
{
   register int	i;

   if (key_ev->state & ControlMask)
   {
      switch (key_sym)
      {
         case XK_Left: return (BAD);
         case XK_KP_Left: return (BAD);
         case XK_Up: key_sym = ((unsigned long)'b')&0xff; break;
         case XK_KP_Up: key_sym = ((unsigned long)'b')&0xff; break;
         case XK_Right: return (BAD);
         case XK_KP_Right: return (BAD);
         case XK_Down: key_sym = ((unsigned long)'f')&0xff; break;
         case XK_KP_Down: key_sym = ((unsigned long)'f')&0xff; break;
      }
   }
   else
   {
      switch (key_sym)
      {
         case XK_Left: return (BAD);
         case XK_KP_Left: return (BAD);
         case XK_Up: key_sym = ((unsigned long)'k')&0xff; break;
         case XK_KP_Up: key_sym = ((unsigned long)'k')&0xff; break;
         case XK_Right: return (BAD);
         case XK_KP_Right: return (BAD);
         case XK_Down: key_sym = ((unsigned long)'j')&0xff; break;
         case XK_KP_Down: key_sym = ((unsigned long)'j')&0xff; break;
      }
   }
   switch (key_sym&0xff)
   {
      case 'w': /* erase */
      case 'y':
         return (INVALID);
      case 'n': /* down one */
      case 'j':
         i = (nameMarked < nameEntries-1) ? nameMarked+1 : nameEntries-1;
         break;
      case 'p': /* up one */
      case 'k':
         i = (nameMarked>0) ? nameMarked-1 : 0;
         break;
      case 'd': /* down one page */
      case 'f':
         if (nameMarked==INVALID)
            i = (nameEntries <= ITEM_DSPED) ? nameEntries-1 : ITEM_DSPED;
         else if (nameMarked < nameEntries-ITEM_DSPED)
            i = nameMarked+ITEM_DSPED;
         else
            i = nameEntries-1;
         break;
      case 'u': /* up one page */
      case 'b':
         i = (nameMarked > (ITEM_DSPED-1)) ? nameMarked-ITEM_DSPED : 0;
         break;
      default: return (BAD);
   }
   return (i);
}

static
void ParseFileName (FullName, DirName, Name)
   char	* FullName, * DirName, * Name;
{
   register int	i, len;

   len = strlen (FullName);
   strcpy (DirName, FullName);
   for (i=len-1; i>=0; i--)
      if (DirName[i] == '/')
      {
         strcpy (Name, &(DirName[i+1]));
         DirName[i] = '\0';
         return;
      }
   *DirName = *Name = '\0';
}

static
void BackUpOneWord (Name, NameIndex)
   char	* Name;
   int	* NameIndex;
{
   if (*NameIndex == 0) return;

   if (Name[(*NameIndex)-1] == '/')
      Name[--(*NameIndex)] = '\0';
   else
   {
      while (*NameIndex > 0)
      {
         if (Name[(*NameIndex)-1] == '/')
         {
            Name[*NameIndex] = '\0';
            return;
         }
         else
            (*NameIndex)--;
      }
      *Name = '\0';
   }
}

static
int DirNames (TopStr, ExtStr, SelStr, JustSetDir)
   char	* TopStr, * ExtStr, * SelStr;
   int	*JustSetDir;
{
   int			button_widths, str_width, graph_width;
   int			str_start, button_start, graph_start, index = 0;
   int			dsp_w, dsp_h, w, h, i, exposed = FALSE;
   int			button_selected = INVALID, change_to_root;
   int			faking_dot_dot, tabbed_from_root=TRUE;
   int			just_tabbed_from_root=FALSE;
   int			name_is_remote=FALSE;
   XEvent		input, ev;
   int			looping = TRUE, changing, name_index, pop_from_root;
   char			buf[80], name[MAXPATHLENGTH], full_name[MAXPATHLENGTH];
   char			dir_name[MAXPATHLENGTH], sel_str[MAXPATHLENGTH];
   char			saved_dir_name[MAXPATHLENGTH], saved_name[MAXSTRING];
   char			tmp_top_str[MAXPATHLENGTH], tmp_name[MAXPATHLENGTH];
   char			other_ext_str[MAXSTRING];
   XKeyEvent		* key_ev;
   XButtonEvent		* button_ev;
   KeySym		key_sym;
   XWMHints		wmhints;
   XSizeHints		sizehints;
   XSetWindowAttributes	win_attrs;
   int			win_x, win_y;
   DspList		* dsp_ptr, * next_dsp;
   struct BBRec		edit_bbox;

   dsp_w = DisplayWidth (mainDisplay, mainScreen);
   dsp_h = DisplayHeight (mainDisplay, mainScreen);

   button_widths = ButtonWidth("OK", 8) + ButtonWidth("CANCEL", 8) +
         ButtonWidth("SETDIR", 8) + defaultFontWidth;
   numButtons = 3;
   strcpy (buttonStr[0], "OK");
   strcpy (buttonStr[1], "SETDIR");
   strcpy (buttonStr[2], "CANCEL");

   str_width = defaultFontWidth * strlen (TopStr);
   graph_width = nameDspWinW + scrollBarW + 2 * brdrW;

   if (str_width > graph_width)
   {
      w = str_width + 4 * defaultFontWidth;
      str_start = 2 * defaultFontWidth;
      graph_start = (w - graph_width)>>1;
   }
   else
   {
      w = graph_width + 4 * defaultFontWidth;
      str_start = (w - str_width)>>1;
      graph_start = 2 * defaultFontWidth;
   }
   button_start = (w - button_widths)>>1;
   h = (8 + ITEM_DSPED) * ROW_HEIGHT;

   win_x = (w > dsp_w) ? 0 : ((dsp_w - w)>>1);
   win_y = (h > dsp_h) ? 0 : (dsp_h - h)/3;

   if ((nameBaseWin = XCreateSimpleWindow (mainDisplay, rootWindow,
         win_x, win_y, w, h, brdrW, myBorderPixel, myBgPixel)) == 0)
      Error ("DirNames()", "Can not XCreateSimpleWindow() for nameBaseWin");

   XDefineCursor (mainDisplay, nameBaseWin, defaultCursor);

   if ((nameDspWin = XCreateSimpleWindow (mainDisplay, nameBaseWin, graph_start,
         5*ROW_HEIGHT, nameDspW, nameDspH, brdrW, myBorderPixel,
         myBgPixel)) == 0)
      Error ("DirNames()", "Can not XCreateSimpleWindow() for nameDspWin");

   if ((nameScrollWin = XCreateSimpleWindow (mainDisplay, nameBaseWin,
         graph_start+nameDspWinW, 5*ROW_HEIGHT, scrollBarW, nameDspH,
         brdrW, myBorderPixel, myBgPixel)) == 0)
      Error ("DirNames()", "Can not XCreateSimpleWindow() for nameScrollWin");

   win_attrs.save_under = True;
   win_attrs.colormap = mainColormap;
   XChangeWindowAttributes (mainDisplay, nameBaseWin, CWSaveUnder | CWColormap,
         &win_attrs);

   wmhints.flags = InputHint | StateHint;
   wmhints.input = True;
   wmhints.initial_state = NormalState;
   XSetWMHints (mainDisplay, nameBaseWin, &wmhints);

   sizehints.flags = PPosition | PSize | USPosition | PMinSize | PMaxSize;
   sizehints.x = win_x;
   sizehints.y = win_y;
   sizehints.width = sizehints.min_width = sizehints.max_width = w;
   sizehints.height = sizehints.min_height = sizehints.max_height = h;
#ifdef NOTR4MODE
   XSetNormalHints (mainDisplay, nameBaseWin, &sizehints);
#else
   XSetWMNormalHints (mainDisplay, nameBaseWin, &sizehints);
#endif
   sprintf (buf, "%s - %s", TOOL_NAME, TopStr);
   XStoreName (mainDisplay, nameBaseWin, buf);

   XSetTransientForHint (mainDisplay, nameBaseWin, mainWindow);

#ifdef MAPBEFORESELECT
   XMapWindow (mainDisplay, nameBaseWin);
   XSelectInput (mainDisplay, nameBaseWin,
         KeyPressMask | ButtonPressMask | ExposureMask | StructureNotifyMask);
   XMapWindow (mainDisplay, nameDspWin);
   XSelectInput (mainDisplay, nameDspWin,
         KeyPressMask | ButtonPressMask | ExposureMask);
   XMapWindow (mainDisplay, nameScrollWin);
   XSelectInput (mainDisplay, nameScrollWin,
         KeyPressMask | ButtonPressMask | ExposureMask);
#else
   XSelectInput (mainDisplay, nameBaseWin,
         KeyPressMask | ButtonPressMask | ExposureMask | StructureNotifyMask);
   XMapWindow (mainDisplay, nameBaseWin);
   XSelectInput (mainDisplay, nameDspWin,
         KeyPressMask | ButtonPressMask | ExposureMask);
   XMapWindow (mainDisplay, nameDspWin);
   XSelectInput (mainDisplay, nameScrollWin,
         KeyPressMask | ButtonPressMask | ExposureMask);
   XMapWindow (mainDisplay, nameScrollWin);
#endif

   if (warpToWinCenter)
      XWarpPointer (mainDisplay, None, nameBaseWin, 0, 0, 0, 0, (w>>1), (h>>1));

   XSync (mainDisplay, False);

   if (importingFile)
      strcpy (dir_name, curImportDir);
   else if (curDirIsLocal)
      strcpy (dir_name, curDir);
   else
      strcpy (dir_name, curLocalDir);

   for (dsp_ptr = topOfDirLinkList; dsp_ptr != NULL; dsp_ptr = next_dsp)
   {
      next_dsp = dsp_ptr->next;
      cfree (dsp_ptr);
   }
   topOfDirLinkList = NULL;

   SetWatchCursor (drawWindow);
   SetWatchCursor (mainWindow);
   SetWatchCursor (nameBaseWin);
   Msg ("Generating list of file names, please wait ...");
   if (ExtStr != NULL && strcmp (ExtStr, EPSF_FILE_EXT) == 0)
      sprintf (other_ext_str, ".%s;.epsi", PS_FILE_EXT);
   else if (ExtStr != NULL && strcmp (ExtStr, OBJ_FILE_EXT) == 0)
      strcpy (other_ext_str, SYM_FILE_EXT);
   else
      *other_ext_str = '\0';
   if ((topOfDirLinkList = DirListing (dir_name,ExtStr,other_ext_str)) == NULL)
   {
      *sel_str = '\0';
      index = INVALID;
      looping = FALSE;
   }
   SetDefaultCursor (mainWindow);
   SetDefaultCursor (drawWindow);
   SetDrawCursor (nameBaseWin);

   edit_bbox.ltx = graph_start;
   edit_bbox.lty = 3*ROW_HEIGHT;
   edit_bbox.rbx = graph_start+ITEM_LEN*defaultFontWidth+8;
   edit_bbox.rby = 3*ROW_HEIGHT+defaultFontHeight+4;

   justClicked = FALSE;
   *saved_dir_name = '\0';
   faking_dot_dot = FALSE;
   while (looping)
   {
      nameEntries = numDirEntries;
      if (topOfDirLinkList == NULL)
         nameDspPtr = MakeNameDspItemArray (nameEntries, dirList);
      else
         nameDspPtr = MakeNameDspItemArray (nameEntries, topOfDirLinkList);
      nameFirst = 0;
      nameMarked = INVALID;

      if (faking_dot_dot)
      {
         name_index = strlen (saved_name);
         for (i = 0; i < nameEntries; i++)
            if (strncmp (nameDspPtr[i], saved_name, name_index) == 0)
            {
               strcpy (name, saved_name);
               if (i >= ITEM_DSPED)
               {
                  if (i < nameEntries-ITEM_DSPED)
                     nameFirst = i;
                  else
                     nameFirst = nameEntries-ITEM_DSPED;
               }
               nameMarked = i;
               break;
            }

         if (i == nameEntries)
         {
            name[0] = '\0';
            name_index = 0;
         }
      }
      else if (tabbed_from_root && !just_tabbed_from_root)
      {
         name[0] = '\0';
         name_index = 0;
      }
      else if (tabbed_from_root && just_tabbed_from_root)
      {
         name_index = strlen (name);
         for (i = 0; i < nameEntries; i++)
            if (strncmp (nameDspPtr[i], name, name_index) == 0)
               break;

         if (i < nameEntries)
         {
            if (i < nameFirst)
               nameFirst = i;
            else if (i >= nameFirst+ITEM_DSPED)
            {
               if (i < nameEntries-ITEM_DSPED)
                  nameFirst = i;
               else
                  nameFirst = nameEntries-ITEM_DSPED;
            }
            nameMarked = i;

            sprintf (full_name, "%s/%s", dir_name, name);

            if (exposed)
            {
               RedrawNamePath (full_name, graph_start,
                     3*ROW_HEIGHT+defaultFontAsc+2);
               RedrawNameScrollWin ();
               RedrawDspWindow ();
            }
         }
         else
         {
            name[0] = '\0';
            name_index = 0;
         }
      }

      sprintf (full_name, "%s/%s", dir_name, name);

      if (exposed)
      {
         XClearWindow (mainDisplay, nameBaseWin);
         XClearWindow (mainDisplay, nameDspWin);
         XClearWindow (mainDisplay, nameScrollWin);
         if (tabbed_from_root)
            RedrawNameBaseWindow (TopStr, full_name, str_start, graph_start,
                  button_start, w, h);
         else
            RedrawNameBaseWindow (tmp_top_str, full_name, str_start,
                  graph_start, button_start, w, h);
         RedrawNameScrollWin ();
         RedrawDspWindow ();
      }

      changing = TRUE;
      change_to_root = FALSE;
      just_tabbed_from_root = FALSE;
      pop_from_root = FALSE;
      faking_dot_dot = FALSE;
      while (changing)
      {
         XNextEvent (mainDisplay, &input);

         if ((input.type==MapNotify && input.xany.window==nameBaseWin) ||
               (input.type==Expose && (input.xany.window==nameBaseWin ||
               input.xany.window==nameScrollWin ||
               input.xany.window==nameDspWin)) ||
               (!exposed &&
               (XCheckWindowEvent (mainDisplay,nameBaseWin,ExposureMask,&ev) ||
               XCheckWindowEvent (mainDisplay,nameScrollWin,ExposureMask,&ev) ||
               XCheckWindowEvent (mainDisplay,nameDspWin,ExposureMask,&ev) ||
               XCheckWindowEvent (mainDisplay,nameBaseWin,StructureNotifyMask,
               &ev))))
         {
            while (XCheckWindowEvent (mainDisplay,nameBaseWin,ExposureMask,&ev))
               ;
            while (XCheckWindowEvent (mainDisplay,nameScrollWin,ExposureMask,
                  &ev))
               ;
            while (XCheckWindowEvent (mainDisplay,nameDspWin,ExposureMask,&ev))
               ;
            while (XCheckWindowEvent (mainDisplay,nameBaseWin,
                  StructureNotifyMask,&ev))
               ;

            if (tabbed_from_root)
               RedrawNameBaseWindow (TopStr, full_name, str_start, graph_start,
                     button_start, w, h);
            else
               RedrawNameBaseWindow (tmp_top_str, full_name, str_start,
                     graph_start, button_start, w, h);
            RedrawNameScrollWin ();
            RedrawDspWindow ();

            exposed = TRUE;
            XSync (mainDisplay, False);

            if ((input.type==MapNotify && input.xany.window==nameBaseWin) ||
                  (input.type==Expose && (input.xany.window==nameBaseWin ||
                  input.xany.window==nameScrollWin ||
                  input.xany.window==nameDspWin)))
               continue;
         }

         if (input.type==Expose)
            ExposeEventHandler (&input, FALSE);
         else if (input.type==VisibilityNotify &&
               input.xany.window==mainWindow &&
               input.xvisibility.state==VisibilityUnobscured)
         {
            while (XCheckWindowEvent (mainDisplay, mainWindow,
                  VisibilityChangeMask, &ev)) ;
            if (pinnedMainMenu) XMapRaised (mainDisplay, mainMenuWindow);
            for (i = 0; i < numExtraWins; i++)
               if (extraWinInfo[i].mapped && extraWinInfo[i].raise &&
                     extraWinInfo[i].window != None)
                  XMapRaised (mainDisplay, extraWinInfo[i].window);
            XMapRaised (mainDisplay, nameBaseWin);
         }
         else if (input.type == KeyPress)
         {
            key_ev = &(input.xkey);
            XLookupString (key_ev, buf, 80-1, &key_sym, &c_stat);
            TranslateKeys (buf, &key_sym);

            if (tabbed_from_root && ((buf[0]=='\r' && (key_sym & 0xff)=='\r') ||
                (buf[0]=='\n' && (key_sym & 0xff)=='\n') ||
		(buf[0]=='\r' && (key_sym & 0xff)=='m')))
            {
               changing = FALSE;
               index = nameMarked;
               button_selected = BUTTON_OK;
            }
            else if ((buf[0]=='\033' && (key_sym & 0xff)=='\033') ||
		  (buf[0]=='\033' && (key_sym & 0xff)=='['))
            {
               looping = FALSE;
               changing = FALSE;
               index = INVALID;
               button_selected = BUTTON_CANCEL;
            }
            else if ((buf[0]=='\b' && (key_sym & 0xff)=='\b') ||
                  (buf[0]=='\b' && (key_sym & 0xff)=='h') ||
                  (buf[0]=='\177' && (key_sym & 0x7f)=='\177') ||
                  key_sym==XK_Left || key_sym==XK_KP_Left)
            {
               if (name_index != 0)
               {
                  name[--name_index] = '\0';

                  sprintf (full_name, "%s/%s", dir_name, name);

                  if (tabbed_from_root && name_index != 0)
                  {
                     for (i = 0; i < nameEntries; i++)
                        if (strncmp (nameDspPtr[i], name, name_index) == 0)
                           break;

                     if (i < nameEntries)
                     {
                        if (i < nameFirst)
                           nameFirst = i;
                        else if (i >= nameFirst+ITEM_DSPED)
                        {
                           if (i < nameEntries-ITEM_DSPED)
                              nameFirst = i;
                           else
                              nameFirst = nameEntries-ITEM_DSPED;
                        }
                        nameMarked = i;
                        if (exposed)
                        {
                           RedrawNamePath (full_name, graph_start,
                                 3*ROW_HEIGHT+defaultFontAsc+2);
                           RedrawNameScrollWin ();
                           RedrawDspWindow ();
                        }
                     }
                  }
                  else
                  {
                     nameFirst = 0;
                     nameMarked = INVALID;
                     if (exposed)
                     {
                        RedrawNamePath (full_name, graph_start,
                              3*ROW_HEIGHT+defaultFontAsc+2);
                        RedrawNameScrollWin ();
                        RedrawDspWindow ();
                     }
                  }
               }
               else if (*dir_name == '\0' && *saved_dir_name != '\0')
               {
                  changing = FALSE;
                  pop_from_root = TRUE;
                  index = INVALID;
               }
               else
               {  /* fake as if "../" is selected */
                  strcpy (name, "../");
                  name_index = strlen (name);
                  for (i = 0; i < nameEntries; i++)
                     if (strncmp (nameDspPtr[i], name, name_index) == 0)
                        break;
                  if (i != nameEntries)
                  {
                     changing = FALSE;
                     faking_dot_dot = TRUE;
                     index = nameMarked = i;
                  }
               }
            }
            else if (!tabbed_from_root && (buf[0]=='\t' ||
                  (buf[0]=='\r' && (key_sym & 0xff)=='\r') ||
                  (buf[0]=='\n' && (key_sym & 0xff)=='\n') ||
		  (buf[0]=='\r' && (key_sym & 0xff)=='m')))
            {
               tabbed_from_root = TRUE;
               just_tabbed_from_root = TRUE;
               if (FileIsRemote (name))
                  name_is_remote = TRUE;
               else
               {
                  sprintf (full_name, "%s/%s", dir_name, name);
                  strcpy (tmp_name, name);
                  ParseFileName (full_name, dir_name, name);
               }
               changing = FALSE;
               index = INVALID;
            }
            else if (((tabbed_from_root && nameEntries != 0) ||
                  !tabbed_from_root) && ((key_sym>'\040' && key_sym<='\177' &&
                  (key_ev->state & ControlMask)) || key_sym==XK_Up ||
                  key_sym==XK_Down || key_sym==XK_KP_Up || key_sym==XK_KP_Down))
            {
               if (tabbed_from_root &&
                     ((i = ControlChar (key_ev, key_sym)) != BAD))
               {
                  if (i == INVALID)
                  {
                     name[0] = '\0';
                     name_index = 0;
                     nameFirst = 0;
                     nameMarked = INVALID;
                  }
                  else
                  {
                     strcpy (name, nameDspPtr[i]);
                     name_index = strlen (name);

                     if (i < nameFirst)
                        nameFirst = i;
                     else if (i >= nameFirst+ITEM_DSPED)
                     {
                        if (i < nameEntries-ITEM_DSPED)
                           nameFirst = i;
                        else
                           nameFirst = nameEntries-ITEM_DSPED;
                     }
                     nameMarked = i;
                  }

                  sprintf (full_name, "%s/%s", dir_name, name);

                  if (exposed)
                  {
                     RedrawNamePath (full_name, graph_start,
                           3*ROW_HEIGHT+defaultFontAsc+2);
                     RedrawNameScrollWin ();
                     RedrawDspWindow ();
                  }
               }
               else if (!tabbed_from_root &&
                     ControlChar (key_ev, key_sym) == INVALID)
               {
                  BackUpOneWord (name, &name_index);
                  sprintf (full_name, "%s/%s", dir_name, name);
                  if (exposed)
                  {
                     RedrawNamePath (full_name, graph_start,
                           3*ROW_HEIGHT+defaultFontAsc+2);
                     RedrawNameScrollWin ();
                     RedrawDspWindow ();
                  }
               }
            }
            else if (key_sym>='\040' && key_sym<='\177' &&
                  ((tabbed_from_root && nameEntries != 0) ||
                  (!tabbed_from_root)))
            {
               i = INVALID;
               if (!tabbed_from_root)
               {
                  name[name_index++] = buf[0];
                  name[name_index] = '\0';
                  sprintf (full_name, "%s/%s", dir_name, name);
                  if (exposed)
                  {
                     RedrawNamePath (full_name, graph_start,
                           3*ROW_HEIGHT+defaultFontAsc+2);
                     RedrawNameScrollWin ();
                     RedrawDspWindow ();
                  }
                  continue;
               }
               else if (buf[0] == '$')
               {
                  i = nameEntries-1;
                  strcpy (name, nameDspPtr[i]);
               }
               else if (buf[0] == '^')
               {
                  i = 0;
                  strcpy (name, nameDspPtr[i]);
               }
#ifdef apollo
               else if (name_index == 0 && buf[0] == '/' && *dir_name == '\0')
               {
                  strcpy (dir_name, "/");
                  name[name_index++] = buf[0];
                  i = nameEntries;
                  strcpy (full_name, "//");
                  if (exposed)
                     RedrawNamePath (full_name, graph_start,
                           3*ROW_HEIGHT+defaultFontAsc+2);
               }
#endif
               else if (name_index == 0 && buf[0] == '/')
               {
                  if (*saved_dir_name == '\0')
                     strcpy (saved_dir_name, dir_name);
                  changing = FALSE;
                  change_to_root = TRUE;
                  tabbed_from_root = FALSE;
                  index = INVALID;
                  *dir_name = *name = '\0';
                  strcpy (tmp_top_str, "Type <TAB> for file completion..");
               }
               else
               {
                  name[name_index++] = buf[0];
                  name[name_index] = '\0';
                  for (i = 0; i < nameEntries; i++)
                     if (strncmp (nameDspPtr[i], name, name_index) == 0)
                        break;
               }

               if (i < nameEntries)
               {
                  if (buf[0] == '/')
                  {
                     changing = FALSE;
                     index = nameMarked = i;
                  }
                  else
                  {
                     if (i < nameFirst)
                        nameFirst = i;
                     else if (i >= nameFirst+ITEM_DSPED)
                     {
                        if (i < nameEntries-ITEM_DSPED)
                           nameFirst = i;
                        else
                           nameFirst = nameEntries-ITEM_DSPED;
                     }
                     nameMarked = i;

                     sprintf (full_name, "%s/%s", dir_name, name);

                     if (exposed)
                     {
                        RedrawNamePath (full_name, graph_start,
                              3*ROW_HEIGHT+defaultFontAsc+2);
                        RedrawNameScrollWin ();
                        RedrawDspWindow ();
                     }
                  }
               }
               else
                  name[--name_index] = '\0';
            }
         }
         else if (input.type == ButtonPress)
         {
            button_ev = &(input.xbutton);
            if (button_ev->window == nameBaseWin)
            {
               if (PointInBBox (button_ev->x, button_ev->y, buttonBBox[0]))
               {
                  if (!tabbed_from_root)
                  {
                     if (FileIsRemote (name))
                        name_is_remote = TRUE;
                     else
                     {
                        tabbed_from_root = TRUE;
                        just_tabbed_from_root = TRUE;
                        sprintf (full_name, "%s/%s", dir_name, name);
                        strcpy (tmp_name, name);
                        ParseFileName (full_name, dir_name, name);
                     }
                  }
                  changing = FALSE;
                  index = nameMarked;
                  button_selected = BUTTON_OK;
               }
               else if (PointInBBox (button_ev->x, button_ev->y, buttonBBox[1]))
               {
                  changing = FALSE;
                  if (nameMarked != INVALID &&
                        nameDspPtr[nameMarked][strlen(nameDspPtr[nameMarked])-1]
                        == '/')
                  {
                     button_selected = BUTTON_OK;
                     index = nameMarked;
                  }
                  else
                  {
                     button_selected = BUTTON_SETDIR;
                     index = INVALID;
                     looping = FALSE;
                  }
               }
               else if (PointInBBox (button_ev->x, button_ev->y, buttonBBox[2]))
               {
                  looping = FALSE;
                  changing = FALSE;
                  index = INVALID;
                  button_selected = BUTTON_CANCEL;
               }
               else if (!tabbed_from_root && button_ev->button == Button2 &&
                     PointInBBox (button_ev->x, button_ev->y, edit_bbox))
               {
                  int	buf_len=0;
                  char	* cut_buffer=FetchCutBuffer (&buf_len);

                  if (cut_buffer != NULL)
                  {
                     char	* c_ptr=cut_buffer;
                     int	max_len=sizeof(full_name)-strlen(dir_name)-3;

                     while (name_index < max_len &&
                           *c_ptr >= '\040' && *c_ptr < '\177')
                        name[name_index++] = *c_ptr++;

                     name[name_index] = '\0';
                     sprintf (full_name, "%s/%s", dir_name, name);
                     if (exposed)
                     {
                        RedrawNamePath (full_name, graph_start,
                              3*ROW_HEIGHT+defaultFontAsc+2);
                        RedrawNameScrollWin ();
                        RedrawDspWindow ();
                     }
                     XFree (cut_buffer);
                  }
               }
            }
            else if (button_ev->window == nameScrollWin)
               NameScrollHandler (button_ev);
            else if (button_ev->window == nameDspWin)
            {
               if (NameDspHandler (button_ev) != INVALID)
               {
                  changing = FALSE;
                  index = nameMarked;
                  button_selected = BUTTON_OK;
               }
               else if (nameMarked != INVALID)
               {
                  strcpy (name, nameDspPtr[nameMarked]);
                  name_index = strlen (name);
                  sprintf (full_name, "%s/%s", dir_name, name);
                  RedrawNamePath (full_name, graph_start,
                        3*ROW_HEIGHT+defaultFontAsc+2);
               }
            }
         }
      }

      if (index != INVALID) strcpy (sel_str, nameDspPtr[index]);

      if (nameDspPtr != NULL)
      {
         cfree (*nameDspPtr);
         cfree (nameDspPtr);
         nameDspPtr = NULL;
      }

      if (index==INVALID && !change_to_root && !pop_from_root &&
            !just_tabbed_from_root)
         break;

      if (change_to_root)
         *dir_name = '\0';
      else if (pop_from_root)
      {
         strcpy (dir_name, saved_dir_name);
         *saved_dir_name = '\0';
         tabbed_from_root = TRUE;
      }
      else if (sel_str[strlen(sel_str)-1] == '/')
      {
         sel_str[strlen(sel_str)-1] = '\0';
         if (strcmp (sel_str, "..") == 0)
         {
            for (i = strlen(dir_name)-1; i>=0 && dir_name[i]!='/'; i--) ;
            if (i < 0)
            {
               strcpy (saved_name, dir_name);
               dir_name[0] = '\0';
            }
            else
            {
               strcpy (saved_name, &dir_name[i+1]);
               dir_name[i] = '\0';
            }
         }
         else
         {
            strcat (dir_name, "/");
            strcat (dir_name, sel_str);
         }
      }
      else if (!just_tabbed_from_root)
         break;

      for (dsp_ptr = topOfDirLinkList; dsp_ptr != NULL; dsp_ptr = next_dsp)
      {
         next_dsp = dsp_ptr->next;
         cfree (dsp_ptr);
      }
      topOfDirLinkList = NULL;

      if (change_to_root)
      {
         numDirEntries = 0;
         nameEntries = 0;
         index = INVALID;
         *sel_str = '\0';
         if (dirList != NULL) { cfree (dirList); dirList = NULL; }
      }
      else if (name_is_remote)
         break;
      else
      {
         SetWatchCursor (drawWindow);
         SetWatchCursor (mainWindow);
         SetWatchCursor (nameBaseWin);
         Msg ("Generating list of file names, please wait ...");
         if ((topOfDirLinkList =
               DirListing (dir_name, ExtStr, other_ext_str)) == NULL)
         {
            if (just_tabbed_from_root)
            {
               tabbed_from_root = FALSE;
               strcpy (name, tmp_name);
               *dir_name = '\0';
            }
            else
            {
               SetDefaultCursor (mainWindow);
               SetDefaultCursor (drawWindow);
               SetDrawCursor (nameBaseWin);
               *sel_str = '\0';
               index = INVALID;
               break;
            }
         }
         SetDefaultCursor (mainWindow);
         SetDefaultCursor (drawWindow);
         SetDrawCursor (nameBaseWin);
      }
      if (importingFile)
         Msg ("Click on 'SETDIR' to set importing directory.");
      else
         Msg ("Click on 'SETDIR' to set current directory.");
   }

   if (exposed && button_selected != INVALID)
      DisplayButton (nameBaseWin, buttonStr[button_selected], 8,
            &buttonBBox[button_selected], BUTTON_INVERT);

   XDestroyWindow (mainDisplay, nameBaseWin);
   if (warpToWinCenter)
      XWarpPointer (mainDisplay, None, drawWindow, 0, 0, 0, 0,
            (int)(ZOOMED_SIZE(drawWinW)>>1), (int)(ZOOMED_SIZE(drawWinH)>>1));

   if (button_selected == BUTTON_SETDIR)
   {
      if (DirIsRemote (dir_name))
      {
         *SelStr = '\0';
         *JustSetDir = FALSE;
         sprintf (name, "SETDIR not supported for '%s'.", dir_name);
         MsgBox (name, TOOL_NAME, INFO_MB);
      }
      else
      {
         sprintf (SelStr, "%s", dir_name);
         *JustSetDir = TRUE;
      }
   }
   else if (name_is_remote)
   {
      /* index != INVALID means SelStr is valid */
      index = 0;
      strcpy (SelStr, name);
      *JustSetDir = FALSE;
   }
   else
   {
      sprintf (SelStr, "%s/%s", dir_name, sel_str);
      *JustSetDir = FALSE;
   }
   return (index);
}

static
int ChooseAName (TopStr)
   char	* TopStr;
{
   int			button_widths, str_width, graph_width;
   int			str_start, button_start, graph_start, index = 0;
   int			dsp_w, dsp_h, w, h, i, button_selected = INVALID;
   XEvent		input, ev;
   int			changing = TRUE, name_index, exposed = FALSE;
   char			buf[80], name[MAXPATHLENGTH];
   XKeyEvent		* key_ev;
   XButtonEvent		* button_ev;
   KeySym		key_sym;
   XWMHints		wmhints;
   XSizeHints		sizehints;
   XSetWindowAttributes	win_attrs;
   int			win_x, win_y;

   dsp_w = DisplayWidth (mainDisplay, mainScreen);
   dsp_h = DisplayHeight (mainDisplay, mainScreen);

   button_widths = ButtonWidth("OK", 8) + ButtonWidth("CANCEL", 8) +
         defaultFontWidth;
   numButtons = 2;
   strcpy (buttonStr[0], "OK");
   strcpy (buttonStr[1], "CANCEL");

   str_width = defaultFontWidth * strlen (TopStr);
   graph_width = nameDspWinW + scrollBarW + 2 * brdrW;

   if (str_width > graph_width)
   {
      w = str_width + 4 * defaultFontWidth;
      str_start = 2 * defaultFontWidth;
      graph_start = (w - graph_width) / 2;
   }
   else
   {
      w = graph_width + 4 * defaultFontWidth;
      str_start = (w - str_width) / 2;
      graph_start = 2 * defaultFontWidth;
   }
   button_start = (w - button_widths) / 2;
   h = (8 + ITEM_DSPED) * ROW_HEIGHT;

   win_x = (w > dsp_w) ? 0 : (dsp_w - w)/2;
   win_y = (h > dsp_h) ? 0 : (dsp_h - h)/3;

   if ((nameBaseWin = XCreateSimpleWindow (mainDisplay, rootWindow,
         win_x, win_y, w, h, brdrW, myBorderPixel, myBgPixel)) == 0)
      Error ("ChooseAName()", "Can not XCreateSimpleWindow() for nameBaseWin");

   XDefineCursor (mainDisplay, nameBaseWin, defaultCursor);

   if ((nameDspWin = XCreateSimpleWindow (mainDisplay, nameBaseWin, graph_start,
         5*ROW_HEIGHT, nameDspW, nameDspH, brdrW, myBorderPixel,
         myBgPixel)) == 0)
      Error ("ChooseAName()", "Can not XCreateSimpleWindow() for nameDspWin");

   if ((nameScrollWin = XCreateSimpleWindow (mainDisplay, nameBaseWin,
         graph_start+nameDspWinW, 5*ROW_HEIGHT, scrollBarW, nameDspH,
         brdrW, myBorderPixel, myBgPixel)) == 0)
      Error ("ChooseAName()","Can not XCreateSimpleWindow() for nameScrollWin");

   win_attrs.save_under = True;
   win_attrs.colormap = mainColormap;
   XChangeWindowAttributes (mainDisplay, nameBaseWin, CWSaveUnder | CWColormap,
         &win_attrs);

   wmhints.flags = InputHint | StateHint;
   wmhints.input = True;
   wmhints.initial_state = NormalState;
   XSetWMHints (mainDisplay, nameBaseWin, &wmhints);

   sizehints.flags = PPosition | PSize | USPosition | PMinSize | PMaxSize;
   sizehints.x = win_x;
   sizehints.y = win_y;
   sizehints.width = sizehints.min_width = sizehints.max_width = w;
   sizehints.height = sizehints.min_height = sizehints.max_height = h;
#ifdef NOTR4MODE
   XSetNormalHints (mainDisplay, nameBaseWin, &sizehints);
#else
   XSetWMNormalHints (mainDisplay, nameBaseWin, &sizehints);
#endif
   sprintf (buf, "%s - %s", TOOL_NAME, TopStr);
   XStoreName (mainDisplay, nameBaseWin, buf);

   XSetTransientForHint (mainDisplay, nameBaseWin, mainWindow);

#ifdef MAPBEFORESELECT
   XMapWindow (mainDisplay, nameBaseWin);
   XSelectInput (mainDisplay, nameBaseWin,
         KeyPressMask | ButtonPressMask | ExposureMask | StructureNotifyMask);
   XMapWindow (mainDisplay, nameDspWin);
   XSelectInput (mainDisplay, nameDspWin,
         KeyPressMask | ButtonPressMask | ExposureMask);
   XMapWindow (mainDisplay, nameScrollWin);
   XSelectInput (mainDisplay, nameScrollWin,
         KeyPressMask | ButtonPressMask | ExposureMask);
#else
   XSelectInput (mainDisplay, nameBaseWin,
         KeyPressMask | ButtonPressMask | ExposureMask | StructureNotifyMask);
   XMapWindow (mainDisplay, nameBaseWin);
   XSelectInput (mainDisplay, nameDspWin,
         KeyPressMask | ButtonPressMask | ExposureMask);
   XMapWindow (mainDisplay, nameDspWin);
   XSelectInput (mainDisplay, nameScrollWin,
         KeyPressMask | ButtonPressMask | ExposureMask);
   XMapWindow (mainDisplay, nameScrollWin);
#endif

   if (warpToWinCenter)
      XWarpPointer (mainDisplay, None, nameBaseWin, 0, 0, 0, 0,
            (int)(w/2), (int)(h/2));

   XSync (mainDisplay, False);

   justClicked = FALSE;

   Msg ("");

   if (nameMarked == INVALID)
   {
      name[0] = '\0';
      name_index = 0;
   }
   else
   {
      if (nameMarked >= ITEM_DSPED)
      {
         if (nameMarked < nameEntries-ITEM_DSPED)
            nameFirst = nameMarked;
         else
            nameFirst = nameEntries-ITEM_DSPED;
      }
      strcpy (name, nameDspPtr[nameMarked]);
      name_index = strlen (name);
   }

   while (changing)
   {
      XNextEvent (mainDisplay, &input);

      if ((input.type==MapNotify && input.xany.window==nameBaseWin) ||
            (input.type==Expose && (input.xany.window==nameBaseWin ||
            input.xany.window==nameScrollWin ||
            input.xany.window==nameDspWin)) ||
            (!exposed &&
            (XCheckWindowEvent (mainDisplay,nameBaseWin,ExposureMask,&ev) ||
            XCheckWindowEvent (mainDisplay,nameScrollWin,ExposureMask,&ev) ||
            XCheckWindowEvent (mainDisplay,nameDspWin,ExposureMask,&ev) ||
            XCheckWindowEvent (mainDisplay,nameBaseWin,StructureNotifyMask,
            &ev))))
      {
         while (XCheckWindowEvent (mainDisplay,nameBaseWin,ExposureMask,&ev)) ;
         while (XCheckWindowEvent (mainDisplay,nameScrollWin,ExposureMask,
               &ev))
            ;
         while (XCheckWindowEvent (mainDisplay,nameDspWin,ExposureMask,&ev)) ;
         while (XCheckWindowEvent (mainDisplay,nameBaseWin,StructureNotifyMask,
               &ev))
            ;

         RedrawNameBaseWindow (TopStr, name, str_start, graph_start,
               button_start, w, h);
         RedrawNameScrollWin ();
         RedrawDspWindow ();

         exposed = TRUE;
         XSync (mainDisplay, False);

         if ((input.type==MapNotify && input.xany.window==nameBaseWin) ||
               (input.type==Expose && (input.xany.window==nameBaseWin ||
               input.xany.window==nameScrollWin ||
               input.xany.window==nameDspWin)))
            continue;
      }

      if (input.type==Expose)
         ExposeEventHandler (&input, FALSE);
      else if (input.type==VisibilityNotify && input.xany.window==mainWindow &&
            input.xvisibility.state==VisibilityUnobscured)
      {
         while (XCheckWindowEvent (mainDisplay, mainWindow,
               VisibilityChangeMask, &ev)) ;
         if (pinnedMainMenu) XMapRaised (mainDisplay, mainMenuWindow);
         for (i = 0; i < numExtraWins; i++)
            if (extraWinInfo[i].mapped && extraWinInfo[i].raise &&
                  extraWinInfo[i].window != None)
               XMapRaised (mainDisplay, extraWinInfo[i].window);
         XMapRaised (mainDisplay, nameBaseWin);
      }
      else if (input.type == KeyPress)
      {
         key_ev = &(input.xkey);
         XLookupString (key_ev, buf, 80-1, &key_sym, &c_stat);
         TranslateKeys (buf, &key_sym);

	 if ((buf[0]=='\r' && (key_sym & 0xff)=='\r') ||
	     (buf[0]=='\n' && (key_sym & 0xff)=='\n') ||
	     (buf[0]=='\r' && (key_sym & 0xff)=='m'))
         {
            changing = FALSE;
            index = nameMarked;
            button_selected = BUTTON_OK;
         }
	 else if ((buf[0]=='\033' && (key_sym & 0xff)=='\033') ||
	       (buf[0]=='\033' && (key_sym & 0xff)=='['))
         {
            changing = FALSE;
            index = INVALID;
            button_selected = 1;
         }
         else if ((buf[0] == '\b'  && (key_sym & 0xff)=='\b') ||
               (buf[0] == '\b' && (key_sym & 0xff)=='h') ||
               (buf[0] == '\177' && (key_sym & 0x7f)=='\177') ||
               key_sym==XK_Left || key_sym==XK_KP_Left)
         {
            if (name_index != 0)
            {
               name[--name_index] = '\0';

               if (name_index != 0)
               {
                  for (i = 0; i < nameEntries; i++)
                     if (strncmp (nameDspPtr[i], name, name_index) == 0)
                        break;

                  if (i < nameEntries)
                  {
                     if (i < nameFirst)
                        nameFirst = i;
                     else if (i >= nameFirst+ITEM_DSPED)
                     {
                        if (i < nameEntries-ITEM_DSPED)
                           nameFirst = i;
                        else
                           nameFirst = nameEntries-ITEM_DSPED;
                     }
                     nameMarked = i;
                     if (exposed)
                     {
                        RedrawNamePath (name, graph_start,
                              3*ROW_HEIGHT+defaultFontAsc+2);
                        RedrawNameScrollWin ();
                        RedrawDspWindow ();
                     }
                  }
               }
               else
               {
                  nameFirst = 0;
                  nameMarked = INVALID;
                  if (exposed)
                  {
                     RedrawNamePath (name, graph_start,
                           3*ROW_HEIGHT+defaultFontAsc+2);
                     RedrawNameScrollWin ();
                     RedrawDspWindow ();
                  }
               }
            }
         }
         else if (nameEntries != 0 && ((key_sym>'\040' && key_sym<='\177' &&
               (key_ev->state & ControlMask)) || key_sym==XK_Up ||
               key_sym==XK_Down || key_sym==XK_KP_Up || key_sym==XK_KP_Down))
         {
            if ((i = ControlChar (key_ev, key_sym)) != BAD)
            {
               if (i == INVALID)
               {
                  name[0] = '\0';
                  name_index = 0;
                  nameFirst = 0;
                  nameMarked = INVALID;
               }
               else
               {
                  strcpy (name, nameDspPtr[i]);
                  name_index = strlen (name);

                  if (i < nameFirst)
                     nameFirst = i;
                  else if (i >= nameFirst+ITEM_DSPED)
                  {
                     if (i < nameEntries-ITEM_DSPED)
                        nameFirst = i;
                     else
                        nameFirst = nameEntries-ITEM_DSPED;
                  }
                  nameMarked = i;
               }

               if (exposed)
               {
                  RedrawNamePath (name, graph_start,
                        3*ROW_HEIGHT+defaultFontAsc+2);
                  RedrawNameScrollWin ();
                  RedrawDspWindow ();
               }
            }
         }
         else if (key_sym>='\040' && key_sym<='\177' && nameEntries != 0)
         {
            if (buf[0] == '$')
            {
               i = nameEntries-1;
               strcpy (name, nameDspPtr[i]);
            }
            else if (buf[0] == '^')
            {
               i = 0;
               strcpy (name, nameDspPtr[i]);
            }
            else
            {
               name[name_index++] = buf[0];
               name[name_index] = '\0';
               for (i = 0; i < nameEntries; i++)
                  if (strncmp (nameDspPtr[i], name, name_index) == 0)
                     break;
            }

            if (i < nameEntries)
            {
               if (i < nameFirst)
                  nameFirst = i;
               else if (i >= nameFirst+ITEM_DSPED)
               {
                  if (i < nameEntries-ITEM_DSPED)
                     nameFirst = i;
                  else
                     nameFirst = nameEntries-ITEM_DSPED;
               }
               nameMarked = i;

               if (exposed)
               {
                  RedrawNamePath (name, graph_start,
                        3*ROW_HEIGHT+defaultFontAsc+2);
                  RedrawNameScrollWin ();
                  RedrawDspWindow ();
               }
            }
            else
               name[--name_index] = '\0';
         }
      }
      else if (input.type == ButtonPress)
      {
         button_ev = &(input.xbutton);
         if (button_ev->window == nameBaseWin)
         {
            if (PointInBBox (button_ev->x, button_ev->y, buttonBBox[0]))
            {
               changing = FALSE;
               index = nameMarked;
               button_selected = BUTTON_OK;
            }
            else if (PointInBBox (button_ev->x, button_ev->y, buttonBBox[1]))
            {
               changing = FALSE;
               index = INVALID;
               button_selected = 1;
            }
         }
         else if (button_ev->window == nameScrollWin)
            NameScrollHandler (button_ev);
         else if (button_ev->window == nameDspWin)
         {
            if (NameDspHandler (button_ev) != INVALID)
            {
               changing = FALSE;
               index = nameMarked;
               button_selected = BUTTON_OK;
            }
            else if (nameMarked != INVALID)
            {
               strcpy (name, nameDspPtr[nameMarked]);
               name_index = strlen (name);
               RedrawNamePath (name, graph_start,
                     3*ROW_HEIGHT+defaultFontAsc+2);
            }
         }
      }
   }

   if (exposed && button_selected != INVALID)
      DisplayButton (nameBaseWin, buttonStr[button_selected], 8,
            &buttonBBox[button_selected], BUTTON_INVERT);

   XDestroyWindow (mainDisplay, nameBaseWin);
   if (warpToWinCenter)
      XWarpPointer (mainDisplay, None, drawWindow, 0, 0, 0, 0,
            (int)(ZOOMED_SIZE(drawWinW)>>1), (int)(ZOOMED_SIZE(drawWinH)>>1));
   return (index);
}

int SelectFileName (MsgStr, SelStr)
   char	* MsgStr, * SelStr;
{
   int		index, saved_num_dir_entries, just_set_dir;
   DspList	* dsp_ptr, * next_dsp;
   char		saved_cur_dir[MAXPATHLENGTH];

   if (curDirIsLocal)
      strcpy (saved_cur_dir, curDir);
   else
      strcpy (saved_cur_dir, curLocalDir);
   saved_num_dir_entries = numDirEntries;
   if ((index = DirNames (MsgStr,OBJ_FILE_EXT,SelStr,&just_set_dir)) == INVALID)
   {
      if (just_set_dir)
      {
         strcpy (curDir, SelStr);
         BuildDirList ();
         if (strcmp (saved_cur_dir, curDir) != 0 && DirInSymPath ("."))
            UpdateSymInfo ();
         RedrawTitleWindow ();
         Msg ("");
      }
      else
      {
         numDirEntries = saved_num_dir_entries;
         for (dsp_ptr = topOfDirLinkList; dsp_ptr != NULL; dsp_ptr = next_dsp)
         {
            next_dsp = dsp_ptr->next;
            cfree (dsp_ptr);
         }
         topOfDirLinkList = NULL;
      }
      *SelStr = '\0';
      return (INVALID);
   }
   BuildDirList ();
   Msg ("");
   return (index);
}

int SelectFileNameToPaste (MsgStr, SelStr)
   char	* MsgStr, * SelStr;
{
   int		index, saved_num_dir_entries, just_set_dir;
   DspList	* dsp_ptr, * next_dsp;
   char		saved_cur_dir[MAXPATHLENGTH];

   if (curDirIsLocal)
      strcpy (saved_cur_dir, curDir);
   else
      strcpy (saved_cur_dir, curLocalDir);
   saved_num_dir_entries = numDirEntries;
   if ((index = DirNames (MsgStr,NULL,SelStr,&just_set_dir)) == INVALID)
   {
      if (just_set_dir)
      {
         strcpy (curDir, SelStr);
         BuildDirList ();
         if (strcmp (saved_cur_dir, curDir) != 0 && DirInSymPath ("."))
            UpdateSymInfo ();
         RedrawTitleWindow ();
         Msg ("");
      }
      else
      {
         numDirEntries = saved_num_dir_entries;
         for (dsp_ptr = topOfDirLinkList; dsp_ptr != NULL; dsp_ptr = next_dsp)
         {
            next_dsp = dsp_ptr->next;
            cfree (dsp_ptr);
         }
         topOfDirLinkList = NULL;
      }
      *SelStr = '\0';
      return (INVALID);
   }
   BuildDirList ();
   Msg ("");
   return (index);
}

int SelectFileNameToImport (MsgStr, ExtStr, SelStr)
   char	* MsgStr, * ExtStr, * SelStr;
{
   int		index, saved_num_dir_entries, just_set_dir;
   DspList	* dsp_ptr, * next_dsp;
   char		msg[MAXPATHLENGTH];

   saved_num_dir_entries = numDirEntries;
   if ((index = DirNames (MsgStr, ExtStr, SelStr, &just_set_dir)) == INVALID)
   {
      if (just_set_dir)
      {
         strcpy (curImportDir, SelStr);
         sprintf (msg, "Changing importing directory to %s.", curImportDir);
      }
      *SelStr = '\0';
   }
   else
      Msg ("");

   numDirEntries = saved_num_dir_entries;
   for (dsp_ptr = topOfDirLinkList; dsp_ptr != NULL; dsp_ptr = next_dsp)
   {
      next_dsp = dsp_ptr->next;
      cfree (dsp_ptr);
   }
   topOfDirLinkList = NULL;

   return (index);
}

int GetSymbolPath (SymName, PathName)
   char	* SymName, * PathName;
{
   register int	i;

   if (symbolList == NULL) return (FALSE);

   for (i = 0; i < numSymbols; i++)
      if (strcmp (SymName, symbolList[i].itemstr) == 0)
      {
         strcpy (PathName, symbolList[i].pathstr);
         return (TRUE);
      }
   return (FALSE);
}

int NameInCurDir (FileName)
   char	* FileName;
{
   register int	i;

   if (dirList == NULL) return (FALSE);

   for (i = 0; i < numDirEntries; i++)
      if (dirList[i].directory && strcmp (FileName, dirList[i].itemstr) == 0)
         return (TRUE);

   return (FALSE);
}

int DirInSymPath (DirName)
   char	* DirName;
{
   register int	i;

   if (symPath == NULL) return (FALSE);

   for (i = 0; i < symPathNumEntries; i++)
      if (strcmp (DirName, symPath[i]) == 0)
         return (TRUE);

   return (FALSE);
}

static char	* * tmpDomainName=NULL;

static
DspList * DomainListing (Entries)
   int	* Entries;
{
   register int	i;
   int		seen_examples = FALSE;
   char		s[MAXSTRING], * c_ptr;
   DspList	* dsp_ptr, * head_ptr, * tail_ptr, * p, * p1;
   DspList	* next_dsp;

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "MaxDomains")) == NULL)
      *Entries = 1;
   else
      *Entries = atoi (c_ptr)+1;

   tmpDomainName = (char **) calloc (*Entries, sizeof(char *));
   for (i = 0; i < *Entries; i++) tmpDomainName[i] = NULL;

   head_ptr = tail_ptr = NULL;
   for (i = 0; i < *Entries; i++)
   {
      if (i != (*Entries)-1)
      {
         char	* c_ptr1;

         if (domainInResource)
         {
            sprintf (s, "DomainPath%1d", i);
            if ((c_ptr=XGetDefault (mainDisplay, TOOL_NAME, s)) != NULL)
               while (*c_ptr==' ' || *c_ptr=='\t' || *c_ptr=='\n') c_ptr++;
         }
         else
         {
            sprintf (s, "Domain%1d", i);
            c_ptr = XGetDefault (mainDisplay, TOOL_NAME, s);
         }
         if (c_ptr == NULL || *c_ptr == '\0')
         {
            for ( ; head_ptr != NULL; head_ptr = next_dsp)
            {
               next_dsp = head_ptr->next;
               cfree (head_ptr);
            }
            return (NULL);
         }
         dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
         tmpDomainName[i] = (char *) calloc (strlen(c_ptr)+1, sizeof(char));
         if ((c_ptr1=strchr (c_ptr, ':')) != NULL)
         {
            int	len=c_ptr1-c_ptr;

            strncpy (dsp_ptr->itemstr, c_ptr, len);
            strncpy (tmpDomainName[i], c_ptr, len);
            dsp_ptr->itemstr[len] = '\0';
            tmpDomainName[i][len] = '\0';
         }
         else
         {
            strcpy (dsp_ptr->itemstr, c_ptr);
            strcpy (tmpDomainName[i], c_ptr);
         }
         if (strcmp (dsp_ptr->itemstr, "Examples") == 0)
            seen_examples = TRUE;
      }
      else if (seen_examples)
      {
         (*Entries)--;
         break;
      }
      else
      {
         dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
         strcpy (dsp_ptr->itemstr, "Examples");
         tmpDomainName[i] = (char *) calloc (strlen("Examples")+1,sizeof(char));
         strcpy (tmpDomainName[i], "Examples");
      }

      if (head_ptr == NULL)
         head_ptr = tail_ptr = dsp_ptr;
      else
      {
         p1 = NULL;
         for (p = head_ptr; p != NULL; p = p->next)
            if (LargerStr (dsp_ptr->itemstr, p->itemstr))
               p1 = p;
            else
               break;

         dsp_ptr->next = p;
         if (p == NULL)
         {  /* dsp_ptr has the largest element */
            tail_ptr->next = dsp_ptr;
            tail_ptr = dsp_ptr;
         }
         else if (p1 == NULL)
            head_ptr = dsp_ptr;
         else
            p1->next = dsp_ptr;
      }
   }
   return (head_ptr);
}

int SelectDomain (SelStr)
   char	* SelStr;
{
   register int	i;
   int		index;
   DspList	* dsp_ptr, * next_dsp;

   Msg ("Generating list of domain names, please wait ...");

   if ((dsp_ptr = DomainListing (&nameEntries)) == NULL)
   {
      if (tmpDomainName != NULL)
      {
         for (i=0; i < nameEntries; i++)
            if (tmpDomainName[i] != NULL)
               cfree (tmpDomainName[i]);
         cfree (tmpDomainName);
      }
      tmpDomainName = NULL;
      Msg ("No domain names found.");
      *SelStr = '\0';
      return (INVALID);
   }

   nameDspPtr = MakeNameDspItemArray (nameEntries, dsp_ptr);
   nameFirst = 0;
   nameMarked = INVALID;

   if ((index = ChooseAName ("Please select a new DOMAIN ...")) ==
         INVALID)
      *SelStr = '\0';
   else
      strcpy (SelStr, nameDspPtr[index]);

   for ( ; dsp_ptr != NULL; dsp_ptr = next_dsp)
   {
      next_dsp = dsp_ptr->next;
      cfree (dsp_ptr);
   }
   if (nameDspPtr != NULL)
   {
      cfree (*nameDspPtr);
      cfree (nameDspPtr);
      nameDspPtr = NULL;
   }

   Msg ("");

   index = INVALID;
   if (*SelStr != '\0' && nameEntries > 0 && tmpDomainName != NULL)
   {
      for (i=0; i<nameEntries; i++)
         if (tmpDomainName[i] != NULL && strcmp (tmpDomainName[i], SelStr) == 0)
         {
            index = i;
            break;
         }
   }
   if (tmpDomainName != NULL)
   {
      for (i=0; i < nameEntries; i++)
         if (tmpDomainName[i] != NULL)
            cfree (tmpDomainName[i]);
      cfree (tmpDomainName);
      tmpDomainName = NULL;
   }
   return (index);
}

static char	* oldDomain=NULL, * oldDir=NULL;

static
DspList * SymDirListing ()
{
   register int	i;
   int		checking=FALSE;
   DspList	* dsp_ptr, * head_ptr, * tail_ptr;

   if (oldDomain!=NULL && oldDir!=NULL && strcmp(oldDomain,curDomainName)==0)
      checking = TRUE;

   head_ptr = tail_ptr = NULL;
   for (i = 0; i < symPathNumEntries; i++)
   {
      dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
      dsp_ptr->next = NULL;
      strcpy (dsp_ptr->itemstr, symPath[i]);

      if (head_ptr == NULL)
         head_ptr = tail_ptr = dsp_ptr;
      else
      {
         tail_ptr->next = dsp_ptr;
         tail_ptr = dsp_ptr;
      }
      if (checking && strcmp (oldDir, symPath[i]) == 0)
      {
         checking = FALSE;
         nameMarked = i;
      }
   }
   nameEntries = symPathNumEntries;
   return (head_ptr);
}

int SelectSymDir (SelStr)
   char	* SelStr;
{
   int		index;
   char		msg[MAXSTRING+1];
   DspList	* dsp_ptr, * next_dsp;

   *SelStr = '\0';
   nameMarked = INVALID;
   if ((dsp_ptr = SymDirListing ()) == NULL) return (INVALID);

   nameDspPtr = MakeLongNameDspItemArray (nameEntries, dsp_ptr);
   nameFirst = 0;

   sprintf (msg, "Please select a DIRECTORY in the '%s' domain ...",
         curDomainName);
   if ((index = ChooseAName (msg)) != INVALID)
   {
      strcpy (SelStr, nameDspPtr[index]);
      if (oldDomain != NULL) cfree (oldDomain);
      if (oldDir != NULL) cfree (oldDir);
      oldDomain = (char *) calloc (strlen(curDomainName)+1, sizeof(char));
      oldDir = (char *) calloc (strlen(SelStr)+1, sizeof(char));
      strcpy (oldDomain, curDomainName);
      strcpy (oldDir, SelStr);
   }

   for ( ; dsp_ptr != NULL; dsp_ptr = next_dsp)
   {
      next_dsp = dsp_ptr->next;
      cfree (dsp_ptr);
   }
   if (nameDspPtr != NULL)
   {
      cfree (*nameDspPtr);
      cfree (nameDspPtr);
      nameDspPtr = NULL;
   }
   Msg ("");

   return (index);
}

static
DspList * BitmapListing (ExtStr,OtherExtStr)
   char	* ExtStr, * OtherExtStr;
{
   int			len, path_index, count = 0, reject, ext_len;
   char			path[MAXPATHLENGTH], ext_str[MAXSTRING];
   DspList		* dsp_ptr, * head_ptr, * tail_ptr, * p, * p1;
   DIR			* dirp;
   DIR_ENTRY		* d;

   head_ptr = tail_ptr = NULL;

   sprintf (ext_str, ".%s", ExtStr);
   ext_len = strlen (ext_str);
   for (path_index = 0; path_index < symPathNumEntries; path_index++)
   {
      strcpy (path, symPath[path_index]);
      if (strcmp (".", path) == 0)
      {
         if (curDirIsLocal)
            strcpy (path, curDir);
         else
            strcpy (path, curLocalDir);
      }

      if ((dirp = opendir (path)) == NULL)
         continue;

      while ((d = readdir (dirp)) != NULL)
      {
         len = strlen (d->d_name);
         if (!((len > ext_len &&
               UtilStrICmp (ext_str,&d->d_name[len-ext_len]) == 0) ||
               ExtensionMatch(OtherExtStr, d->d_name)))
            continue;

         if (head_ptr == NULL)
         {
            head_ptr = tail_ptr = (DspList *) calloc (1, sizeof(DspList));
            strcpy (head_ptr->itemstr, d->d_name);
            strcpy (head_ptr->pathstr, path);
         }
         else
         {
            p1 = NULL;
            reject = FALSE;
            for (p = head_ptr; p != NULL; p = p->next)
            {
               if (strcmp (d->d_name, p->itemstr) == 0)
               {
                  reject = TRUE;
                  break;
               }
               else if (LargerStr (d->d_name, p->itemstr))
                  p1 = p;
               else
               {
                  dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
                  strcpy (dsp_ptr->itemstr, d->d_name);
                  strcpy (dsp_ptr->pathstr, path);
                  break;
               }
            }
            if (reject) continue;
   
            dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
            dsp_ptr->next = p;
            strcpy (dsp_ptr->itemstr, d->d_name);
            strcpy (dsp_ptr->pathstr, path);

            if (p == NULL)
            {  /* dsp_ptr has the largest element */
               tail_ptr->next = dsp_ptr;
               tail_ptr = dsp_ptr;
            }
            else if (p1 == NULL)
               head_ptr = dsp_ptr;
            else
               p1->next = dsp_ptr;
         }
         count++;
      }
      closedir (dirp);
   }
   numSymbols = count;
   return (head_ptr);
}

int SelectFromLibrary (MsgStr, ExtStr, SelStr, PathStr)
   char	* MsgStr, * ExtStr, * SelStr, * PathStr;
{
   int		index;
   char		s[MAXPATHLENGTH], other_ext_str[MAXSTRING];
   DspList	* dsp_ptr, * next_dsp;

   *other_ext_str = '\0';

   if (strcmp (ExtStr, XBM_FILE_EXT) == 0)
      Msg ("Generating list of bitmap names, please wait ...");
   else if (strcmp (ExtStr, XPM_FILE_EXT) == 0)
      Msg ("Generating list of pixmap names, please wait ...");
   else if (strcmp (ExtStr, OBJ_FILE_EXT) == 0)
      Msg ("Generating list of object file names, please wait ...");
   else if (strcmp (ExtStr, SYM_FILE_EXT) == 0)
      Msg ("Generating list of symbol names, please wait ...");
   else if (strcmp (ExtStr, EPSF_FILE_EXT) == 0)
   {
      Msg ("Generating list of EPS file names, please wait ...");
      sprintf (other_ext_str, ".%s;.epsi", PS_FILE_EXT);
   }
   else
   {
      sprintf (s, "Unrecognized extension '%s'.  Abort!", ExtStr);
      Msg (s);
      *SelStr = *PathStr = '\0';
      return (INVALID);
   }

   if ((topOfSymLinkList = BitmapListing (ExtStr,other_ext_str)) == NULL)
   {
      if (strcmp (ExtStr, XBM_FILE_EXT) == 0)
         Msg ("No bitmap names found.");
      else if (strcmp (ExtStr, XPM_FILE_EXT) == 0)
         Msg ("No pixmap names found.");
      else if (strcmp (ExtStr, OBJ_FILE_EXT) == 0)
         Msg ("No object file names found.");
      else if (strcmp (ExtStr, SYM_FILE_EXT) == 0)
         Msg ("No symbol names found.");
      else if (strcmp (ExtStr, EPSF_FILE_EXT) == 0)
         Msg ("No EPS file names found.");
      *SelStr = *PathStr = '\0';
      return (INVALID);
   }
   BuildSymbolList ();

   nameEntries = numSymbols;
   nameDspPtr = MakeNameDspItemArray (nameEntries, symbolList);
   nameFirst = 0;
   nameMarked = INVALID;

   if ((index = ChooseAName (MsgStr)) == INVALID)
      *SelStr = *PathStr = '\0';
   else
   {
      strcpy (SelStr, nameDspPtr[index]);
      strcpy (PathStr, symbolList[index].pathstr);
   }

   for (dsp_ptr = topOfSymLinkList; dsp_ptr != NULL; dsp_ptr = next_dsp)
   {
      next_dsp = dsp_ptr->next;
      cfree (dsp_ptr);
   }
   if (nameDspPtr != NULL)
   {
      cfree (*nameDspPtr);
      cfree (nameDspPtr);
      nameDspPtr = NULL;
   }
   Msg ("");

   UpdateSymInfo ();
   return (index);
}

static
void ShrinkName (FileName)
   char	* FileName;
{
   register char	* c_ptr, * real_ptr;
   char			real_name[MAXPATHLENGTH];

   if (*FileName != '/') return;

   strcpy (real_name, FileName);
   real_ptr = real_name;
   c_ptr = &real_name[1];

   while (*c_ptr != '\0')
   {
      if (*c_ptr == '.')
      {
         if (*(c_ptr+1) == '.')
         {
            if (*(c_ptr+2) == '/')
            {  /* "../" */
               if (real_ptr != real_name)
                  while (*(--real_ptr) != '/') ;
               c_ptr += 3;
            }
            else
            {
               while (*c_ptr != '\0' && *c_ptr != '/')
                  *(++real_ptr) = *c_ptr++;
               if (*c_ptr == '/') { c_ptr++; *(++real_ptr) = '/'; }
            }
         }
         else if (*(c_ptr+1) == '/')
         {  /* "./" */
            c_ptr += 2;
         }
         else
         {
            while (*c_ptr != '\0' && *c_ptr != '/')
               *(++real_ptr) = *c_ptr++;
            if (*c_ptr == '/') { c_ptr++; *(++real_ptr) = '/'; }
         }
      }
#ifndef apollo
      else if (*c_ptr == '/')
         c_ptr++;
#endif
      else
      {
         while (*c_ptr != '\0' && *c_ptr != '/')
            *(++real_ptr) = *c_ptr++;
         if (*c_ptr == '/') { c_ptr++; *(++real_ptr) = '/'; }
      }
   }
   *(++real_ptr) = '\0';
   strcpy (FileName, real_name);
}

void SetCurDir (FileName)
   char	* FileName;
{
   register int	i;
   char		file_name[MAXPATHLENGTH+1];

   strcpy (file_name, FileName);
   ShrinkName (file_name);

   if (curDirIsLocal && FileIsRemote (FileName))
   {
      strcpy (curLocalDir, curDir);
      if (autoHyperSpaceOnRemote) {
         inHyperSpace = TRUE;
         Msg ("Entering hyperspace...");
      }
   }
   else if (!curDirIsLocal && !FileIsRemote (FileName))
      *curLocalDir = '\0';

   for (i = strlen(file_name)-1; i>=0 && file_name[i]!='/'; i--) ;

   if (i < 0)
   {
      TwoLineMsg ("Error:  No '/' found in SetCurDir ().",
                  "        curDir set to '.'.");
      strcpy (curDir, ".");
      strcpy (curFileName, FileName);
   }
   else
   {
      strcpy (curFileName, &file_name[i+1]);
      file_name[i] = '\0';
      strcpy (curDir, file_name);
   }
   curDirIsLocal = (!DirIsRemote (curDir));
   RedrawDummyWindow1 ();
}

void SetCurSymDir (FileName)
   char	* FileName;
{
   register int	i;
   char		file_name[MAXPATHLENGTH+1];

   strcpy (file_name, FileName);
   ShrinkName (file_name);

   for (i = strlen(file_name)-1; i>=0 && file_name[i]!='/'; i--) ;

   if (i < 0)
   {
      TwoLineMsg ("Error:  No '/' found in SetCurSymDir ().",
                  "        curSymDir set to '.'.");
      strcpy (curSymDir, ".");
      strcpy (curFileName, FileName);
   }
   else
   {
      strcpy (curFileName, &file_name[i+1]);
      file_name[i] = '\0';
      strcpy (curSymDir, file_name);
   }
}

void SetCurImportDir (FileName)
   char	* FileName;
{
   register int	i;
   char		file_name[MAXPATHLENGTH+1];

   strcpy (file_name, FileName);
   ShrinkName (file_name);

   for (i = strlen(file_name)-1; i>=0 && file_name[i]!='/'; i--) ;

   if (i < 0)
   {
      TwoLineMsg ("Error:  No '/' found in SetCurImportDir ().",
                  "        curImportDir set to '.'.");
      strcpy (curImportDir, ".");
   }
   else
   {
      file_name[i] = '\0';
      strcpy (curImportDir, file_name);
   }
}
