/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-1995, William Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell derivative works of
 * "tgif", and the right to distribute "tgif" for a fee) are
 * reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /u/multimedia/william/X11/TGIF2/RCS/obj.c,v 2.52 1995/05/15 01:22:30 william Exp $";
#endif

#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "arc.e"
#include "attr.e"
#include "auxtext.e"
#include "box.e"
#include "cmd.e"
#include "cursor.e"
#include "group.e"
#include "msg.e"
#ifndef _NO_EXTERN
#include "obj.e"
#endif
#include "oval.e"
#include "page.e"
#include "poly.e"
#include "polygon.e"
#include "rcbox.e"
#include "setup.e"
#include "spline.e"
#include "stretch.e"
#include "text.e"
#include "xbitmap.e"
#include "xpixmap.e"

struct ObjRec	* topObj = NULL, * botObj = NULL;

void AddObj (PrevPtr, NextPtr, ObjPtr)
   struct ObjRec	* PrevPtr, * NextPtr, * ObjPtr;
   /* add ObjPtr between PrevPtr and NextPtr */
{
   ObjPtr->prev = PrevPtr;
   ObjPtr->next = NextPtr;

   if (PrevPtr == NULL)
      curPage->top = topObj = ObjPtr;
   else
      PrevPtr->next = ObjPtr;

   if (NextPtr == NULL)
      curPage->bot = botObj = ObjPtr;
   else
      NextPtr->prev = ObjPtr;
}

void UnlinkObj (ObjPtr)
   struct ObjRec	*ObjPtr;
{
   if (topObj == ObjPtr)
      curPage->top = topObj = ObjPtr->next;
   else
      ObjPtr->prev->next = ObjPtr->next;

   if (botObj == ObjPtr)
      curPage->bot = botObj = ObjPtr->prev;
   else
      ObjPtr->next->prev = ObjPtr->prev;
}

void FreeObj (ObjPtr)
   register struct ObjRec	* ObjPtr;
{
   switch (ObjPtr->type)
   {
      case OBJ_POLY: DelAllAttrs(ObjPtr->fattr); FreePolyObj (ObjPtr); break;
      case OBJ_BOX: DelAllAttrs(ObjPtr->fattr); FreeBoxObj (ObjPtr); break;
      case OBJ_OVAL: DelAllAttrs(ObjPtr->fattr); FreeOvalObj (ObjPtr); break;
      case OBJ_TEXT: FreeTextObj (ObjPtr); break;
      case OBJ_POLYGON: DelAllAttrs(ObjPtr->fattr); FreePolygonObj (ObjPtr);
         break;
      case OBJ_ARC: DelAllAttrs(ObjPtr->fattr); FreeArcObj (ObjPtr); break;
      case OBJ_RCBOX: DelAllAttrs(ObjPtr->fattr); FreeRCBoxObj (ObjPtr); break;
      case OBJ_XBM: DelAllAttrs(ObjPtr->fattr); FreeXBmObj (ObjPtr); break;
      case OBJ_XPM: DelAllAttrs(ObjPtr->fattr); FreeXPmObj (ObjPtr); break;
      case OBJ_SYM:
      case OBJ_ICON:
      case OBJ_GROUP: DelAllAttrs(ObjPtr->fattr); FreeGroupObj (ObjPtr); break;
   }
}

void DelObj (ObjPtr)
   struct ObjRec	*ObjPtr;
{
   if (topObj == ObjPtr)
      curPage->top = topObj = ObjPtr->next;
   else
      ObjPtr->prev->next = ObjPtr->next;

   if (botObj == ObjPtr)
      curPage->bot = botObj = ObjPtr->prev;
   else
      ObjPtr->next->prev = ObjPtr->prev;

   FreeObj (ObjPtr);
}

void DelAllObj ()
{
   register struct ObjRec	* ptr, * next_obj;

   if (topObj == NULL) return;

   for (ptr = topObj; ptr != NULL; ptr = next_obj)
   {
      next_obj = ptr->next;
      FreeObj (ptr);
   }
   if (curPage != NULL) curPage->top = curPage->bot = NULL;
   topObj = botObj = NULL;
}

void AdjObjBBox (ObjPtr)
   struct ObjRec        * ObjPtr;
{
   register int			w = 0;
   register struct ObjRec	* obj_ptr;
   register struct AttrRec	* attr_ptr;
   struct PolyRec		* poly_ptr;
   int				ltx, lty, rbx, rby;
   int				oltx, olty, orbx, orby;

   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         poly_ptr = ObjPtr->detail.p;
         CalcPolyBBox(ObjPtr);
         break;
      case OBJ_ARC:
         CalcArcBBox (ObjPtr->detail.a, ObjPtr->obbox, &(ObjPtr->bbox));
         break;
      case OBJ_POLYGON: w = HALF_W(ObjPtr->detail.g->width); break;
      case OBJ_BOX: w = HALF_W(ObjPtr->detail.b->width); break;
      case OBJ_OVAL: w = HALF_W(ObjPtr->detail.o->width); break;
      case OBJ_RCBOX: w = HALF_W(ObjPtr->detail.rcb->width); break;
      case OBJ_XBM: break;
      case OBJ_XPM: break;

      case OBJ_SYM:
      case OBJ_GROUP:
      case OBJ_ICON:
         obj_ptr = ObjPtr->detail.r->last;
         ltx = obj_ptr->bbox.ltx; lty = obj_ptr->bbox.lty;
         rbx = obj_ptr->bbox.rbx; rby = obj_ptr->bbox.rby;
         oltx = obj_ptr->obbox.ltx; olty = obj_ptr->obbox.lty;
         orbx = obj_ptr->obbox.rbx; orby = obj_ptr->obbox.rby;
         for (obj_ptr = obj_ptr->prev; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
         {
            if (obj_ptr->bbox.ltx < ltx) ltx = obj_ptr->bbox.ltx;
            if (obj_ptr->bbox.lty < lty) lty = obj_ptr->bbox.lty;
            if (obj_ptr->bbox.rbx > rbx) rbx = obj_ptr->bbox.rbx;
            if (obj_ptr->bbox.rby > rby) rby = obj_ptr->bbox.rby;
            if (obj_ptr->obbox.ltx < oltx) oltx = obj_ptr->obbox.ltx;
            if (obj_ptr->obbox.lty < olty) olty = obj_ptr->obbox.lty;
            if (obj_ptr->obbox.rbx > orbx) orbx = obj_ptr->obbox.rbx;
            if (obj_ptr->obbox.rby > orby) orby = obj_ptr->obbox.rby;
         }
         ObjPtr->bbox.ltx = ltx; ObjPtr->bbox.lty = lty;
         ObjPtr->bbox.rbx = rbx; ObjPtr->bbox.rby = rby;
         ObjPtr->obbox.ltx = oltx; ObjPtr->obbox.lty = olty;
         ObjPtr->obbox.rbx = orbx; ObjPtr->obbox.rby = orby;
         break;
   }
   switch (ObjPtr->type)
   {
      case OBJ_POLY:
      case OBJ_ARC:
         break;
      case OBJ_POLYGON:
      case OBJ_BOX:
      case OBJ_OVAL:
      case OBJ_RCBOX:
      case OBJ_XBM:
      case OBJ_XPM:
         ObjPtr->bbox.ltx = ObjPtr->obbox.ltx - w;
         ObjPtr->bbox.lty = ObjPtr->obbox.lty - w;
         ObjPtr->bbox.rbx = ObjPtr->obbox.rbx + w;
         ObjPtr->bbox.rby = ObjPtr->obbox.rby + w;
         break;
      case OBJ_TEXT:
         ObjPtr->bbox.ltx = ObjPtr->obbox.ltx - 2;
         ObjPtr->bbox.lty = ObjPtr->obbox.lty - 2;
         ObjPtr->bbox.rbx = ObjPtr->obbox.rbx + 2;
         ObjPtr->bbox.rby = ObjPtr->obbox.rby + 2;
         break;
   }

   attr_ptr = ObjPtr->fattr;

   ltx = ObjPtr->bbox.ltx;
   lty = ObjPtr->bbox.lty;
   rbx = ObjPtr->bbox.rbx;
   rby = ObjPtr->bbox.rby;
   for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
   {
      if (attr_ptr->shown)
      {
         if (attr_ptr->obj->bbox.ltx < ltx) ltx = attr_ptr->obj->bbox.ltx;
         if (attr_ptr->obj->bbox.lty < lty) lty = attr_ptr->obj->bbox.lty;
         if (attr_ptr->obj->bbox.rbx > rbx) rbx = attr_ptr->obj->bbox.rbx;
         if (attr_ptr->obj->bbox.rby > rby) rby = attr_ptr->obj->bbox.rby;
      }
   }
   ObjPtr->bbox.ltx = ltx;
   ObjPtr->bbox.lty = lty;
   ObjPtr->bbox.rbx = rbx;
   ObjPtr->bbox.rby = rby;

   if (ObjPtr->type == OBJ_SYM)
   {
      if (ObjPtr->obbox.ltx-QUARTER_INCH < ObjPtr->bbox.ltx)
         ObjPtr->bbox.ltx = ObjPtr->obbox.ltx - QUARTER_INCH;
      if (ObjPtr->obbox.lty-QUARTER_INCH < ObjPtr->bbox.lty)
         ObjPtr->bbox.lty = ObjPtr->obbox.lty - QUARTER_INCH;
      if (ObjPtr->obbox.rbx+QUARTER_INCH > ObjPtr->bbox.rbx)
         ObjPtr->bbox.rbx = ObjPtr->obbox.rbx + QUARTER_INCH;
      if (ObjPtr->obbox.rby+QUARTER_INCH > ObjPtr->bbox.rby)
         ObjPtr->bbox.rby = ObjPtr->obbox.rby + QUARTER_INCH;
   }
}

static int dontAutoRetractArrow=FALSE;

#define RETREAT (0.8)

void AdjObjSplineVs (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   register int			i;
   register struct ObjRec	* ptr;
   int 				auto_retracted_arrows=FALSE;

   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         switch (ObjPtr->detail.p->curved)
         {
            case LT_STRAIGHT:
               if (ObjPtr->detail.p->svlist != NULL)
                  cfree (ObjPtr->detail.p->svlist);
               ObjPtr->detail.p->svlist = MakeMultiSplinePolyVertex (
                     &(ObjPtr->detail.p->sn), ObjPtr->detail.p->smooth,
                     drawOrigX, drawOrigY,
                     ObjPtr->detail.p->n, ObjPtr->detail.p->vlist);
               break;
            case LT_SPLINE:
               if (ObjPtr->detail.p->svlist != NULL)
                  cfree (ObjPtr->detail.p->svlist);
               ObjPtr->detail.p->svlist = MakeMultiSplinePolyVertex (
                     &(ObjPtr->detail.p->sn), ObjPtr->detail.p->smooth,
                     drawOrigX, drawOrigY,
                     ObjPtr->detail.p->n, ObjPtr->detail.p->vlist);
               break;
            case LT_INTSPLINE:
               if (ObjPtr->detail.p->svlist != NULL)
                  cfree (ObjPtr->detail.p->svlist);
               if (ObjPtr->detail.p->intvlist != NULL)
                  cfree (ObjPtr->detail.p->intvlist);
               if (!undoingOrRedoing && !dontAutoRetractArrow) {
                  auto_retracted_arrows = AutoRetractedArrowAttr(ObjPtr, FALSE);
                  if (auto_retracted_arrows) {
                     struct PolyRec *poly_ptr=ObjPtr->detail.p;
                     int new_x=0, new_y=0;
                     XPoint *v=NULL;

                     if (poly_ptr->n != 3) {
                        int x0, y0, x2, y2;

                        v = poly_ptr->vlist;
                        x0 = v[0].x; y0 = v[0].y;
                        x2 = v[poly_ptr->n-1].x; y2 = v[poly_ptr->n-1].y;
                        if (poly_ptr->smooth != NULL) cfree(poly_ptr->smooth);
                        poly_ptr->smooth = (char*)calloc(4, sizeof(char));
                        if (poly_ptr->smooth == NULL) FailAllocMessage();
                        poly_ptr->smooth[0] = poly_ptr->smooth[1] =
                              poly_ptr->smooth[2] = FALSE;
                        if (poly_ptr->vlist != NULL) cfree(poly_ptr->vlist);
                        poly_ptr->vlist = (XPoint*)calloc(4, sizeof(XPoint));
                        if (poly_ptr->vlist == NULL) FailAllocMessage();
                        poly_ptr->vlist[0].x = x0; poly_ptr->vlist[0].y = y0;
                        poly_ptr->vlist[2].x = x2; poly_ptr->vlist[2].y = y2;
                        poly_ptr->n = 3;
                     }
                     v = poly_ptr->vlist;
                     CalcAutoRetractedArrowAttrBend(poly_ptr->style,
                           v[0].x, v[0].y, v[2].x, v[2].y, &new_x, &new_y);
                     v[1].x = new_x;
                     v[1].y = new_y;
                  }
               }
               ObjPtr->detail.p->svlist = MakeIntSplinePolyVertex (
                     &(ObjPtr->detail.p->sn), &(ObjPtr->detail.p->intn),
                     &(ObjPtr->detail.p->intvlist), drawOrigX, drawOrigY,
                     ObjPtr->detail.p->n, ObjPtr->detail.p->vlist);
               break;
         }

         if (ObjPtr->detail.p->style != LS_PLAIN)
         {
            struct PolyRec	* poly_ptr = ObjPtr->detail.p;
            XPoint		* v = poly_ptr->vlist, * v_copy;
            int			aw = poly_ptr->aw;
            int			n = poly_ptr->n, dx, dy;
            int			retracted_arrow;
            double		len, sin, cos;

            retracted_arrow = (RetractedArrowAttr(ObjPtr) ||
                  AutoRetractedArrowAttr(ObjPtr, TRUE));
            if (ObjPtr->detail.p->asvlist != NULL)
               cfree (ObjPtr->detail.p->asvlist);

            if (poly_ptr->curved != LT_INTSPLINE)
            {
               v = poly_ptr->vlist;
               n = poly_ptr->n;
            }
            else
            {
               v = poly_ptr->intvlist;
               n = poly_ptr->intn;
            }
            v_copy = (XPoint *) calloc (n+1, sizeof(XPoint));
            for (i = 0; i < n; i++)
            {
               v_copy[i].x = v[i].x;
               v_copy[i].y = v[i].y;
            }

            if (aw == 0) aw = 1;

            dx = v_copy[1].x - v_copy[0].x;
            dy = v_copy[1].y - v_copy[0].y;
            if (!retracted_arrow && (poly_ptr->style & LS_LEFT) &&
                  (dx != 0 || dy != 0))
            {
               len = (double)sqrt((double)(((double)dx)*((double)dx) +
                     ((double)dy)*((double)dy)));
               sin = ((double)dy)/len;
               cos = ((double)dx)/len;

               v_copy[0].x = round(v_copy[0].x+RETREAT*aw*cos);
               v_copy[0].y = round(v_copy[0].y+RETREAT*aw*sin);
            }

            dx = v_copy[n-1].x - v_copy[n-2].x;
            dy = v_copy[n-1].y - v_copy[n-2].y;
            if (!retracted_arrow && (poly_ptr->style & LS_RIGHT) &&
                  (dx != 0 || dy != 0))
            {
               len = (double)sqrt((double)(((double)dx)*((double)dx) +
                     ((double)dy)*((double)dy)));
               sin = ((double)dy)/len;
               cos = ((double)dx)/len;

               v_copy[n-1].x = round(v_copy[n-1].x-RETREAT*aw*cos);
               v_copy[n-1].y = round(v_copy[n-1].y-RETREAT*aw*sin);
            }
            switch (ObjPtr->detail.p->curved)
            {
               case LT_STRAIGHT:
               case LT_SPLINE:
                  poly_ptr->asvlist = MakeMultiSplinePolyVertex (
                        &(poly_ptr->asn), poly_ptr->smooth,
                        drawOrigX, drawOrigY,
                        n, v_copy);
                  break;
               case LT_INTSPLINE:
                  poly_ptr->asvlist = MakeSplinePolyVertex (&(poly_ptr->asn),
                        drawOrigX, drawOrigY, n, v_copy);
                  break;
            }
            cfree (v_copy);
         }
         break;
      case OBJ_POLYGON:
         switch (ObjPtr->detail.g->curved)
         {
            case LT_STRAIGHT:
               if (ObjPtr->detail.g->svlist != NULL)
                  cfree (ObjPtr->detail.g->svlist);
               ObjPtr->detail.g->svlist = MakeMultiSplinePolygonVertex (
                     &(ObjPtr->detail.g->sn), ObjPtr->detail.g->smooth,
                     drawOrigX, drawOrigY,
                     ObjPtr->detail.g->n, ObjPtr->detail.g->vlist);
               break;
            case LT_SPLINE:
               if (ObjPtr->detail.g->svlist != NULL)
                  cfree (ObjPtr->detail.g->svlist);
               ObjPtr->detail.g->svlist = MakeMultiSplinePolygonVertex (
                     &(ObjPtr->detail.g->sn), ObjPtr->detail.g->smooth,
                     drawOrigX, drawOrigY,
                     ObjPtr->detail.g->n, ObjPtr->detail.g->vlist);
               break;
            case LT_INTSPLINE:
               if (ObjPtr->detail.g->svlist != NULL)
                  cfree (ObjPtr->detail.g->svlist);
               if (ObjPtr->detail.g->intvlist != NULL)
                  cfree (ObjPtr->detail.g->intvlist);
               ObjPtr->detail.g->svlist = MakeIntSplinePolygonVertex (
                     &(ObjPtr->detail.g->sn), &(ObjPtr->detail.g->intn),
                     &(ObjPtr->detail.g->intvlist), drawOrigX, drawOrigY,
                     ObjPtr->detail.g->n, ObjPtr->detail.g->vlist);
               break;
         }
         break;
      case OBJ_SYM:
      case OBJ_ICON:
      case OBJ_GROUP:
         for (ptr = ObjPtr->detail.r->first; ptr != NULL; ptr = ptr->next)
            AdjObjSplineVs (ptr);
         break;
   }
}

void AdjSplineVs()
{
   register struct ObjRec *obj_ptr, *ptr;

   if (topObj == NULL) return;

   dontAutoRetractArrow = TRUE;
   for (obj_ptr = topObj; obj_ptr != NULL; obj_ptr = obj_ptr->next) {
      switch (obj_ptr->type) {
      case OBJ_POLY:
      case OBJ_POLYGON:
         AdjObjSplineVs (obj_ptr);
         break;
      case OBJ_SYM:
      case OBJ_ICON:
      case OBJ_GROUP:
         for (ptr = obj_ptr->detail.r->first; ptr != NULL; ptr = ptr->next) {
            AdjObjSplineVs (ptr);
         }
         break;
      }
   }
   dontAutoRetractArrow = FALSE;
}

void AdjObjCache (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   register struct ObjRec	* ptr;
   register struct AttrRec	* attr_ptr;
   int				w, h, num_rows, num_cols;
   struct TextRec		* text_ptr;
   struct XBmRec		* xbm_ptr;
   struct XPmRec		* xpm_ptr;

   w = ObjPtr->obbox.rbx - ObjPtr->obbox.ltx;
   h = ObjPtr->obbox.rby - ObjPtr->obbox.lty;

   switch (ObjPtr->type)
   {
      case OBJ_TEXT:
         if (zoomScale!=0 || ObjPtr->detail.t->rotate!=ROTATE0 ||
               ObjPtr->detail.t->faked)
         {
            text_ptr = ObjPtr->detail.t;

            if (text_ptr->rotate != ROTATE0 ||
                  !(text_ptr->cached_bitmap != None &&
                  text_ptr->cached_zoomed == zoomedIn &&
                  text_ptr->cached_zoom == zoomScale))
            {
               if (text_ptr->cached_bitmap != None)
                  XFreePixmap (mainDisplay, text_ptr->cached_bitmap);
               text_ptr->cached_zoom = 0;
               text_ptr->cached_bitmap = None;
            }
         }
         break;
      case OBJ_XBM:
         xbm_ptr = ObjPtr->detail.xbm;
         num_cols = (zoomedIn) ? (w<<zoomScale) : (w>>zoomScale);
         num_rows = (zoomedIn) ? (h<<zoomScale) : (h>>zoomScale);
         if (NeedsToCacheXBmObj (ObjPtr) && !(
               xbm_ptr->cached_bitmap!=None &&
               xbm_ptr->cached_zoomed==zoomedIn &&
               xbm_ptr->cached_zoom==zoomScale &&
               xbm_ptr->cached_w==num_cols && xbm_ptr->cached_h==num_rows &&
               xbm_ptr->cached_rotate==xbm_ptr->rotate &&
               xbm_ptr->cached_flip==xbm_ptr->flip
               ))
         {
            if (xbm_ptr->cached_bitmap != None)
               XFreePixmap (mainDisplay, xbm_ptr->cached_bitmap);
            xbm_ptr->cached_bitmap = None;
            if (zoomScale != 0)
               xbm_ptr->cached_zoom = 0;
            else
               xbm_ptr->cached_rotate = INVALID;
         }
         break;
      case OBJ_XPM:
         xpm_ptr = ObjPtr->detail.xpm;
         num_cols = (zoomedIn) ? (w<<zoomScale) : (w>>zoomScale);
         num_rows = (zoomedIn) ? (h<<zoomScale) : (h>>zoomScale);
         if (NeedsToCacheXPmObj (ObjPtr) && !(
               xpm_ptr->cached_pixmap!=None &&
               xpm_ptr->cached_zoomed==zoomedIn &&
               xpm_ptr->cached_zoom==zoomScale &&
               xpm_ptr->cached_w==num_cols && xpm_ptr->cached_h==num_rows &&
               xpm_ptr->cached_rotate==xpm_ptr->rotate &&
               xpm_ptr->cached_flip==xpm_ptr->flip
               ))
         {
            if (xpm_ptr->cached_pixmap != None)
               XFreePixmap (mainDisplay, xpm_ptr->cached_pixmap);
            xpm_ptr->cached_pixmap = None;
            if (zoomScale != 0)
               xpm_ptr->cached_zoom = 0;
            else
               xpm_ptr->cached_rotate = INVALID;
         }
         break;

      case OBJ_SYM:
      case OBJ_ICON:
      case OBJ_GROUP:
         for (ptr = ObjPtr->detail.r->first; ptr != NULL; ptr = ptr->next)
            AdjObjCache (ptr);
         break;
   }
   for (attr_ptr=ObjPtr->fattr; attr_ptr!=NULL; attr_ptr=attr_ptr->next)
      if (attr_ptr->shown)
         AdjObjCache (attr_ptr->obj);
}

void AdjCaches ()
{
   register struct ObjRec	* obj_ptr, * ptr;
   register struct AttrRec	* attr_ptr;

   if (topObj == NULL) return;

   for (obj_ptr = topObj; obj_ptr != NULL; obj_ptr = obj_ptr->next)
   {
      switch (obj_ptr->type)
      {
         case OBJ_TEXT:
         case OBJ_XBM:
         case OBJ_XPM:
            AdjObjCache (obj_ptr);
            break;
         case OBJ_SYM:
         case OBJ_ICON:
         case OBJ_GROUP:
            for (ptr = obj_ptr->detail.r->first; ptr != NULL; ptr = ptr->next)
               AdjObjCache (ptr);
            break;
      }
      for (attr_ptr=obj_ptr->fattr; attr_ptr!=NULL; attr_ptr=attr_ptr->next)
         if (attr_ptr->shown)
            AdjObjCache (attr_ptr->obj);
   }
}

void AdjHotSpots()
{
}

void AdjObjHotSpot()
{
}
