#include <sys/exec.h>
#include <sys/types.h>
#include <stdio.h>
#include <a.out.h>
#include <link.h>
#include <string.h>
#include <malloc.h>

char *progname;
int verbose = 0;

extern void exit();

FILE *
efopen(file, mode)		/* fopen file, die if can't */
	char *file, *mode;
{
	FILE *fp, *fopen();
	extern char *progname;

	if ((fp = fopen(file, mode)) != NULL)
		return fp;
	(void) fprintf(stderr, "%s: can't open file %s mode %s\n",
		progname, file, mode);
	exit(1);
	/*NOTREACHED*/
}

char *
emalloc(size)
	unsigned size;
{
	char *p;

	if ((p = malloc(size)) == NULL) {
		(void) fprintf(stderr, "%s: can't allocate memory\n", progname);
		exit(1);
	}
	return p;
}

void
efread(ptr, size, stream, info, filename)
	char *ptr;
	unsigned size;
	FILE *stream;
	char *info, *filename;
{
	if (fread(ptr, (int)size, 1, stream) == 0) {
		(void) fprintf(stderr, "%s: can't read %s from file %s\n",
			progname, info, filename);
		exit(1);
	}
}

void
efwrite(ptr, size, stream, info, filename)
	char *ptr;
	unsigned size;
	FILE *stream;
	char *info, *filename;
{
	if (fwrite(ptr, (int)size, 1, stream) == 0) {
		(void) fprintf(stderr, "%s: can't write %s to file %s\n",
			progname, info, filename);
		exit(1);
	}
}

void
efseek(fp, offset, ptrname, filename)
	FILE *fp;
	long offset;
	int ptrname;
	char *filename;
{
	if (fseek(fp, offset, ptrname)) {
		(void) fprintf(stderr, "%s: can't seek file %s\n",
			progname, filename);
		exit(1);
	}
}

/*
 * return value:
 *	= 0: the file is dynamically linked
 *	> 0: statically linked
 *	< 0: error
 * if the file is dynamically linked, fp is positioned to top of
 * struct link_dynamic_2 on return
 */
int
seek_to_link_dynamic(fp, filename)
	FILE *fp;
	char *filename;
{
	struct exec header;
	struct nlist *sym, *p;
	unsigned strsize;
	char *str;
	struct link_dynamic link;

	efread((char *)&header, sizeof(struct exec), fp, "header", filename);
	if (N_BADMAG(header)) {
		(void) fprintf(stderr, "%s: %s is not binary executable\n",
			progname, filename);
		return -1;
	}
	if (header.a_dynamic == 0) {
		(void) printf("%s: statically linked\n", filename);
		return 1;
	}
	efseek(fp, (long)N_SYMOFF(header), 0, filename);
	sym = (struct nlist *)emalloc((unsigned)header.a_syms);
	efread((char *)sym, (unsigned)header.a_syms, fp,
		"symbol table", filename);
	strsize = getw(fp);
	if (ferror(fp)) {
		(void) fprintf(stderr, "can't read string table from %s\n",
			filename);
		exit(1);
	}
	efseek(fp, -(long)sizeof(strsize), 1, filename);
	str = emalloc(strsize);
	efread(str, strsize, fp, "string table", filename);
	for (p = sym; (u_long)p < (u_long)sym + header.a_syms; p++) {
		if (strcmp(str + p->n_un.n_strx, "__DYNAMIC") == 0)
			break;
	}
	if ((u_long)p >= (u_long)sym + header.a_syms) {
		(void) fprintf(stderr, "can't find symbol __DYNAMIC\n");
		exit(1);
	}
	efseek(fp, (long)(p->n_value - _N_BASEADDR(header)), 0, filename);
	efread((char *)&link, sizeof(struct link_dynamic), fp,
		"__DYNAMIC", filename);
	if (verbose) {
		(void) fprintf(stderr, "%s: ld_version is %d\n",
			filename, link.ld_version);
	}
	if (link.ld_version < 2) {
		(void) fprintf(stderr, "ld_version mismatch\n");
		exit(1);
	}
	efseek(fp, (long)link.ld_un.ld_2 - _N_BASEADDR(header), 0, filename);

	free((char *)sym);
	free(str);

	return 0;
}

void
usage()
{
	(void) fprintf(stderr, "usage: %s [-v] [--] file ...\n", progname);
	exit(1);
}

main(argc, argv)
	int	argc;
	char	*argv[];
{
	register int i, j, opt;
	FILE *fp;

	extern int optind;

	progname = argv[0];
	while (1) {
		if ((opt = getopt(argc, argv, "v")) == -1) {
			break;
		} else if (opt == 'v') {
			verbose++;
		} else if (opt == '?') {
			usage();
		}
	}
	if (argc <= optind) {
		usage();
	}
	for (i = optind; i < argc; i++) {
		char buf1[BUFSIZ];
		struct link_dynamic_2 ld;
		struct link_object lo;

		fp = efopen(argv[i], "r+");
		if (seek_to_link_dynamic(fp, argv[i])) {
			continue;
		}
		efread((char *)&ld, sizeof(struct link_dynamic_2), fp,
			"dynamic linking information", argv[i]);
		if (ld.ld_need == 0) {
			(void) printf("%s: no dynamically linked libraries\n",
				argv[i]);
			break;
		}
		efseek(fp, ld.ld_need, 0, argv[i]);
		while (1) {
			int changed;
			short ma, mi;

			changed = 0;
			efread((char *)&lo, sizeof(lo), fp,
				"link_object", argv[i]);
			ma = lo.lo_major;
			mi = lo.lo_minor;
			if (ma > 100) {
				changed++;
				lo.lo_major -= 100;
			}
			if (mi > 100) {
				changed++;
				lo.lo_minor -= 100;
			}
			if (changed) {
				efseek(fp, -(long)sizeof(lo), 1, argv[i]);
				efwrite((char *)&lo, sizeof(lo), fp,
					"link_object", argv[i]);
			}
			efseek(fp, lo.lo_name, 0, argv[i]);
			for (j = 0; buf1[j] = getc(fp); j++)
				;
			if (verbose) {
				(void) printf("%s: lib%s.%d.%d ",
					argv[i], buf1, ma, mi);
				if (changed) {
					(void) printf("-> lib%s.%d.%d\n",
						buf1, lo.lo_major, lo.lo_minor);
				} else {
					(void) printf("unchanged\n");
				}
			}
			if (lo.lo_next == 0) {
				break;
			}
			efseek(fp, lo.lo_next, 0, argv[i]);
		}
		(void) fclose(fp);
	}
	return 0;
}
