/*
 * Copyright (c) 1993 The Regents of the University of Texas System.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that the above copyright notice and this paragraph are duplicated in all
 * such forms and that any documentation, advertising materials,  and other
 * materials  related to such  distribution  and use  acknowledge  that the
 * software  was  developed  by the  University of Texas.  The  name of the
 * University may not be  used to endorse or promote  products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright (c) 1993 The Regents of the University of Texas System.\n\
 All rights reserved.\n";
static char rcsid[] =
"$Id$\n";
static char rcspath[] =
"$Source$\n";
#endif

/* $Log$
 */

#include <stdio.h>
#include <X11/Intrinsic.h>

#include "top.h"
#include "machine.h"
#include "appres.h"
#include "boolean.h"

/*
 * Globals.
 */
extern char *username();
extern char *itoa7();
extern char *ctime();
extern char *kill_procs();
extern char *renice_procs();
extern char *format_next_process();
extern char *format_header();
extern caddr_t get_process_info();
extern int proc_compare();
extern XtAppContext app;
extern Widget toplevel;

/*
 * Local varialbes.
 */
static char *(*get_userid)() = username;
static char *uname_field = "USERNAME";
static char *header_text = NULL;


static struct statics statics;
static struct system_info system_info;
static struct process_select ps = {Yes, No, -1, NULL};

static char **procstate_names;
static char **cpustate_names;
static char **memory_names;

static int num_procstates;
static int num_cpustates;
static int num_memory;

static int *lprocstates;
static int *lcpustates;
static int *lmemory;

static char buf[1024];
static char format[1024];

static XtIntervalId timeout = 0;

static int count = 0;

static void    display_data();

void
ReDisplay()
{
    if (timeout) XtRemoveTimeOut(timeout);
    display_data(NULL, NULL);
}

void
ReDrawBar()
{
    if (count > 1)
        Bar_Cpu(num_cpustates, cpustate_names,  system_info.cpustates,
		num_memory   , memory_names  ,  system_info.memory);
}


static void
display_data(client_data, id)
caddr_t client_data;
XtIntervalId *id;
{
    int width = Display_width();
    int n,m,i;
    time_t now;
    int lw = 0;
    caddr_t processes;

    Reset_Window();

    get_system_info(&system_info);
    processes = get_process_info(&system_info, &ps, proc_compare);
    count++;

    /*
     * Load and current time.
     */
    sprintf(buf, "load averages: %5.2f, %5.2f, %5.2f ", 
	    system_info.load_avg[0], 
	    system_info.load_avg[1],
	    system_info.load_avg[2]);
    Write_Window(buf, 1);
    n = strlen(buf);
    sprintf(format,"%%-%ds%%-8.8s\n", 80-n- 8);
    time(&now);
    sprintf(buf, format,"", &(ctime(&now)[11]));
    Write_Window(buf, 1);
    /*
     * Display the Process stats.
     */
    lw = 0;
    sprintf(buf, "%d processes:",system_info.p_total);
    Write_Window(buf, 1);
    lw += strlen(buf);
    m = 0;
    for (i=1; i<num_procstates; i++) {
	if (system_info.procstates[i]) {
	    if (m) {
		Write_Window(", ");
		lw += sizeof(", ") - 1;
	    }
	    sprintf(buf, " %d %s", system_info.procstates[i],
			           procstate_names[i]);
	    n = strlen(buf);
	    if (buf[n-1] == ' ' && buf[n-2] == ',') {
		buf[n-2] = '\0';
		n -= 2;
	    }
            Write_Window(buf, 1);
            lw += n;
  	    m++;	
 	}
    }
    if (lw < 80) {
        sprintf(format,"%%%ds",lw-80);
	sprintf(buf, format, "");
        Write_Window(buf, 1);
    }
    Write_Window("\n", 1);

    if (count > 1) 
        Bar_Cpu(num_cpustates, cpustate_names,  system_info.cpustates,
		num_memory   , memory_names  ,  system_info.memory);
	    

    Write_Window("\n", 1);

    Write_Window(header_text, 1);
    Write_Window("\n", 1);

    High_Water();

    n = Display_height() - 4;
    if (n > system_info.p_active) n = system_info.p_active;
    for (i=0; i<n; i++) {
	 sprintf(buf, "%-80.80s\n",format_next_process(processes, get_userid));
         Write_Window(buf, 0);
    }
    End_Window();

    timeout = XtAppAddTimeOut(app, 
			      (unsigned long)(app_resources.delay*1000),
			      (XtTimerCallbackProc)display_data,
			      (XtPointer)NULL);
}

int 
get_delay()
{
    return app_resources.delay;
}

void
init_display()
{

    if (!app_resources.do_unames) {
	uname_field = "   UID  ";
        get_userid = itoa7;
    }

    if (app_resources.delay <= 2) app_resources.delay = 5;

    if (machine_init(&statics)== -1) exit(1);

    if (app_resources.do_unames) init_hash();

    header_text = format_header(uname_field);

    ps.idle = Yes;
    ps.system = No;
    if (app_resources.user) {
       ps.uid =userid(app_resources.user);
       app_resources.user = NULL;
    } else {
       ps.uid = -1;
    }

    ps.command = NULL;

    procstate_names = statics.procstate_names;
    num_procstates = string_count(procstate_names);
    lprocstates = (int *)malloc(num_procstates * sizeof(int));

    cpustate_names = statics.cpustate_names;
    num_cpustates = string_count(cpustate_names);
    lcpustates = (int *)malloc(num_cpustates * sizeof(int));

    memory_names = statics.memory_names;
    num_memory = string_count(memory_names);
    lmemory = (int *)malloc(num_memory * sizeof(int));

    Display_Width_Bar_Height(80, num_memory+num_cpustates);
  
    timeout = XtAppAddTimeOut(app, 
			      (unsigned long)(1*1000),
			      (XtTimerCallbackProc)display_data,
			      (XtPointer)NULL);
}

set_delay(delay)
int delay;
{
    app_resources.delay = delay;
}

void
set_user(name)
char *name;
{
    if (name) {
        ps.uid = userid(name);
    } else {
	ps.uid = -1;
    }
}


int
show_idle()
{
    return ps.idle; 
}

int
show_user()
{
    if (app_resources.user && ps.uid == -1) {
        ps.uid = userid(app_resources.user);
    } 
    return (ps.uid==-1?0:1);
}

static int 
string_count(pp)
char **pp;
{
    int cnt;
    cnt = 0;
    while (*pp++ != NULL) cnt++;
    return(cnt);
}

void
toggle_idle()
{
    ps.idle = !ps.idle; 

}
