/*
 * Copyright (c) 1993 The Regents of the University of Texas System.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that the above copyright notice and this paragraph are duplicated in all
 * such forms and that any documentation, advertising materials,  and other
 * materials  related to such  distribution  and use  acknowledge  that the
 * software  was  developed  by the  University of Texas.  The  name of the
 * University may not be  used to endorse or promote  products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright (c) 1993 The Regents of the University of Texas System.\n\
 All rights reserved.\n";
static char rcsid[] =
"$Id$\n";
static char rcspath[] =
"$Source$\n";
#endif

/* $Log$
 */

#include "os.h"
#include <ctype.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/resource.h>

#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/Xutil.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/TextP.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>


#define EXT
#include "appres.h"
#include "xtop.xbm"

/*
 * Widgets.
 */
Widget toplevel = NULL;
XtAppContext app = NULL;

#define Offset(field) XtOffsetOf(struct _resources, field)

static XtResource resources[] = {
    {"debug", "Debug", XtRBoolean, sizeof(Boolean),
         Offset(debug), XtRImmediate, (XtPointer)FALSE},
    {"doUnames","DoUnames", XtRBoolean, sizeof(Boolean),
         Offset(do_unames), XtRImmediate, (XtPointer)TRUE},
    {"douser","DoUser", XtRString, sizeof(char *),
         Offset(user), XtRString, NULL},
    {"dotimeout","DoTimeout", XtRInt, sizeof(int),
         Offset(delay), XtRString, "5"},
};


static XrmOptionDescRec table[] = {
    {"-debug",  "debug",                XrmoptionNoArg,  "on"},
    {"-u",      "DoUnames",             XrmoptionNoArg,  "off"},
    {"-U",      "DoUser",               XrmoptionSepArg, (caddr_t)NULL},
    {"-s",      "DoVimeout", 		XrmoptionSepArg, (caddr_t)NULL},
};

static String FallbackResources[] = {
"*Text*font: -*-courier-bold-r-*-*-14-*-*-*-*-*-ISO8859-1",
"*bar*font: -*-courier-bold-r-*-*-12-*-*-*-*-*-ISO8859-1",
NULL,
};

char *myname = "xtop";
static Pixmap xtop_bitmap = None;

main(argc, argv)
int argc;
char **argv;
{
    Arg arg[2];
    XtTranslations tranlations;
    char host[100];
    char *cp;
    int i;

    for (i=0; i<argc; i++) 
	if (strcmp(argv[i],"-v") == 0) {
	    fprintf(stderr, "xtop - Version %s\n",version_string());
	    exit(0);
        }

    XtSetArg(arg[0], XtCAllowShellResize, TRUE);
    XtSetArg(arg[1],  XtNallowShellResize, TRUE);
    toplevel = XtAppInitialize(&app, "Xtop", table, XtNumber(table),
                               &argc, argv, FallbackResources,
                               arg, (Cardinal)2);

    XtGetApplicationResources(toplevel, (XtPointer)&app_resources,
                               resources, XtNumber(resources),
                               NULL, (Cardinal)0 );

    create_widgets();

    XtRealizeWidget(toplevel);

    xtop_bitmap = XCreateBitmapFromData(XtDisplay(toplevel),
                                        XtWindow(toplevel),
                                        (char *)xtop_bits,
                                        xtop_width,
                                        xtop_height);

    gethostname(host, sizeof(host));
    host[sizeof(host)-1] = '\0';
    cp = strchr(host, '.');
    if (cp) *cp = '\0';

    XtSetArg(arg[0], XtNiconPixmap, xtop_bitmap);
    XtSetArg(arg[1], XtNiconName, host);
    XtSetValues(toplevel, arg, 2);

    init_display();

    XtAppMainLoop(app);
}

void
quit()
{
   exit(1);
}

