/*
 * Copyright (c) 1993 The Regents of the University of Texas System.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that the above copyright notice and this paragraph are duplicated in all
 * such forms and that any documentation, advertising materials,  and other
 * materials  related to such  distribution  and use  acknowledge  that the
 * software  was  developed  by the  University of Texas.  The  name of the
 * University may not be  used to endorse or promote  products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright (c) 1993 The Regents of the University of Texas System.\n\
 All rights reserved.\n";
static char rcsid[] =
"$Id$\n";
static char rcspath[] =
"$Source$\n";
#endif

/* $Log$
 */

#include "os.h"
#include <ctype.h>
#include <errno.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/resource.h>

#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/Xutil.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <sys/resource.h>

#if defined(XAW3D)
#include <X11/Xaw3d/Form.h>
#include <X11/Xaw3d/AsciiText.h>
#include <X11/Xaw3d/TextP.h>
#include <X11/Xaw3d/Label.h>
#include <X11/Xaw3d/Command.h>
#include <X11/Xaw3d/Dialog.h>
#include <X11/Xaw3d/SimpleMenu.h>
#include <X11/Xaw3d/SmeBSB.h>
#else
#include <X11/Xaw/Form.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/TextP.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#endif

#include "appres.h"


/*
 * Globals.
 */
extern Widget toplevel;
extern XtAppContext app;

/*
 * Widgets.
 */
static Widget quit = NULL;
static Widget options = NULL;
static Widget form = NULL;
static Widget text = NULL;
static Widget bar = NULL;
static Widget kill_w = NULL;
static Widget term = NULL;
static Widget nice= NULL;
static Widget info_shell = NULL;
static Widget info_d = NULL;
static Widget nice_shell = NULL;
static Widget nice_d = NULL;
static Widget kill_shell = NULL;
static Widget kill_d = NULL;
static Widget time_shell = NULL;
static Widget time_d = NULL;
static Widget msg_shell = NULL;
static Widget msg_d = NULL;
static Widget user_shell = NULL;
static Widget user_d = NULL;
static Widget opt_menu = NULL;
static Widget opt_1 = NULL;
static Widget opt_2 = NULL;
static Widget opt_3 = NULL;


/*
 * Defines.
 */
#define DO_NICE    0
#define DO_KILL    1
#define DO_TERM    2

#define MENU_TOGGLE_PROCESS 0
#define MENU_UPDATE_TIME    1
#define MENU_USER_NAME      2


/*
 * Translations.
 */

static char textTranslations[] = 
"#override\n\
<Key>: no-op() \n\
<BtnUp>: select-start() DoFunc() extend-end(PRIMARY, CUT_BUFFER0) \n\
<BtnDown>: no-op() \n\
<BtnMotion>: no-op()";

static char menuTranslations[] = 
"#override\n\
<BtnDown>:    XawPositionSimpleMenu(menu) XtMenuPopup(menu)";

static char barTranslations[] = 
"#override\n\
<Expose>: Repaint()";

/*
 * Functions.
 */
static void repaint_act();
static void do_func_act();
static void do_cb();
static void quit_cb();
static void menu_cb();
static void get_font();
static void do_it();
static void do_time_cb();
static void do_user_cb();
static void error();
static void position_dialog();
static void query_nice();
static void query_kill();
static void reset_user();
static void create_user_dialog();
static void create_info();
static void end_func();
static void init_bar();
extern int  get_delay();

/*
 * Actions.
 */
static XtActionsRec Actions[] = {
    {"Repaint"        , repaint_act},
    {"DoFunc"         , do_func_act},
};
static XawTextPosition lastPos = 0;
static XawTextPosition highPos = 0;
static XawTextPosition maxPos = 0;
static int text_disabled = 0;


/*
 * Local variables.
 */
static XFontStruct *FS = NULL;
static XFontStruct *FS_BAR = NULL;
static int maxw = 0;
static int maxv = 0;
static int scale = 1;
static GC  bar_gc  = NULL;
static GC bar_rgc  = NULL;
static Cursor   crosshair = NULL;
static Cursor   pirate = NULL;
static int procnum = -1;
static int func = -1;
static int busy = 0;
static char texts[100000];
static Time lastTime;
static char msg[1024];
static char buff[1024];

void
Bar_Cpu(num1, names1, values1, num2, names2, values2)
int num1;
char **names1;
int  *values1;
int num2;
char **names2;
int  *values2;
{
    Arg args[3];
    int width, border, height;
    int fh;
    int x,y, ydel, ww, bh, bs;
    Widget w;
    char label[100];
    int i;

    w = text;

    get_font();
    init_bar();

    XtSetArg(args[0], XtNwidth, NULL);
    XtSetArg(args[1], XtNheight, NULL);
    XtSetArg(args[2], XtNborderWidth, NULL);
    XtGetValues(bar, args, XtNumber(args));
    width = (int)args[0].value;
    height = (int)args[1].value;
    border = (int)args[2].value;

    x = border;
    y = border;

    width -= 2*border;
    height -= 2*border;

    /*
     * Font hieght plust 2 for pad.
     */
    fh = FS_BAR->max_bounds.ascent + FS_BAR->max_bounds.descent + 2;

    /*
     * Compute scale max value.
     */
    for (i=0; i<num2; i++) {
	if (names2[i][0] == 'K' && values2[i] > 1000 && scale == 1) 
	    scale = 1000;
	if (names2[i][0] == 'M' && scale == 1000) {
	    if (maxv < (values2[i]*scale)) maxv = values2[i]*scale;
	} else if (maxv < values2[i]) maxv = values2[i];
    }
    maxv = (maxv + scale - 11)/scale;
    maxv = (maxv+9)/10;
    if (maxv == 0) maxv = 10;
    else           maxv = maxv*10;
    maxv = maxv*scale;

    /*
     * Find right margin.
     */
    if (maxw == 0) {
        for (i=0; i<num1; i++) {
	    int m;
 	    sprintf(label,"%5.1f%% %s",(float)values1[i]/10, names1[i]);
            m = XTextWidth(FS_BAR, label, strlen(label));
	    if (m > maxw) maxw = m;
	}
        for (i=0; i<num2; i++) {
	    int m;
 	    sprintf(label,"%5d%s",values2[i]/scale, names2[i]);
            m = strlen(label);
            if (label[m-1] == ' ' && label[m-2] == ',') label[m-2] = '\0';
            m = XTextWidth(FS_BAR, label, strlen(label));
	    if (m > maxw) maxw = m;
	}
        maxw += 4;
    }


    /*
     * Make bars .8 of font height.
     */
    bh =  fh*.8;
    if (bh == 0) bh = fh - 8;
    if (bh == 0) bh = fh - 4;
    if (bh == 0) bh = fh - 2;
    bs = (fh - bh)/2;

    /*
     * Draw the cpu stats.
     */
#define center(text) \
    XDrawImageString(XtDisplay(bar), XtWindow(bar), bar_gc, \
		     x + (width - XTextWidth(FS_BAR, text, strlen(text)))/2, \
		     y + FS_BAR->max_bounds.ascent + 1, \
			 text, strlen(text))
    
    center("Cpu States");
    y += fh;
    for (i=0; i<num1; i++) {
 	sprintf(label,"%5.1f%% %s",(float)values1[i]/10, names1[i]);
        XDrawImageString(XtDisplay(bar), XtWindow(bar), bar_gc, 
		         x,
			 y + FS_BAR->max_bounds.ascent + 1,
			 label, strlen(label));
        ww = ((width-maxw)*values1[i])/1000;
	if (ww > (width-maxw)) ww = width - maxw;
	if (ww) 
	    XFillRectangle(XtDisplay(bar), XtWindow(bar), bar_gc, 
			   x+maxw, y+bs, 
		           ww, bh);
	if (width-ww) 
            XFillRectangle(XtDisplay(bar), XtWindow(bar), bar_rgc, 
			   x+maxw+ww, y+bs, 
		           width-ww, bh);
	y += fh;
    }
    y += 4;
    bh =  fh*.8;
    if (bh == 0) bh = fh - 8;
    if (bh == 0) bh = fh - 4;
    if (bh == 0) bh = fh - 2;
    bs = (fh - bh)/2;

    /* 
     * Draw memory stats.
     */
    center("Memory");
    y += fh;
    for (i=0; i<num2; i++) {
	int m;
	char name[1024];
        int sv;

	strcpy(name, names2[i]);
	sv = values2[i];
        if (name[0] == 'K' && scale == 1000) {
	     name[0] = 'M';
	     sv = sv/scale;
	}
   
 	sprintf(label,"%5d%s", sv, name);
	sv = sv*scale;
        m = strlen(label);
        if (label[m-1] == ' ' && label[m-2] == ',') label[m-2] = '\0';
        XDrawImageString(XtDisplay(bar), XtWindow(bar), bar_gc, 
		         x,
			 y + FS_BAR->max_bounds.ascent + 1,
			 label, strlen(label));
        ww = (int)(((double)(width-maxw)*(double)sv)/
		   (double)maxv);
	if (ww < 0) ww = 0;
	if (ww > (width-maxw)) ww = width - maxw;
	if (ww) 
	    XFillRectangle(XtDisplay(bar), XtWindow(bar), bar_gc, 
			   x+maxw, y+bs, 
		           ww, bh);
	if (width-ww) 
            XFillRectangle(XtDisplay(bar), XtWindow(bar), bar_rgc, 
			   x+maxw+ww, y+bs, 
		           width-ww, bh);
	y += fh;
    }
}

int
Display_height()
{
    Arg arg[3];
    int height;
    int h;

    XtSetArg(arg[0], XtNheight, NULL);
    XtSetArg(arg[1], XtNbottomMargin, NULL);
    XtSetArg(arg[2], XtNtopMargin, NULL);
    XtGetValues(text, arg, XtNumber(arg));
    get_font();
    height  = (int)arg[0].value - (int)arg[1].value - (int)arg[2].value;
    h = (height-(FS->max_bounds.ascent+FS->max_bounds.descent-1))/
	(FS->max_bounds.ascent+FS->max_bounds.descent + 1);
    if (h <= 0) h = 1;
    return  h;
}

int
Display_width()
{
    Arg arg[1];
    int width;

    XtSetArg(arg[0], XtNwidth, NULL);
    XtGetValues(text, arg, XtNumber(arg));
    get_font();
    width  = (int)arg[0].value;
    return ((width/FS->max_bounds.width)-1);
}

void
Display_Width_Bar_Height(size, num)
int size;
int num;
{
    Arg arg[4];
    int w,h, mh;

    get_font();

    w = (size+2)*FS->max_bounds.width;
    h = (FS_BAR->max_bounds.ascent + FS_BAR->max_bounds.descent + 2)*
                     (num+2) + 10;
    XawFormDoLayout(form, FALSE);
    XtUnmanageChild(bar);
    XtSetArg(arg[0], XtNheight, h);
    XtSetValues(bar, arg, 1);
    XtManageChild(bar);

    XawFormDoLayout(form, TRUE);
    while(XtAppPending(app) & XtIMXEvent)  {
           XtAppProcessEvent(app, XtIMXEvent);
    }
    XtSetArg(arg[0], XtNy, 0);
    XtGetValues(text, arg, 1);
    mh = (int)arg[0].value + 
       (FS->max_bounds.ascent + FS->max_bounds.descent)*5;
    XtSetArg(arg[0], XtNwidth, 0);
    XtGetValues(form, arg, 1);
    w = (int)arg[0].value;
    XtSetArg(arg[0], XtNheight, 0);
    XtGetValues(form, arg, 1);
    h = (int)arg[0].value;
    XtSetArg(arg[0], XtNminWidth,  w);
    XtSetArg(arg[1], XtNminHeight, mh);
    XtSetArg(arg[2], XtNheight, h);
    XtSetArg(arg[3], XtNwidth,  w);
    XtSetValues(toplevel, arg, 4);
    XSync(XtDisplay(toplevel), FALSE);
    while(XtAppPending(app) & XtIMXEvent)  {
           XtAppProcessEvent(app, XtIMXEvent);
    }
}

void
End_Window()
{
    XawTextBlock textblock;
    XawTextPosition startPos;
    XawTextPosition endPos;
    
    if (text_disabled) {
        startPos = 0;
        endPos = lastPos;
        XawTextInvalidate(text, startPos, endPos);
	XawTextEnableRedisplay(text);
        text_disabled = 0;
        return;
    }
    if (lastPos < maxPos) {
        textblock.firstPos = 0;
        textblock.length = strlen("");
        textblock.ptr    = "";
        startPos = lastPos;
        endPos = maxPos; 
        XawTextReplace(text, startPos, endPos, &textblock);
    }
    startPos = 0;
    endPos = lastPos;
    XawTextInvalidate(text, startPos, endPos);

}

void
High_Water()
{
    highPos = lastPos;
}

void
Reset_Window()
{
    maxPos = lastPos;
    lastPos = 0;
}

void
Write_Window(string, flag)
char *string;
int flag;
{
    XawTextBlock textblock;
    XawTextPosition startPos;
    XawTextPosition endPos;

    if (maxPos && ((int)(lastPos + (int)strlen(string)) <= (int)maxPos)) {
        strcpy((char *)&texts[lastPos], string);
        startPos = lastPos;
        endPos = lastPos + strlen(string);
    	lastPos = endPos;
    } else {
        if (!text_disabled) XawTextDisableRedisplay(text);
        text_disabled = 1;
        textblock.firstPos = 0;
    	textblock.length = strlen(string);
    	textblock.ptr    = string;
    	startPos = lastPos;
    	endPos = lastPos + textblock.length;
    	XawTextReplace(text, startPos, endPos, &textblock);
    	lastPos = startPos + textblock.length;
    }
}

static void
create_info()
{
   int n;
   Arg args[5];

   if (info_shell != NULL) return;
   n = 0;
   XtSetArg(args[n], XtNallowShellResize, TRUE); n++;
   info_shell = XtCreatePopupShell("info", 
				   transientShellWidgetClass,
			           toplevel,
			     	   args, n);
   n = 0;
   XtSetArg(args[n], XtNlabel,
		    "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"); n++;
   XtSetArg(args[n], XtNresizable, TRUE),n++;
   info_d = XtCreateManagedWidget("Dialog", dialogWidgetClass, info_shell, 
				  args, n); 
}

static void
create_user_dialog()
{
    int n;
    Arg args[3];

    if (user_shell != NULL) return;

    n = 0;
    XtSetArg(args[n], XtNallowShellResize, TRUE); n++;
    user_shell = XtCreatePopupShell("user", 
				    transientShellWidgetClass,
				    toplevel,
			            args, n);

    n = 0;
    XtSetArg(args[n], XtNlabel, "User name:"); n++;
    XtSetArg(args[n], XtNvalue, ""); n++;
    XtSetArg(args[n], XtNresizable, TRUE),n++;
    user_d = XtCreateManagedWidget("dialog", dialogWidgetClass, user_shell, 
			            args, n);    
    XawDialogAddButton(user_d, "Yes", do_user_cb, (XtPointer)1); 
    XawDialogAddButton(user_d, "Cancel", do_user_cb, (XtPointer)0); 
    XtRealizeWidget(user_shell);
}

void
create_update_time_dialog()
{
    int n;
    Arg args[3];

    if (time_shell != NULL) return;

    n = 0;
    XtSetArg(args[n], XtNallowShellResize, TRUE); n++;
    time_shell = XtCreatePopupShell("time", 
				    transientShellWidgetClass,
				    toplevel,
			            args, n);

    n = 0;
    XtSetArg(args[n], XtNlabel, "Enter new time interval:"); n++;
    XtSetArg(args[n], XtNvalue, ""); n++;
    XtSetArg(args[n], XtNresizable, TRUE),n++;
    time_d = XtCreateManagedWidget("dialog", dialogWidgetClass, time_shell, 
			            args, n);    
    XawDialogAddButton(time_d, "Yes", do_time_cb, (XtPointer)1); 
    XawDialogAddButton(time_d, "Cancel", do_time_cb, (XtPointer)0); 
    XtRealizeWidget(time_shell);
}

void
create_widgets()
{
    Arg args[15];
    int n;
    XtTranslations tranlations;

    XtAppAddActions(app, Actions, sizeof(Actions)/sizeof(XtActionsRec));
    
    form = XtCreateManagedWidget("form", formWidgetClass, toplevel,
			         NULL, (Cardinal)0);

    n = 0;
    XtSetArg(args[n], XtNtop,              XawChainTop); n++;
    XtSetArg(args[n], XtNbottom,           XawChainTop); n++;
    XtSetArg(args[n], XtNleft,             XawChainLeft); n++;
    XtSetArg(args[n], XtNright,            XawChainLeft); n++;
    XtSetArg(args[n], XtNlabel, 	   "Quit"); n++;
    quit = XtCreateManagedWidget("nice", commandWidgetClass, form,
				  args, (Cardinal)n);
    XtAddCallback(quit, XtNcallback, (XtCallbackProc)quit_cb, NULL); 

    n = 0;
    XtSetArg(args[n], XtNtop,              XawChainTop); n++;
    XtSetArg(args[n], XtNbottom,           XawChainTop); n++;
    XtSetArg(args[n], XtNleft,             XawChainLeft); n++;
    XtSetArg(args[n], XtNright,            XawChainLeft); n++;
    XtSetArg(args[n], XtNlabel, 	   "Options"); n++;
    XtSetArg(args[n], XtNfromHoriz,	   quit); n++;
    options = XtCreateManagedWidget("options", commandWidgetClass, form,
                                    args, (Cardinal)n);
    tranlations = XtParseTranslationTable(menuTranslations);
    XtOverrideTranslations(options, tranlations);

    opt_menu = XtCreatePopupShell("menu", simpleMenuWidgetClass, options,
				  NULL, (Cardinal)0);
   

    n = 0;
    if (show_idle()) {
        XtSetArg(args[n], XtNlabel, "Show Idle Process"); n++;
    } else {
       	XtSetArg(args[n], XtNlabel, "Exclude Idle Process"); n++;
    }
    opt_1 = XtCreateManagedWidget("op_1", smeBSBObjectClass, opt_menu,
                                  args, (Cardinal)n);

    XtAddCallback(opt_1, XtNcallback, (XtCallbackProc)menu_cb,
		(XtPointer)MENU_TOGGLE_PROCESS);
    n = 0;
    XtSetArg(args[n], XtNlabel, "Change update time"); n++;
    opt_2 = XtCreateManagedWidget("op_2", smeBSBObjectClass, opt_menu,
                                  args, (Cardinal)n);

    XtAddCallback(opt_2, XtNcallback, (XtCallbackProc)menu_cb,
		(XtPointer)MENU_UPDATE_TIME);

    n = 0;
    XtSetArg(args[n], XtNlabel, "Show by user"); n++;
    opt_3 = XtCreateManagedWidget("op_2", smeBSBObjectClass, opt_menu,
                                  args, (Cardinal)n);
    reset_user();

    XtAddCallback(opt_3, XtNcallback, (XtCallbackProc)menu_cb,
		(XtPointer)MENU_USER_NAME);

    n = 0;
    XtSetArg(args[n], XtNtop,              XawChainTop); n++;
    XtSetArg(args[n], XtNbottom,           XawChainTop); n++;
    XtSetArg(args[n], XtNleft,             XawChainLeft); n++;
    XtSetArg(args[n], XtNright,            XawChainLeft); n++;
    XtSetArg(args[n], XtNlabel, 	   "Nice"); n++;
    XtSetArg(args[n], XtNfromHoriz,	   options); n++;
    nice = XtCreateManagedWidget("nice", commandWidgetClass, form,
				  args, (Cardinal)n);
    XtAddCallback(nice, XtNcallback, (XtCallbackProc)do_cb, (XtPointer)DO_NICE);

    n = 0;
    XtSetArg(args[n], XtNtop,              XawChainTop); n++;
    XtSetArg(args[n], XtNbottom,           XawChainTop); n++;
    XtSetArg(args[n], XtNleft,             XawChainLeft); n++;
    XtSetArg(args[n], XtNright,            XawChainLeft); n++;
    XtSetArg(args[n], XtNlabel, 	   "SIG KILL"); n++;
    XtSetArg(args[n], XtNfromHoriz,	   nice); n++;
    kill_w = XtCreateManagedWidget("kill", commandWidgetClass, form,
				   args, (Cardinal)n);
    XtAddCallback(kill_w, XtNcallback, (XtCallbackProc)do_cb, 
		  (XtPointer)DO_KILL);

    n = 0;
    XtSetArg(args[n], XtNtop,              XawChainTop); n++;
    XtSetArg(args[n], XtNbottom,           XawChainTop); n++;
    XtSetArg(args[n], XtNleft,             XawChainLeft); n++;
    XtSetArg(args[n], XtNright,            XawChainLeft); n++;
    XtSetArg(args[n], XtNlabel, 	   "SIG TERM"); n++;
    XtSetArg(args[n], XtNfromHoriz,	   kill_w); n++;
    term = XtCreateManagedWidget("term", commandWidgetClass, form,
				  args, (Cardinal)n);
    XtAddCallback(term, XtNcallback, (XtCallbackProc)do_cb, (XtPointer)DO_TERM);
    
    n = 0;
    XtSetArg(args[n], XtNtop,              XawChainTop); n++;
    XtSetArg(args[n], XtNbottom,           XawChainTop); n++;
    XtSetArg(args[n], XtNleft,             XawChainLeft); n++;
    XtSetArg(args[n], XtNright,            XawChainRight); n++;
    XtSetArg(args[n], XtNfromVert,	   nice); n++;
    XtSetArg(args[n], XtNwidth,		   666); n++;
    XtSetArg(args[n], XtNheight,           100); n++;
    XtSetArg(args[n], XtNlabel,		   " "); n++;
    XtSetArg(args[n], XtNresizable,        TRUE); n++;
    bar = XtCreateManagedWidget("bar", labelWidgetClass, form,
				 args, (Cardinal)n);
    tranlations = XtParseTranslationTable(barTranslations);
    XtOverrideTranslations(bar, tranlations);

    n = 0;
    XtSetArg(args[n], XtNtop,              XawChainTop); n++;
    XtSetArg(args[n], XtNbottom,           XawChainBottom); n++;
    XtSetArg(args[n], XtNleft,             XawChainLeft); n++;
    XtSetArg(args[n], XtNright,            XawChainRight); n++;
    XtSetArg(args[n], XtNfromVert,	   bar); n++;
    XtSetArg(args[n], XtNwidth,		   666); n++;
    XtSetArg(args[n], XtNheight,           500); n++;
    XtSetArg(args[n], XtNstring, 	   texts); n++;
    XtSetArg(args[n], XtNlength,  sizeof(texts)); n++;
    XtSetArg(args[n], XtNuseStringInPlace, TRUE); n++;
    XtSetArg(args[n], XtNeditType,(XtArgVal)XawtextEdit); n++;
    XtSetArg(args[n], XtNdisplayCaret, FALSE); n++;
    XtSetArg(args[n], XtNresizable,     TRUE); n++;
    texts[0] = 0;

    text = XtCreateManagedWidget("text", asciiTextWidgetClass, form,
				 args, (Cardinal)n);
    tranlations = XtParseTranslationTable(textTranslations);
    XtOverrideTranslations(text, tranlations);
    return;
}

static void
do_cb(w, closure, call_data)
Widget w;
XtPointer closure;
XtPointer call_data;
{
    Arg arg[1];

    XtSetArg(arg[0], XtNsensitive, FALSE);
    XtSetValues(kill_w, arg, 1);
    XtSetValues(term, arg, 1);
    XtSetValues(nice, arg, 1);

    func = (int)closure;
    XtAppAddTimeOut(app,
                   (unsigned long)(1),
                   (XtTimerCallbackProc)do_it,
                   NULL);
 

}

static void
do_func_act(w, event, params, nparams)
Widget          w;
XEvent         *event;
String         *params;
Cardinal       *nparams;
{
    XawTextPosition pos;
    char *start;
    char *end;
    int prio;
    char temp[1000];
    int uid;
    int n;
    Arg args[10];
    Dimension width, height;

    if (func == -1) return;

    while(XtAppPending(app) & XtIMXEvent)  {
           XtAppProcessEvent(app, XtIMXEvent);
    }

    pos = XawTextGetInsertionPoint(text);
    if (lastPos == 0) return;
    if (pos < highPos) return;
    if (pos >= lastPos) pos = lastPos - 1;

    start = &texts[pos];
    while (start > texts && *start != '\n') start--;
    if (*start == '\n') start++;
    end = &texts[pos];
    while (end < &texts[lastPos] && *end != '\n') end++;
    if (*end == '\n') end--;
    strncpy(temp, start, end-start);
    temp[end-start] = '\0';
    procnum = atoi(start);
    uid = getuid();

    switch (func) {
	case DO_NICE:
            if (uid && (uid != proc_owner(procnum))) {
		sprintf(msg, "Not owner of process %d", procnum);
	        error(msg);
            } else {
                busy++;;
	        query_nice(temp);
	    }
	    break;
	case DO_TERM:
	case DO_KILL:
            if (uid && (uid != proc_owner(procnum))) {
		sprintf(msg, "Not owner of process %d", procnum);
	        error(msg);
            } else {
                busy++;
	        query_kill(temp);
	    }
	    break;
    }

}

static void
do_func_cb(w, closure, call_data)
Widget w;
XtPointer closure;
XtPointer call_data;
{
    int yes = (int)closure;
    char * value;
    int pri;
    int uid;
    Widget parent = w;

    while (!XtIsShell(parent)) parent = XtParent(parent);
    XtPopdown(parent);
    busy--;
    if (busy < 0) busy = 0;
    uid = getuid();
    if (func == DO_NICE  && yes) {
	value =  XawDialogGetValueString(nice_d);
 	pri = atoi(value);
	ReDisplay();
#if defined(PRIO_MIN) && defined(PRIO_MAX)
        if (procnum == -1 || pri <= PRIO_MIN || pri >= PRIO_MAX) {
	     error("Bad priority value");
        } else 
#endif
	if (uid && (uid != proc_owner(procnum))) {
	    sprintf(msg, "You do not own process %d", procnum);
	    error(msg);
	} else {
	    if (pri < 0 && uid) {
	        error("Bad priority value");
	    } else if (setpriority(PRIO_PROCESS, procnum, pri) == -1) {
	        sprintf(msg, "Could not set priorty on proc %d to %d\n", 
		        procnum, pri);
	    	error(msg);
            } else {
	    	ReDisplay();
	    }
	}
    } else if ((func == DO_KILL || func == DO_TERM)  && yes) {
	ReDisplay();
	if (uid && (uid != proc_owner(procnum))) {
	    sprintf(msg, "Not owner of process %d",procnum);
	    error(msg);
	} else {
	    if (func == DO_KILL) {
		if (kill(procnum, SIGKILL) == -1) {
		    sprintf(msg, "Could not kill process %d", procnum);
	    	    error(msg);
		}
	    } else if (func == DO_TERM) {
		if (kill(procnum, SIGTERM) == -1) {
		    sprintf(msg, "Could not terminate process %d", procnum);
	    	    error(msg);
		}
	    }
	    ReDisplay();
	}
    } 
    if (func >= 0)end_func();
}

static void
do_it(client_data, id)
caddr_t client_data;
XtIntervalId *id;
{
   XEvent   event;
   Widget   w;
   Arg args[10];
   int width,x,y,n;
   Position root_x, root_y;
   Cursor   cursor= NULL;

   XtSetArg(args[0], XtNwidth, NULL);
   XtGetValues(text, args, 1);
   width = (int)args[0].value;

   XtTranslateCoords(text, 0, 0, &root_x, &root_y);
   x = root_x;
   y = root_y;

   if (crosshair == NULL)
       crosshair = XCreateFontCursor (XtDisplay(toplevel), XC_crosshair);

   if (pirate == NULL)
       pirate = XCreateFontCursor (XtDisplay(toplevel), XC_pirate);

   create_info();

   XtRealizeWidget(info_shell);
   XtSetArg(args[0], XtNheight, NULL);
   XtGetValues(info_shell, args, 1);
   y -= (int)args[0].value;


   n = 0;
   switch (func) {
	case DO_NICE:
           XtSetArg(args[n], XtNlabel, 
		    "Place cursor on process to renice");n++;
           cursor = crosshair;
	   break;
	case DO_KILL:
           XtSetArg(args[n], XtNlabel, 
	            "Place cursor on process to kill"); n++;
           cursor = pirate;
	   break;
	case DO_TERM:
           XtSetArg(args[n], XtNlabel, 
		    "Place cursor on process to terminate"); n++;
           cursor = pirate;
	   break;
    } 
    XtSetArg(args[n], XtNjustify, XtJustifyCenter); n++;
    XtSetValues(XtNameToWidget(info_d, "label"), args, n);
    n = 0;
    XtSetArg(args[n], XtNx, x); n++;
    XtSetArg(args[n], XtNy, y); n++;
    XtSetArg(args[n], XtNwidth, width); n++;
    XtSetArg (args[n], XtNallowShellResize, True); n++;
    XtSetValues(info_shell, args, n); 
    XtPopup(info_shell, XtGrabNone);
    /*
     * Make sure all pending events get to the server and we process
     * the responses.  This insures that info_d label will be updated and
     * visable before the grab.
     */
    XSync(XtDisplay(toplevel), FALSE);
    while(XtAppPending(app) & XtIMXEvent)  {
	XtAppProcessEvent(app, XtIMXEvent);
    }

    lastTime = XtLastTimestampProcessed(XtDisplay(toplevel));
    XtGrabPointer(toplevel, True, (ButtonPressMask | ButtonReleaseMask),
                  GrabModeAsync, GrabModeAsync, NULL, cursor, lastTime);
    while (1) {
	XtAppNextEvent(app, &event);
	if (event.type == ButtonRelease) {
            XtPopdown(info_shell);
 	    XtUngrabPointer(toplevel, lastTime);
            XtDispatchEvent(&event);
   	    break;
	} else {
            XtDispatchEvent(&event);
	}
   }
   end_func();
}

static void
do_time_cb(w, closure, call_data)
Widget w;
XtPointer closure;
XtPointer call_data;
{
    int ok = (int)closure;
    Widget parent = w;
    int update;
    char *value;

    while (!XtIsShell(parent)) parent = XtParent(parent);
    XtPopdown(parent);

    if (ok) {
	value =  XawDialogGetValueString(time_d);
 	update = atoi(value);
	if (update <= 0) {
	    sprintf(msg, "Update time of %d seconds is to short", update);
	    error(msg);
	    return;
	}
	set_delay(update);
	ReDisplay();
    }

}

static void
do_user_cb(w, closure, call_data)
Widget w;
XtPointer closure;
XtPointer call_data;
{
    int ok = (int)closure;
    Widget parent = w;
    int update;
    char *value;
    Arg arg[1];

    while (!XtIsShell(parent)) parent = XtParent(parent);
    XtPopdown(parent);

    if (ok) {
	set_user(XawDialogGetValueString(user_d));
	ReDisplay();
        reset_user();
    }
}




static void
end_func()
{
    Arg arg[1];

    if (busy) return;
    func = -1;
    procnum = -1;
    XtSetArg(arg[0], XtNsensitive, TRUE);
    XtSetValues(kill_w, arg, 1);
    XtSetValues(term, arg, 1);
    XtSetValues(nice, arg, 1);
}

static void
error(msg)
char *msg;
{
    int n;
    Arg args[5];

    if (msg_shell == NULL) {
	n = 0;
        XtSetArg(args[n], XtNallowShellResize, TRUE); n++;
	msg_shell = XtCreatePopupShell("msg", 
				       transientShellWidgetClass,
				       toplevel,
			               args, n);
	n = 0;
	XtSetArg(args[n], XtNlabel, "SLAG"); n++;
        XtSetArg(args[n], XtNresizable, TRUE),n++;
    	msg_d = XtCreateManagedWidget("Dialog", dialogWidgetClass, msg_shell, 
			              args, n);    
	XawDialogAddButton(msg_d, "Cancel", do_func_cb, (XtPointer)0); 
   	XtRealizeWidget(msg_shell);
    }
    n = 0;
    XtSetArg(args[n], XtNlabel, msg); n++;
    XtSetArg(args[n], XtNresizable, TRUE),n++;
    XtSetValues(XtNameToWidget(msg_d, "label"), args, n);
    busy++;
    position_dialog(msg_shell, NULL);
}

static void
get_font()
{
    Arg arg[1];

    if (FS != NULL) return;
    XtSetArg(arg[0], XtNfont, NULL);
    XtGetValues(text, arg, XtNumber(arg));
    FS = (XFontStruct *)arg[0].value;
    XtSetArg(arg[0], XtNfont, NULL);
    XtGetValues(bar, arg, XtNumber(arg));
    FS_BAR = (XFontStruct *)arg[0].value;
}

static void
init_bar()
{
    Arg args[2];
    XGCValues gcv;

    if (bar_gc != NULL) return;
    XtSetArg(args[0], XtNforeground, 0);
    XtSetArg(args[1], XtNbackground, 0);
    XtGetValues(bar, args, XtNumber(args));

    gcv.foreground = (unsigned long)args[0].value;
    gcv.background = (unsigned long)args[1].value;
    gcv.font       = FS_BAR->fid;
    bar_gc =  XtGetGC(bar, GCFont|GCForeground|GCBackground, &gcv);

    gcv.foreground = (unsigned long)args[1].value;
    gcv.background = (unsigned long)args[0].value;
    bar_rgc =  XtGetGC(bar, GCForeground|GCBackground, &gcv);
}

static void
menu_cb(w, closure, call_data)
Widget w;
XtPointer closure;
XtPointer call_data;
{
    int func = (int)closure;
    int n;
    Arg args[2];

    switch (func) {
    	case MENU_TOGGLE_PROCESS:
	    toggle_idle();
            n = 0;
            if (!show_idle()) {
            	XtSetArg(args[n], XtNlabel, "Show Idle Process"); n++;
            } else {
            	XtSetArg(args[n], XtNlabel, "Exclude Idle Process"); n++;
            }
            XtSetValues(opt_1, args, n); 
	    ReDisplay();
	    return;
	case MENU_UPDATE_TIME:
	    create_update_time_dialog();
            sprintf(buff, "%d", get_delay());
	    n = 0;
            XtSetArg(args[n], XtNvalue, "5"); n++;
    	    XtSetValues(time_d, args, n);
            XtSetValues(XtNameToWidget(time_d, "label"), args, n);
	    position_dialog(time_shell, XtNameToWidget(time_d, "value"));
	    return;
	case MENU_USER_NAME:
	    if (show_user()) {
		set_user(NULL);
	        ReDisplay();
        	reset_user();
    	    } else {
	        create_user_dialog();
	        position_dialog(user_shell, XtNameToWidget(user_d, "value"));
	    }
	    return;
    }
}

static void
position_dialog(shell, w)
Widget shell;
Widget w;
{
    unsigned int buttons;
    int root_x, root_y, child_x, child_y;
    Window root, child;
    int n;
    Arg args[2];

    XQueryPointer(XtDisplay(toplevel), XtWindow(toplevel), &root, &child,
                  &root_x, &root_y, &child_x, &child_y, &buttons);

    if (w != NULL) {
        root_x -= w->core.x+2;
        root_y -= w->core.y+2;
    }

    n = 0;
    XtSetArg(args[n], XtNx, root_x); n++;
    XtSetArg(args[n], XtNy, root_y); n++;
    XtSetValues(shell, args, n);
    XtPopup(shell, XtGrabNone);
}

static void
query_kill(temp)
char *temp;
{
    Arg args[5];
    int n;

    if (kill_shell == NULL) {
	n = 0;
        XtSetArg(args[n], XtNallowShellResize, TRUE); n++;
	kill_shell = XtCreatePopupShell("nice", 
				        transientShellWidgetClass,
				        toplevel,
			                args, n);
	n = 0;
	XtSetArg(args[n], XtNlabel, "SLAG"); n++;
        XtSetArg(args[n], XtNresizable, TRUE),n++;
    	kill_d = XtCreateManagedWidget("Dialog", dialogWidgetClass, kill_shell, 
			               args, n);    
	XawDialogAddButton(kill_d, "Yes", do_func_cb, (XtPointer)1); 
	XawDialogAddButton(kill_d, "Cancel", do_func_cb, (XtPointer)0); 
        XtRealizeWidget(kill_shell);
    }

    if (func == DO_KILL) {
       sprintf(buff, "Kill process: %s\n", temp);
    } else {
       sprintf(buff, "Terminate process: %s\n", temp);
    }
    n = 0;
    XtSetArg(args[n], XtNlabel, buff); n++;
    XtSetArg(args[n], XtNresizable, TRUE),n++;
    XtSetValues(XtNameToWidget(kill_d, "label"), args, n);

    position_dialog(kill_shell, NULL);
}

static void
query_nice(temp)
char *temp;
{
    Arg args[5];
    int n;

    if (nice_shell == NULL) {
	n = 0;
        XtSetArg(args[n], XtNallowShellResize, TRUE); n++;
	nice_shell = XtCreatePopupShell("nice", 
				        transientShellWidgetClass,
				        toplevel,
			                args, n);
	n = 0;
	XtSetArg(args[n], XtNlabel, "SLAG"); n++;
        XtSetArg(args[n], XtNresizable, TRUE),n++;
  	XtSetArg(args[n], XtNvalue, ""); n++;
    	nice_d = XtCreateManagedWidget("Dialog", dialogWidgetClass, nice_shell, 
			               args, n);    
	XawDialogAddButton(nice_d, "Yes", do_func_cb, (XtPointer)1); 
	XawDialogAddButton(nice_d, "Cancel", do_func_cb, (XtPointer)0); 
        XtRealizeWidget(nice_shell);
    }

    n = 0;
    sprintf(buff, "Renice: %s\n", temp);
    XtSetArg(args[n], XtNlabel, buff); n++;
    XtSetArg(args[n], XtNresizable, TRUE),n++;
    XtSetValues(XtNameToWidget(nice_d, "label"), args, n);

    n = 0;
    XtSetArg(args[n], XtNvalue, "5"); n++;
    XtSetValues(nice_d, args, n);

    position_dialog(nice_shell, XtNameToWidget(nice_d, "value"));
}

static void
quit_cb(w, closure, call_data)
Widget w;
XtPointer closure;
XtPointer call_data;
{
    exit(0);
}

static void
reset_user()
{
    Arg arg[1];

    if (show_user()) {
        XtSetArg(arg[0], XtNlabel, "Show all users");
    } else {
        XtSetArg(arg[0], XtNlabel, "Show by user"); 
    }
    XtSetValues(opt_3, arg, 1);
}
static void
repaint_act(w, event, params, nparams)
Widget          w;
XEvent         *event;
String         *params;
Cardinal       *nparams;
{
    ReDrawBar();
}
