#!/usr/bin/perl
# config.pl: OS dependent Makefile generator
# Copyright (C) TOYODA Eizi, 1998.  All rights reserved.

$MSDOS = &MSDOS;
if ($MSDOS) {
	$BASEDIR = undef;
	$XDIR = 'C:\\WINDOWS';
	$XDIR = $ENV{"HOME"} if $ENV{"HOME"};
	$XDIR = `pwd` . "/tmp" if -f "tmp/dcbib.conf";
	$XDIR =~ s/[\r\n]//g;
	$BINDIR = $ETCDIR = $XDIR;
	$OSTYPE = 'dos';
	$INSTALL = 'copy';
	$INSTALLBIN = 'copy';
	$INSTALLDIR = 'mkdir';
	$INSTALLDEP = 'install.bin';
	$CAT = 'type';
	$EXE = '.com';
} else {
	# UNIX
	$BASEDIR = '/usr/local';
	$BASEDIR = `pwd` . "\\tmp" if -f "tmp\\dcbib.conf";
	$BASEDIR =~ s/[\r\n]//g;
	$OSTYPE = 'ux';
	$INSTALL = 'install';
	$INSTALLBIN = 'install -m 0755';
	$INSTALLDIR = 'install -d';
	$INSTALLDEP = 'install.bin install.doc';
	$CAT = 'cat';
	$EXE = '';
}
$HTROFF = 'htroff';

while ($_ = shift) {
	/^BASEDIR=(.*)/ && ($BASEDIR = $1, next);
	/^BINDIR=(.*)/ && ($BINDIR = $1, next);
	/^MANDIR=(.*)/ && ($MANDIR = $1, next);
	/^DOCDIR=(.*)/ && ($DOCDIR = $1, next);
	/^ETCDIR=(.*)/ && ($ETCDIR = $1, next);
}

if (defined $BASEDIR) {
	$BINDIR = "$BASEDIR/bin" unless $BINDIR;
	$MANDIR = "$BASEDIR/man" unless $MANDIR;
	$DOCDIR = "$BASEDIR/doc" unless $DOCDIR;
	$ETCDIR = "$BASEDIR/etc" unless $ETCDIR;
}

&GenerateMakefile("Makefile.txt", "Makefile");
&GenerateMakefile("doc/Makefile.txt", "doc/Makefile");
&GenerateMakefile("src/Makefile.txt", "src/Makefile");
	
exit 0;

sub GenerateMakefile {
	($input, $output) = @_;
	print "<$input >$output\n";
	open($input, "<$input") || die "$0: $input";
	open($output, ">$output") || die "$0: $output";
	
	print $output "# Makefile generated by config.pl.\n";
	print $output "CAT        = $CAT\n";
	print $output "EXE        = $EXE\n";
	print $output "OSTYPE     = $OSTYPE\n";
	print $output "BINDIR     = $BINDIR\n";
	print $output "MANDIR     = $MANDIR\n";
	print $output "DOCDIR     = $DOCDIR\n";
	print $output "ETCDIR     = $ETCDIR\n";
	print $output "INSTALL    = $INSTALL\n";
	print $output "HTROFF     = $HTROFF\n";
	print $output "INSTALLBIN = $INSTALLBIN\n";
	print $output "INSTALLDIR = $INSTALLDIR\n";
	print $output "INSTALLDEP = $INSTALLDEP\n";
	while (<$input>) {
		if (/\t\/\/(.*)\/\/\s*(.*)/) {
			if ($MSDOS) {
				print $output "\tcd $1\n\t$2\n\tcd ..\n";
			} else {
				print $output "\tcd $1; $2\n";
			}
			next;
		}
		if ($MSDOS) {
			s/^-d//;
			s/^-./#UX/;
		} else {
			s/^-d/#DOS/;
			s/^-.//;
		}
		print $output $_;
	}
}

	# it's not complete....
sub MSDOS {
	# MS-DOS has no /dev/null.
	return 0 if ( -c '/dev/null' );
	# MS-DOS has /DEV/CON even in drive without /DEV.
	return 1 if ( -f '/DEV/CoN' && ! -d '/DEV' );
	# MS-DOS allows CON or NUL have extension.
	return 2 if ( -f '/coN.3b7' && -f '/NuL.j0Q' && -f '/nUl.!#$' );
	0;
}

