# japanese.pl - ܸʸѴ롼
# Copyright (C) TOYODA Eizi, 1999.  All rights reserved.
#
# ץɽȤܸ EUC ȤΥ֥롼
#
# &initKC
#	Ѵʤ򤹤. ưŪ˵ư뤬
#	ưȽˤŪ˸ƤǤ褤.
#
# &open_r($filename)
#	եɤ߹ߤΤ˳, Υϥɥ֤.
#
# &readline($handle)
#	$handle  1 ɤ߼ɤѴΤ֤.
#
# $KCMethod
# 	'jcodepl':	Perl Ǽ jcode.pl ɤߤ˹Ԥ. μ.
#	'nkf':		/usr/bin ˤΤư. κ.
#	undef:		ǰ.
#
# $KCICode, $KCOCode
#	'jis'		ISO-2022-JP
#	'euc'		ܸ EUC (ǥե)
#	'sjis'		JIS X 0208-1997 ° ե沽ɽ

sub initKC {
	$KC_NKF = '/usr/bin/nkf';

	if (require 'jcode.pl') {
		$KCMethod = 'jcodepl';
	} elsif (-x $KC_NKF) {
		$KCMethod = 'nkf';
	} else {
		die "no kanji conversion method found.";
	}
	$KCIcode = undef;
}

sub open_r {
	local($filename) = @_;
	defined($KCMethod) || &initKC;
	local($path);
	if ($KCMethod eq 'nkf') {
		$path = "$KC_NKF -e \"$filename\"|"
	} else {
		$path = "<$filename";
	}
	open($filename, "$path") && $filename;
}

sub readline {
	local($handle) = @_;
	local($line, $code);
	defined($KCMethod) || &initKC;
	($line = <$handle>) || return undef;
	return $line if ($line !~ /[\033\200-\377]/);
	if ($KCMethod eq 'jcodepl') {
		($code = &jcode'getcode(*line)) && ($KCIcode = $code);
		&jcode'convert(*line, 'euc', $KCIcode);
		&jcode'h2z_euc(*line);
	}
	$line;
}

# debug code: not executed if this file follows 'exit;' line.
while ($fnam = shift) {
	$handle = &open_r($fnam);
	while ($_ = &readline($handle)) {
		print;
	}
}

