# add.pl: main routine for dcbib-add(1).
# $Id: add.pl,v 1.12 2000/10/03 15:55:07 takepiro Exp $
# Copyright (c) TOYODA Eizi, 1998.  
#               TAKEHIRO Shinichi, 2000. 
#               All rights reserved.
# see COPYING.TXT for terms of license.
#
#  For Developers:
#
# ɤߤȤäǡ, ץ, ƥե̾򥭡Ȥ
#   %CARD Ϣ˳Ǽ.  ʸϥ̾ mainpart Ϣѿ
#   Ǽ. 
#
# %CONFIG, %CARD ϥХѿȤƥ֥롼ϤƤ
#   礬Τ. 
#

$ETCDIR = '/etc' unless $ETCDIR;
$CONFIGFILE = "$ETCDIR/dcbib.conf";

while ($_ = shift) {
	/^-c$/ && ($CONFIGFILE = shift, next);
	/^-t$/ && ($checkmode = 1, next);
	/^-v$/ && ($verbosemode = 1, next);
	&die("undefined commandline argument $_");
}
	
&emlOpenFile($CONFIGFILE);
%CONFIG = &emlReadHeader();

&emlSetFile("STDIN");
%CARD = &emlRead();             # إå, ʸɤ߹

&checkCard(\%CARD);

$outfnam = &generateFileName;

if ( $checkmode ) { 
    print "\nGenerated filename will be $outfnam\n\n" ; 
    &emlWriteinSequence("STDOUT", %CARD);
}
else { 
   &creat($outfnam); 
   &emlWriteinSequence($outfnam, %CARD);
   &okay($outfnam);
   $username = `whoami`;
   &Syslog("$outfnam created by $username.");
   if ( $verbosemode ) { 
       print "\n" ; 
       &emlWriteinSequence("STDOUT", %CARD);
   }
}

&exit;

sub emlWriteinSequence {
    local($outfnam, %card) = @_;
    local($mainpart) = $card{'mainpart-ja'};
    delete $card{'mainpart-ja'};                      # ʸ̰

    local(@fieldlist)=&ExpandSlash(&availableFields($card{'cardtype'}));
    foreach $field ( @fieldlist ) {   # Ƥեɤɤ
	if (exists $card{$field}) {
	    local($cardtmp{$field}) = $card{$field};
	    &emlWriteHeader($outfnam, %cardtmp);     # إå
	    delete $card{$field};
	    delete $cardtmp{$field};
	}
    }
    foreach $field ( keys %card ) {              # Ĥäեɤ
	local($cardtmp{$field}) = $card{$field};
	&emlWriteHeader($outfnam, %cardtmp);   # إå
	delete $card{$field};
	delete $cardtmp{$field};
    }

    $mainpart =~ s/\r?\n/\n/g;          #  ^M 
    print $outfnam "\n";                # ʸȤζڤ
    print $outfnam $mainpart;           # ʸ
    print $outfnam "\n";                # Ǹϲ
}
