# addcgi.pl - CGI main program for dcbib
# Copyright (C) TOYODA Eizi, 1999.  
#               TAKEHIRO Shin-ichi, 2000. 
#               All rights reserved.
#
$rcsid .= '$Id: addcgi.pl,v 1.24 2000/10/13 21:21:02 okuyama Exp $';
#
#  For Developers:
#
#    Хѿ
#      ɥǡ١ %card
#      CGI ѿ           %cntl
#
#  Х
#      CGI ѿѤΥե̾(phase, emailfrom, origfile)
#      Ѥɤ򰷤ȤϤǤʤ. 
#
require 'open3.pl';

$TITLE = "dcbib ʸϿΥڡ";
$MAILADDR = "bunken\@gfd-dennou.org";
$BINDIR = '/usr/bin' unless $BINDIR;
$ETCDIR = '/etc' unless $ETCDIR;
$CONFIGFILE = "$ETCDIR/dcbib.conf";

&emlOpenFile($CONFIGFILE);
%CONFIG = &emlReadHeader();

# å
$COOKIE_ID = 'g8';
$COOKIE_HOLD_DAYS = 30;
# å
$myCookie = &getCookie($COOKIE_ID);
%cookie = &parseCookie($myCookie);

if (not &FormSubmitted()) {
	&SyokiGamen();
	exit 0;
}

%card = &getCGIData();                # submit 줿ǡǼ
foreach $field (&cntldataFields) {    # cntl ѤȥɥǡʬΥ
    if (exists $card{$field}) {
          $cntl{$field} = $card{$field};
          delete $card{$field};
    }
}
$cookie{'emailfrom'}=$cntl{'emailfrom'};
&printSetCookieHeader($COOKIE_ID, $COOKIE_HOLD_DAYS, $myCookie, %cookie);

if ( $cntl{'phase'} eq 'NEW' ) {
	if (not &EmailCheck($cntl{'emailfrom'})) {
		&SyokiGamen("Żҥ᡼륢ɥ쥹ϤƤ.");
		exit 0;
        }
	&printHtmlOpening($TITLE);
	&NyuuryokuGamen();
	&printHtmlClosing($TITLE);

} elsif ( $cntl{'phase'} eq 'MODIFY') {
	if (not &EmailCheck($cntl{'emailfrom'})) {
	    &SyokiGamen("Żҥ᡼륢ɥ쥹ϤƤ.");
	    exit 0;
        }
        $cntl{'origfile'} = &RelativetoFullpathFileName($cntl{'origfile'});
        if ( $cntl{'origfile'} eq '') {
	    &SyokiGamen("ե̾ޤ. ");
	    exit 0;
        } elsif ( !-f $cntl{'origfile'}) {
	    &SyokiGamen("ե뤬¸ߤޤ. ");
	    exit 0;
        } else {
	    &emlOpenFile($cntl{'origfile'});
	    %card = &emlRead();
	}
        &printHtmlOpening($TITLE);
	&NyuuryokuGamen();
        &printHtmlClosing($TITLE);

} elsif ( $cntl{'phase'} eq 'REMOVE') {
	if (not &EmailCheck($cntl{'emailfrom'})) {
	    &SyokiGamen("Żҥ᡼륢ɥ쥹ϤƤ.");
	    exit 0;
        }
        $cntl{'origfile'} = &RelativetoFullpathFileName($cntl{'origfile'});
        if ( $cntl{'origfile'} eq '') {
	    &SyokiGamen("ե̾ޤ. ");
	    exit 0;
        } elsif ( !-f $cntl{'origfile'}) {
	    &SyokiGamen("ե뤬¸ߤޤ. ");
	    exit 0;
        } else {
	    &printHtmlOpening($TITLE);
	    &SakujoGamen();
	    &printHtmlClosing($TITLE);
        }

} elsif ( $cntl{'phase'} eq 'DO REMOVE') {
        &SakujoKekkaGamen();

} elsif ($cntl{'phase'} eq 'CHECK') {
	&CheckGamen();

} elsif ( $cntl{'phase'} eq 'SUBMIT') {
	&KekkaGamen();
} else {
        &printHtmlOpening($TITLE);
        print "Error: Invalid phase field ($cntl{'phase'})";
}

exit 0;


sub SyokiGamen {
	local($message) = @_;
	&printHtmlOpening($TITLE);
	if ($message) {
		print "<HR>", $message;
	}
	print <<EOF;
<HR>
<FORM METHOD="POST" ACTION="$ENV{'SCRIPT_NAME'}">

ǽˤʤŻҥ᡼륢ɥ쥹ϤƤ:
 <INPUT TYPE="text" NAME="emailfrom" SIZE=60 VALUE="$cookie{'emailfrom'}"><P>
<P>
ǡοϿ뤤Ͻ˱ưʲ򤷤Ƥ. 

<OL>
<LI>
 ǡϿ : Ͽʸμ򤷤
 <INPUT TYPE="submit" NAME="phase" VALUE="NEW">
 ܥ򲡤Ƥ:

 <DL>
 <DT><INPUT TYPE="radio" NAME="cardtype" VALUE="article" CHECKED>article
 <DD>ʸ˷Ǻܤ줿ҤȤĤǤ
 <DT><INPUT TYPE="radio" NAME="cardtype" VALUE="book">book
 <DD>ΤǤ
 <DT><INPUT TYPE="radio" NAME="cardtype" VALUE="inbook">inbook
 <DD>ҤΰǤ
 <DT><INPUT TYPE="radio" NAME="cardtype" VALUE="misc">misc
 <DD>嵭ƤˤƤϤޤʤΤǤ
 </DL>

<LI>
 ǡϿ : ȤʤʸǡΥե̾򲼤Ϥ
 <INPUT TYPE="submit" NAME="phase" VALUE="MODIFY">
 ܥ򲡤Ƥ.  <P>

<LI>
 ǡ : ʸǡΥե̾򲼤Ϥ
 <INPUT TYPE="submit" NAME="phase" VALUE="REMOVE">
 ܥ򲡤Ƥ. եȤǧǤޤ. <P>

 ե̾ <INPUT TYPE="text" NAME="origfile" SIZE=30> 
 <INPUT TYPE="submit" NAME="phase" VALUE="MODIFY">
 <INPUT TYPE="submit" NAME="phase" VALUE="REMOVE"><P>
 ե̾η "$CONFIG{'cardpath'}" Ǥ. 
  %y, %i, %n Ϥ줾, year(, x Ϣ³), 
 initial(a-z0 1 ʸ), number()ɽƤޤ. 
</OL>
</FORM>
EOF
	&printHtmlClosing($TITLE);
}

sub NyuuryokuGamen {
        &warn("$field not available.")
	    unless &existsin($card{'cardtype'},&cardTypeList);

# ǽΤ
	print <<EOF;
	<HR>
	<FORM METHOD="POST" ACTION="$ENV{'SCRIPT_NAME'}">
	<P>
	Ͽ $card{'cardtype'} ʸϿޤ
	ʣϿʤɤ
	<A HREF="/arch/bunken/search.htm">
	</a>ƤϿ뤳Ȥ򤪴ᤷޤ
EOF
	 
        if ( $cntl{'phase'} eq 'CHECK' && $exitcode <= 1 ) {
	    print <<EOF;
	    Ͽʤ 
	    <INPUT TYPE="submit" NAME="phase" VALUE="SUBMIT">
	    ܥ򲡤ƥǡϿƤ
	    ٥åʤ, 
EOF
         }
	    print <<EOF;
            ϸ <INPUT TYPE="submit" NAME="phase" VALUE="CHECK">
	    ܥ򲡤ƥåƤ
	    -ja ΤĤƤʤեɤؤȾѱѿȵƤ. 
	    <P>
EOF
	&printInputCntldata;        # ѥǡ CGI Ϥ. 
        print "<TABLE BORDER=0>";
	$hr = "" x 40;

# ɬܹ
	#print "<TR><TD>ɬܹ:</TD><TD>$hr</TD></TR>\n";
	#@needed = &requiredFields($card{'cardtype'});
	#foreach $key (@needed) {
	#    $card{$key}=&cardTypeFieldDefault($key) if !exists $card{$key};
	#}
	#&printTextFields(@needed);
	print "<TR><TD>Ϲ:</TD><TD>$hr</TD></TR>\n";
        print "<TR><TD></TD></TR>\n";
        print <<EOF;
        <TR>
         <TD NOWRAP ALIGN="right">
          <INPUT TYPE="hidden" NAME="cardtype" VALUE="$card{'cardtype'}">
          cardtype </TD>
         <TD> $card{'cardtype'}</TD>
        </TR>
        <TR><TD></TD><TD>Ͽ</TD></TR><TR><TD></TD></TR>
EOF

# Ǥչ
	@optional = &optionFields($card{'cardtype'});
	foreach $key (@optional) {
	    $card{$key}=&cardTypeFieldDefault($key) if !exists $card{$key};
	}
	# id, keyword, keywork-ja copyholder ϥǥեȤ̽
	if ( $cntl{'phase'} eq 'NEW' || $cntl{'phase'} eq 'MODIFY' ) {
	    $default = $cntl{'emailfrom'} .'; ';
	    foreach $key ( ('id', 'keyword','keyword-ja') ) {
		if ( exists $card{$key} ){
		    if ( $card{$key} eq '' ){
		    	$card{$key}=$default;
		    }
		    elsif ($card{$key}!~ /$cntl{'emailfrom'}/){
			$card{$key}=$default . "\n". $card{$key};
		    }
		}
	    }
	    foreach $key ( ('copyholder') ) {
		$default = $cntl{'emailfrom'};
		if ( exists $card{$key} ){
		    if ( $card{$key} eq '' ){
		    	$card{$key}=$default;
		    }
		    elsif ($card{$key}!~ /$cntl{'emailfrom'}/){
			$card{$key}=$default . "\n". $card{$key};
		    }
		}
	    }
	}
	# history, history-ja ϥǥեȤ̽
	if ( $cntl{'phase'} eq 'NEW' ) {
	    $default = &dateandtime . '; ' . $cntl{'emailfrom'} .
		'; ǡ';
	    if ( exists $card{'history-ja'} ){
		if ( $card{'history-ja'} eq '' ){
		    $card{'history-ja'}=$default;
		}else{
		    $card{'history-ja'}=$default . "\n". $card{'history-ja'}; 
		}
	    }
	    $default = &dateandtime . '; ' . $cntl{'emailfrom'} .
		'; data created.';
	    if ( exists $card{'history'} ){
		if ( $card{'history'} eq '' ){
		    $card{'history'}=$default;
		}else{
		    $card{'history'}=$default . "\n". $card{'history'}; 
		}
	    }
	}
	if ( $cntl{'phase'} eq 'MODIFY' ) {
	    $default = &dateandtime . '; ' . $cntl{'emailfrom'} .'; '. 
		$cntl{'origfile'} . ' ǡ';
	    if ( exists $card{'history-ja'} ){
		if ( $card{'history-ja'} eq '' ){
		    $card{'history-ja'}=$default;
		}else{
		    $card{'history-ja'}=$default . "\n". $card{'history-ja'}; 
		}
	    }
	    $default = &dateandtime . '; ' . $cntl{'emailfrom'}. 
		'; data modified from ' . $cntl{'origfile'};
	    if ( exists $card{'history'} ){
		if ( $card{'history'} eq '' ){
		    $card{'history'}=$default;
		}else{
		    $card{'history'}=$default . "\n". $card{'history'}; 
		}
	    }
	}
	#print "<TR><TD>Ǥչ:</TD><TD>$hr</TD></TR>\n";
        #print "<TR><TD></TD></TR>\n";
	&printTextFields(@optional);

# פʹ
        $keylist = ' '.join('  ', keys(%card)).' ';
	foreach $key (&availableFields($card{'cardtype'})) { 
	    $keylist =~ s/ $key //; 
	}
        @unavailable = split(' ', $keylist);
        if ( scalar(@unavailable) > 0 ) {
	    print "<TR><TD>Ŭ:</TD><TD>$hr</TD></TR>\n";
	    print "<TR><TD></TD><TD>Ƥˤйܤޤ. </TD></TR>\n";
	    &printTextFields(@unavailable);
	}

	print <<EOF;
	<TR><TD></TD><TD>$hr</TD></TR>
	<TR><TD></TD><TD>
	    <INPUT TYPE="submit" NAME="phase" VALUE="CHECK"> 
 	    <INPUT TYPE="reset" VALUE="reset">
	</TD></TR>
</TABLE>

</FORM>
EOF
}

sub CheckGamen {
        ($exitcode, $pid, @result) = &processCard;
	&printHtmlOpening($TITLE);
	print "<HR>\n";
	if ($exitcode == 0) {
	    print "<H2>ϥǡˤϸϤޤ.</H2>\n";
	} elsif ($exitcode == 1) {
	    print "<H2>ϥǡˤ̿ŪʸϤޤ.</H2>\n";
	} else {
	    print "<H2>ϥǡˤ̿Ūʸ꤬ޤ.</H2>\n";
	    print "<P>\n";
	    print "ǡ٥åƤ\n";
	    print "<P>\n";
	}
	print join("<BR>\n", @result);

	&NyuuryokuGamen();
	&printHtmlClosing($TITLE);
}

sub KekkaGamen {
        ($exitcode, $pid, @result) = &processCard;
	&printHtmlOpening($TITLE);
	print "<HR>\n";
	if ($exitcode == 0) {
		$result = "";
	} elsif ($exitcode == 1) {
		$result = "(ٹϤΤ) ";
	} else {
		$result = "";
	}
	print "<H2>${result}ޤ</H2>\n";
	print join("<BR>\n", @result);
	print <<EOF;
EOF

	if ($cntl{'origfile'} ne '') {
	    print <<EOF;
	    <HR>
	    <FORM METHOD="POST" ACTION="$ENV{'SCRIPT_NAME'}">
	      Υǡե  $cntl{'origfile'} ޤ?
	      ʤ
	      <INPUT TYPE="submit" NAME="phase" VALUE="REMOVE">
	      ܥ򲡤Ƥ. 
	      եȤǧǤޤ. <BR>
EOF
            &printInputCntldata;
	    print "    </FORM>";
        }
	&printHtmlClosing($TITLE);
}

sub processCard {
	local($READ, $WRITE, $pid, @result, $exitcode);
	local($origfile)='';
        $READ = "READ";
        $WRITE = "WRITE";
	if ( $cntl{'phase'} eq 'CHECK' ) {
	    $pid = &open3($WRITE, $READ, '', "$BINDIR/dcbib-add -t");
	} else {
	    $umask=(umask);
	    umask 0002;
	    $message=sprintf("dcbib-add invoked by $cntl{'emailfrom'} with umask %04lo.",umask);
	    &Syslog("$message");
	    $pid = &open3($WRITE, $READ, '', "$BINDIR/dcbib-add -v");
	    umask $umask;
	}

        &writeCardStream($WRITE, %card);
        close($WRITE);
        @result = <$READ>;
        (waitpid($pid, 0) >= 0)
                || (@result = ("$?: invocation failed."));
        $exitcode = (($? >> 8) & 255);
        ($exitcode, $pid, @result)
}

sub writeCardStream {
	local($WRITE, %card) = @_;
	&emlWrite($WRITE, %card);
}

sub SakujoGamen {
	print "<HR>\n";
        print "<H2>ǡ: $cntl{'origfile'} </H2><P>\n";	

	print <<EOF;
	<FORM METHOD="POST" ACTION="$ENV{'SCRIPT_NAME'}">
	<INPUT TYPE=hidden NAME=origfile VALUE=$cntl{'origfile'}>
	ɤʤ, 
        <INPUT TYPE="submit" NAME="phase" VALUE="DO REMOVE">
	ܥ򲡤Ƥ. <BR>
EOF
        &printInputCntldata;
	print "    </FORM>";

	print "<HR><P>\n";                
        open(FILE,"<".$cntl{'origfile'});
        print $_,"<BR>\n" while (<FILE>);   # եȤɽ
}

sub SakujoKekkaGamen {
        &Syslog("dcbib-remove invoked by $cntl{'emailfrom'}.");
        local($command) = "$BINDIR/dcbib-remove $cntl{'origfile'}";
        $exitcode = system $command;

	&printHtmlOpening($TITLE);
	print "<HR>\n";
	if ($exitcode == 0) {
		$result = "";
	} else {
		$result = "";
        }
	print <<EOF;
	<H2>$resultޤ. </H2>
        <HR>
	¹Ԥ줿ޥ: $command
EOF
	&printHtmlClosing($TITLE);
}

sub EmailCheck {
	local($email) = @_;
	return 0 unless $email;
	return ($email =~ /.@./);
}

sub date {
	local($sec, $min, $hour, $day, $mon, $year) = gmtime(time);
	return sprintf("%04d-%02d-%02d", $year+1900, $mon+1, $day);
}

sub dateandtime {
	local($sec, $min, $hour, $day, $mon, $year) = localtime(time);
	return sprintf("%04d-%02d-%02d %02d:%02d:%02d JST", $year+1900, $mon+1, $day, $hour, $min, $sec);
    }

sub printTextFields {
    local(@fieldlist)=@_;
	foreach $key (@fieldlist) {
#	    &printTextField($key, &cardTypeDescription($key), $card{$key});
	    &printTextField($key, $key, $card{$key});
	    $setsumei = "<TR><TD></TD><TD>".&cardTypeDescription($key) ." : " 
	       . &cardTypeLongDescription($key)."</TD></TR>";
	    print $setsumei,"\n";
	    print "<TR><TD></TD></TR>\n";
	}
}

#
# cgi control ѿѥ֥롼
#
sub cntldataTypeHash {
 %CNTLDATATYPE = (
	'phase'	        => 'CGI ξ֥å. 
                            NEW, MODIFY, REMOVE, CHECK, SUBMIT, DO REMOVE',
	'emailfrom'	=> 'Żҥ᡼륢ɥ쥹',
	'origfile'	=> 'ե̾',
 );
}

sub cntldataFields {
	defined %CNTLDATATYPE || cntldataTypeHash;
	keys %CNTLDATATYPE;
}

sub printInputCntldata {
    foreach $field (&cntldataFields) {
	print <<END if exists $cntl{$field} && $field ne 'phase';
	 <INPUT TYPE="hidden" NAME="$field" VALUE="$cntl{$field}">
END
    }
}
