# card.pl - ʸɤΥեɤ˴ؤ
# $Id: card.pl,v 1.21 2000/10/03 15:55:07 takepiro Exp $
# Copyright (c) TOYODA Eizi, 1998.  All rights reserved.
# see COPYING.TXT for terms of license.
#
#  card.pl ǤΥɤημ
# 
#  1. %CARDTYPE ˤƥɤμ. 
#  2. %REQUIREDFIELD ˳ƥɼˤĤƤɬܥեɹܤ󤹤. 
#    ե̾϶Ƕڤ. 
#    ե̾򥹥å / ǤĤʤ, 
#      ξʤȤĤɬܤǤȲᤵ. 
#    ϻ󤷤֤ȿǤ. 
# 
#  3. %OPTIONFIELD ˤ, ƥɼˤĤƤǤեեɹܤ󤹤. 
#  4. %FIELDDESCRIPTION ˳ƥեɤû򵭤. 
#     %FIELDDELONGSCRIPTION ˳ƥեɤĹ򵭤. 
#     %FIELDDEFAULT ˤϳƥեɤΥǥեͤꤹ. 
#  5. ֥롼 checkFieldContent ˤ, ƥեƤ
#      å롼ꤹ. 
# 
#  : cardtype, mainpart-ja ͽǤ. add.pl ü˽. 
# 
#  Dennou dcbib ե⵬
#
#    ܸ 2 ХʸϤեɤˤ -ja Ĥ. 
#      ĤƤʤեƤ ASCII Character ǤʤФʤʤ. 
#
#    ¸ -ja ʤեɹܤܸ 2 ХʸϤɬפ
#       -ja ĤΥեɤ򿷤˺. 
#

sub cardTypeHash {
 %CARDTYPE = (
	'article'	=> 'ʪޤϳؽѻε',
	'book'		=> ' (ǼԤΤʤ)',
	'inbook'	=> 'Ҥΰ (ͭɽ⤿ʤ)',
	'misc'	        => 'ʪ, ؽѻ, Ƥ°ʤ',
 );
 %REQUIREDFIELD = (
	'article'	=> 'cardtype',
	'book'		=> 'cardtype',
	'inbook'	=> 'cardtype',
	'misc'	        => 'cardtype',
 );
 %OPTIONFIELD = (
	'article'	=> 'author author-ja 
                            year month 
                            title title-ja 
                            journal journal-ja volume number pages 
                            url remark-ja 
                            keyword keyword-ja id copyholder 
                            history-ja mainpart-ja',
	'book'		=> 'author author-ja editor editor-ja 
                            year month series series-ja volume number 
                            booktitle booktitle-ja edition pages 
                            publisher publisher-ja address address-ja 
                            url remark-ja 
                            keyword keyword-ja id copyholder 
                            history-ja mainpart-ja',
	'inbook'	=> 'author author-ja year month title title-ja 
                            editor editor-ja series series-ja 
                            volume number booktitle booktitle-ja 
                            edition chapter pages publisher publisher-ja 
                            address address-ja url remark-ja 
                            keyword keyword-ja id copyholder 
                            history-ja mainpart-ja',
	'misc'	        => 'author author-ja editor editor-ja year month 
                            title title-ja journal journal-ja series series-ja 
                            volume number booktitle booktitle-ja edition 
                            chapter pages publisher publisher-ja 
                            address address-ja url remark-ja 
                            keyword keyword-ja id copyholder 
                            history-ja mainpart-ja',
 );
 %FIELDDESCRIPTION = (
	'cardtype'	=> 'Ͽ',

	'author'	=> '',
	'author-ja'	=> '(ܸ)',

	'editor'	=> 'Խ',
	'editor-ja'	=> 'Խ(ܸ)',

	'year'		=> 'ǯ',
	'month'		=> 'Ԥ줿',

	'title'		=> 'ʸϤɽ',
	'title-ja'	=> 'ʸϤɽ(ܸ)',

	'journal'	=> 'ʪ(ʸʤ)̾',
	'journal-ja'	=> 'ʪ(ʸʤ)̾(ܸ)',

	'series'	=> 'ҥ꡼ɽ',
	'series-ja'	=> 'ҥ꡼ɽ(ܸ)',

	'volume'	=> 'ֹ',
	'number'	=> '',

	'booktitle'	=> 'Ҥɽ',
	'booktitle-ja'	=> 'Ҥɽ(ܸ)',
	'edition'	=> 'Ҥǿ',

	'chapter'	=> 'ֹ',

	'pages'		=> 'ڡϰ',

	'publisher'	=> 'Ǽ',
	'publisher-ja'	=> 'Ǽ(ܸ)',
	'address'	=> 'ǼԤν',
	'address-ja'	=> 'ǼԤν(ܸ)',

	'url'	        => 'URL ',
	'remark-ja'	=> 'Ÿ(ܸ)',

	'keyword'	=> '',
	'keyword-ja'	=> '(ܸ)',
        'id'	        => 'ʸֹ',
	'copyholder'	=> 'ʸ',
	'from'	        => 'ȯԤΥ᡼륢ɥ쥹',
	'history'	=> '',
	'history-ja'	=> '(ܸ)',

	'mainpart-ja'	=> 'ʸ(ܸ)',
 );
 %FIELDLONGDESCRIPTION = (
	'address'	=> '̾ʽǼҤʤԻ̾Ǥ褤. ',
	'address-ja'	=> 'äɬפʾ˵. ',
	'author'	=> "ʣϲԤ뤫 \'/\' Ƕڤ. \n 
                            ̾̾ǤΤȤ˥ (',') 
                            . ",
	'author-ja'	=> 'ʣϲԤ뤫 \'/\' Ƕڤ. ',
	'booktitle'	=> '',
	'booktitle-ja'	=> '',
	'chapter'	=> 'Τߤ򵭤',
	'editor'	=> "ʣϲԤ뤫 \'/\' Ƕڤ. \n 
                            ̾̾ǤΤȤ˥ (',') 
                            . ",
	'editor-ja'	=> 'ʣϲԤ뤫 \'/\' Ƕڤ. ',
	'journal'	=> '',
	'journal-ja'	=> '',
	'month'		=> '(̤ԤξϽ񤫤줿)',
	'number'	=> '̾ϱѿ',
	'pages'		=> 'ڡϰϤξ 42--111 Τ褦˥ϥե 
                            2 Ѥ. 
                            ڡξ 687pp. Τ褦˵. ',
	'publisher'	=> '',
	'publisher-ja'	=> '',
	'series'	=> '',
	'series-ja'	=> '',
	'title'		=> '',
	'title-ja'	=> '',
	'volume'	=> '̾ϱѿ',
	'year'		=> '4 ο. ̤ԤξϽ񤫤줿ǯ. 
                            ǯ 85 Τ褦άƤϤʤʤ. 
                            ʾ 19xx, 199x ʤ',
	'url'	        => '1 񸻤Ǽ, 
                            سΥե Web ˤƸƤ.',
	'remark-ja'	=> '̾νŸƤϤޤʤ
                            ܸǵ.',
	'from'	        => '᡼륢ɥ쥹. 
                            ʣ¸ߤϲԤ뤫 \'/\' Ƕڤ. ',
	'copyholder'	=> '᡼륢ɥ쥹. 
                            ʣ¸ߤϲԤ뤫 \'/\' Ƕڤ. ',
	'history'	=> '; ᡼륢ɥ쥹; ȡפηǵ.
                            <br>
                            : 2000-08-29 10:00:00 JST; shosuke@gfd-dennou.org; 
                                card created. <br>
                            ʣιܤ¸ߤϲԤ뤫 
                            \'/\' Ƕڤ.',
	'history-ja'	=> '; ᡼륢ɥ쥹; ȡפηǵ.
                             <br>
                             :2000-08-29; shosuke@gfd-dennou.org; 
                                ǡ <br>
                             ʣιܤ¸ߤϲԤ뤫 
                             \'/\' Ƕڤ.',
	'id'	        => '֥᡼륢ɥ쥹; ֹפηǵ. <br>
                             : shosuke@gfd-dennou.org; 123<br>
                             ʣΰۤʤ᡼륢ɥ쥹¸ߤ
                             Ԥ뤫 \'/\' Ƕڤ.
                             ʤϹԤõ. ',
	'keyword'	=> '֥᡼륢ɥ쥹; ɡפηǵ.<br>
                             : shosuke@gfd-dennou.org; Rossby wave, 
                                 rotation, wave momentum<br>
                             ʣΰۤʤ᡼륢ɥ쥹¸ߤ
                             Ԥ뤫 \'/\' Ƕڤ.
                             ʤϾõƶԤˤ. ',
	'keyword-ja'	=> 'Ϸ keyword Ʊ',
	'mainpart-ja'	=> '׻, ʤɤ. 
                            ׻ݤϡ--- Abstract:פ, 
                            ܸ׻ݤϡ--- Abstract-ja:פ, 
                             --- Note-ja:᡼륢ɥ쥹פ
                            Ϥ. <p>
                            <p>
                            --- Abstract:
                            <p>
                            Abstract is here.<br>
                            ..................................................
                            <p>
                            --- Abstract-ja:
                            <p>
                            ܸ׻ݤϤ<br>
                            ..................................................
                            <p>
                            --- Note-ja: shosuke@gfd-dennou.org
                            <p>
                            ˥<br>
                            ..................................................
                            <p>
                            --- Note-ja: takepiro@gfd-dennou.org
                            <p>
                            ̤οͤϤʶ³<br>
                            ..................................................
                            <p>',
 );
 %FIELDDEFAULT = (
	'author'	=> '',
	'author-ja'	=> '',

	'editor'	=> '',
	'editor-ja'	=> '',

	'year'		=> '',
	'month'		=> '',

	'title'		=> '',
	'title-ja'	=> '',

	'journal'	=> '',
	'journal-ja'	=> '',

	'series'	=> '',
	'series-ja'	=> '',

	'volume'	=> '',
	'number'	=> '',

	'booktitle'	=> '',
	'booktitle-ja'	=> '',
	'edition'	=> '',

	'chapter'	=> '',

	'pages'		=> '',

	'publisher'	=> '',
	'publisher-ja'	=> '',
	'address'	=> '',
	'address-ja'	=> '',

	'url'	        => '',
	'remark-ja'	=> '',

	'keyword'	=> '',
	'keyword-ja'	=> '',
        'id'	        => '',
	'copyholder'	=> '',
	'from'	        => '',
	'history'	=> '',
	'history-ja'	=> '',

	'mainpart-ja'	=> "--- Abstract:\n\n--- Abstract-ja:\n\n--- Note-ja: hogehoge\@gfd-dennou.org\n",
 );
}

    #
    # ƥեɤƤå. 
    # ˡ : $content=checkFieldContent($field,$content);
    # 
sub checkFieldContent {
    require 'jcode.pl';
    local($field,$content)=@_;

    if ( $field eq 'pages' ) {
	&warn("pages has no number. Are you sure?")
		if ($content ne '' && $content !~ /[0-9]/);
    }

    if ( $field eq 'author' ) {
	&warn("author should begin in uppercase letter.")
		if ($content ne '' && $content =~ /^[a-z]/);
	&warn("author should begin in A-Za-z. ($content)")
		unless ($content eq '' || $content =~ /^[A-Za-z]/);
	$content =~ s/[\/]/\n/g;     # ߥԤ
    }
    if ( $field eq 'author-ja' ) {
	$content =~ s/[\/]/\n/g;     # ߥԤ
    }

    if ( $field eq 'editor' ) {
	&warn("editor should begin in uppercase letter.")
		if ($content ne '' && $content =~ /^[a-z]/);
	&warn("editor should begin in A-Za-z. ($content)")
		unless ($content eq '' || $content =~ /^[A-Za-z]/);
	$content =~ s/[;\/]/\n/g;     # å, ߥԤ
    }
    if ( $field eq 'editor-ja' ) {
	$content =~ s/[;\/]/\n/g;     # å, ߥԤ
    }

    if ( $field eq 'title' ) {
	#  ASCII Ƥ褤⤦äȼ嵤
	# ե٥åȤ1ʸߤʤȷٹ𤹤
	&warn("title has no letter. Are you sure?")
		if ($content ne '' && $content !~ /[A-Za-z]/);
    }

    if ( $field eq 'year' ) {
	$content =~ s/\s+//g;
	if (length $content > 4) {
	    $content = substr($content,0,4);
	    &warn("year is too long  --- trancated as $content.");
	} elsif (length $content < 4) {
	    $content = $content .'x'x(4-length $content);
	    &warn("year is too short  --- converted to $content.");
	}
	#if ($content =~ /([^0-9x]+)/) {
	#	local($bad) = $1;
	#	$content =~ tr/0-9/x/c;
	#	&warn("year has bad character '$bad' --- converted to 'x'.");
	#}
    }

    if ( $field eq 'copyholder' ) {
	$content =~ s/[\/]/\n/g;     # åԤ
    }

    if ( $field eq 'keyword' ) {
	$content =~ s/[\/]/\n/g;     # åԤ
    }

    if ( $field eq 'keyword-ja' ) {
	$content =~ s/[\/]/\n/g;     # åԤ
    }

    if ( $field eq 'id' ) {
	$content =~ s/[\/]/\n/g;     # åԤ
    }

    if ( $field eq 'history' ) {
	$content =~ s/[\/]/\n/g;     # åԤ
    }

    if ( $field eq 'mainpart-ja' ) {
	$content =~ s/\t/\n/g;        # ֤ԤѴ
    }

    if ( $field =~ /-ja$/ ) {
	&jcode'convert(*content,"euc"); # Ǹ -ja Ĥեɤ EUC 
    } else {
	&die("$field should be ASCII characters. ($field : $content)")
		unless ($content =~ /^[\x20-\x7E\n]*$/);
    }
    $content;
}

######################### ʲѹ٤餺 #########################

sub cardTypeList {
	defined %CARDTYPE || cardTypeHash;
	keys %CARDTYPE;
}

sub cardTypeDescription {
	local($type) = @_;
	defined %CARDTYPE || cardTypeHash;
	$FIELDDESCRIPTION{$type};
}

sub cardTypeLongDescription {
	local($type) = @_;
	defined %CARDTYPE || cardTypeHash;
	$FIELDLONGDESCRIPTION{$type};
}

sub cardTypeFieldDefault {
	local($type) = @_;
	defined %CARDTYPE || cardTypeHash;
	$FIELDDEFAULT{$type};
}

sub requiredFields {
	local($type) = @_;
	defined %REQUIREDFIELD || cardTypeHash;
	split(' ', $REQUIREDFIELD{$type});
}

sub optionFields {
	local($type) = @_;
	defined %OPTIONFIELD || cardTypeHash;
	split(' ', $OPTIONFIELD{$type});
}

sub availableFields {
	local($type) = @_;
	defined %OPTIONFIELD || cardTypeHash;
	split(' ', "$REQUIREDFIELD{$type} $OPTIONFIELD{$type}");
}
