# help.pl: main routine for dcbib-help(1).
# Copyright (c) TAKEHIRO Shinichi, 2000. 
#               All rights reserved.
#
$ETCDIR = '/etc' unless $ETCDIR;
$CONFIGFILE = "$ETCDIR/dcbib.conf";

$FIELDLENGTH=15;
$DESCLENGTH=60;

while ($_ = shift) {
	/^-c$/ && ($CONFIGFILE = shift, next);
	/^-f$/ && ($field = shift, next);
	/^-h$/ && &usage;
	$cardtype = $_; last;
}

&cardTypeHash;

if ($field ne '') {
    if (exists $FIELDDESCRIPTION{$field}){
	$description = &cardTypeLongDescription($field);
	$description =~ s/\n[ ]+//g;
	$description =~ s/<[Bb][Rr]>/\n/g;
	$description =~ s/<[Pp]>/\n\n/g;
	print "\nե̾\n\n";
	printf("%${FIELDLENGTH}s : %s\n",$field,&cardTypeDescription($field));
	print "\n";
	#print &cardTypeLongDescription($field),"\n";
	print $description,"\n\n";
	&exit;
    }
    else{
	&die("ե̾ \'$field\' Ƥޤ.");
    }
}

if ( exists $CARDTYPE{$cardtype}) {
    print "\nɼ\n\n";
    printf("%${FIELDLENGTH}s : %s\n",$cardtype,$CARDTYPE{$cardtype});
    print "\nɬܹ\n\n";
    foreach $field (&requiredFields($cardtype)) {
	printf("%${FIELDLENGTH}s : %s\n",$field,&cardTypeDescription($field));
    }
    print "\nǤչ\n\n";
    foreach $field (&optionFields($cardtype)) {
	printf("%${FIELDLENGTH}s : %s\n",$field,&cardTypeDescription($field));
    }
    print "\n\n\n";
    print "        \% $0 -f [ե̾]\n\n  ǥե̾ξܤɽޤ.\n\n";
}
else{
    print "\nɼ\n\n";
    foreach $cardtype (&cardTypeList) {
	printf("%${FIELDLENGTH}s : %s\n",$cardtype,$CARDTYPE{$cardtype});
    }
    print "\n\n\n";
    print "        \% $0 [ɼ]\n\n  ǻȤեɤȴñɽޤ.\n\n";
}

&exit;

sub usage {
    print "$0 [-c config file] [-h] [-f field name] cardtype\n";
    exit 0;
}
