# fncreat.pl: filename generation routine for dcbib-add(1).
# $Id: fncreat.pl,v 1.1.1.1 2000/03/18 06:54:10 odakker Exp $
# Copyright (c) TOYODA Eizi, 1998.  All rights reserved.
# see COPYING.TXT for terms of license.

# assumption:
# * %CONFIG has information from configfile (e.g. /etc/dcbib.conf).
# * %HEADER has information from bib card and tested with &testCard.

sub generateFileName {
	# assumes ending with slash
	local($pat) = $CONFIG{"basedir:"};
	$pat =~ s/\/+$//;
	$pat .= "/";
	$pat .= $CONFIG{"cardpath:"};
	$pat =~ s/%i/&gfn_initial/ge;
	$pat =~ s/%y/&gfn_year/ge;

	# unique number generator
	if ($pat =~ /%n/) {
		local($number) = 1;
		for (;; $number++) {
			$fnam = $pat;
			$fnam =~ s/%n/$number/g;
			last unless (-e $fnam);
		} 
	} else {
		# Are you sure?  This will overwrite existing same name.
		&warn("cardpath has no %n");
		$fnam = $pat;
	}

	$fnam;
}


sub gfn_year {
	$HEADER{"year:"};
}


# get initial character of author's family name
sub gfn_initial {
	local($author) = $HEADER{"author:"};
	$author = $HEADER{"editor:"} unless $author;
	$author =~ s/^\n+//;
	# if unknown
	return "u" unless $author;
	if ($author =~ /,/) {
		$author =~ s/^\s*//;
	} else {
		# getting last word
		$author =~ s/\s*$//; 
		$author =~ s/^.*[ .]+//; 
	}
	# get initial character
	local($ini) = substr($author, 0, 1);
	return 'u' unless ($ini =~ /^[A-Za-z]/);
	$ini =~ tr/A-Z/a-z/;
	$ini;
}

