# add.pl: main routine for dcbib-add(1).
# $Id: add.pl,v 1.11 2000/09/30 13:49:04 takepiro Exp $
# Copyright (c) TOYODA Eizi, 1998.  
#               TAKEHIRO Shinichi, 2000. 
#               All rights reserved.
# see COPYING.TXT for terms of license.
#
#  For Developers:
#
# ɤߤȤäǡ, ץ, ƥե̾򥭡Ȥ
#   %CARD Ϣ˳Ǽ.  ʸϥ̾ mainpart Ϣѿ
#   Ǽ. 
#
# %CONFIG, %CARD ϥХѿȤƥ֥롼ϤƤ
#   礬Τ. 
#

$ETCDIR = '/etc' unless $ETCDIR;
$CONFIGFILE = "$ETCDIR/dcbib.conf";

while ($_ = shift) {
	/^-c$/ && ($CONFIGFILE = shift, next);
	/^-t$/ && ($checkmode = 1, next);
	/^-v$/ && ($verbosemode = 1, next);
	&die("undefined commandline argument $_");
}
	
&emlOpenFile($CONFIGFILE);
%CONFIG = &emlReadHeader();

&emlSetFile("STDIN");
%CARD = &emlRead();             # إå, ʸɤ߹

if ($CARD{'cardtype'} eq 'book') {
    if (exists $CARD{'title'}){
	$CARD{'booktitle'} = $CARD{'title'};
	delete $CARD{'title'};
        print STDERR "titile moved to booktitle\n";
    }
    if (exists $CARD{'title-ja'}){
	$CARD{'booktitle-ja'} = $CARD{'title-ja'};
	delete $CARD{'title-ja'};
        print STDERR "titile-ja moved to booktitle-ja\n";
    }
}

if (defined $CARD{'from'}) {
    $from=$CARD{'from'};
    delete $CARD{'from'};
    if (exists $CARD{'history'}){
	$CARD{'history-ja'}=&dateandtime . '; ' . $from 
	    .'; ǡѴ'."\n".$CARD{'history'};
	delete $CARD{'history'};
    }else{
	$CARD{'history-ja'}=&dateandtime . '; ' . $from .'; ǡѴ';
    }
    $CARD{'copyholder'}=$from;
}
foreach $field (keys %CARD) {
    if ($field =~ /^(id|keyword)-(\w+)(-ja)?$/){ 
	$newfield=$1.$3;
	$user=$2;
        $user=$from if $from =~ /^$user/;
        print STDERR "$field is transformed to $newfield\n";
	$CARD{$field} =~s/\//-/g;
	if (defined $CARD{$newfield}) {
	    $CARD{$newfield} = $CARD{$newfield}.'\n'.$user.'; '.$CARD{$field};
	}else{
	    $CARD{$newfield} = $user.'; '.$CARD{$field};
	}
	delete $CARD{$field};
    }
}

while ($CARD{'mainpart-ja'} =~ /Note-(\w+)-ja:/){
    $newfield='Note-ja';
    $user=$1;
    $user=$from if $from =~ /^$user/;
    print STDERR "mailaddress added to note in the mainpart\n";
    $CARD{'mainpart-ja'} =~ s/Note-(\w+)-ja:/$newfield: $user/;
}

#&checkCard(\%CARD);

$outfnam = 'STDOUT';

if ( $checkmode ) { 
    print "\nGenerated filename will be $outfnam\n\n" ; 
    &emlWriteinSequence("STDOUT", %CARD);
#    &emlWrite("STDOUT", %CARD);
}
else { 
#   &creat($outfnam); 
   &emlWriteinSequence($outfnam, %CARD);
#   &emlWrite($outfnam, %CARD);
   &okay($outfnam);
   if ( $verbosemode ) { 
       print "\n" ; 
       &emlWriteinSequence("STDOUT", %CARD);
#       &emlWrite("STDOUT", %CARD);
   }
}

&exit;

sub emlWriteinSequence {
    local($outfnam, %card) = @_;
    local($mainpart) = $card{'mainpart-ja'};
    delete $card{'mainpart-ja'};                      # ʸ̰

    local(@fieldlist)=&ExpandSlash(&availableFields($card{'cardtype'}));
    foreach $field ( @fieldlist ) {   # Ƥեɤɤ
	if (exists $card{$field}) {
	    local($cardtmp{$field}) = $card{$field};
	    &emlWriteHeader($outfnam, %cardtmp);     # إå
	    delete $card{$field};
	    delete $cardtmp{$field};
	}
    }
    foreach $field ( keys %card ) {              # Ĥäեɤ
	local($cardtmp{$field}) = $card{$field};
	&emlWriteHeader($outfnam, %cardtmp);   # إå
	delete $card{$field};
	delete $cardtmp{$field};
    }

    $mainpart =~ s/\r?\n/\n/g;          #  ^M 
    print $outfnam "\n";                # ʸȤζڤ
    print $outfnam $mainpart;           # ʸ
    print $outfnam "\n";                # Ǹϲ
}

sub dateandtime {
	local($sec, $min, $hour, $day, $mon, $year) = gmtime(time);
	return sprintf("%04d-%02d-%02d %02d:%02d:%02d JST", $year+1900, $mon+1, $day, $hour+9, $min, $sec);
}
