# addcgi.pl - CGI main program for dcbib
# Copyright (C) TOYODA Eizi, 1999.  
#               TAKEHIRO Shin-ichi, 2000. 
#               All rights reserved.

#
$rcsid .= '$Id: addcgi.pl,v 1.9 2000/09/20 03:15:19 takepiro Exp $';
#

require 'open3.pl';

$TITLE = "dcbib ʸϿΥڡ";
$MAILADDR = "bunken\@gfd-dennou.org";
$BINDIR = '/usr/bin' unless $BINDIR;
$ETCDIR = '/etc' unless $ETCDIR;
$CONFIGFILE = "$ETCDIR/dcbib.conf";

&emlOpenFile($CONFIGFILE);
%CONFIG = &emlReadHeader();

if (not &FormSubmitted()) {
	&SyokiGamen();
	exit 0;
}

%card = &getCGIData();

if ( $card{'phase'} eq 'NEW' ) {
	if (not &EmailCheck($card{'from'})) {
		&SyokiGamen("Żҥ᡼륢ɥ쥹ϤƤ.");
		exit 0;
        }
	&printHtmlOpening($TITLE);
	&NyuuryokuGamen();
	&printHtmlClosing($TITLE);

} elsif ( $card{'phase'} eq 'MODIFY') {
	if (not &EmailCheck($card{'from'})) {
	    &SyokiGamen("Żҥ᡼륢ɥ쥹ϤƤ.");
	    exit 0;
        }
        $card{'origfile'} = &RelativetoFullpathFileName($card{'origfile'});
        if ( $card{'origfile'} eq '') {
	    &SyokiGamen("ե̾ޤ. ");
	    exit 0;
        } elsif ( !-f $card{'origfile'}) {
	    &SyokiGamen("ե뤬¸ߤޤ. ");
	    exit 0;
        } else {
	    &emlOpenFile($card{'origfile'});
	    %cardfile = &emlRead();
	    foreach $key ( keys %cardfile ) { 
		$card{$key} = $cardfile{$key} unless $key eq 'from'; 
	    }
	}
        &printHtmlOpening($TITLE);
	&NyuuryokuGamen();
        &printHtmlClosing($TITLE);

} elsif ( $card{'phase'} eq 'REMOVE') {
	if (not &EmailCheck($card{'from'})) {
	    &SyokiGamen("Żҥ᡼륢ɥ쥹ϤƤ.");
	    exit 0;
        }
        $card{'origfile'} = &RelativetoFullpathFileName($card{'origfile'});
        if ( $card{'origfile'} eq '') {
	    &SyokiGamen("ե̾ޤ. ");
	    exit 0;
        } elsif ( !-f $card{'origfile'}) {
	    &SyokiGamen("ե뤬¸ߤޤ. ");
	    exit 0;
        } else {
	    &printHtmlOpening($TITLE);
	    &SakujoGamen();
	    &printHtmlClosing($TITLE);
        }

} elsif ( $card{'phase'} eq 'DO REMOVE') {
        &SakujoKekkaGamen();

} elsif ($card{'phase'} eq 'check') {
	&CheckGamen();

} else {
	&KekkaGamen();
}

exit 0;


sub SyokiGamen {
	local($message) = @_;
	&printHtmlOpening($TITLE);
	if ($message) {
		print "<HR>", $message;
	}
	print <<EOF;
<HR>
<FORM METHOD="POST" ACTION="$ENV{'SCRIPT_NAME'}">

ǽˤʤŻҥ᡼륢ɥ쥹ϤƤ:
 <INPUT TYPE="text" NAME="from" SIZE=60><P>
<P>
ǡοϿ뤤Ͻ˱ưʲ򤷤Ƥ. 

<OL>
<LI>
 ǡϿ : Ͽʸμ򤷤
 <INPUT TYPE="submit" NAME="phase" VALUE="NEW">
 ܥ򲡤Ƥ:
 <DL>
 <DT><INPUT TYPE="radio" NAME="cardtype" VALUE="article" CHECKED>article
 <DD>ʸ˷Ǻܤ줿ҤȤĤǤ
 <DT><INPUT TYPE="radio" NAME="cardtype" VALUE="book">book
 <DD>ΤǤ
 <DT><INPUT TYPE="radio" NAME="cardtype" VALUE="inbook">inbook
 <DD>ҤΰǤ
 </DL>

<LI>
 ǡϿ : ȤʤʸǡΥե̾򲼤Ϥ
 <INPUT TYPE="submit" NAME="phase" VALUE="MODIFY">
 ܥ򲡤Ƥ.  <P>

<LI>
 ǡ : ʸǡΥե̾򲼤Ϥ
 <INPUT TYPE="submit" NAME="phase" VALUE="REMOVE">
 ܥ򲡤Ƥ. եȤǧǤޤ. <P>

 ե̾ <INPUT TYPE="text" NAME="origfile" SIZE=30> 
 <INPUT TYPE="submit" NAME="phase" VALUE="MODIFY">
 <INPUT TYPE="submit" NAME="phase" VALUE="REMOVE"><P>
 ե̾η "$CONFIG{'cardpath'}" Ǥ. 
  %y, %i, %n Ϥ줾, year(), initial(a-z 1 ʸ), number()
 ɽƤޤ. 

</OL>
</FORM>
EOF
	&printHtmlClosing($TITLE);
}

sub NyuuryokuGamen {
	$lang = $card{'lang'} || 'ja';
	$user = $card{'from'};
	$user =~ s/@.*//;

        &warn("$field not available.")
	    unless &existsin($card{'cardtype'},&cardTypeList);

# ǽΤ
	print <<EOF;
	<HR>
	<FORM METHOD="POST" ACTION="$ENV{'SCRIPT_NAME'}">
	<P>
	Ͽ $card{'cardtype'} ʸϿޤ
	ʣϿʤɤ
	<A HREF="/arch/bunken/search.htm">
	</a>ƤϿ뤳Ȥ򤪴ᤷޤ
	 
	ϤѤ <INPUT TYPE="submit" NAME="phase" VALUE="check">
	ܥ򲡤ϤǡåƤ
	ٹ𤬤ʤʤä <INPUT TYPE="submit" NAME="phase" VALUE="submit">
	ܥ򲡤ƥǡϿƤ
	<P>
	<TABLE BORDER=0>
EOF

# ɬܹ
	$hr = "" x 40;
	@needed = &requiredFields($card{'cardtype'});
	$neededfields = join(', ',@needed);
	@needed = &ExpandSlash(@needed);
	if ( $card{'phase'} eq 'NEW' ) {
	    foreach $key (@needed) {
	        $card{$key}=&cardTypeFieldDefault($key);
	    }
	}

	print <<EOF;
	<TR><TD>ɬܹ:</TD><TD>$hr</TD></TR>
	<TR><TD></TD><TD>ʲ $neededfields ɬϤƤ.  / Ƕڤ줿ܤ, ʤȤ⤽Τɤ줫ĤιܤϤƤ. </TD>
        <TR><TD></TD></TR>
	<TR>
	 <TD NOWRAP ALIGN="right">
	  <INPUT TYPE="hidden" NAME="cardtype" VALUE="$card{'cardtype'}">
	  cardtype </TD>
	 <TD> $card{'cardtype'}</TD>
	</TR>

        <TR><TD></TD><TD>Ͽ</TD></TR><TR><TD></TD></TR>
	<TR>
	 <TD NOWRAP ALIGN="right">
	    <INPUT TYPE="hidden" NAME="from" VALUE="$card{'from'}">From </TD>
	 <TD> $card{'from'}</TD>
 	</TR>
        <TR><TD></TD><TD></TD></TR><TR><TD></TD></TR>
EOF
	&printTextFields(@needed);

# Ǥչ
	@optional = &optionFields($card{'cardtype'});
	if ( $card{'phase'} eq 'NEW' ) {
	    foreach $key (@optional) {
	        $card{$key}=&cardTypeFieldDefault($key);
            }
	}

	print "<TR><TD>Ǥչ:</TD><TD>$hr</TD></TR>\n";
        print "<TR><TD></TD></TR>\n";
	&printTextFields(@optional);

# פʹ
	print "<INPUT TYPE=hidden NAME=origfile VALUE=$card{'origfile'}>\n"
	    if exists $card{'origfile'};

        $keylist = join(' ', keys(%card)).' ';
	foreach $key ( ('lang','phase','cardtype','from','origfile') ) { $keylist =~ s/$key //; }
	foreach $key ( @needed   ) { $keylist =~ s/$key //; }
	foreach $key ( @optional ) { $keylist =~ s/$key //; }
        @unavailable = split(' ', $keylist);
        if ( scalar(@unavailable) > 0 ) {
	    print "<TR><TD>Ŭ:</TD><TD>$hr</TD></TR>\n";
	    print "<TR><TD></TD><TD>Ƥˤйܤޤ. </TD></TR>\n";
	    &printTextFields(@unavailable);
	}

	print <<EOF;
	<TR><TD></TD><TD>$hr</TD></TR>
	<TR><TD></TD><TD>
	    <INPUT TYPE="submit" NAME="phase" VALUE="check">
	    <INPUT TYPE="submit" NAME="phase" VALUE="submit">
 	    <INPUT TYPE="reset" VALUE="reset">
	</TD></TR>
</TABLE>

</FORM>
EOF
}

sub CheckGamen {
        ($exitcode, $pid, @result) = &processCard;
	&printHtmlOpening($TITLE);
	print "<HR>\n";
	if ($exitcode == 0) {
	    print "<H2>ϥǡˤϸϤޤ.</H2>\n";
	} else {
	    print "<H2>ϥǡˤϸ꤬ޤ.</H2>\n";
	    print "<P>\n";
	    print "ǡ٥åƤ\n";
	    print "<P>\n";
	}
	print join("<BR>\n", @result);

	&NyuuryokuGamen();
	&printHtmlClosing($TITLE);
}

sub KekkaGamen {
        ($exitcode, $pid, @result) = &processCard;
	&printHtmlOpening($TITLE);
	print "<HR>\n";
	if ($exitcode == 0) {
		$result = "";
	} elsif ($exitcode == 1) {
		$result = "(ٹϤΤ) ";
	} else {
		$result = "";
	}
	print "<H2>${result}ޤ</H2>\n";
	print join("<BR>\n", @result);
	print <<EOF;
<HR>
ƤϰʲΤȤǤ
<DL>
EOF
	foreach $key (keys %card) {
		print "<DT>$key:<DD>$card{$key}\n";
	}
	print "</DL>\n";

	if ( exists $card{'origfile'} ) {
	    print <<EOF
	    <HR>
	    <FORM METHOD="POST" ACTION="$ENV{'SCRIPT_NAME'}">
	      <INPUT TYPE=hidden NAME=origfile VALUE=$card{'origfile'}>
	      <INPUT TYPE=hidden NAME=from VALUE=$card{'from'}>
	      Υǡե  $card{'origfile'} ޤ?
	      ʤ
	      <INPUT TYPE="submit" NAME="phase" VALUE="REMOVE">
	      ܥ򲡤Ƥ. 
	      եȤǧǤޤ. <BR>
	    </FORM>
EOF
        }
	&printHtmlClosing($TITLE);
}

sub processCard {
	local($READ, $WRITE, $pid, @result, $exitcode);
	local($origfile)='';
        $READ = "READ";
        $WRITE = "WRITE";
	if ( $card{'phase'} eq 'check' ) {
	    $pid = &open3($WRITE, $READ, '', "$BINDIR/dcbib-add -t");
	} else {
	    $pid = &open3($WRITE, $READ, '', "$BINDIR/dcbib-add");
	}
	$phase = $card{'phase'};
	delete $card{'phase'};
	if (exists $card{'origfile'}){
	    $origfile = $card{'origfile'} ;
	    delete $card{'origfile'};
	}

        &writeCardStream($WRITE, %card);
        close($WRITE);
        @result = <$READ>;
        (waitpid($pid, 0) >= 0)
                || (@result = ("$?: invocation failed."));
        $exitcode = (($? >> 8) & 255);

	if ($origfile ne ''){
	    $card{'origfile'} = $origfile;
	}
	$card{'phase'} = $phase;
        ($exitcode, $pid, @result)
}

sub writeCardStream {
	local($WRITE, %card) = @_;
	&emlWrite($WRITE, %card);
}

sub SakujoGamen {
	print "<HR>\n";
        print "<H2>ǡ: $card{'origfile'} </H2><P>\n";	

	print <<EOF;
	<FORM METHOD="POST" ACTION="$ENV{'SCRIPT_NAME'}">
	<INPUT TYPE=hidden NAME=origfile VALUE=$card{'origfile'}>
	ɤʤ, 
        <INPUT TYPE="submit" NAME="phase" VALUE="DO REMOVE">
	ܥ򲡤Ƥ. <BR>
	</FORM>
EOF
	print "<HR><P>\n";
        open(FILE,"<".$card{'origfile'});
        print $_,"<BR>\n" while (<FILE>);
}

sub SakujoKekkaGamen {
        local($movedfile) = &RemovedFileName($card{'origfile'});
        local($command) = "mv $card{'origfile'} $movedfile";
        $exitcode = system($command);

	&printHtmlOpening($TITLE);
	print "<HR>\n";
	if ($exitcode == 0) {
		$result = "";
	} elsif ($exitcode == 1) {
		$result = "(ٹϤΤ) ";
	} else {
		$result = "";
        }
	print <<EOF;
	<H2>$resultޤ. </H2>
        <HR>
	¹Ԥ줿ޥ: $command
EOF
	&printHtmlClosing($TITLE);
}

sub EmailCheck {
	local($email) = @_;
	return 0 unless $email;
	return ($email =~ /.@./);
}

sub date {
	local($sec, $min, $hour, $day, $mon, $year) = gmtime(time);
	return sprintf("%04d-%02d-%02d", $year+1900, $mon+1, $day);
}

sub printTextFields {
    local(@fieldlist)=@_;
	foreach $key (@fieldlist) {
#	    &printTextField($key, &cardTypeDescription($key), $card{$key});
	    &printTextField($key, $key, $card{$key});
	    $setsumei = "<TR><TD></TD><TD>".&cardTypeDescription($key) ." : " 
	       . &cardTypeLongDescription($key)."</TD></TR>";
	    print $setsumei,"\n";
	    print "<TR><TD></TD></TR>\n";
	}
}

