# card.pl - ʸɤΥեɤ˴ؤ
# $Id: card.pl,v 1.6 2000/09/20 03:15:19 takepiro Exp $
# Copyright (c) TOYODA Eizi, 1998.  All rights reserved.
# see COPYING.TXT for terms of license.
#
#  : cardtype, From, mainpart ͽ
#
sub cardTypeHash {
 %CARDTYPE = (
	'article'	=> 'ʪޤϳؽѻε',
	'book'		=> ' (ǼԤΤʤ)',
	'inbook'	=> 'Ҥΰ (ͭɽ⤿ʤ)',
 );
 %REQUIREDFIELD = (
	'article'	=> 'author/author-ja title/title-ja journal year',
	'book'		=> 'author/editor/author-ja/editor-ja title/title-ja publisher year',
	'inbook'	=> 'author/editor/author-ja/editor-ja title/title-ja chapter/pages publisher year',
 );
 %OPTIONFIELD = (
	'article'	=> 'volume number pages month mainpart',
	'book'		=> 'volume series address edition month mainpart',
	'inbook'	=> 'volume series address edition month mainpart',
 );
 %FIELDDESCRIPTION = (
	'address'	=> 'ǼԤν',
	'author'	=> '',
	'author-ja'	=> '(ܸ)',
	'chapter'	=> 'ֹ',
	'edition'	=> 'Ҥǿ',
	'editor'	=> 'Խ',
	'editor-ja'	=> 'Խ(ܸ)',
	'journal'	=> 'ʪ̾',
	'month'		=> 'Ԥ줿',
	'number'	=> '',
	'pages'		=> 'ڡϰ',
	'publisher'	=> 'Ǽ',
	'series'	=> 'ҥ꡼ɽ',
	'title'		=> 'ɽ',
	'title-ja'	=> 'ɽ(ܸ)',
	'volume'	=> 'ֹ',
	'year'		=> 'ǯ',
	'from'	        => 'ȯ',
	'mainpart'	=> 'ʸ',
 );
 %FIELDLONGDESCRIPTION = (
	'address'	=> '̾ʽǼҤʤԻ̾Ǥ褤. ',
	'author'	=> "ʣϲԤ뤫 \'/\' Ƕڤ. \n ̾̾ǤΤȤ˥ (',') . ",
	'author-ja'	=> 'ʣϲԤ뤫 \'/\' Ƕڤ. ',
	'chapter'	=> 'Τߤ򵭤',
	'editor'	=> "ʣϲԤ뤫 \'/\' Ƕڤ. \n ̾̾ǤΤȤ˥ (',') . ",
	'editor-ja'	=> 'ʣϲԤ뤫 \'/\' Ƕڤ. ',
	'journal'	=> '',
	'month'		=> '(̤ԤξϽ񤫤줿)',
	'number'	=> '',
	'pages'		=> '42--111 Τ褦˥ϥե2Ѥ',
	'publisher'	=> '',
	'series'	=> '',
	'title'		=> '',
	'title-ja'	=> '',
	'volume'	=> '',
	'year'		=> '4̤ο. ̤ԤξϽ񤫤줿ǯ. ǯ 85 Τ褦άƤϤʤʤ.',
	'from'	        => '᡼륢ɥ쥹. ʣϲԤ뤫 \'/\' Ƕڤ. ',
	'mainpart'	=> ', ֥ȥ饯Ȥʤɤ. ',
 );
 %FIELDDEFAULT = (
	'address'	=> '',
	'author'	=> '',
	'author-ja'	=> '',
	'chapter'	=> '',
	'editor'	=> '',
	'editor-ja'	=> '',
	'journal'	=> '',
	'month'		=> '',
	'number'	=> '',
	'pages'		=> '',
	'publisher'	=> '',
	'series'	=> '',
	'title'		=> '',
	'title-ja'	=> '',
	'volume'	=> '',
	'year'		=> '',
	'mainpart'	=> "--- Abstract:\n\n--- Abstract-ja:\n",
 );
}

    #
    # ƥեɤƤå. 
    # ˡ : $content=checkFieldContent($field,$content);
    # 
sub checkFieldContent {
    local($field,$content)=@_;

    if ( $field eq 'pages' ) {
	&warn("pages has no number. Are you sure?")
		if ($content ne '' && $content !~ /[0-9]/);
    }

    if ( $field eq 'author' ) {
	&warn("author should begin in uppercase letter.")
		if ($content =~ /^[a-z]/);
	&warn("author should begin in A-Za-z. ($content)")
		unless ($content =~ /^[A-Za-z]/);
	$content =~ s/[;\/]/\n/g;     # å, ߥԤ
    }
    if ( $field eq 'author-ja' ) {
	$content =~ s/[;\/]/\n/g;     # å, ߥԤ
    }

    if ( $field eq 'editor' ) {
	&warn("editor should begin in uppercase letter.")
		if ($content =~ /^[a-z]/);
	&warn("editor should begin in A-Za-z. ($content)")
		unless ($content =~ /^[A-Za-z]/);
	$content =~ s/[;\/]/\n/g;     # å, ߥԤ
    }
    if ( $field eq 'editor-ja' ) {
	$content =~ s/[;\/]/\n/g;     # å, ߥԤ
    }

    if ( $field eq 'title' ) {
	#  ASCII Ƥ褤⤦äȼ嵤
	# ե٥åȤ1ʸߤʤȷٹ𤹤
	&warn("title has no letter. Are you sure?")
		if ($content !~ /[A-Za-z]/);
    }

    if ( $field eq 'year' ) {
	$content =~ s/\s+//g;
	if ($content =~ /([^0-9x]+)/) {
		local($bad) = $1;
		$content =~ tr/0-9/x/c;
		&warn("year has bad character '$bad' --- converted to 'x'.");
	}
    }
    if ( $field eq 'mainpart' ) {
	$content =~ s/\t/\n/g;        # ֤ԤѴ
    }
    $content;
}

######################### ʲѹ٤餺 #########################

sub cardTypeList {
	defined %CARDTYPE || cardTypeHash;
	keys %CARDTYPE;
}

sub cardTypeDescription {
	local($type) = @_;
	defined %CARDTYPE || cardTypeHash;
	$FIELDDESCRIPTION{$type};
}

sub cardTypeLongDescription {
	local($type) = @_;
	defined %CARDTYPE || cardTypeHash;
	$FIELDLONGDESCRIPTION{$type};
}

sub cardTypeFieldDefault {
	local($type) = @_;
	defined %CARDTYPE || cardTypeHash;
	$FIELDDEFAULT{$type};
}

sub requiredFields {
	local($type) = @_;
	defined %REQUIREDFIELD || cardTypeHash;
	split(' ', $REQUIREDFIELD{$type});
}

sub optionFields {
	local($type) = @_;
	defined %OPTIONFIELD || cardTypeHash;
	split(' ', $OPTIONFIELD{$type});
}

sub availableFields {
	local($type) = @_;
	defined %OPTIONFIELD || cardTypeHash;
	split(' ', "cardtype $REQUIREDFIELD{$type} $OPTIONFIELD{$type}");
}

