# cgi.pl - CGI assistant routines
# Copyright (C) by TOYODA Eizi, 1999.  All rights reserved.
#
$rcsid .= '$Id: cgi.pl,v 1.3 2000/09/07 16:33:10 takepiro Exp $';
#

	# ۥ̾ (FQDN) ֤
	# Debian GNU/Linux ƥ DNS ꤬Ԥ줿֤ͤƤʤ
sub Hostname () {
	local($hostname) = '/bin/hostname';
	return 'localhost' unless -x $hostname;
	$hostname = `$hostname -f`;
	chop $hostname;
	return $hostname;
}

#
# HTML 뤿Υ֥롼.
# ̾ print ǻϤޤΤϴŪ print ʸηǤ,
# ɸ (select ѹǽ)  HTML ΰϤ.
#

	# ʸ HTML ʸǤ褦ѷ.
	# 
	#	$line	Ǥդʸ
	# ֵ
	#	HTML üʰ̣ʸ & < > " Ѵ
	# Х
	#	\0  & ȺƱƤޤ.
sub HTMLEscape {
	local($line) = @_;
	$line =~ s/&/\0/g;
	$line =~ s/</\&lt;/g;
	$line =~ s/>/\&gt;/g;
	$line =~ s/"/\&quot;/g;
	$line =~ s/\0/\&amp;/g;
	return $line;
}

	# HTTP إå HTML Ƭ롣
	# 
	#	$title		ʸΥȥ
	#	$color		(ά) 
sub printHtmlOpening {
	local($title, $color) = @_;
	$color = "#CCEECC" unless $color;
	local($hostname) = &Hostname();
	print <<"END";
Content-type: text/html;charset='euc-jp'

<HTML>
<HEAD>
<TITLE>$title</TITLE>
</HEAD>
<BODY BGCOLOR="$color">
<A HREF="/doc/dcbib/dcbib.htm">dcbib</a>
(<A HREF='/'>$hostname</a> ˤư)
<H1 ALIGN="center">$title</H1>
END
}

	# &printTextField ƥȥեɤ礭
	# ѤĤϤȤѤƤ.
$printTextFieldLength = 60;
$printTextFieldHeight = 10;	# ƥȥꥢǤ

	# Ͽե <TABLE> ΤʤǤҤȤĤΥƥȥեɤ
	# Ϥ׵᤹ <TR> .
	#
	# 
	#   $fieldname		̾
	#   $description	
	#   $default		ά (ʤƤ褤)
	#			%card{$fieldname} ¸ߤФ줬ͥ
	# ۤΰ
	#   %card
sub printTextField {
	local($fieldname, $description, $default) = @_;
	local($size) = $printTextFieldLength;
	local($defaultvalue) = $card{$fieldname} || $default;
	if ($fieldname eq "token") {
		#
		# ̾Τ token ξϥѥˤ
		# ޤͤ϶ˤ
		print <<"END";
 <TR>
 <TD NOWRAP ALIGN="right">$description</TD>
 <TD NOWRAP>
 <INPUT TYPE="PASSWORD" NAME="$fieldname" SIZE="$size">
 </TD>
 </TR>
END
	} elsif ($default =~ /\n/) {
		#
		# άͤ˲ԤޤޤƤХƥȥե
		# (Ǥ)
		#
		print <<"END";
 <TR>
 <TD NOWRAP ALIGN="right">$description</TD>
 <TD NOWRAP>
 <TEXTAREA NAME="$fieldname" COLS="$size" ROWS=$printTextFieldHeight>
$defaultvalue
 </TEXTAREA>
 </TD>
 </TR>
END
	} else {
		print <<"END";
 <TR>
 <TD NOWRAP ALIGN="right">$description</TD>
 <TD NOWRAP>
 <INPUT TYPE="text" NAME="$fieldname" SIZE="$size" VALUE="$defaultvalue">
 </TD>
 </TR>
END
	}
}

	# Ͽե <TABLE> ΤʤꥹȤΥ饸ܥä
	# Ϥ׵᤹ <TR> .
	# άͤ "\n" ޤޤƤʣԥץĤ.
	# 
	#   $fieldname		̾
	#   $description	
	#   $default		ǥե
	#   @ValueDescriptionList
	#	ǽͤΥꥹ. ƹब "\t" ޤǤ
	#	θɽ.
sub printRadioButton {
	local($fieldname, $description, $default, @ValueDescriptionList) = @_;
	print <<"END";
<TR>
<TD NOWRAP ALIGN="right">$description</TD>
<TD>
ʲΥꥹȤǤ:<BR>
<TABLE BORDER><TR><TD><!-- ȤĤä -->
END
	local($vdpair, $value, $desc, $checked);
	foreach $vdpair (@ValueDescriptionList) {
		print "<BR>" if $value;
		($value, $desc) = split(/\t/, $vdpair, 2);
		$checked = ($value eq $default) ? "CHECKED" : "";
		$desc = $value unless $desc;
		print "<INPUT TYPE=RADIO NAME='$fieldname' ",
		"VALUE='$value' $checked>$desc\n";
	}
	print <<"END";
</TD></TR></TABLE><!-- ȤĤä -->
</TD>
END
}

	# HTML ʸκ
	# 
	#	$title		ʸΥȥ
sub printHtmlClosing {
	local($title) = @_;
	print "<hr>\n";
	print "<a href=\"", &CGISelfName, "\">$title ˤɤ</a><br>\n"
		if &FormSubmitted();
	print <<"END";
<div align="right">
: <i><a href=mailto:$MAILADDR>$MAILADDR</a></i>
<br>$rcsid
</div>
</body>
</html>
END
}

#
# CGI (Common Gateway Interface) طΥ֥롼
#

	# 桼󥫡ɤɤ߹Ϣ %param 
	# å˥åȤ٤ʸ.
sub HashToCookie {
	local(%param) = @_;
	local(@pairs) = ();
	local($key, $value);
	foreach $key (sort(keys(%param))) {
		$value = $param{$key};
		push(@pairs, &URLEncode($key) . ":" . &URLEncode($value));
	}
	join('&', @pairs);
}

	# CGI ץȤƤӽФ, ʬȤΥե֤̾.
	# ϱΥ󥯤ȤƻȤ.
sub CGISelfName {
	$ENV{'SCRIPT_NAME'};
}

	# CGI ǡĹ֤.
sub CGIDataLength {
	$ENV{'CONTENT_LENGTH'};
}

	# 桼 Submit ܥ򲡤翿
	# Ǥʤ絶֤롣
	# CGI ץȥ뻲.
sub FormSubmitted() {
	return ($ENV{"CONTENT_LENGTH"} > 0);
}

	# CGI ǡɤ߹ϢȤ֤.
	# ǡͿƤʤ϶ꥹȤ֤.
sub getCGIData {
	local(%card);
	local($data, $key, $value);
	require 'jcode.pl';

	return () unless &FormSubmitted();
	read(STDIN, $alldata, &CGIDataLength);
	foreach $data (split(/&/, $alldata)) {
		($key, $value) = split(/=/, $data);
		$value =~ tr/+/ /;
		$value = &URLDecode($value);
		&jcode'convert(*value, "euc");
		$card{$key} = $value;
	}
	%card;
}

	#  $x  URL 󥳡ɤ֤.
	# åˤʸƤν򤷤ʤƤϤʤʤ
	# CGI ץȥ뻲.
sub URLEncode {
    local($x) = @_;
    $x =~ s/([&:;=%\x00-\x21])/sprintf("%%%02X",unpack("C",$1))/ge;
    return $x;
}
 
	# URL 󥳡ɤ줿ʸ ( $x) ɤ֤.
	# åʸƤν򤷤ʤƤϤʤʤ
	# CGI ץȥ뻲.
sub URLDecode {
    local($x) = @_;
    $x =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("C",hex($1))/ge;
    return $x;
}


0;
