# fncreat.pl: filename generation routine for dcbib-add(1).
# $Id: fncreat.pl,v 1.4 2000/09/06 23:42:19 takepiro Exp $
# Copyright (c) TOYODA Eizi, 1998.  
#               TAKEHIRO Shin-ichi, 2000. 
#               All rights reserved.
# see COPYING.TXT for terms of license.

# assumption:
# * %CONFIG has information from configfile (e.g. /etc/dcbib.conf).
# * %HEADER has information from bib card and tested with &testCard.

sub generateFileName {
        local(%HEADER) = @_;
	# assumes ending with slash
	local($pat) = $CONFIG{"basedir"};
	$pat =~ s/\/+$//;
	$pat .= "/";
	$pat .= $CONFIG{"cardpath"};
	$pat =~ s/%i/&gfn_initial(%HEADER)/ge;
	$pat =~ s/%y/&gfn_year(%HEADER)/ge;

	# unique number generator
	if ($pat =~ /%n/) {
		local($number) = 1;
		for (;; $number++) {
			$fnam = $pat;
			$fnam =~ s/%n/$number/g;
			$fnambak = &RemovedFileName($fnam); 
			#last unless (-e $fnam);
			last if (!-e $fnam && !-e $fnambak);
		} 
	} else {
		# Are you sure?  This will overwrite existing same name.
		&warn("cardpath has no %n");
		$fnam = $pat;
	}

	$fnam;
}


sub gfn_year {
        local(%HEADER) = @_;
	$HEADER{"year"};
}


# get initial character of author's family name
sub gfn_initial {
        local(%HEADER) = @_;
	local($author) = $HEADER{"author"};
	$author = $HEADER{"editor"} unless $author;
	$author =~ s/^\n+//;
	# if unknown
	return "u" unless $author;
	if ($author =~ /,/) {
		$author =~ s/^\s*//;
	} else {
		# getting last word
		$author =~ s/\s*$//; 
		$author =~ s/^.*[ .]+//; 
	}
	# get initial character
	local($ini) = substr($author, 0, 1);
	return 'u' unless ($ini =~ /^[A-Za-z]/);
	$ini =~ tr/A-Z/a-z/;
	$ini;
}

# backup (removed) file name
sub RemovedFileName {
    local($origfile)=@_;
    $origfile ."~";      # tilde is added
}

# Generate full path filename from 'basedir' and 'cardpath' fields 
# of CONFIG file. Portion of the input fitted to 'cardpath' pattern 
# and connected with the 'basedir'. 
# Null file name is returned if the input does not match the patter. 
#
sub RelativetoFullpathFileName {
    local($filename) = @_;
    $regexp = $CONFIG{'cardpath'};
    $regexp =~ s/%y/[0-9x][0-9x][0-9x][0-9x]/g;   # year
    $regexp =~ s/%i/[a-z]/g;                      # initial
    $regexp =~ s/%n/[0-9]+/g;                     # number
    $filename =~ m"($regexp)";

    return '' if $1 eq '';

    $CONFIG{'basedir'} .'/' . $1;
}
