# RFC-822-like file reading/writing module
# $Id: rfc822.pl,v 1.3 2000/09/06 01:38:05 takepiro Exp $
# Copyright (c) TOYODA Eizi, 1998.  
#               TAKEHIRO Shin-ichi, 2000. 
#               All rights reserved.
# see COPYING.TXT for terms of license.

sub emlOpenFile {
	local($file) = @_;
	&open_r($file) || &die("cannot open <$file>");
	&emlSetFile($file);
}

sub emlSetFile {
	($emlFile) = @_;
}

sub emlReadLine {
	&readline($emlFile);
}

# -- emlReadHeader() ---
#
# Reads RFC 822 headers from $inputfile and returns hash with which
# $returned_hash{$field_name} == $filed_value,
# where $field_name is lowercased  filed name.
# If $field_value contains '\n', it means that the header
# $field_name appeared more than once.
# Undefined return value means there is a format error.

sub emlReadHeader {
	local(%headers) = ();
	local($name, $val) = ("", "");

	while ($_ = &emlReadLine) {
		s/\r?\n$//;
		last if /^$/;    # ԤޤǤإå
		if (!/^\s/) {
			next if /^From /;
			if (!/^([-A-Za-z0-9]*)(:)\s*(.*)/) {
				&warn("broken header <$_> in $emlFile");
				return undef;
			}
			($name = $1) =~ tr/A-Z/a-z/;
			($val = $3) =~ s/[\t\r]/ /g;
			if (defined $headers{$name}) {
				# Ʊ̾ʣإåϲԶ
				$headers{$name} .= "\n$val";
			} else {
				$headers{$name} = $val;
			}
		} else {
			s/[\t\r]/ /g;
			# ³Ԥϥֶ
			s/^ */\t/;
			$headers{$name} .= $_;
		}
	}
	%headers;
}

sub emlWriteHeader {
	local($outfnam, %headers) = @_;
	local($fieldname, @values, $value, $folded);

	foreach $fieldname (keys %headers) {
		local(@values) = split(/\n/, $headers{$fieldname});
		foreach $value (@values) {
			next if $value =~ /^[ \n\t]*$/;
			$folded = $value;
			$folded =~ s/\t/\n\t/g;
			print $outfnam "$fieldname: $value\n";
		    }
	    }
    }

# -- emlRead() ---
#
#

sub emlRead {
    local(%card) = ();
    %card = &emlReadHeader();        # إåɤ߹
    while ($_ = &emlReadLine) {      # ʸɤ߹
	$card{'mainpart'} .= $_;    #   إå mainpart ɲ
    }
    %card;
}

sub emlWrite {
    local($outfnam, %card) = @_;

    local($mainpart) = $card{'mainpart'};
    delete $card{'mainpart'};

    &emlWriteHeader($outfnam, %card);   # إå
    print $outfnam "\n";                # ʸȤζڤ
    print $outfnam $mainpart;           # ʸ
}
