#
# uspk11.rb
#
# $Id: uspk11.rb,v 1.1.1.1 2011-02-23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


n = 181
N1 = 26
N2 = 7
nc = 4
t = NArray.sfloat(n)
y = NArray.sfloat(n)
ux1 = NArray.sfloat(N1)

#-----------------------------------------------------------------------
ch = ['JAN', 'FEB', 'MAR', 'APL', 'JUN', 'JULY', '   ']
ux2 = NArray[0.0, 31.0, 59.0, 90.0, 120.0, 151.0, 181.0]

r = 0.2
a = 4.0
y[0] = 120.0
t.indgen(0.5, 1.0)
for i in 1..n-1
  r = a*r*(1.0-r)
  y[i] = y[i-1] + (r-0.46)*2
end

ux1.indgen(1.0, 7.0)

#-----------------------------------------------------------------------
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i

rundef = DCL::glrget('RUNDEF')
DCL::uslset('LYINV', true)

DCL::gropn iws

DCL::grfrm

DCL::grswnd(0.0, 181.0, rundef, rundef)
DCL::grsvpt(0.2, 0.8, 0.2, 0.8)
DCL::grstrn(1)

DCL::usspnt(rundef, y)
DCL::uspfit

DCL::grstrf

#------------------------------- Y-AXIS --------------------------------
DCL::usyaxs('L')
DCL::usyaxs('R')
DCL::uysttl('L', 'YEN/DOLLAR', 0.0)

#------------------------------- X-AXIS --------------------------------
DCL::uzlset('LBTWN', true)
DCL::uxaxlb('B', ux1, ux2, ch, nc)
DCL::uxaxlb('T', ux1, ux2, ch, nc)
DCL::uxsttl('T', 'EXCHANGE RATE', 0.0)

#-------------------------------- LINE ---------------------------------
DCL::sgplu(t, y)

DCL::grcls

