/*
 * $Id: p_header,v 1.3 2015/03/18 03:27:42 horinout Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_uverb(obj, n, upx, upy1, upy2)
    VALUE obj, n, upx, upy1, upy2;
{
    integer i_n;
    real *i_upx;
    real *i_upy1;
    real *i_upy2;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy1) == T_FLOAT) {
      upy1 = rb_Array(upy1);
    }
    /* if ((TYPE(upy1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy2) == T_FLOAT) {
      upy2 = rb_Array(upy2);
    }
    /* if ((TYPE(upy2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx = dcl_obj2crealary(upx);
    i_upy1 = dcl_obj2crealary(upy1);
    i_upy2 = dcl_obj2crealary(upy2);


    uverb_(&i_n, i_upx, i_upy1, i_upy2);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy1);
    dcl_freecrealary(i_upy2);

    return Qnil;

}

static VALUE
dcl_uverbz(obj, n, upx, upy1, upy2, itype, index, rsize)
    VALUE obj, n, upx, upy1, upy2, itype, index, rsize;
{
    integer i_n;
    real *i_upx;
    real *i_upy1;
    real *i_upy2;
    integer i_itype;
    integer i_index;
    real i_rsize;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy1) == T_FLOAT) {
      upy1 = rb_Array(upy1);
    }
    /* if ((TYPE(upy1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy2) == T_FLOAT) {
      upy2 = rb_Array(upy2);
    }
    /* if ((TYPE(upy2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }
    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_rsize = (real)NUM2DBL(rsize);
    i_upx = dcl_obj2crealary(upx);
    i_upy1 = dcl_obj2crealary(upy1);
    i_upy2 = dcl_obj2crealary(upy2);


    uverbz_(&i_n, i_upx, i_upy1, i_upy2, &i_itype, &i_index, &i_rsize);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy1);
    dcl_freecrealary(i_upy2);

    return Qnil;

}

static VALUE
dcl_uvdif(obj, n, upx, upy1, upy2)
    VALUE obj, n, upx, upy1, upy2;
{
    integer i_n;
    real *i_upx;
    real *i_upy1;
    real *i_upy2;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy1) == T_FLOAT) {
      upy1 = rb_Array(upy1);
    }
    /* if ((TYPE(upy1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy2) == T_FLOAT) {
      upy2 = rb_Array(upy2);
    }
    /* if ((TYPE(upy2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx = dcl_obj2crealary(upx);
    i_upy1 = dcl_obj2crealary(upy1);
    i_upy2 = dcl_obj2crealary(upy2);


    uvdif_(&i_n, i_upx, i_upy1, i_upy2);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy1);
    dcl_freecrealary(i_upy2);

    return Qnil;

}

static VALUE
dcl_uvdifz(obj, n, upx, upy1, upy2, itpat1, itpat2)
    VALUE obj, n, upx, upy1, upy2, itpat1, itpat2;
{
    integer i_n;
    real *i_upx;
    real *i_upy1;
    real *i_upy2;
    integer i_itpat1;
    integer i_itpat2;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy1) == T_FLOAT) {
      upy1 = rb_Array(upy1);
    }
    /* if ((TYPE(upy1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy2) == T_FLOAT) {
      upy2 = rb_Array(upy2);
    }
    /* if ((TYPE(upy2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itpat1) != T_BIGNUM) || (TYPE(itpat1) != T_FIXNUM)) {
      itpat1 = rb_funcall(itpat1, rb_intern("to_i"), 0);
    }
    if ((TYPE(itpat2) != T_BIGNUM) || (TYPE(itpat2) != T_FIXNUM)) {
      itpat2 = rb_funcall(itpat2, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_itpat1 = NUM2INT(itpat1);
    i_itpat2 = NUM2INT(itpat2);
    i_upx = dcl_obj2crealary(upx);
    i_upy1 = dcl_obj2crealary(upy1);
    i_upy2 = dcl_obj2crealary(upy2);


    uvdifz_(&i_n, i_upx, i_upy1, i_upy2, &i_itpat1, &i_itpat2);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy1);
    dcl_freecrealary(i_upy2);

    return Qnil;

}

static VALUE
dcl_uvbrf(obj, n, upx, upy1, upy2)
    VALUE obj, n, upx, upy1, upy2;
{
    integer i_n;
    real *i_upx;
    real *i_upy1;
    real *i_upy2;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy1) == T_FLOAT) {
      upy1 = rb_Array(upy1);
    }
    /* if ((TYPE(upy1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy2) == T_FLOAT) {
      upy2 = rb_Array(upy2);
    }
    /* if ((TYPE(upy2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx = dcl_obj2crealary(upx);
    i_upy1 = dcl_obj2crealary(upy1);
    i_upy2 = dcl_obj2crealary(upy2);


    uvbrf_(&i_n, i_upx, i_upy1, i_upy2);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy1);
    dcl_freecrealary(i_upy2);

    return Qnil;

}

static VALUE
dcl_uvbrfz(obj, n, upx, upy1, upy2, itype, index, rsize)
    VALUE obj, n, upx, upy1, upy2, itype, index, rsize;
{
    integer i_n;
    real *i_upx;
    real *i_upy1;
    real *i_upy2;
    integer i_itype;
    integer i_index;
    real i_rsize;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy1) == T_FLOAT) {
      upy1 = rb_Array(upy1);
    }
    /* if ((TYPE(upy1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy2) == T_FLOAT) {
      upy2 = rb_Array(upy2);
    }
    /* if ((TYPE(upy2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }
    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_rsize = (real)NUM2DBL(rsize);
    i_upx = dcl_obj2crealary(upx);
    i_upy1 = dcl_obj2crealary(upy1);
    i_upy2 = dcl_obj2crealary(upy2);


    uvbrfz_(&i_n, i_upx, i_upy1, i_upy2, &i_itype, &i_index, &i_rsize);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy1);
    dcl_freecrealary(i_upy2);

    return Qnil;

}

static VALUE
dcl_uvbra(obj, n, upx, upy1, upy2)
    VALUE obj, n, upx, upy1, upy2;
{
    integer i_n;
    real *i_upx;
    real *i_upy1;
    real *i_upy2;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy1) == T_FLOAT) {
      upy1 = rb_Array(upy1);
    }
    /* if ((TYPE(upy1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy2) == T_FLOAT) {
      upy2 = rb_Array(upy2);
    }
    /* if ((TYPE(upy2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx = dcl_obj2crealary(upx);
    i_upy1 = dcl_obj2crealary(upy1);
    i_upy2 = dcl_obj2crealary(upy2);


    uvbra_(&i_n, i_upx, i_upy1, i_upy2);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy1);
    dcl_freecrealary(i_upy2);

    return Qnil;

}

static VALUE
dcl_uvbraz(obj, n, upx, upy1, upy2, itpat1, itpat2, rsize)
    VALUE obj, n, upx, upy1, upy2, itpat1, itpat2, rsize;
{
    integer i_n;
    real *i_upx;
    real *i_upy1;
    real *i_upy2;
    integer i_itpat1;
    integer i_itpat2;
    real i_rsize;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy1) == T_FLOAT) {
      upy1 = rb_Array(upy1);
    }
    /* if ((TYPE(upy1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy2) == T_FLOAT) {
      upy2 = rb_Array(upy2);
    }
    /* if ((TYPE(upy2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itpat1) != T_BIGNUM) || (TYPE(itpat1) != T_FIXNUM)) {
      itpat1 = rb_funcall(itpat1, rb_intern("to_i"), 0);
    }
    if ((TYPE(itpat2) != T_BIGNUM) || (TYPE(itpat2) != T_FIXNUM)) {
      itpat2 = rb_funcall(itpat2, rb_intern("to_i"), 0);
    }
    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_itpat1 = NUM2INT(itpat1);
    i_itpat2 = NUM2INT(itpat2);
    i_rsize = (real)NUM2DBL(rsize);
    i_upx = dcl_obj2crealary(upx);
    i_upy1 = dcl_obj2crealary(upy1);
    i_upy2 = dcl_obj2crealary(upy2);


    uvbraz_(&i_n, i_upx, i_upy1, i_upy2, &i_itpat1, &i_itpat2, &i_rsize);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy1);
    dcl_freecrealary(i_upy2);

    return Qnil;

}

static VALUE
dcl_uvbrl(obj, n, upx, upy)
    VALUE obj, n, upx, upy;
{
    integer i_n;
    real *i_upx;
    real *i_upy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx = dcl_obj2crealary(upx);
    i_upy = dcl_obj2crealary(upy);


    uvbrl_(&i_n, i_upx, i_upy);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uvbrlz(obj, n, upx, upy, itype, index, rsize)
    VALUE obj, n, upx, upy, itype, index, rsize;
{
    integer i_n;
    real *i_upx;
    real *i_upy;
    integer i_itype;
    integer i_index;
    real i_rsize;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }
    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_rsize = (real)NUM2DBL(rsize);
    i_upx = dcl_obj2crealary(upx);
    i_upy = dcl_obj2crealary(upy);


    uvbrlz_(&i_n, i_upx, i_upy, &i_itype, &i_index, &i_rsize);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uvbxf(obj, n, upx, upy1, upy2)
    VALUE obj, n, upx, upy1, upy2;
{
    integer i_n;
    real *i_upx;
    real *i_upy1;
    real *i_upy2;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy1) == T_FLOAT) {
      upy1 = rb_Array(upy1);
    }
    /* if ((TYPE(upy1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy2) == T_FLOAT) {
      upy2 = rb_Array(upy2);
    }
    /* if ((TYPE(upy2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx = dcl_obj2crealary(upx);
    i_upy1 = dcl_obj2crealary(upy1);
    i_upy2 = dcl_obj2crealary(upy2);


    uvbxf_(&i_n, i_upx, i_upy1, i_upy2);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy1);
    dcl_freecrealary(i_upy2);

    return Qnil;

}

static VALUE
dcl_uvbxfz(obj, n, upx, upy1, upy2, itype, index)
    VALUE obj, n, upx, upy1, upy2, itype, index;
{
    integer i_n;
    real *i_upx;
    real *i_upy1;
    real *i_upy2;
    integer i_itype;
    integer i_index;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy1) == T_FLOAT) {
      upy1 = rb_Array(upy1);
    }
    /* if ((TYPE(upy1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy2) == T_FLOAT) {
      upy2 = rb_Array(upy2);
    }
    /* if ((TYPE(upy2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_upx = dcl_obj2crealary(upx);
    i_upy1 = dcl_obj2crealary(upy1);
    i_upy2 = dcl_obj2crealary(upy2);


    uvbxfz_(&i_n, i_upx, i_upy1, i_upy2, &i_itype, &i_index);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy1);
    dcl_freecrealary(i_upy2);

    return Qnil;

}

static VALUE
dcl_uvbxa(obj, n, upx, upy1, upy2)
    VALUE obj, n, upx, upy1, upy2;
{
    integer i_n;
    real *i_upx;
    real *i_upy1;
    real *i_upy2;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy1) == T_FLOAT) {
      upy1 = rb_Array(upy1);
    }
    /* if ((TYPE(upy1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy2) == T_FLOAT) {
      upy2 = rb_Array(upy2);
    }
    /* if ((TYPE(upy2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx = dcl_obj2crealary(upx);
    i_upy1 = dcl_obj2crealary(upy1);
    i_upy2 = dcl_obj2crealary(upy2);


    uvbxa_(&i_n, i_upx, i_upy1, i_upy2);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy1);
    dcl_freecrealary(i_upy2);

    return Qnil;

}

static VALUE
dcl_uvbxaz(obj, n, upx, upy1, upy2, itpat1, itpat2)
    VALUE obj, n, upx, upy1, upy2, itpat1, itpat2;
{
    integer i_n;
    real *i_upx;
    real *i_upy1;
    real *i_upy2;
    integer i_itpat1;
    integer i_itpat2;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy1) == T_FLOAT) {
      upy1 = rb_Array(upy1);
    }
    /* if ((TYPE(upy1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy2) == T_FLOAT) {
      upy2 = rb_Array(upy2);
    }
    /* if ((TYPE(upy2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itpat1) != T_BIGNUM) || (TYPE(itpat1) != T_FIXNUM)) {
      itpat1 = rb_funcall(itpat1, rb_intern("to_i"), 0);
    }
    if ((TYPE(itpat2) != T_BIGNUM) || (TYPE(itpat2) != T_FIXNUM)) {
      itpat2 = rb_funcall(itpat2, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_itpat1 = NUM2INT(itpat1);
    i_itpat2 = NUM2INT(itpat2);
    i_upx = dcl_obj2crealary(upx);
    i_upy1 = dcl_obj2crealary(upy1);
    i_upy2 = dcl_obj2crealary(upy2);


    uvbxaz_(&i_n, i_upx, i_upy1, i_upy2, &i_itpat1, &i_itpat2);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy1);
    dcl_freecrealary(i_upy2);

    return Qnil;

}

static VALUE
dcl_uvbxl(obj, n, upx, upy)
    VALUE obj, n, upx, upy;
{
    integer i_n;
    real *i_upx;
    real *i_upy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx = dcl_obj2crealary(upx);
    i_upy = dcl_obj2crealary(upy);


    uvbxl_(&i_n, i_upx, i_upy);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uvbxlz(obj, n, upx, upy, itype, index)
    VALUE obj, n, upx, upy, itype, index;
{
    integer i_n;
    real *i_upx;
    real *i_upy;
    integer i_itype;
    integer i_index;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_upx = dcl_obj2crealary(upx);
    i_upy = dcl_obj2crealary(upy);


    uvbxlz_(&i_n, i_upx, i_upy, &i_itype, &i_index);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy);

    return Qnil;

}
void
init_grph2_uvpack(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "uverb", dcl_uverb, 4);
    rb_define_module_function(mDCL, "uverbz", dcl_uverbz, 7);
    rb_define_module_function(mDCL, "uvdif", dcl_uvdif, 4);
    rb_define_module_function(mDCL, "uvdifz", dcl_uvdifz, 6);
    rb_define_module_function(mDCL, "uvbrf", dcl_uvbrf, 4);
    rb_define_module_function(mDCL, "uvbrfz", dcl_uvbrfz, 7);
    rb_define_module_function(mDCL, "uvbra", dcl_uvbra, 4);
    rb_define_module_function(mDCL, "uvbraz", dcl_uvbraz, 7);
    rb_define_module_function(mDCL, "uvbrl", dcl_uvbrl, 3);
    rb_define_module_function(mDCL, "uvbrlz", dcl_uvbrlz, 6);
    rb_define_module_function(mDCL, "uvbxf", dcl_uvbxf, 4);
    rb_define_module_function(mDCL, "uvbxfz", dcl_uvbxfz, 6);
    rb_define_module_function(mDCL, "uvbxa", dcl_uvbxa, 4);
    rb_define_module_function(mDCL, "uvbxaz", dcl_uvbxaz, 6);
    rb_define_module_function(mDCL, "uvbxl", dcl_uvbxl, 3);
    rb_define_module_function(mDCL, "uvbxlz", dcl_uvbxlz, 5);
}
