/*
 * $Id: p_header,v 1.3 2015/03/18 03:27:42 horinout Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_chngc(obj, ch, ca, cb)
    VALUE obj, ch, ca, cb;
{
    char *io_ch;
    char *i_ca;
    char *i_cb;

    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }
    if (TYPE(ca) != T_STRING) {
      ca = rb_funcall(ca, rb_intern("to_str"), 0);
    }
    if (TYPE(cb) != T_STRING) {
      cb = rb_funcall(cb, rb_intern("to_str"), 0);
    }

    io_ch = ALLOCA_N(char, strlen(StringValuePtr(ch))+1);
    strcpy(io_ch, StringValuePtr(ch));
    i_ca = StringValuePtr(ca);
    i_cb = StringValuePtr(cb);


    chngc_(io_ch, i_ca, i_cb, (ftnlen)strlen(io_ch), (ftnlen)strlen(i_ca), (ftnlen)strlen(i_cb));

    ch = rb_str_new2(io_ch);


    return ch;

}

static VALUE
dcl_chngi(obj, ch, ca, ii, cfmt)
    VALUE obj, ch, ca, ii, cfmt;
{
    char *io_ch;
    char *i_ca;
    integer i_ii;
    char *i_cfmt;

    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }
    if (TYPE(ca) != T_STRING) {
      ca = rb_funcall(ca, rb_intern("to_str"), 0);
    }
    if ((TYPE(ii) != T_BIGNUM) || (TYPE(ii) != T_FIXNUM)) {
      ii = rb_funcall(ii, rb_intern("to_i"), 0);
    }
    if (TYPE(cfmt) != T_STRING) {
      cfmt = rb_funcall(cfmt, rb_intern("to_str"), 0);
    }

    io_ch = ALLOCA_N(char, strlen(StringValuePtr(ch))+1);
    strcpy(io_ch, StringValuePtr(ch));
    i_ca = StringValuePtr(ca);
    i_ii = NUM2INT(ii);
    i_cfmt = StringValuePtr(cfmt);


    chngi_(io_ch, i_ca, &i_ii, i_cfmt, (ftnlen)strlen(io_ch), (ftnlen)strlen(i_ca), (ftnlen)strlen(i_cfmt));

    ch = rb_str_new2(io_ch);


    return ch;

}

static VALUE
dcl_chngr(obj, ch, ca, rr, cfmt)
    VALUE obj, ch, ca, rr, cfmt;
{
    char *io_ch;
    char *i_ca;
    real i_rr;
    char *i_cfmt;

    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }
    if (TYPE(ca) != T_STRING) {
      ca = rb_funcall(ca, rb_intern("to_str"), 0);
    }
    if (TYPE(rr) != T_FLOAT) {
      rr = rb_funcall(rr, rb_intern("to_f"), 0);
    }
    if (TYPE(cfmt) != T_STRING) {
      cfmt = rb_funcall(cfmt, rb_intern("to_str"), 0);
    }

    io_ch = ALLOCA_N(char, strlen(StringValuePtr(ch))+1);
    strcpy(io_ch, StringValuePtr(ch));
    i_ca = StringValuePtr(ca);
    i_rr = (real)NUM2DBL(rr);
    i_cfmt = StringValuePtr(cfmt);


    chngr_(io_ch, i_ca, &i_rr, i_cfmt, (ftnlen)strlen(io_ch), (ftnlen)strlen(i_ca), (ftnlen)strlen(i_cfmt));

    ch = rb_str_new2(io_ch);


    return ch;

}
void
init_misc1_chnlib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "chngc", dcl_chngc, 3);
    rb_define_module_function(mDCL, "chngi", dcl_chngi, 4);
    rb_define_module_function(mDCL, "chngr", dcl_chngr, 4);
}
