!------------------------------------------------------------------------
! Copyright(c) 2008-2011 SPMODEL Development Group. All rights reserved.!
!----------------------------------------------------------------------
!
!ɽ  wu_module ƥȥץ
!
!      ؿΥƥ
!           wr_DivLon_xyr, wr_DivLat_xyr
!
!  2008/01/01  ݹ
!      2008/06/28  ʿ  ѹ
!      2011/03/11  ʿ dc_test Ѥ褦˽
!
program wu_test_derivative3

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wu_module
  implicit none

  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=16         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=1.5d0             ! Ⱦ

  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_VLon
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_VLat
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_DivLon
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_DivLat
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_Data

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  call MessageNotify('M','wu_test_derivative3', &
       'wu_module derivative function test #3')

  call wu_Initial(im,jm,km,nm,lm,ra)

! -----------------  1 --------------------
  xyr_VLon   = xyr_rad**2 * cos(xyr_Lat)**2*sin(xyr_Lon)
  xyr_DivLon = xyr_rad*cos(xyr_Lat)*cos(xyr_Lon)

  xyr_VLat   = xyr_rad**2 * cos(xyr_Lat)**2*sin(xyr_Lon)
  xyr_DivLat = -3.0d0*xyr_rad*cos(xyr_Lat)*sin(xyr_Lat)*sin(xyr_Lon)

!!  write(6,*)
!!  write(6,*)'Example 1'
!!  write(6,*)'  xyr_VLon=xyr_rad**n * cos(xyr_Lat)**2*sin(xyr_Lon)'
!!  write(6,*)'  xyr_VLat=xyr_rad**n * cos(xyr_Lat)**2*sin(xyr_Lon)'
  call checkresult

  call MessageNotify('M','wu_test_derivative3', &
       'wu_module derivative function test #3 succeeded!')

contains

  subroutine checkresult

    xyr_Data =  xyr_wr(wr_DivLon_xyr(xyr_VLon))
    call check3d(xyr_DivLon, xyr_Data, 'Checking DivLon (1/r cos(Lat) dLon)')

    xyr_Data =  xyr_wr(wr_DivLat_xyr(xyr_VLat))
    call check3d(xyr_DivLat, xyr_Data, 'Checking DivLat (1/r cos(Lat) dLat cos(Lat))')
  end subroutine checkresult

  subroutine check3d(sol, ans, mess)
    real(8) :: sol(:,:,:)
    real(8) :: ans(:,:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message = mess,                                           &
      answer = ans,                                             &
      check = sol,                                              &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check3d


end program wu_test_derivative3

