!------------------------------------------------------------------------
! Copyright(c) 2008-2011 SPMODEL Development Group. All rights reserved.!
!------------------------------------------------------------------------
!
!ɽ  wu_module ƥȥץ
!
!      ȥݥƥ󥷥ζ
!
!  2008/01/02  ݹ
!      2008/06/28  ʿ  ѹ
!      2011/03/11  ʿ dc_test Ѥ褦˽
!
program wu_test_tormagbc

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wu_module

  implicit none

  integer,parameter  :: im=32, jm=16, km=32  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=32         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=0.5d0             ! Ⱦ

  real(8), dimension(0:im-1,1:jm,0:km) :: xyr_TORMAG
  real(8), dimension((nm+1)**2,0:lm)   :: wu_TORMAG
  real(8), dimension(0:im-1,1:jm,0:km) :: xyr_True

  real(8), parameter :: pi=3.1415926535897932385D0
  integer, parameter :: check_digits = 14
  integer, parameter :: ignore = -15

  call wu_initial(im,jm,km,nm,lm,ra)

  call MessageNotify('M','wu_test_tormagbc', &
       'wu_module  wu_TormagBoundary subroutine test')


  ! P_10
  xyr_TORMAG = sin(xyr_lat) * cos( pi*(xyr_rad-ra)/ra ) * xyr_Rad
  wu_TORMAG = wu_xyr(xyr_TORMAG)
  call wu_TormagBoundary(wu_TORMAG)
  xyr_TORMAG = xyr_wu(wu_TORMAG)
  xyr_True = 0.0d0
  call check2d(xyr_True(:,:,0), xyr_TORmag(:,:,0), 'test of P_1^0')

  ! P_1_1
  xyr_TORMAG = cos(xyr_lat)*cos(xyr_lon)* cos( pi*(xyr_rad-ra)/ra )*xyr_Rad
  wu_TORMAG = wu_xyr(xyr_TORMAG)
  call wu_TormagBoundaryGrid(wu_TORMAG)
  xyr_TORMAG = xyr_wu(wu_TORMAG)
  xyr_True = 0.0d0
  call check2d(xyr_True(:,:,0), xyr_TORMAG(:,:,0), 'test of P_1^1')

  call MessageNotify('M','wu_test_tormagbc', &
       'wu_TormagBoundary subroutine test succeded')

contains
  subroutine check3d(sol3, ans3, mess)
    real(8) :: sol3(:,:,:)
    real(8) :: ans3(:,:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans3,                                &
      check              = sol3,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check3d

  subroutine check2d(sol2, ans2, mess)
    real(8) :: sol2(:,:)
    real(8) :: ans2(:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans2,                                &
      check              = sol2,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check2d

  subroutine check1d(sol1, ans1, mess)
    real(8) :: sol1(:)
    real(8) :: ans1(:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans1,                                &
      check              = sol1,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check1d

end program wu_test_tormagbc
