!-----------------------------------------------------------------------
! SWPACK SCREEN DRIVER FOR DEC Visual Fortran   September  1997, S.Sakai
!-----------------------------------------------------------------------
!
!************ service routine interface ***************
!
module ZMSERV
USE PIPE

    integer(4), public    :: hrp,hwp
    integer(4), parameter :: nbuf=1024
    integer(4), private   :: ndata = 0
    integer(4), private, dimension(nbuf) :: sd

!---------  R}h  ----------
    integer(4), parameter :: CM_DrawLine      = 0
    integer(4), parameter :: CM_DrawPolygon   = 1
!    integer(4), parameter :: CM_CreateBrush   = 2
    integer(4), parameter :: CM_GetDCSize     = 3
    integer(4), parameter :: CM_MouseCheck    = 4
!    integer(4), parameter :: CM_DrawImageData = 5
    integer(4), parameter :: CM_CreatePalette = 6
!    integer(4), parameter :: CM_ChangePen     = 7
    integer(4), parameter :: CM_StringOut     = 8
    integer(4), parameter :: CM_NewPage       = 10
    integer(4), parameter :: CM_ExitProcess   = 11
    integer(4), parameter :: CM_SwapActivePage    = 12
    integer(4), parameter :: CM_SwapWritePage     = 13
    integer(4), parameter :: CM_UpdatePage        = 14
    integer(4), parameter :: CM_UpdateAllPage     = 15
    integer(4), parameter :: CM_SetBitmapFileName = 16
    integer(4), parameter :: CM_ToBitmapWriteMode = 17
    integer(4), parameter :: CM_GetPrinterdpi     = 18
    integer(4), parameter :: CM_GetPaperSize      = 19 ! mm P
    integer(4), parameter :: CM_GetWindowHandle   = 20
    integer(4), parameter :: CM_GetPrinterSize    = 21 ! Bit P
    integer(4), parameter :: CM_GetPrintBMPdpi    = 22
    integer(4), parameter :: CM_CreateFullColorBrush   = 32
    integer(4), parameter :: CM_DrawFullColorImageData = 35
    integer(4), parameter :: CM_ChangeFullColorPen     = 37

contains
  subroutine ZMSEND(idat)
     ndata = ndata+1
     sd(ndata) = idat
     if (ndata == nbuf) call ZMFLUSH
  end subroutine

  subroutine  ZMFLUSH
     if(ndata > 0) then
       call pisend(hwp, LOC(sd(1)), ndata*4)
       ndata = 0
     end if
  end subroutine

  subroutine ZMCMNT(ipos, comment)
    character(len=*) :: comment
    character(len=80) :: comz
    integer          :: ipos

    comz = comment
    l1 = min(len_trim(comz)+1, len(comz))
    comz(l1:l1) = char(0)
    call zmsend(CM_StringOut)
    call zmsend(ipos)
    inum = (l1+3)/4
    call zmsend(inum)
    do i = 1, inum
      ist = (i-1)*4+1
      i4 = transfer(comz(ist:ist+3),i4)
      call zmsend(i4)
    end do
  end subroutine

end module ZMSERV
!
!************* coordinate object *****************
!
module ZMCOORD
   use ZMSERV
   integer, private :: nxmin, nxmax, nymin, nymax, nvx, nvy
   integer          :: mode0

contains
  subroutine ZMCOINI (iheight, iwidth)
    nvx    = iwidth - 1
    nxmin  = 0
    nxmax  = nxmin + nvx

    nvy    = iheight - 1
    nymin  = 0
    nymax  = nymin + nvy
  end subroutine

  subroutine ZMGVPT(ixmin, ixmax, iymin, iymax)
    ixmin = nxmin
    ixmax = nxmax
    iymin = nymin
    iymax = nymax
  end subroutine

  subroutine ZMFINT(wx, wy, iwx, iwy)
    iwx = nint(wx)
    iwy = nvy - nint(wy)
  end subroutine

  subroutine ZMIINT(iwx, iwy, wx, wy)
    wx = iwx
    wy = nvy - iwy
  end subroutine

  subroutine ZMQRCT(xwmin, xwmax, ywmin, ywmax, unit)
    xwmin = 0
    ywmin = 0
    xwmax = nvx
    ywmax = nvy
    if(mode0.eq.1) then
      unit  = 20./nvy
    else
      call ZMSEND(CM_GetPrintBMPdpi)
      call zmflush
      call pirecv (hrp,loc(idpi))
      unit = 2.54/idpi
    end if

  end subroutine

  subroutine ZMSTAT
    call ZMSEND(CM_GetPrinterdpi)
    call zmflush
    call pirecv (hrp,loc(ixdpi))
    call pirecv (hrp,loc(iydpi))

    call ZMSEND(CM_GetPrinterSize)
    call zmflush
    call pirecv (hrp,loc(ixsize))
    call pirecv (hrp,loc(iysize))

    call ZMSEND(CM_GetPrintBMPdpi)
    call zmflush
    call pirecv (hrp,loc(ibdpi))

    write(*,'(A,2I6)') ' --- PRINTER RESOLUSION :', ixdpi,  iydpi
    write(*,'(A,2I6)') ' --- PRINTABLE SIZE     :', ixsize, iysize
    write(*,'(A,2I6)') ' --- PRINTING DPI       :', ibdpi
  end subroutine

end module ZMCOORD
!
!*************** colormap object *****************
!
module ZMCOLORMAP

    use ZMSERV

    logical,    private                     :: l_full_color = .false.
    integer(4), private                     :: ipalette

    integer(4), private, parameter         :: nplmax =256
    integer(4), private, dimension(nplmax) :: ir, ig, ib
    integer(4), private                    :: max_pal

contains
  subroutine ZMCLINI(ccfile)
    character(len=*) :: ccfile
    character(len=64) cmsg

    iu = iufopn()
    open(iu, file=ccfile)
    read(iu, '(i3)') max_pal
    if (max_pal.gt.nplmax) then
      max_pal = nplmax
      cmsg='color numbers greater than xx are ignored.'
      write(cmsg(28:29),'(i2)') nplmax
      call msgdmp('w', 'zmdopn', cmsg)
    endif

    call zmsend(CM_CreatePalette)
    ns = 2**8
    do i=1, max_pal
      read(iu, '(3i6)') ir0, ig0, ib0
      ir(i) = ir0 / ns
      ig(i) = ig0 / ns
      ib(i) = ib0 / ns
    end do

    do i=1, nplmax
      CALL zmsend(ir(i))  ! red
      CALL zmsend(ig(i))  ! green
      CALL zmsend(ib(i))  ! blue
    end do
    call zmflush

    close(iu)
  end subroutine

  subroutine ZM_SEND_PALETTE(index)
    icl = index
    if(icl.eq.0) icl=1
    ip = mod(icl-1, max_pal-1)+2

    icolor = ir(ip)*16777216 + ig(ip)*65536 + ib(ip)*256
    CALL zmsend(icolor) 
  end subroutine

  subroutine ZM_SEND_PALETTE2(ip)
    integer(4) :: ip
    icolor = ir(ip+1)*256 + ig(ip+1)*65536 + ib(ip+1)*16777216
    CALL zmsend(icolor) 
  end subroutine

  subroutine ZMQFCC(lflag)
    logical lflag
    lflag = .TRUE.
  end subroutine

  subroutine ZMSFCM(lflag)
    logical lflag
    l_full_color = lflag
  end subroutine

!  subroutine ZMSCLF(color)  ! SWPACK 폜
!    integer(4) :: color
!    i_full_color = color
!  end subroutine

  function ZMQFCM
    logical zmqfcm
    zmqfcm = l_full_color
  end function

end module ZMCOLORMAP
!
!*************** bitmap object *******************
!
module ZMBITMAP

    use ZMSERV
    use ZMCOLORMAP

    integer(4), private, parameter :: ntmax=100,   npat=500,  nch=10000
    integer(2), private            :: ipat(npat,2),ipos(npat),ilen(npat),nrec,iwdth
    integer(1), private            :: idata(nch)
    integer,    private            :: jwtrot=1, i_rgb

contains
  subroutine ZMBMINI(cbfile)
    character cbfile*(*)

    iu = iufopn()
    open (iu, file=cbfile,  form='unformatted')
    read (iu) nrec, iwdth, ipat, ipos, ilen, idata
    close(iu)
  end subroutine

  subroutine ZMSTCL(irgb)
    i_rgb = irgb*256
  end subroutine

  subroutine ZMSPATTERN(itpat)
    integer(1), dimension(4) :: itmp
    integer :: itpz=-1, ifz=-1, icz=-1
    character cmsg*64

    icol  = itpat / 1000
    itptn = itpat - icol*1000
    if(zmqfcm()) then
      if(itptn.eq.itpz .and. i_rgb.eq.ifz) return
      ifz = i_rgb
      icz = -1
    else
      if(itptn.eq.itpz .and. icol.eq.icz) return
      icz = icol
      ifz = -1
    end if
    itpz = itptn

    itrec = 1
    do while (ipat(itrec, jwtrot).ne.itptn)
      itrec = itrec + 1
      if(itrec .gt. nrec) then
        cmsg = 'pattern (xxxxx) is not defined.'
        write(cmsg(10:14), '(i5)') itptn
        call msgdmp('w', 'zmspattern', cmsg)
        exit
      end if
    end do

    jlen = ilen(itrec)
    itmp = 0

    call zmsend(CM_CreateFullColorBrush)
    iword = iwdth/8
    CALL zmsend(iword) ! pattern width

    do  i=1, iwdth
      do j=1, iword
        itmp = 0
        jpos = ipos(itrec) + mod((i-1)*iword+j-1, jlen*iword)
        itmp(1) = idata(jpos)
        int4 = not(transfer(itmp, int4))
        call zmsend(int4)
      end do
    end do

    if(zmqfcm()) then
      call zmsend(i_rgb)
    else
      call zm_send_palette(icol)
    end if
  end subroutine

  subroutine ZMSROT(iwtrot)
    jwtrot=iwtrot
  end subroutine
end module
!
!***************** LINE OBJECT *******************
!
module ZMLINE

    use ZMSERV
    use ZMCOORD
    use ZMCOLORMAP

    integer(4), private, parameter :: nmax =100
    integer(4), private :: ix(nmax), iy(nmax)
    integer(4), private :: ndata=0, iwidth=1, icolor=1, i_rgb=0, iwz=-1, icz=-1, ifz=-1

contains
  subroutine ZMQCLC(lflag)
    logical lflag
    lflag=.true.
  end subroutine

  subroutine ZMQWDC(lflag)
    logical lflag
    lflag=.true.
  end subroutine

  subroutine ZMSCLI(index)
    icolor = index
  end subroutine

  subroutine ZMSLCL(irgb)
    i_rgb = irgb*256
  end subroutine

  subroutine ZMSWDI(index)
    iwidth = index
    if(iwidth == 0) iwidth = 1
    iwidth = (iwidth+1)/2
  end subroutine

  subroutine ZMGOPN
    if(zmqfcm()) then
      if(i_rgb /= ifz .or. iwidth /= iwz) then
        call zmsend(CM_ChangeFullColorPen )
        CALL zmsend(i_rgb) 
        CALL zmsend(iwidth )  ! line width
        ifz = i_rgb
        icz = -1
        iwz = iwidth
      end if
    else
      if(icolor /= icz .or. iwidth /= iwz) then
        call zmsend(CM_ChangeFullColorPen )
        call zm_send_palette(icolor)
        CALL zmsend(iwidth )  ! line width
        icz = icolor
        ifz = -1
        iwz = iwidth
      end if
    end if
  end subroutine

  subroutine ZMGPLT(xx, yy)
    ndata= ndata + 1
    call zmfint(xx, yy, ix(ndata), iy(ndata))
    if (ndata == nmax ) then
      call zmpline
      ix(1) = ix(ndata)
      iy(1) = iy(ndata)
      ndata = 1
    end if
  end subroutine

  subroutine ZMGMOV(xx, yy)
    call zmpline
    ndata = 1
    call zmfint(xx, yy, ix(ndata), iy(ndata))
  end subroutine

  subroutine ZMGCLS
    call zmpline
    ndata = 0
!    CALL zmsend(CM_UpdatePage)    ! flush
!    call ZMFLUSH
  end subroutine

  subroutine ZMPLINE
    if(ndata >= 2) then

      CALL zmsend(CM_DrawLine )  ! line
      CALL zmsend(ndata  )  ! number

      do i =1, ndata
        ixy = ix(i)*65536 + iy(i)
        CALL zmsend(ixy)  ! data x
      end do

    end if
  end subroutine
end module ZMLINE
!
!****************** TONE OBJECT *******************
!
module ZMTONE

    use ZMSERV
    use ZMCOORD
    use ZMCOLORMAP
    use ZMBITMAP

contains
  subroutine ZMQTNC(lflag)
    logical lflag
    lflag=.TRUE.
  end subroutine

  subroutine ZMGTON(np, wpx, wpy, itpat)
    real, dimension(np) :: wpx, wpy

    call zmspattern(itpat)
    CALL zmsend(CM_DrawPolygon )  ! fill
    CALL zmsend(np)       ! number

    do i=1, np
      call zmfint(wpx(i), wpy(i), ix, iy)
      ixy = ix*65536 + iy
      call zmsend(ixy)
    end do

  end subroutine
end module ZMTONE
!
!****************** IMAGE OBJECT *****************
!
module ZMIMAGE

    use ZMSERV
    use ZMCOLORMAP

    integer(4), private :: ix0, iy0, iy1, iy2, iy3, iwd, ipos, iend, idata
    integer(1), private, dimension(4) :: imd
    integer(4), parameter :: nline = 16
    character(len=16), private  :: cmnt

contains
  subroutine ZMQIMC(lflag)
    logical lflag
    lflag = .TRUE.
  end subroutine

  subroutine ZMihead

    ifrac = (iy1-iy0)*100/(iy3-iy0)
    write(cmnt, '(a,i3,a)') 'image:', ifrac, '%'
    call zmcmnt(1, cmnt)

    iy2 = min(iy3, iy1+nline-1)
    iht = iy2 - iy1 + 1
    if(iht /= 0) then
      CALL zmsend(CM_DrawFullColorImageData )  ! image data
      CALL zmsend(ix0)     ! x (corner)
      CALL zmsend(iy1)     ! y (corner)
      CALL zmsend(iwd)     ! width
      CALL zmsend(iht)     ! height
      CALL zmsend(4)       ! 1byte/pixel
      idata = 0
      iend = iwd*iht

    end if
  end subroutine

  subroutine ZMIOPN(iwx, iwy, imw, imh)
    ix0 = iwx
    iy0 = iwy
    iy3 = iwy + imh -1
    iwd = imw

    iy1 = iwy
    call zmihead
  end subroutine

  subroutine ZMIDAT(image, nlen)
    integer(4) :: image(*), int4

    do i=1, nlen
       idata = idata + 1
       CALL ZM_SEND_PALETTE2(image(i))
       if (idata == iend) then
         iy1 = iy2 + 1
         call zmihead
       end if
    end do
  end subroutine

  subroutine ZMICLS
  end subroutine

!------------------- Full color image -----------------------------------

  subroutine ZMICLR(image, nlen)
    integer(4) :: image(*)

    do i=1, nlen
       idata = idata + 1
       ir = ishft(iand(image(i), #FF0000),  -8)
       ig = ishft(iand(image(i), #00FF00),   8)
       ib = ishft(iand(image(i), #0000FF),  24)

       CALL zmsend(ior(ir, ior(ig, ib))) 
       if (idata == iend) then
         iy1 = iy2 + 1
         call zmihead
       end if
    end do
  end subroutine
end module ZMIMAGE
!
!***************** MOUSE OBJECT ******************
!
module ZMMOUSE
contains
  subroutine ZMQPTC(LFLAG)
    logical lflag
    LFLAG = .FALSE.
  end subroutine

  subroutine ZMQPNT(WX, WY, MB)
  end subroutine
end module ZMMOUSE
!
!**************** ZMPACK CONTROL *****************
!
module ZMPACK

    use ZMSERV
    use ZMLINE
    use ZMTONE
    use ZMIMAGE
    use ZMMOUSE
    integer(4) ivis, iact                       ! visual page and active page
    logical    laltz, lstatus

contains

  subroutine zmdopn(iwidth, iheight, iposx, iposy, lwait, lalt, ldump, &
             &      ccfile, cbfile, cout, mode)
    character(len=*)  :: ccfile, cbfile, cout
    character(len=80) :: comment
    logical lwait, lalt, ldump, ldisp
    integer(4)        :: mode, ixmax, iymax

    mode0 = mode
    ldisp = mode .eq. 1

    CALL popen(hrp,hwp, iwidth+12, iheight+69,mode)
!    if(mode.eq.2) then
!      call zmsend(CM_GetDCSize)
!      call zmflush
!      call pirecv (hrp,loc(ixmax))
!      call pirecv (hrp,loc(iymax))
!      iwidth  = ixmax
!      iheight = iymax
!      write(*,*) ixmax, iymax
!    end if

     if(ldump) then
       lenc = len_trim(cout)
       lw = (lenc+3)/4
       call zmsend(CM_SetBitmapFileName)
       call zmsend(lw)

       ip = 0
       do ii=1, lw
         ic = 0
         do i=1, 4
           ip = ip + 1
           ic = ic + iachar(cout(ip:ip))*256**(i-1)
           if(ip.ge.lenc) exit
         end do
         call zmsend(ic)
       end do
       call zmsend(3)
     end if

    call osgarg(0, comment)
    ipos = index(comment, '\', .true.)
    comment = comment(ipos+1:)
    ipos = len_trim(comment)
    comment(ipos+1:) = ' - (dcl-5.0)'
    call zmcmnt(0, comment)
    laltz = lalt

    call zmcoini(iheight, iwidth)          ! Initialize coordinate
    call zmclini(ccfile)                   ! Set up colormap
    call zmbmini(cbfile)                   ! Set up Tone pattern

    call zmsend (CM_NewPage)  ! new page
    call zmflush

    if(lwait) then
      call zmpause
    endif

    if(laltz) then
      call fsleep (300)

      call zmsend (CM_SwapWritePage)  ! change active  page
      call zmsend (CM_NewPage)  ! new page
!      call zmsend (CM_UpdatePage)  ! flush
      call zmflush
     endif

    call ZMGVPT     (nxmin, nxmax, nymin, nymax)

  end subroutine

  subroutine ZMDCLS (lwait)
    logical lwait

    if(lwait) then
      call zmpause
    endif

    call zmsend (CM_ExitProcess )  ! device close
    call zmflush

  end subroutine

  subroutine ZMPOPN
  end subroutine

  subroutine ZMPCLS (lwait, ldump)
    logical lwait, ldump

    if(ldump) then
      call zmsend(CM_ToBitmapWriteMode)
    end if

    call zmcmnt(1, 'Completed.')
    call zmsend (CM_UpdatePage)  ! flush
    call zmflush

    if(laltz) then
      call zmsend (CM_SwapActivePage)  ! chang display page
      call zmsend (CM_SwapWritePage)  ! chang active page
      call zmflush
    endif

    if(lwait) then
      call zmpause
    endif

    call zmsend (CM_NewPage)  ! new page

  end subroutine

  subroutine ZMOOPN(cobj, comm)
    character(len=*) :: cobj, comm

    call zmcmnt(1, cobj)
  end subroutine

  subroutine ZMOCLS(cobj)
    character(len=*) :: cobj
    call zmflush
  end subroutine

  subroutine ZMPAUSE
    do
      call zmsend (CM_MouseCheck )  ! mouse botton
      call zmflush
      call pirecv(hrp, LOC(idat))
      call pirecv(hrp, LOC(ix))
      call pirecv(hrp, LOC(iy))

      if(idat == 1) then
        exit
      else if(idat == 2) then
        if(ix == 81 .or. ix== 113) then
          call zmsend (CM_ExitProcess )  ! device close
          call zmflush
          stop
        else
          exit
        end if
      end if
      call fsleep (100)
    end do
  end subroutine
end module zmpack
