/*
 * $Id: p_header,v 1.2 2011-02-23 17:47:10 koshiro Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_iblklt(obj, rx, n, rr)
    VALUE obj, rx, n, rr;
{
    real *i_rx;
    integer i_n;
    real i_rr;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(rr) != T_FLOAT) {
      rr = rb_funcall(rr, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_rr = (real)NUM2DBL(rr);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = iblklt_(i_rx, &i_n, &i_rr);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_iblkle(obj, rx, n, rr)
    VALUE obj, rx, n, rr;
{
    real *i_rx;
    integer i_n;
    real i_rr;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(rr) != T_FLOAT) {
      rr = rb_funcall(rr, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_rr = (real)NUM2DBL(rr);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = iblkle_(i_rx, &i_n, &i_rr);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_iblkgt(obj, rx, n, rr)
    VALUE obj, rx, n, rr;
{
    real *i_rx;
    integer i_n;
    real i_rr;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(rr) != T_FLOAT) {
      rr = rb_funcall(rr, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_rr = (real)NUM2DBL(rr);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = iblkgt_(i_rx, &i_n, &i_rr);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_iblkge(obj, rx, n, rr)
    VALUE obj, rx, n, rr;
{
    real *i_rx;
    integer i_n;
    real i_rr;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(rr) != T_FLOAT) {
      rr = rb_funcall(rr, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_rr = (real)NUM2DBL(rr);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = iblkge_(i_rx, &i_n, &i_rr);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}
void
init_math1_blklib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "iblklt", dcl_iblklt, 3);
    rb_define_module_function(mDCL, "iblkle", dcl_iblkle, 3);
    rb_define_module_function(mDCL, "iblkgt", dcl_iblkgt, 3);
    rb_define_module_function(mDCL, "iblkge", dcl_iblkge, 3);
}
