!--
!----------------------------------------------------------------------
!     Copyright 2009 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  ef_module
!
!      spml/ef_module ⥸塼 x ˼Ū, y ̵ΰ
!      Ǥ 2 ΰήαư򥹥ڥȥˡˤͷ׻뤿
!       Fortran90 ؿ󶡤. 
!
!       ISPACK/U2PACK  Fortran77 ֥롼ƤǤ. 
!      ڥȥǡӳʻǡγǼˡˤĤƤ
!      ISPACK/U2PACK Υޥ˥奢򻲾Ȥ줿. 
!
!  2009/12/13  ݹ
!
!++
module ef_module
  !
  != ef_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: ef_module.f90,v 1.1 2009-12-26 02:34:32 takepiro Exp $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/ef_module ⥸塼 x ˼Ū, y ̵ΰ
  ! Ǥ 2 ΰήαư򥹥ڥȥˡˤͷ׻뤿
  !  Fortran90 ؿ󶡤. 
  !
  !  ISPACK/U2PACK  Fortran77 ֥롼ƤǤ. 
  ! ڥȥǡӳʻǡγǼˡˤĤƤ
  ! ISPACK/U2PACK Υޥ˥奢򻲾Ȥ줿. 
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !  
  ! * ؿ̾Ƭ (ef_, yx_, x_, y_) , ֤ͤη򼨤Ƥ.
  !   ef_ :: ڥȥǡ( 1,2 줾 Y,X ȿ)
  !   yx_ :: 2 ʻǡ( 1,2 줾 Y,X γʻ)
  !   x_  :: X  1 ʻǡ, y_ : Y  1 ʻǡ
  !
  ! * ؿ̾δ֤ʸ(Dx, Dy, Lapla, LaplaInv, Jacobian), 
  !   δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (_ef_ef, _ef, _yx, _x, _y) , ѿη
  !   ڥȥǡӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !   _ef    :: ڥȥǡ
  !   _ef_ef :: 2 ĤΥڥȥǡ
  !   _yx    :: 2 ʻǡ
  !   _x     :: X  1 ʻǡ
  !   _y     :: Y  1 ʻǡ.
  !  
  !=== ƥǡμ
  !  
  ! * yx : 2 ʻǡ.
  !   * ѿμȼ real(8), dimension(0:jm-1,0:im-1). 
  !   * im, jm Ϥ줾 X, Y ɸγʻǤ, ֥롼 
  !     ef_initial ˤƤ餫ꤷƤ.
  !   *  1  Y ɸγʻֹ,  2  X ɸ
  !     ʻֹǤ (X, Y νǤϤʤ)Ȥ.
  !
  ! * ef : ڥȥǡ.
  !   * ѿμȼ real(8), dimension(-lm:lm,-km:km). 
  !   * km, lm Ϥ줾 X, Y κȿǤ, ֥롼 
  !     ef_initial ˤƤ餫ꤷƤ.
  !     (X, Y ȿνǤϤʤ)Ȥ. 
  !   * ڥȥǡγǼΤˤĤƤ...
  !
  ! * x, y : X, Y  1 ʻǡ.
  !   * ѿμȼϤ줾
  !     real(8), dimension(0:im-1)  real(8), dimension(0:jm-1).
  !
  ! * ef_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * yx_ ǻϤޤؿ֤ͤ 2 ʻǡƱ.
  !
  ! * x_, y_ ǻϤޤؿ֤ͤ 1 ʻǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  !
  !== ѿ³
  !
  !====  
  !
  ! ef_Initial :: ڥȥѴγʻ, ȿ, ΰ礭
  !
  !==== ɸѿ
  !
  ! x_X, y_Y     ::  ʻɸ(X,Yɸ)Ǽ 1 
  ! x_X_Weight, y_Y_Weight ::  ŤߺɸǼ 1 
  ! yx_X, yx_Y   :: ʻǡ XY ɸ(X,Y)(ʻǡ 2 )
  !
  !==== Ѵ
  !
  ! yx_ef :: ڥȥǡʻҥǡؤѴ
  ! ef_yx :: ʻҥǡ饹ڥȥǡؤѴ
  !
  !==== ʬ
  !
  ! yx_Lapla_ef       :: ڥȥǡ˥ץ饷Ѥ
  ! yx_Dx_ef          :: ڥȥǡ X ʬѤ
  ! yx_Dy_ef          :: ڥȥǡ Y ʬѤ
  ! ef_IntX_yx        :: ʻǡ X ʬѤ
  ! ef_IntY_yx        :: ʻǡ Y ʬѤ
  ! yx_Jacobian_ef_ef :: 2 ĤΥڥȥǡ䥳ӥ׻
  !
  !==== ʬʿ
  !
  ! IntYX_yx, AvrYX_yx   :: 2 ʻǡΰʬʿ
  ! y_IntX_yx, y_AvrX_yx :: 2 ʻǡ X ʬʿ
  ! IntX_x, AvrX_x       :: 1 (X)ʻǡ X ʬʿ
  ! x_IntY_yx, x_AvrY_yx :: 2 ʻǡ Y ʬʿ
  ! IntY_y, AvrY_y       :: 1 (Y)ʻǡ Y ʬʿ
  !
  !==== ַ׻
  !
  ! Interpolate_ef       :: Ǥդͤ򥹥ڥȥǡ׻
  !
  use dc_message, only : MessageNotify
  implicit none

  private
  public ef_Initial                                       ! 롼
  public ef_ChangeResolutionDomain                        ! ɥᥤѹ
  public yx_ef, ef_yx                                     ! Ѵ
  public yx_Lapla_ef, yx_Dx_ef, yx_Dy_ef                  ! ʬ
  public ef_IntX_yx, ef_IntY_yx                           ! ʬ
  public yx_Jacobian_ef_ef                                ! ׻
  public IntYX_yx, y_IntX_yx, x_IntY_yx, IntX_x, IntY_y   ! ʬ
  public AvrYX_yx, y_AvrX_yx, x_AvrY_yx, AvrX_x, AvrY_y   ! ʿ
  public Interpolate_ef                                   ! 
  public x_X, y_Y, x_X_Weight, y_Y_Weight, yx_X, yx_Y     ! ɸѿ

  integer   :: im=32, jm=32                      ! ʻ(X,Y)
  integer   :: km=10, lm=10                      ! ȿ(X,Y)
  real(8)   :: xl=1.0                            ! X ΰ礭
  real(8)   :: yr=1.0                            ! Y 

  integer, dimension(:),   pointer :: itj => null()
  real(8), dimension(:),   pointer :: tj => null()
  integer, dimension(:),   pointer :: iti => null()
  real(8), dimension(:),   pointer :: ti => null()

  real(8), dimension(:),   pointer :: x_X => null()
                                         ! ʻɸ(X)
  real(8), dimension(:),   pointer :: y_Y => null()
                                         ! ʻɸ(Y)

  real(8), dimension(:),   pointer :: x_X_Weight => null()
                                         ! ʻŤ(X)
                                         ! X γʻδֳ֤ǼƤ.
  real(8), dimension(:),   pointer :: y_Y_Weight => null()
                                         ! ʻŤ(Y)
                                         ! Y γʻδֳ֤ǼƤ.

  real(8), dimension(:,:), pointer :: yx_X => null()
                          ! ʻ(X)ɸ(2 )
                          ! Ƴʻ(i,j)ΰ֤ X ɸǼʻҥǡ
  real(8), dimension(:,:), pointer :: yx_Y => null()
                          ! ʻ(Y)ɸ(2 )
                          ! Ƴʻ(i,j)ΰ֤ Y ɸǼʻҥǡ


  integer, parameter :: nparams_max = 10 ! ee_Initial Ƥ٤
  type ee_param                          ! ΰ¤
     integer   :: im, jm
     integer   :: km, lm
     real(8)   :: xl, yr
     integer, dimension(:),   pointer :: itj
     real(8), dimension(:),   pointer :: tj
     integer, dimension(:),   pointer :: iti
     real(8), dimension(:),   pointer :: ti
     real(8), dimension(:),   pointer :: x_X
     real(8), dimension(:),   pointer :: y_Y
     real(8), dimension(:),   pointer :: x_X_Weight
     real(8), dimension(:),   pointer :: y_Y_Weight
     real(8), dimension(:,:), pointer :: yx_X
     real(8), dimension(:,:), pointer :: yx_Y 
  end type ee_param
  type(ee_param) :: params(nparams_max)  ! ΰ
  integer :: nparams                     ! ΰθĿ

  real(8), parameter  :: pi=3.1415926535897932385D0

  save im, jm, km, lm, itj, tj, iti, ti, xl, yr
  save x_X, y_Y, x_X_Weight, y_Y_Weight, yx_X, yx_Y
  save params, nparams

  contains
  !---------------  -----------------
    subroutine ef_Initial(i,j,k,l,xmin,xmax,yrad,id)
      !
      ! ڥȥѴγʻ, ȿ, ΰ礭ꤹ.
      !
      ! ¾δؿѿƤ, ǽˤΥ֥롼Ƥ
      ! 򤷤ʤФʤʤ.
      !
      ! ץʥ id Ѥưۤʤ, ΰƱ
      ! ȤǤ. ef_Initial , ΰ褴Ȥ˸Ƥ
      !  id 򥭡פ, ef_ChangeResolutionDomain ؤ. 
      !
      integer,intent(in) :: i           ! ʻ(X)
      integer,intent(in) :: j           ! ʻ(Y)
      integer,intent(in) :: K           ! ȿ(X)
      integer,intent(in) :: l           ! ȿ(Y)

      real(8),intent(in) :: xmin, xmax     ! X ɸϰ
      real(8),intent(in) :: yrad           ! Y 

      integer, intent(out), optional :: id  ! ΰֹ

      character(len=3) cid
      integer :: ii

      im = i         ; jm = j
      km = k         ; lm = l
      xl = xmax-xmin ; yr = yrad

      if ( nparams .ge. nparams_max ) then
         call MessageNotify('W','ef_initial',&
              'too many call of ef_Initial, nothing was done.')
         if ( present(id) ) id = -1
         return
      end if

      nparams = nparams + 1

      params(nparams)%im = im
      params(nparams)%jm = jm
      params(nparams)%km = km
      params(nparams)%lm = lm
      params(nparams)%xl = xl
      params(nparams)%yr = yr

      allocate(params(nparams)%itj(5))
      allocate(params(nparams)%iti(5))
      allocate(params(nparams)%tj(jm*3))
      allocate(params(nparams)%ti(im*2))

      allocate(params(nparams)%x_X(0:im-1))
      allocate(params(nparams)%x_X_Weight(0:im-1))
      allocate(params(nparams)%y_Y(0:jm-1))
      allocate(params(nparams)%y_Y_Weight(0:jm-1))
      allocate(params(nparams)%yx_X(0:jm-1,0:im-1))
      allocate(params(nparams)%yx_Y(0:jm-1,0:im-1))

      call ef_ChangeResolutionDomain(nparams)

      call u2init(jm,im,itj,tj,iti,ti,y_Y,yr)

      do ii=0,im-1
         x_X(ii) = xmin + xl/im*ii
      enddo
      x_X_Weight = xl/im

      y_Y_Weight = (2*PI/jm)*(yrad/cos(atan(y_Y/(2*yr)))**2)

      yx_X = spread(x_X,1,jm)
      yx_Y = spread(y_Y,2,im)

      if ( present(id) ) id = nparams

      write(cid,'(I3)') nparams
      call MessageNotify('M','ef_initial','ee_module (2009/12/11) is initialized')
      call MessageNotify('M','ef_initial',&
           'ResolutionDomain ID is '//trim(adjustl(cid)))
    end subroutine ef_Initial

  !--------------- id ѹ -----------------
    subroutine ef_ChangeResolutionDomain(id)
      !
      ! , ΰѹ. ee_Initial ꤹݤ
      ! äƤ륪ץʥ id ͤѤ. 
      ! 
      integer, intent(in) :: id

      if (id .gt. nparams .or. id .lt. 1) then
         write(*,*)"id is invalid"
      end if

      im = params(id)%im
      jm = params(id)%jm
      km = params(id)%km
      lm = params(id)%lm
      xl = params(id)%xl
      yr = params(id)%yr
      itj => params(id)%itj
      tj => params(id)%tj
      iti => params(id)%iti
      ti => params(id)%ti
      x_X => params(id)%x_X
      y_Y => params(id)%y_Y
      x_X_Weight => params(id)%x_X_Weight
      y_Y_Weight => params(id)%y_Y_Weight
      yx_X => params(id)%yx_X
      yx_Y => params(id)%yx_Y
      
    end subroutine ef_ChangeResolutionDomain

  !--------------- Ѵ -----------------
    function yx_ef(ef)
      !
      ! ڥȥǡʻҥǡѴ.
      !
      real(8), dimension(0:jm-1,0:im-1)             :: yx_ef
      !(out) ʻǡ

      real(8), dimension(-lm:lm,-km:km), intent(in) :: ef
      !(in)  ڥȥǡ

      real(8), dimension(jm*im)                     :: w
      ! 

      call u2s2ga(lm,km,jm,im,ef,yx_ef,w,itj,tj,iti,ti)
    end function yx_ef

    function ef_yx(yx)
      !
      ! ʻҥǡ饹ڥȥǡѴ.
      !
      real(8), dimension(-lm:lm,-km:km)              :: ef_yx
      !(out)  ڥȥǡ

      real(8), dimension(0:jm-1,0:im-1), intent(in)  :: yx
      !(in) ʻǡ

      real(8), dimension(jm*im)                     :: w
      real(8), dimension(0:jm-1,0:im-1)             :: yx_tmp
      ! 

      yx_tmp = yx
      call u2g2sa(lm,km,jm,im,yx_tmp,ef_yx,w,itj,tj,iti,ti)

    end function ef_yx

  !--------------- ʬ׻ -----------------
    function yx_Lapla_ef(ef)
      !
      ! ϥڥȥǡ˥ץ饷(xx+yy)Ѥ.
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(0:jm-1,0:im-1)              :: yx_Lapla_ef
      !(out) ڥȥǡΥץ饷

      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ef
      !(in) ϥڥȥǡ

      ! ѿ

      yx_Lapla_ef = yx_Dx_ef(ef_yx(yx_Dx_ef(ef))) &
                  + yx_Dy_ef(ef_yx(yx_Dy_ef(ef)))
      
    end function yx_Lapla_ef

    function yx_Dx_ef(ef)
      !
      ! ϥڥȥǡ X ʬ(x)ѤƳʻǡѴ.
      !
      real(8), dimension(0:jm-1,0:im-1)              :: yx_Dx_ef
      !(out) ڥȥǡ X ʬ

      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ef
      !(in) ϥڥȥǡ

      real(8), dimension(jm*im)                     :: w
      ! 

      call u2s2gx(lm,km,jm,im,ef,yx_Dx_ef,w,itj,tj,iti,ti)

      yx_Dx_ef = yx_Dx_ef * (2*PI)/xl

    end function yx_Dx_ef

    function yx_Dy_ef(ef)
      !
      ! ϥڥȥǡ Y ʬ(y)ѤƳʻǡѴ.
      !
      real(8), dimension(0:jm-1,0:im-1)              :: yx_Dy_ef
      !(out) ڥȥǡ Y ʬ

      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ef
      !(in) ϥڥȥǡ

      real(8), dimension(jm*im)                     :: w
      ! 

      call u2s2gy(lm,km,jm,im,ef,yx_Dy_ef,w,itj,tj,iti,ti,y_Y,yr)

    end function yx_Dy_ef

    function yx_Jacobian_ef_ef(ef_a,ef_b)
      !
      !  2 ĤΥڥȥǡ䥳ӥ
      !
      !     J(A,B)=(xA)(yB)-(yA)(xB)
      !
      !  ׻.
      !
      real(8), dimension(0:jm-1,0:im-1)              :: yx_Jacobian_ef_ef
      !(out) 2 ĤΥڥȥǡΥ䥳ӥ

      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ef_a
      !(in) 1ܤϥڥȥǡ

      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ef_b
      !(in) 2ܤϥڥȥǡ

      yx_Jacobian_ef_ef  = yx_Dx_ef(ef_a)*yx_Dy_ef(ef_b) &
                         - yx_Dy_ef(ef_a)*yx_Dx_ef(ef_b)

    end function yx_Jacobian_ef_ef

    function ef_IntX_yx(yx)
      !
      ! ϳʻǡ X ʬѤƥڥȥǡѴ.
      !
      real(8), dimension(0:jm-1,0:im-1), intent(in)  :: yx
      !(in) ϳʻǡ

      real(8), dimension(-lm:lm,-km:km)              :: ef_IntX_yx
      !(in) X ʬ줿ڥȥǡ

      real(8), dimension(jm*im)                     :: w
      ! 

      call u2g2sx(lm,km,jm,im,yx,ef_IntX_yx,w,itj,tj,iti,ti)

    end function ef_IntX_yx

    function ef_IntY_yx(yx)
      !
      ! ϳʻǡ Y ʬѤƥڥȥǡѴ.
      !
      real(8), dimension(0:jm-1,0:im-1), intent(in)  :: yx
      !(in) ϳʻǡ

      real(8), dimension(-lm:lm,-km:km)              :: ef_IntY_yx
      !(in) X ʬ줿ڥȥǡ

      real(8), dimension(jm*im)                     :: w
      ! 

      call u2g2sx(lm,km,jm,im,yx,ef_IntY_yx,w,itj,tj,iti,ti,y_Y,yr)

    end function ef_IntY_yx

  !--------------- ʬ׻ -----------------
    function IntYX_yx(yx)
      !
      ! 2 ʻǡΰʬʿ.
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:jm-1,0:im-1)   :: yx          
      !(in)  2 ʻǡ

      real(8)                             :: IntYX_yx
      !(out) ʬ

      integer :: i, j
      ! ѿ

      IntYX_yx = 0.0d0
      do i=0,im-1
         do j=0,jm-1
            IntYX_yx = IntYX_yx + yx(j,i) * y_Y_Weight(j) * x_X_Weight(i)
         enddo
      enddo
    end function IntYX_yx

    function y_IntX_yx(yx)
      !
      ! 2 ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:jm-1,0:im-1)   :: yx
      !(in) 2 ʻǡ

      real(8), dimension(0:jm-1)          :: y_IntX_yx
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: i
      ! ѿ

      y_IntX_yx = 0.0d0
      do i=0,im-1
         y_IntX_yx(:) = y_IntX_yx(:) + yx(:,i) * x_X_Weight(i)
      enddo
    end function y_IntX_yx

    function x_IntY_yx(yx)
      !
      ! 2 ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:jm-1,0:im-1)   :: yx      
      !(in)  2 ʻǡ

      real(8), dimension(0:im-1)        :: x_IntY_yx 
      !(out) ʬ줿 1 (X)ʻǡ

      integer :: j
      ! ѿ

      x_IntY_yx = 0.0d0
      do j=0,jm-1
         x_IntY_yx(:) = x_IntY_yx(:) + yx(j,:) * y_Y_Weight(j)
      enddo
    end function x_IntY_yx

    function IntX_x(x)
      !
      ! 1 (X)ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:im-1)   :: x          !(in)  1 ʻǡ
      real(8)                      :: IntX_x     !(out) ʬ

      IntX_x = sum(x*x_X_Weight)
    end function IntX_x

    function IntY_y(y)      ! Y ʬ
      !
      ! 1 (Y)ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:jm-1)   :: y          !(in)  1 ʻǡ
      real(8)                      :: IntY_y     !(out) ʬ

      IntY_y = sum(y*y_Y_Weight)
    end function IntY_y

  !--------------- ʿѷ׻ -----------------
    function AvrYX_yx(yx)
      !
      ! 2 ʻǡΰʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻, x_X_Weight*y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:jm-1,0:im-1)   :: yx
      !(in)  2 ʻǡ

      real(8)                             :: AvrYX_yx    
      !(out) ʿ

      AvrYX_yx = AvrX_x(x_AvrY_yx(yx))
    end function AvrYX_yx

    function y_AvrX_yx(yx)
      !
      ! 2 ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:jm-1,0:im-1)   :: yx
      !(in) 2 ʻǡ

      real(8), dimension(0:jm-1)          :: y_AvrX_yx
      !(out) ʿѤ줿 1 (Y)ʻǡ

      y_AvrX_yx = y_IntX_yx(yx)/sum(x_X_weight)
    end function y_AvrX_yx

    function x_AvrY_yx(yx)
      !
      ! 2 ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:jm-1,0:im-1)   :: yx
      !(in) 2 ʻǡ

      real(8), dimension(0:im-1)          :: x_AvrY_yx
      !(out) ʿѤ줿 1 (X)ʻǡ

      real(8), dimension(0:jm-1,0:im-1)   :: yx_Data
      real(8), dimension(-lm:lm,-km:km)   :: ef_Data

      ef_Data = ef_yx(yx)
      ef_Data(1:lm,:) = 0.0D0
      ef_Data(-lm:-1,:) = 0.0D0

      yx_Data = yx_ef(ef_Data)

      x_AvrY_yx = yx_Data(1,:)

    end function x_AvrY_yx

    function AvrX_x(x)
      !
      ! 1 (X)ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:im-1)   :: x          !(in)  1 ʻǡ
      real(8)                      :: AvrX_x     !(out) ʿ

      AvrX_x = IntX_x(x)/sum(x_X_weight)
    end function AvrX_x

    function AvrY_y(y)
      !
      ! 1 (Y)ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:jm-1) :: y          !(in)  1 ʻǡ
      real(8)                    :: AvrY_y     !(out) ʿ

      real(8), dimension(0:jm-1,0:im-1)   :: yx_Data
      real(8), dimension(0:im-1)          :: x_Data

      yx_Data = spread(y,2,im)
      x_Data  = x_AvrY_yx(yx_Data)
      AvrY_y = x_Data(0)

    end function AvrY_y

  !--------------- ַ׻ -----------------
    function Interpolate_ef( ef_Data, x, y )
      real(8), intent(IN)  :: ef_data(-lm:lm,-km:km)  ! ڥȥǡ
      real(8), intent(IN)  :: x                       ! ֤ x ɸ 
      real(8), intent(IN)  :: y                       ! ֤ y ɸ 
      real(8)              :: Interpolate_ef          ! ֤

      integer :: k, l
      real(8) :: xx, theta

      xx =(2*PI/xl)*(x - x_X(0))
      theta = 2.0D0*atan(y/(2*yr))

      Interpolate_ef = ef_Data(0,0)

      ! l=0
      do k=1,km
         Interpolate_ef = Interpolate_ef &
              +   ( ef_Data(0,k)*cos(k*xx) - ef_Data(0,-k)*sin(k*xx) ) &
              +   ( ef_Data(0,k)*cos(-k*xx) + ef_Data(0,-k)*sin(-k*xx) )
      end do

      ! l /= 0
      do l=1,lm
         do k=1,km
            Interpolate_ef = Interpolate_ef &
              +    (   ef_Data(l,k)*cos(k*xx)*cos(l*theta)    &
                     - ef_Data(l,-k)*sin(k*xx)*cos(l*theta)   &
                     + ef_Data(-l,k)*cos(k*xx)*sin(l*theta)   &
                     + ef_Data(-l,-k)*sin(k*xx)*sin(l*theta) )&
              +    (   ef_Data(l,k)*cos(-k*xx)*cos(l*theta)    &
                     + ef_Data(l,-k)*sin(-k*xx)*cos(l*theta)   &
                     + ef_Data(-l,k)*cos(-k*xx)*sin(l*theta)   &
                     - ef_Data(-l,-k)*sin(-k*xx)*sin(l*theta) )
         end do
      end do

    end function Interpolate_ef

end module ef_module
