!--
!----------------------------------------------------------------------
! Copyright(c) 2009-2010 SPMDODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wq_module_sjpack
!
!    spml/wq_module_sjpack ⥸塼ϵǤήαư򥹥ڥȥˡ
!    äƿͷ׻뤿 Fortran90 ؿ󶡤ΤǤ. 
!
!    ʿ˵ĴȡѴư
!    Matsushima and Marcus (1994) 󾧤줿¿༰Ѥ
!    ڥȥ׻ΤΤޤޤʴؿ󶡤. 
!
!     wa_module_sjpack, aq_module ѤƤ. 
!    ǲǤϵĴѴѴΥ󥸥Ȥ 
!    ISPACK  Fortran77 ֥롼ѤƤ.
!
!    ؿ, ֥롼̾ȵǽ wq_module ΤΤƱǤ. 
!    ä use ʸ wq_module  wq_module_sjpack 
!    ѹ SJPACK εǽȤ褦ˤʤ. 
! 
!     l_nm, nm_l λȤˤդ줿. wq_module  l_nm,
!    nm_l wq_Initial ǽʤȤѤ뤳ȤǤ(̤
!    ȿ˰ͤʤ), wq_module_sjpack ΤΤϽΤˤ
!    ȤǤʤ.
!
!    Matsushima and Marcus (1994) ¿༰˴ؤ 
!    doc/spectral_radial.tex 򻲾ȤΤ. 
!
!
!  2008/04/03  ݹ  wu_module 
!      2008/05/02  ݹ  ɲ
!      2008/07/01  ʿ ʿγʻ 0:im-1,1:jm ˽
!      2008/07/04  ʿ Ȥ RDoc Ѥ
!      2008/07/20  ݹ  wq_Rad2_wq, wq_Rad2Inv_wq, wq_Lapla_wq ɲ
!      2008/07/21  ݹ  ׻ѹ
!      2009/01/09  ݹ  wu_Initial åդɲ
!      2009/01/29  ʿ Ȥ RDoc Ѥ
!      2009/07/31  ݹ  ׻ threadprivate (OpenMP)
!      2009/12/06  ݹ  ƬȤ, threadprivate ȥ
!      2010/03/10  ʿ  threadprivate (ѥ¸)
!      2010/05/08  ݹ  wr_DivRad_xyr ɲ, wr_Div_xyr_xyr_xyr ѹ
!
!
!      ǡ index
!        x :          y :         r : ư
!        w : Ĵ´ؿڥȥ
!        n : Ĵ´ؿڥȥ(ʿȿ)
!        m : Ĵ´ؿڥȥ(Ӿȿ)
!        q : ڥȥؿڥȥ
!        a : Ǥդμ
!
!        xyr : 3 ʻǡ
!        xy  : ʿ 2 ʻǡ
!        yr  : Ҹ 2 ʻǡ
!        xr  :  2 ʻǡ
!
!        wr  : ʿڥȥư³ʻǡ
!        wq  : ڥȥǡ
!
!++
module wq_module_sjpack
  !
  != wq_module_sjpack
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: wq_module_sjpack.f90,v 1.3 2010-05-08 11:53:56 takepiro Exp $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/wq_module_sjpack ⥸塼ϵǤήαư򥹥ڥȥˡ
  ! äƿͷ׻뤿 Fortran90 ؿ󶡤ΤǤ. 
  !
  ! ʿ˵ĴȡѴư
  ! Matsushima and Marcus (1994) 󾧤줿¿༰Ѥ
  ! ڥȥ׻ΤΤޤޤʴؿ󶡤. 
  !
  !  wa_module, aq_module ѤƤ. 
  ! ǲǤϵĴѴΥ󥸥Ȥ 
  ! ISPACK  Fortran77 ֥롼ѤƤ.
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !
  ! * ؿ̾Ƭ (wq_, nmr_, nr_, xyr_, wr_, w_, xy_, x_, y_, r_, a_) , 
  !   ֤ͤη򼨤Ƥ.
  !   wq_  :: ڥȥǡ(ĴȡӥѴ)
  !   nmr_ :: ʿڥȥǡ(ȿ n, Ӿȿʬ, ư)
  !   nr_  :: ʿڥȥǡ(ȿ n, ư)
  !   xyr_ :: 3 ʻǡ(١١ư)
  !   wr_  :: ʿڥȥ, ư³ʻǡ
  !
  ! * ؿ̾δ֤ʸ(DLon, GradLat, GradLat, DivLon, DivLat, Lapla,..)
  !   , δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (wq_, xyz_, wr_, w_, xy_, x_, y_, r_, a_) , ѿ
  !   ڥȥǡӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !   _wq      :: ڥȥǡ
  !   _xyr     :: 3 ʻǡ
  !   _xyr_xyr :: 2 Ĥ3 ʻǡ, ...
  !
  !=== ƥǡμ
  !
  ! * xyr : 3 ʻǡ(١١ư)
  !   * ѿμȼ real(8), dimension(0:im-1,1:jm,km). 
  !   * im, jm, km Ϥ줾, , ưºɸγʻǤ, 
  !     ֥롼 wq_Initial ˤƤ餫ꤷƤ.
  !
  ! * wq : ڥȥǡ
  !   * ѿμȼ real(8), dimension((nm+1)*(nm+1),0:lm). 
  !   * nm ϵĴȡκȿ, lm ϥӥ¿༰κ缡
  !     Ǥ, ֥롼 wq_Initial ˤƤ餫ꤷƤ. 
  !   * ʿڥȥǡγǼΤϴؿ l_nm, nm_l ˤäĴ٤
  !     ȤǤ. 
  !   * ư¥ڥȥǡγǼˡˤĤƤ aq_module.f90 
  !     ȤΤ. km < 2*im ǤʤФʤʤ. 
  !
  ! * nmr : ʿڥȥǡ¤ 3 .
  !   * ѿμȼ real(8), dimension(0:nm,-nm:nm,km). 
  !   *  1 ʿȿ,  2 Ӿȿ,  3 ưºɸɽ. 
  !   * nm ϵĴȡκȿǤ, ֥롼 wq_Initial ˤ
  !     餫ꤷƤ.
  !
  ! * nr : ڥȥǡ¤ 2 .
  !   * ѿμȼ real(8), dimension(0:nm,km). 
  !   *  1 ʿȿɽ. nm ϵĴȡκȿǤ, 
  !     ֥롼 wq_Initial ˤƤ餫ꤷƤ.
  !
  ! * wr : ʿڥȥ, ư³ʻǡ.
  !   * ѿμȼ real(8), dimension((nm+1)*(nm+1),km).
  !
  ! * wq_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * xyr_ ǻϤޤؿ֤ͤ 3 ʻǡƱ.
  !
  ! * wr_ ǻϤޤؿ֤ͤϿʿڥȥ, ư³ʻǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  ! 
  !
  !== ѿ³
  !
  !====  
  !
  ! wq_Initial :: ڥȥѴγʻ, ȿ, ΰ礭
  ! 
  !==== ɸѿ
  !
  ! x_Lon, y_Lat, r_Rad          :: ʻɸ(, , ưºɸ)
  !                                 Ǽ1 
  ! x_Lon_Weight, y_Lat_Weight, r_Rad_Weight :: ŤߺɸǼ 1 
  ! xyr_Lon, xyr_Lat, xyr_Rad    :: ʻǡη١١ưºɸ(X,Y,Z)
  !                                 (ʻǡ 3 )
  !
  !==== Ѵ
  !
  ! xyr_wq, wq_xyr :: ڥȥǡ 3 ʻҥǡδ֤Ѵ
  !                   (Ĵȡ, ӥѴ)
  !
  ! xyr_wr, wr_xyr :: 3 ʻҥǡȿʿڥȥ롦ư³ʻҥǡȤ
  !                   ֤Ѵ (Ĵȡ)
  !
  ! wr_wq, wq_wr   :: ڥȥǡȿʿڥȥ롦ư³ʻҥǡȤ
  !                   ֤Ѵ (ӥѴ)
  !
  ! w_xy, xy_w     :: ڥȥǡ 2 ʿʻҥǡ
  !                   ֤Ѵ(ĴȡѴ) 
  !
  ! l_nm, nm_l     :: ڥȥǡγǼ֤ȿӾȿѴ 
  !
  !==== ʬ
  !
  ! wq_RadDRad_wq       :: ڥȥǡưʬ r/r Ѥ
  ! wr_DivRad_wq        :: ڥȥǡȯưʬ
  !                        1/r^2 /r r^2 = /r + 2/r Ѥ
  ! wr_DivRad_xyr       :: ʻǡȯưʬ
  !                        1/r^2 /r r^2 = /r + 2/r Ѥ
  ! wr_RotDRad_wq       :: ڥȥǡ˲žưʬ
  !                        1/r /rr = /r + 1/r Ѥ
  ! wr_RotDRad_wr       :: ڥȥǡ˲žưʬ
  !                        1/r /rr = /r + 1/r Ѥ
  ! wq_RotDRad_wr       :: ڥȥǡ˲žưʬ
  !                        1/r /rr = /r + 1/r Ѥ
  ! wq_Lapla_wq         :: ڥȥǡ˥ץ饷Ѥ
  ! xyr_GradLon_wq      :: ڥȥǡ˸۷ʬ
  !                        1/rcosա/ߦˤѤ
  ! xyr_GradLat_wq      :: ڥȥǡ˸۷ʬ
  !                        1/r/ߦդѤ
  ! wr_DivLon_xyr       :: ʻҥǡȯʬ
  !                        1/rcosա/ߦˤѤ
  ! wr_DivLat_xyr       :: ʻҥǡȯʬ
  !                        1/rcosա(g cos)/ߦդѤ
  ! wr_Div_xyr_xyr_xyr  :: ٥ȥʬǤ 3 Ĥγʻҥǡ
  !                        ȯѤ
  ! xyr_Div_xyr_xyr_xyr :: ٥ȥʬǤ 3 Ĥγʻҥǡ
  !                        ȯѤ
  ! xyr_RotLon_wq_wq    :: ٥ȥβžηʬ׻
  ! xyr_RotLat_wq_wq    :: ٥ȥβžΰʬ׻
  ! wr_RotRad_xyr_xyr   :: ٥ȥβžưʬ׻
  !
  !==== ȥݥ׻ʬ
  !
  ! wq_KxRGrad_wq     :: ڥȥǡ˷ʬ
  !                      kr = /ߦˤѤ
  ! xyr_KGrad_wq      :: ڥȥǡ˼ʬ
  !                      k = cos/r /ߦ + sinբ/r Ѥ
  ! wq_L2_wq          :: ڥȥǡ L2 黻 = -ʿץ饷
  !                      Ѥ
  ! wq_L2Inv_wq       :: ڥȥǡ L2 黻Ҥε = -տʿץ饷
  !                      Ѥ
  ! wq_QOperator_wq   :: ڥȥǡ˱黻
  !                      Q=(k-1/2(L2 k+ kL2)) Ѥ
  ! wr_RadRot_xyr_xyr :: ٥ȥ v α٤ư¥٥ȥ r  r(v) 
  !                      ׻
  ! wr_RadRotRot_xyr_xyr_xyr :: ٥ȥ v  r(ߢv) ׻
  ! wq_RadRotRot_xyr_xyr_xyr :: ٥ȥ v  r(ߢv) ׻
  ! wq_Potential2Vector      :: ȥݥݥƥ󥷥뤫
  !                             ٥ȥ׻
  ! wq_Potential2Rotation    :: ȥݥݥƥ󥷥ɽ
  !                             ȯ٥ȥβžγʬ׻
  !
  !==== ݥ/ȥǥѥڥȥ
  !
  ! nmr_ToroidalEnergySpectrum_wq, nr_ToroidalEnergySpectrum_wq  ::
  !     ȥݥƥ󥷥뤫饨ͥ륮εĴȡʬ׻
  ! nmr_PoloidalEnergySpectrum_wq, nr_PoloidalEnergySpectrum_wq  ::
  !     ݥݥƥ󥷥뤫饨ͥ륮εĴȡʬ׻
  !
  !==== 
  !
  ! wq_BoundaryTau, wr_BoundaryGrid, wq_Boundary                         ::
  !     ǥꥯ, Υޥ󶭳ŬѤ(ˡ, ˡ)
  ! wq_TorBoundaryTau, wr_TorBoundaryGrid, wq_TorBoundary                ::
  !     ®٥ȥݥƥ󥷥ζŬѤ(ˡ,ˡ)       
  ! wq_LaplaPol2Pol_wq, wq_LaplaPol2PolTau_wq                            ::
  !     ®٥ݥݥƥ󥷥릵^2
  !     (Ϥ줾ʻӥڥȥ뷸)
  ! wq_TorMagBoundaryTau, wr_TorMagBoundaryGrid, wq_TorMagBoundary       ::
  !     ȥݥƥ󥷥ζŬѤ(ˡ, ˡ)
  ! wq_PolMagBoundaryTau, wr_PolMagBoundaryGrid, wq_PolMagBoundary       ::
  !     ȥݥƥ󥷥붭ζŬѤ(ˡ, ˡ)
  !
  !==== ʬʿ(3 ǡ)
  !
  ! IntLonLatRad_xyr, AvrLonLatRad_xyr :: 3 ʻǡ
  !                                       ΰʬʿ
  ! r_IntLonLat_xyr, r_AvrLonLat_xyr   :: 3 ʻǡ
  !                                       ٷ(ʿ)ʬʿ
  ! y_IntLonRad_xyr, y_AvrLonRad_xyr   :: 3 ʻǡ
  !                                       ưʬʿ
  ! r_IntLatRad_xyr, r_AvrLatRad_xyr   :: 3 ʻǡ
  !                                       ư(Ҹ)ʬʿ
  ! yr_IntLon_xyr, yr_AvrLon_xyr       :: 3 ʻǡ
  !                                       ʬʿ
  ! xr_IntLat_xyr, xr_AvrLat_xyr       :: 3 ʻǡ
  !                                       ʬʿ
  ! xr_IntRad_xyr, xr_AvrRad_xyr       :: 3 ʻǡ
  !                                       ưʬʿ
  !
  !==== ʬʿ(2 ǡ)
  !
  ! IntLonLat_xy, AvrLonLat_xy :: 2 ʻǡοʿ()ʬʿ
  ! IntLonRad_xr, AvrLonRad_xr :: 2 (XZ)ʻǡηưʬ
  !                               ʿ
  ! IntLatRad_yr, AvrLatRad_yr :: 2 (YZ)ʻǡΰư(Ҹ)
  !                               ʬʿ 
  ! y_IntLon_xy, y_AvrLon_xy   :: ʿ 2 ()ʻǡη
  !                               ʬʿ
  ! x_IntLat_xy, x_AvrLat_xy   :: ʿ2 ()ʻǡΰʬ
  !                               ʿ
  ! r_IntLon_xr, r_AvrLon_xr   :: 2 (XZ)ʻǡηʬ
  !                               ʿ
  ! x_IntRad_xr, x_AvrRad_xr   :: 2 (XZ)ʻǡưʬ
  !                               ʿ
  ! r_IntLat_yr, r_AvrLat_yr   :: 2 (YZ)ʻǡΰʬ
  !                               ʿ
  ! y_IntRad_yr, y_AvrRad_yr   :: 2 (YZ)ʻǡưʬ
  !                               ʿ                  
  !
  !==== ʬʿ(1 ǡ)
  !
  ! IntLon_x, AvrLon_x  :: 1 (X)ʻǡηʬʿ
  ! IntLat_y, AvrLat_y  :: 1 (Y)ʻǡΰʬʿ
  ! IntRad_r, AvrRad_r  :: 1 (Z)ʻǡưʬʿ
  !
  ! 
  use dc_message
  use lumatrix
  use wa_module_sjpack
  use aq_module, r_Rad => g_R, r_RAD_WEIGHT => g_R_WEIGHT, &
                 aq_ar => aq_ag, ar_aq => ag_aq, &
                 q_RadDRad_q => q_rDr_q, wq_RadDRad_wq => aq_rDr_aq, &
                 wq_Rad2_wq => aq_r2_aq, q_Rad2_q => q_r2_q, &
                 wq_Rad2Inv_wq => aq_r2Inv_aq, q_Rad2Inv_q => q_r2Inv_q
  implicit none
  private

  public wq_Initial

  public x_Lon, x_Lon_Weight
  public y_Lat, y_Lat_Weight
  public r_Rad, r_Rad_Weight
  public l_nm, nm_l
  public xy_Lon, xy_Lat
  public xyr_Lon, xyr_Lat, xyr_Rad
  public wr_Rad
  public wq_VMiss

  public w_xy, xy_w
  public wq_RadDRad_wq, q_RadDRad_q, wr_wq, wq_wr
  public wq_Rad2_wq, q_Rad2_q, wq_Rad2Inv_wq, q_Rad2Inv_q
  public xyr_wq, wq_xyr, xyr_wr, wr_xyr
  public wr_DivRad_wq, wr_RotDRad_wq, wr_RotDRad_wr, wq_Lapla_wq
  public wq_RotDRad_wr
  public xyr_GradLon_wq, xyr_GradLat_wq
  public wr_DivLon_xyr, wr_DivLat_xyr, wr_DivRad_xyr
  public wr_Div_xyr_xyr_xyr, xyr_Div_xyr_xyr_xyr
  public xyr_RotLon_wq_wq, xyr_RotLat_wq_wq, wr_RotRad_xyr_xyr

  public yr_IntLon_xyr, xr_IntLat_xyr, xy_IntRad_xyr
  public x_IntLatRad_xyr, y_IntLonRad_xyr, r_IntLonLat_xyr
  public IntLonLatRad_xyr

  public x_IntLat_xy, y_IntLon_xy, IntLonLat_xy
  public r_IntLat_yr, y_IntRad_yr, IntLatRad_yr
  public r_IntLon_xr, x_IntRad_xr, IntLonRad_xr
  public IntLon_x, IntLat_y, IntRad_r

  public yr_AvrLon_xyr, xr_AvrLat_xyr, xy_AvrRad_xyr
  public x_AvrLatRad_xyr, y_AvrLonRad_xyr, r_AvrLonLat_xyr
  public AvrLonLatRad_xyr

  public x_AvrLat_xy, y_AvrLon_xy, AvrLonLat_xy
  public r_AvrLat_yr, y_AvrRad_yr, AvrLatRad_yr
  public r_AvrLon_xr, x_AvrRad_xr, AvrLonRad_xr
  public AvrLon_x, AvrLat_y, AvrRad_r

  public wq_KxRGrad_wq, xyr_KGrad_wq, wq_L2_wq, wq_L2Inv_wq, wq_QOperator_wq
  public wr_RadRot_xyr_xyr, wr_RadRotRot_xyr_xyr_xyr
  public wq_RadRotRot_xyr_xyr_xyr
  public wq_Potential2vector, wq_Potential2Rotation

  public nmr_ToroidalEnergySpectrum_wq, nr_ToroidalEnergySpectrum_wq
  public nmr_PoloidalEnergySpectrum_wq, nr_PoloidalEnergySpectrum_wq

  public wq_Boundary, wq_TorBoundary, wq_LaplaPol2Pol_wq ! wr_LaplaPol2Pol_wr
  public wq_TormagBoundary, wq_PolmagBoundary

  public wq_BoundaryTau, wq_TorBoundaryTau, wq_LaplaPol2PolTau_wq
  public wq_TormagBoundaryTau, wq_PolmagBoundaryTau

  public wr_BoundaryGrid, wr_TorBoundaryGrid
  public wr_TormagBoundaryGrid, wr_PolmagBoundaryGrid

  interface wq_Boundary
     module procedure wq_BoundaryTau
  end interface

  interface wq_TorBoundary
     module procedure wq_TorBoundaryTau
  end interface

  interface wq_LaplaPol2Pol_wq
     module procedure wq_LaplaPol2PolTau_wq
  end interface

  interface wq_TorMagBoundary
     module procedure wq_TorMagBoundaryTau
  end interface

  interface wq_PolMagBoundary
     module procedure wq_PolMagBoundaryTau
  end interface

  integer            :: im=64, jm=32, km=16  ! ʻ(, , ư)
  integer            :: nm=21, lm=31         ! ȿ(ʿ, ư)
  real(8)            :: ra=1.0               ! Ⱦ
  real(8), parameter :: pi=3.1415926535897932385D0

  real(8), parameter :: alpha = 1.0D0      ! Ÿ¿༰ѥ᥿  0 <  <= 1
  real(8), parameter :: beta  = 2.0D0      ! Ÿ¿༰ѥ᥿  0 < 

  real(8), dimension(:,:,:), allocatable :: xyr_LON, xyr_LAT, xyr_RAD ! ɸ
  real(8), dimension(:,:), allocatable   :: wr_RAD                    ! ɸ
  integer, dimension(:), allocatable     :: nd             ! Ť r^n λؿ

  real(8) :: wq_VMiss = -999.0        ! »

  save im, jm, km, nm, lm, ra, nd, xyr_Lon, xyr_Lat, xyr_Rad, wr_Rad

  contains
  !---------------  -----------------
   subroutine wq_Initial(i,j,k,n,l,r,np,wa_init)
     !
     ! ڥȥѴγʻ, ȿ, ưºɸϰϤꤹ.
     !
     ! ¾δؿƤ, ǽˤΥ֥롼Ƥǽ
     ! ʤФʤʤ. 
     !
     ! np  1 礭ͤꤹ ISPACK εĴȡѴ 
     ! OPENMP ׻롼Ѥ. ׻¹Ԥˤ, 
     ! ¹Ի˴Ķѿ OMP_NUM_THREADS  np ʲοꤹ
     ! ƥ˱ɬפȤʤ. 
     !
     ! np  1 礭ͤꤷʤ׻롼ϸƤФʤ.
     !
     !
     integer,intent(in) :: i              ! ʻ(٦)
     integer,intent(in) :: j              ! ʻ(٦)
     integer,intent(in) :: k              ! ʻ(ư r)
     integer,intent(in) :: n              ! ȿ(ʿȿ)
     integer,intent(in) :: l              ! ȿ(ưȿ)

     real(8),intent(in) :: r              ! Ⱦ

     integer,intent(in), optional :: np   ! OPENMP Ǥκ祹åɿ
     logical,intent(in), optional :: wa_init   ! wa_initial å

     logical    :: wa_initialize=.true.   ! wa_initial å

     integer :: nn, mm

     im = i  ; jm = j ; km = k
     nm = n  ; lm = l
     ra = r

     if ( present(wa_init) ) then
        wa_initialize = wa_init
     else
        wa_initialize = .true.
     endif

     if ( wa_initialize ) then
        if ( present(np) ) then
           call wa_Initial(nm,im,jm,km,np)
        else
           call wa_Initial(nm,im,jm,km)
        endif
     endif

     allocate(nd((nm+1)*(nm+1)))

     do nn=0,nm
        do mm=-nn,nn
           nd(l_nm(nn,mm)) = nn                 ! ʿ n  r^n 
        enddo
     enddo

     call aq_Initial(km,lm,ra,alpha,beta,nd)

     allocate(xyr_Lon(0:im-1,1:jm,km))
     allocate(xyr_Lat(0:im-1,1:jm,km))
     allocate(xyr_Rad(0:im-1,1:jm,km))

     allocate(wr_Rad((nm+1)*(nm+1),km))

     xyr_Lon = spread(xy_Lon,3,km)
     xyr_Lat = spread(xy_Lat,3,km)
     xyr_Rad = spread(spread(r_Rad,1,jm),1,im)

     wr_Rad = spread(r_Rad,1,(nm+1)*(nm+1))

    call MessageNotify('M','wq_initial','wq_module_sjpack (2009/12/06) is initialized')

   end subroutine wq_initial

  !--------------- Ѵ -----------------

    function xyr_wq(wq)
      !
      ! ڥȥǡ 3 ʻǡ()Ѵ.
      !
      real(8), dimension(0:im-1,1:jm,km)                       :: xyr_wq
      !(out) 3 ٰư³ʻǡ

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      xyr_wq = xya_wa(wr_wq(wq))

    end function xyr_wq

    function wq_xyr(xyr)
      !
      ! 3 ʻǡ饹ڥȥǡ()Ѵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wq_xyr
      !(out) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:im-1,1:jm,km), intent(in)           :: xyr
      !(in) 3 ٰư³ʻǡ

      wq_xyr = wq_wr(wa_xya(xyr))

    end function wq_xyr

    function xyr_wr(wr)
      !
      ! ʿڥȥ롦ư³ʻǡ 3 ʻǡ()Ѵ.
      !
      real(8), dimension(0:im-1,1:jm,km)                     :: xyr_wr
      !(out) 3 ٰư³ʻǡ

      real(8), dimension((nm+1)*(nm+1),km), intent(in) :: wr
      !(in) 2 Ĵȡڥȥ롦ư³ʻǡ

      xyr_wr = xya_wa(wr)

    end function xyr_wr

    function wr_xyr(xyr)
      !
      ! 3 ʻҥǡʿڥȥ롦ư³ʻǡ()Ѵ.
      !
      real(8), dimension((nm+1)*(nm+1),km)               :: wr_xyr
      !(out) 2 Ĵȡڥȥ롦ư³ʻǡ

      real(8), dimension(0:im-1,1:jm,km), intent(in)         :: xyr
      !(in) 3 ٰư³ʻǡ

      wr_xyr = wa_xya(xyr)

    end function wr_xyr

    function wr_wq(wq)
      !
      ! ڥȥǡʿڥȥ롦ư³ʻǡ()Ѵ.
      !
      real(8), dimension((nm+1)*(nm+1),km) :: wr_wq
      !(out) 2 Ĵȡڥȥ롦ư³ʻǡ
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      wr_wq = ar_aq(wq)

    end function wr_wq

    function wq_wr(wr)
      !
      ! ʿڥȥ롦ư³ʻǡ饹ڥȥǡ()Ѵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm) :: wq_wr
      !(out) 2 Ĵȡӥեڥȥǡ
      real(8), dimension((nm+1)*(nm+1),km), intent(in) :: wr
      !(in) 2 Ĵȡڥȥ롦ư³ʻǡ

      wq_wr = aq_ar(wr)
      
    end function wq_wr


  !--------------- ʬ׻ -----------------
    function wr_DivRad_wq(wq)
      ! 
      ! ϥڥȥǡȯưʬ
      !
      !       1/r^2 /r (r^2 .)= /r + 2/r
      !
      ! Ѥ.
      !
      ! ڥȥǡȯưʬȤ, бʻǡ
      ! ȯưʬѤǡΥڥȥѴΤȤǤ. 
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),km)             :: wr_DivRad_wq
      !(out) ȯưʬѤ줿ʿڥȥư³ʻǡ

      wr_DivRad_wq = wr_wq(wq_RadDRad_wq(wq))/wr_Rad + 2/wr_Rad * wr_wq(wq)

    end function wr_DivRad_wq

    function wr_DivRad_xyr(xyr)
      ! 
      ! ʻǡȯưʬ
      !
      !       1/r^2 /r (r^2  = /r + 2/= 1/r/(r.) + 1/r
      !
      ! Ѥ.
      !
      ! δؿϤư¼ȿʿȿζۤʤäƤ뤳Ȥ
      ! ꤷƤ. פƤˤ wr_DigRad_wq Ѥ뤳.
      !
      real(8), dimension(0:im-1,jm,km), intent(in) :: xyr
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),km)             :: wr_DivRad_xyr
      !(out) ȯưʬѤ줿ʿڥȥư³ʻǡ

      wr_DivRad_xyr = wr_wq(wq_RadDRad_wq(wq_xyr(xyr_Rad*xyr)))/wr_Rad**2 &
                    + 1/wr_Rad * wr_xyr(xyr)

    end function wr_DivRad_xyr

    function wr_RotDRad_wq(wq)
      !
      ! ϥڥȥǡ˲žưʬ
      !
      !      1/r (r.)/r = (.)/r + (.)/r
      !
      ! Ѥ.
      !
      ! ڥȥǡβžưʬȤ, бʻǡ
      ! žưʬѤǡΥڥȥѴΤȤǤ. 
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),km)               :: wr_RotDRad_wq
      !(out) žưʬѤ줿ʿڥȥư³ʻǡ

      wr_RotDRad_wq = wr_wq(wq_RadDrad_wq(wq))/wr_Rad + wr_wq(wq)/wr_Rad

    end function wr_RotDRad_wq

    function wr_RotDRad_wr(wr)
      !
      ! ϥڥȥǡ˲žưʬ
      !
      !      1/r (r.)/r = (.)/r + (.)/r
      !
      ! Ѥ.
      !
      ! ڥȥǡβžưʬȤ, бʻǡ
      ! žưʬѤǡΥڥȥѴΤȤǤ. 
      !
      real(8), dimension((nm+1)*(nm+1),km), intent(in) :: wr
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),km)               :: wr_RotDRad_wr
      !(out) žưʬѤ줿ʿڥȥư³ʻǡ

      wr_RotDRad_wr = wr_wq(wq_RadDRad_wq(wq_wr(wr*wr_Rad)))/wr_Rad**2

    end function wr_RotDRad_wr

    function wq_RotDRad_wr(wr)
      !
      ! ϥڥȥǡ˲žưʬ
      !
      !      1/r (r.)/r = (.)/r + (.)/r
      !
      ! Ѥ.
      !
      ! ڥȥǡβžưʬȤ, бʻǡ
      ! žưʬѤǡΥڥȥѴΤȤǤ. 
      !
      real(8), dimension((nm+1)*(nm+1),km), intent(in) :: wr
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)               :: wq_RotDRad_wr
      !(out) žưʬѤ줿ʿڥȥư³ʻǡ

      wq_RotDRad_wr = wq_Rad2Inv_wq(wq_RadDRad_wq(wq_wr(wr*wr_Rad)))

    end function wq_RotDRad_wr

    function wq_Lapla_wq(wq)
      ! ϥڥȥǡ˥ץ饷
      !
      !     ^2 =   1/r^2 cos^2ա^2/ߦ^2 
      !            + 1/r^2 cosա/ߦ(cosբ/ߦ) 
      !            + 1/r^2 /r (r^2 /r) 
      !              [1/r^2 (r/r)(r/r) + 1/r^2(r/r)]
      !
      ! Ѥ.
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ. 
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wq_Lapla_wq
      !(out) ץ饷Ѥ줿ʿڥȥǡ

      wq_Lapla_wq = wq_Rad2Inv_wq(  wq_RadDRad_wq(wq_RadDRad_wq(wq)) &
                                  + wq_RadDRad_wq(wq)+ wa_Lapla_wa(wq) )

    end function wq_Lapla_wq

    function xyr_GradLon_wq(wq)
      !
      ! ڥȥǡ˸۷ʬ 1/rcosա/ߦ
      ! Ѥ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:im-1,1:jm,km)    :: xyr_GradLon_wq
      !(out) ۷ʬѤ줿 2 ڥȥǡ

      xyr_GradLon_wq = xya_GradLon_wa(wr_wq(wq))/xyr_Rad

    end function xyr_GradLon_wq

    function xyr_GradLat_wq(wq) 
      !
      ! ڥȥǡ˸۷ʬ 1/r /ߦ Ѥ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:im-1,1:jm,km)    :: xyr_GradLat_wq
      !(out) ۷ʬѤ줿 2 ڥȥǡ

      xyr_GradLat_wq = xya_GradLat_wa(wr_wq(wq))/xyr_Rad

    end function xyr_GradLat_wq

    function wr_DivLon_xyr(xyr)
      ! 
      ! ʻǡȯʬ 1/rcosա/ߦ Ѥ
      ! ڥȥǡ֤.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in)     :: xyr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension((nm+1)*(nm+1),km)         :: wr_DivLon_xyr
      !(out) ȯʬѤ줿ʿڥȥư³ʻǡ

      wr_DivLon_xyr = wa_DivLon_xya(xyr/xyr_Rad)

    end function wr_DivLon_xyr

    function wr_DivLat_xyr(xyr)
      !
      ! ʻҥǡȯʬ 1/rcosա(f cos)/ߦ 
      ! Ѥڥȥǡ֤.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in)     :: xyr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension((nm+1)*(nm+1),km)         :: wr_DivLat_xyr
      !(out) ȯʬѤ줿ʿڥȥư³ʻǡ

      wr_DivLat_xyr = wa_DivLat_xya(xyr/xyr_Rad)

    end function wr_DivLat_xyr

    function wr_Div_xyr_xyr_xyr(xyr_Vlon,xyr_Vlat,xyr_Vrad)
      !
      ! ٥ȥʬǤ 3 ĤγʻҥǡȯѤ
      ! ڥȥǡ֤.
      !
      !  1, 2 ,3 (u,v,w)줾٥ȥηʬ, ʬ, 
      ! ưʬɽ, ȯ 
      !
      !      1/rcosաu/ߦ + 1/rcosա(v cos)/ߦ 
      !    + 1/r^2 /r (r^2 w)
      !
      ! ȷ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_Vlon
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),km)     :: wr_Div_xyr_xyr_xyr
      !(out) ٥ȥȯ

      wr_Div_xyr_xyr_xyr =   wr_DivLon_xyr(xyr_Vlon) &
                           + wr_DivLat_xyr(xyr_Vlat) &
                           + wr_DivRad_xyr(xyr_Vrad)

    end function wr_Div_xyr_xyr_xyr

    function xyr_Div_xyr_xyr_xyr(xyr_Vlon,xyr_Vlat,xyr_Vrad)
      !
      ! ٥ȥʬǤ 3 ĤγʻҥǡȯѤ.
      !
      !  1, 2 ,3 (u,v,w)줾٥ȥηʬ, ʬ, 
      ! ưʬɽ.
      !
      ! ˤð򤹤뤿˥٥ȥ cos/r νŤߤ򤫤
      ! ׻Ƥ. 
      !
      !      div V = (r/cos)div (Vcos/r) + V_tan/r + V_r/r
      ! 
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_Vlon
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension(0:im-1,1:jm,km)             :: xyr_Div_xyr_xyr_xyr
      !(out) ٥ȥȯ

      xyr_Div_xyr_xyr_xyr &
           = xyr_Rad/cos(xyr_Lat) &
                * xyr_wr(wr_Div_xyr_xyr_xyr(xyr_VLon*cos(xyr_Lat)/xyr_Rad,  &
                                            xyr_VLat*cos(xyr_Lat)/xyr_Rad,  &
                                            xyr_VRad*cos(xyr_Lat)/xyr_Rad ))&
             + xyr_VLat*tan(xyr_Lat)/xyr_Rad &
             + xyr_VRad/xyr_Rad

    end function xyr_Div_xyr_xyr_xyr

    function xyr_RotLon_wq_wq(wq_Vrad,wq_Vlat) 
      !
      ! ٥ȥưʬ, ʬǤ 1, 2  Vrad, Vlat 
      ! žηʬ 
      !
      !    1/r Vrad/ߦ-1/r (r Vlat)/r ׻.
      !
      ! ׻
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jm,km)                 :: xyr_RotLon_wq_wq
      !(out) ٥ȥβžηʬ

        xyr_RotLon_wq_wq =   xyr_GradLat_wq(wq_Vrad) &
                           - xyr_wr(wr_RotDRad_wq(wq_Vlat))

    end function xyr_RotLon_wq_wq

    function xyr_RotLat_wq_wq(wq_Vlon,wq_Vrad) 
      !
      ! ٥ȥηʬ, ưʬǤ 1, 2  Vlon, Vrad 
      ! žΰʬ 
      !
      !    1/r (r Vlon)/r - 1/rcosաVrad/ߦ
      !
      ! ׻.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_Vlon
      !(in) ٥ȥηʬ

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension(0:im-1,1:jm,km)                 :: xyr_RotLat_wq_wq
      !(out) ٥ȥβžΰʬ

        xyr_RotLat_wq_wq =   xyr_wr(wr_RotDRad_wq(wq_Vlon)) &
                           - xyr_GradLon_wq(wq_Vrad) 

    end function xyr_RotLat_wq_wq

    function wr_RotRad_xyr_xyr(xyr_Vlat,xyr_Vlon) 
      !
      ! ٥ȥΰʬ, ʬǤ 1, 2  Vlat, Vlon Ф
      ! ٥ȥβžưʬ 
      !
      !    1/rcosաVlat/ߦ - 1/rcosա(Vlon cos)/ߦ
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_Vlon
      !(in) ٥ȥηʬ

      real(8), dimension((nm+1)*(nm+1),km)       :: wr_RotRad_xyr_xyr
      !(out) ٥ȥβžưʬ

        wr_RotRad_xyr_xyr =   wr_DivLon_xyr(xyr_Vlat) &
                            - wr_DivLat_xyr(xyr_Vlon)

    end function wr_RotRad_xyr_xyr

  !--------------- ʬ׻ -----------------
    !----(ϥǡ xyr)---
    function yr_IntLon_xyr(xyr)  ! (Ӿ)ʬ
      !
      ! 3 ʻǡη(Ӿ)ʬ.
      !
      ! 3 ǡ f(,,r) Ф f(,,r)d ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(1:jm,km)  :: yr_IntLon_xyr
      !(out) (Ӿ)ʬ줿 2 Ҹ̳ʻǡ

      integer :: i

      yr_IntLon_xyr = 0.0d0
      do i=0,im-1
         yr_IntLon_xyr(:,:) = yr_IntLon_xyr(:,:) &
                       + xyr(i,:,:) * x_Lon_Weight(i)
      enddo
    end function yr_IntLon_xyr

    function xr_IntLat_xyr(xyr)
      !
      ! 3 ʻǡΰʬ.
      !
      ! 3 ǡ f(,,r) ФƢf(,,r) cos d ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1,km)  :: xr_IntLat_xyr        
      !(out) ʬ줿 2 ư³ʻǡ
      ! ٱ߳ʻǡ

      integer :: j

      xr_IntLat_xyr = 0.0d0
      do j=1,jm
         xr_IntLat_xyr(:,:) = xr_IntLat_xyr(:,:) &
                       + xyr(:,j,:) * y_Lat_Weight(j)
      enddo

    end function xr_IntLat_xyr

    function xy_IntRad_xyr(xyr)  ! ưʬ
      !
      ! 3 ʻǡưʬ.
      !
      ! 3 ǡ f(,,r) ФƢf(,,r) r^2dr ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1,1:jm)  :: xy_IntRad_xyr
      !(out) ưʬ줿 2 ٰ(ʿ, )ʻǡ

      integer :: k

      xy_IntRad_xyr = 0.0d0
      do k=1,km
         xy_IntRad_xyr(:,:) = xy_IntRad_xyr(:,:) &
                       + xyr(:,:,k) * r_Rad_Weight(k) 
      enddo

    end function xy_IntRad_xyr

    function x_IntLatRad_xyr(xyr)
      !
      ! 3 ʻǡΰư(Ҹ)ʬ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) r^2cos ddr 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1)     :: x_IntLatRad_xyr
      !(out) ư(Ҹ)ʬ줿 1 ٳʻǡ

      integer :: j, k

      x_IntLatRad_xyr = 0.0D0
      do k=1,km
         do j=1,jm
            x_IntLatRad_xyr = x_IntLatRad_xyr &
                 + xyr(:,j,k) * y_Lat_Weight(j) * r_Rad_Weight(k)
         enddo
      enddo

    end function x_IntLatRad_xyr

    function y_IntLonRad_xyr(xyr)
      !
      ! 3 ʻǡηư(ٱ)ʬ.
      !
      ! 3 ǡ f(,,r) ФƢf(,,r) r^2ddr ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(1:jm)       :: y_IntLonRad_xyr
      !(out) ư(ٱ)ʬ줿 1 ٳʻǡ

      integer :: i, k

      y_IntLonRad_xyr = 0.0D0
      do k=1,km
         do i=0,im-1
            y_IntLonRad_xyr = y_IntLonRad_xyr &
                 + xyr(i,:,k) * x_Lon_Weight(i) * r_Rad_Weight(k)
         enddo
      enddo

    end function y_IntLonRad_xyr

    function r_IntLonLat_xyr(xyr)  ! ٷ(ʿ)ʬ
      !
      ! 3 ʻǡΰٷ(ʿ, )ʬ
      ! 
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) cos dd 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(km)     :: r_IntLonLat_xyr
      !(out) ٷ(ʿ, )ʬ줿 1 ư³ʻǡ

      integer :: i, j

      r_IntLonLat_xyr = 0.0D0
      do j=1,jm
         do i=0,im-1
            r_IntLonLat_xyr = r_IntLonLat_xyr &
                 + xyr(i,j,:) * x_Lon_Weight(i) * y_Lat_Weight(j)
         enddo
      enddo
    end function r_IntLonLat_xyr

    function IntLonLatRad_xyr(xyr) ! ٷư()ʬ
      !
      ! 3 ʻǡΰٷư()ʬ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !     f(,,r) r^2cos dddr 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr 
      !(in) 3 ٰư³ʻǡ

      real(8)                     :: IntLonLatRad_xyr 
      !(out) ʬ

      integer :: i, j, k

      IntLonLatRad_xyr = 0.0D0
      do k=1,km
         do j=1,jm
            do i=0,im-1
               IntLonLatRad_xyr = IntLonLatRad_xyr &
                    + xyr(i,j,k) * x_Lon_Weight(i) &
                         * y_Lat_Weight(j) * r_Rad_Weight(k)
            enddo
         enddo
      enddo

    end function IntLonLatRad_xyr

    !----(ϥǡ yr)---
    function r_IntLat_yr(yr)  ! ʬ
      !
      ! 2 (YR)ʻǡΰʬ.
      !
      ! 2 ǡ f(,r) ФƢf(,r) cos d ׻.
      !
      real(8), dimension(1:jm,km), intent(in) :: yr
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(km)  :: r_IntLat_yr
      !(out) ʬ줿 1 ư³ʻǡ

      integer :: j

      r_IntLat_yr = 0.0d0
      do j=1,jm
         r_IntLat_yr(:) = r_IntLat_yr(:) + yr(j,:) * y_Lat_Weight(j)
      enddo

    end function r_IntLat_yr

    function y_IntRad_yr(yr)  ! ưʬ
      !
      ! 2 (YR)ʻǡưʬ.
      !
      ! 2 ǡ f(,r) ФƢf(,r) r^2dr ׻.
      !
      real(8), dimension(1:jm,km), intent(in) :: yr
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(1:jm)  :: y_IntRad_yr
      !(out) ưʬ줿 1 ٳʻǡ

      integer :: k

      y_IntRad_yr = 0.0d0
      do k=1,km
         y_IntRad_yr(:) = y_IntRad_yr(:) &
                       + yr(:,k) * r_Rad_Weight(k) 
      enddo

    end function y_IntRad_yr

    function IntLatRad_yr(yr)
      !
      ! 2 (YR)ʻǡΰưʬ(Ҹ)ʿ
      !
      ! 2 ǡ f(,r) Ф f(,r) r^2cos ddr ׻.
      !
      real(8), dimension(1:jm,km), intent(in) :: yr
      !(in) 2 ư(Ҹ)ʻǡ

      real(8)                   :: IntLatRad_yr
      !(out) ʬ
      integer :: j, k

      IntLatRad_yr = 0.0D0
      do k=1,km
         do j=1,jm
            IntLatRad_yr = IntLatRad_yr &
                 + yr(j,k) * y_Lat_Weight(j) * r_Rad_Weight(k)
         enddo
      enddo

    end function IntLatRad_yr

    !----(ϥǡ xr)---
    function r_IntLon_xr(xr)
      !
      ! 2 (XR)ʻǡηʬ.
      !
      ! 2 ǡ f(,r) Ф f(,r)d ׻.
      !
      real(8), dimension(0:im-1,km), intent(in) :: xr
      !(in) 2 ư³ʻǡ

      real(8), dimension(km)  :: r_IntLon_xr
      !(out) ʬ줿 1 ư³ʻǡ

      integer :: i

      r_IntLon_xr = 0.0d0
      do i=0,im-1
         r_IntLon_xr(:) = r_IntLon_xr(:) + xr(i,:) * x_Lon_Weight(i)
      enddo

    end function r_IntLon_xr

    function x_IntRad_xr(xr)
      !
      ! 2 (XR)ʻǡưʬ.
      !
      ! 2 ǡ f(,r) Ф f(,r) r^2dr ׻.
      !
      real(8), dimension(0:im-1,km), intent(in) :: xr
      !(in) 2 ư³ʻǡ

      real(8), dimension(0:im-1)  :: x_IntRad_xr
      !(out) ưʬ줿 1 ٳʻǡ

      integer :: k

      x_IntRad_xr = 0.0d0
      do k=1,km
         x_IntRad_xr(:) = x_IntRad_xr(:) &
                       + xr(:,k) * r_Rad_Weight(k) 
      enddo

    end function x_IntRad_xr

    function IntLonRad_xr(xr)  ! ư(ٱ)ʬ
      !
      ! 2 (XR)ʻǡηưʬ
      !
      ! 2 ǡ f(,r) ФƢf(,r) r^2ddr ׻.
      !
      real(8), dimension(0:im-1,km), intent(in) :: xr
      !(in) 2 ư³ʻǡ

      real(8)                                 :: IntLonRad_xr
      !(out) ʬ

      integer :: i, k

      IntLonRad_xr = 0.0D0
      do k=1,km
         do i=0,im-1
            IntLonRad_xr = IntLonRad_xr &
                 + xr(i,k) * x_Lon_Weight(i) * r_Rad_Weight(k)
         enddo
      enddo

    end function IntLonRad_xr

    !----(ϥǡ z)---
    function IntRad_r(z)  ! ưʬ
      !
      ! 1 (Z)ʻǡưʬ.
      !
      ! 1 ǡ f(r) Ф f(r) r^2dr ׻.
      !
      real(8), dimension(km), intent(in) :: z
      !(in) 1 ư³ʻǡ

      real(8)                              :: IntRad_r
      !(out) ʬ

      integer :: k

      IntRad_r = 0.0d0
      do k=1,km
         IntRad_r = IntRad_r + z(k) * r_Rad_Weight(k) 
      enddo

    end function IntRad_r

  !--------------- ʿѷ׻ -----------------
    !----(ϥǡ xyr)---
    function yr_AvrLon_xyr(xyr)  ! (Ӿ)ʬ
      !
      ! 3 ʻǡη(Ӿ)ʿ.
      !
      ! 3 ǡ f(,,r) Ф f(,,r)d/2 ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(1:jm,km)  :: yr_AvrLon_xyr
      !(out) (Ӿ)ʿѤ줿 2 Ҹ̳ʻǡ

      yr_AvrLon_xyr = yr_IntLon_xyr(xyr)/sum(x_Lon_Weight)

    end function yr_AvrLon_xyr

    function xr_AvrLat_xyr(xyr)  ! ʬ
      !
      ! 3 ʻǡΰʿ.
      !
      ! 3 ǡ f(,,r) Ф f(,,r)cos d/2 ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1,km)  :: xr_AvrLat_xyr
      !(out) ʿѤ줿 2 ư³ʻǡ

      xr_AvrLat_xyr = xr_IntLat_xyr(xyr)/sum(y_Lat_Weight)

    end function xr_AvrLat_xyr

    function xy_AvrRad_xyr(xyr)
      !
      ! 3 ʻǡưʿ.
      !
      ! 3 ǡ f(,,r) Ф 
      !
      !    f(,,r) r^2dr/((r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1,1:jm)  :: xy_AvrRad_xyr          
      !(out) ưʿѤ줿 2 ٰ(ʿ, )ʻǡ
      ! ʿʻǡ

      xy_AvrRad_xyr = xy_IntRad_xyr(xyr)/sum(r_Rad_Weight)

    end function xy_AvrRad_xyr

    function x_AvrLatRad_xyr(xyr)  ! ư(Ҹ)ʬ
      !
      ! 3 ʻǡΰư(Ҹ)ʿ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) r^2cos ddr /(2(r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1)     :: x_AvrLatRad_xyr
      !(out) ư(Ҹ)ʿѤ줿 1 ٳʻǡ

      x_AvrLatRad_xyr = x_IntLatRad_xyr(xyr) &
                   /( sum(y_Lat_Weight)*sum(r_Rad_Weight) )

    end function x_AvrLatRad_xyr

    function y_AvrLonRad_xyr(xyr)  ! ư(ٱ)ʬ
      !
      ! 3 ʻǡηư(ٱ)ʿ.
      !
      ! 3 ǡ f(,,r) Ф
      !
      !     f(,,r) r^2ddr /(2(r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(1:jm)       :: y_AvrLonRad_xyr
      !(out) ư(ٱ)ʿѤ줿 1 ٳʻǡ

      y_AvrLonRad_xyr = y_IntLonRad_xyr(xyr) &
                 /(sum(x_Lon_Weight)*sum(r_Rad_Weight))

    end function y_AvrLonRad_xyr

    function r_AvrLonLat_xyr(xyr)  ! ٷ(ʿ)ʬ
      !
      ! 3 ʻǡΰٷ(ʿ, )ʬ
      ! 
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) cos dd /4 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(km)     :: r_AvrLonLat_xyr
      !(out) ٷ(ʿ, )ʿѤ줿 1 ư³ʻǡ

      r_AvrLonLat_xyr = r_IntLonLat_xyr(xyr) &
                 /(sum(x_Lon_Weight)*sum(y_Lat_Weight))

    end function r_AvrLonLat_xyr

    function AvrLonLatRad_xyr(xyr) ! ٷư()ʬ
      !
      ! 3 ʻǡΰٷư()ʬ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) r^2cos dddr /(4(r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr
      !(in) 3 ٰư³ʻǡ

      real(8)                     :: AvrLonLatRad_xyr
      !(out) ʿ

      AvrLonLatRad_xyr = IntLonLatRad_xyr(xyr) &
            /(sum(x_Lon_Weight)*sum(y_Lat_Weight) * sum(r_Rad_Weight))

    end function AvrLonLatRad_xyr

    !----(ϥǡ yr)---
    function r_AvrLat_yr(yr)
      !
      ! 2 (YR)ʻǡΰʿ.
      !
      ! 2 ǡ f(,r) Ф f(,r) cos d/2 ׻.
      !
      real(8), dimension(1:jm,km), intent(in) :: yr
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(km)  :: r_AvrLat_yr
      !(out) ʿѤ줿 1 ư³ʻǡ

      r_AvrLat_yr = r_IntLat_yr(yr)/sum(y_Lat_Weight)

    end function r_AvrLat_yr

    function y_AvrRad_yr(yr)
      !
      ! 2 (YR)ʻǡưʿ.
      !
      ! 2 ǡ f(,r) Ф f(,r) r^2dr /((r[o]^3-r[i]^3)/3) 
      ! ׻.
      !
      real(8), dimension(1:jm,km), intent(in) :: yr
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(1:jm)  :: y_AvrRad_yr
      !(out) ưʿѤ줿 1 ٳʻǡ

      y_AvrRad_yr = y_IntRad_yr(yr)/sum(r_Rad_Weight)

    end function y_AvrRad_yr

    function AvrLatRad_yr(yr)  ! ư(Ҹ)ʬ
      !
      ! 2 (YR)ʻǡΰư(Ҹ)ʿ
      !
      ! 2 ǡ f(,r) Ф
      !
      !    f(,r) r^2cos ddr /(2(r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(1:jm,km), intent(in) :: yr
      !(in) 2 ư(Ҹ)ʻǡ

      real(8)                   :: AvrLatRad_yr
      !(out) ʿ

      AvrLatRad_yr = IntLatRad_yr(yr)/(sum(y_Lat_Weight)*sum(r_Rad_Weight))

    end function AvrLatRad_yr

    !----(ϥǡ xr)---
    function r_AvrLon_xr(xr)  ! (Ӿ)ʬ
      !
      ! 2 (XR)ʻǡηʿ.
      !
      ! 2 ǡ f(,r) Ф f(,r)d/2 ׻.
      !
      real(8), dimension(0:im-1,km), intent(in) :: xr
      !(in) 2 ư³ʻǡ

      real(8), dimension(km)  :: r_AvrLon_xr 
      !(out) ʿѤ줿 1 ư³ʻǡ

      r_AvrLon_xr = r_IntLon_xr(xr)/sum(x_Lon_Weight)

    end function r_AvrLon_xr

    function x_AvrRad_xr(xr)  ! ưʬ
      !
      ! 2 (XR)ʻǡưʿ.
      !
      ! 2 ǡ f(,r) Ф
      !
      !   f(,r) r^2dr /((r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,km), intent(in) :: xr
      !(in) 2 ư³ʻǡ

      real(8), dimension(0:im-1)  :: x_AvrRad_xr
      !(out) ưʿѤ줿 1 ٳʻǡ

      x_AvrRad_xr = x_IntRad_xr(xr)/sum(r_Rad_Weight)

    end function x_AvrRad_xr

    function AvrLonRad_xr(xr)  ! ư(ٱ)ʬ
      !
      ! 2 (XR)ʻǡηưʿ
      !
      ! 2 ǡ f(,r) Ф 
      ! 
      !    f(,r) r^2ddr /(2(r[o]^3-r[i]^3)/3)
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,km), intent(in) :: xr
      ! (in) 2 ʻǡ
      real(8)                                 :: AvrLonRad_xr      
      ! ʬ

      AvrLonRad_xr = IntLonRad_xr(xr)/(sum(x_Lon_Weight)*sum(r_Rad_Weight))

    end function AvrLonRad_xr

    !----(ϥǡ z)---
    function AvrRad_r(z)
      !
      ! 1 (Z)ʻǡưʿ.
      !
      ! 1 ǡ f(r) Ф f(r) r^2dr /((r[o]^3-r[i]^3)/3) 
      ! ׻.
      !
      real(8), dimension(0:im-1,km), intent(in) :: z
      !(in) 1 ư³ʻǡ
      real(8)                                 :: AvrRad_r
      !(out) ʿ

      AvrRad_r = IntRad_r(z)/sum(r_Rad_Weight)

    end function AvrRad_r

  !--------------- ݥ/ȥǥʬ -----------------

    function wq_KxRGrad_wq(wq)
      !
      ! ϥڥȥǡ˷ʬ kr = /ߦˤѤ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wq_KxRGrad_wq
      !(out) ʬѤ줿 2 ڥȥǡ

      wq_KxRGrad_wq =  wa_Dlon_wa(wq)

    end function wq_KxRGrad_wq

    function xyr_KGrad_wq(wq)    ! k = cos/r /ߦ + sinբ/r
      !
      ! ϥڥȥǡбʻҥǡ˼ʬ 
      !
      !    k = cos/r /ߦ + sinբ/r 
      !
      ! Ѥʻҥǡ֤. 
      ! ǥ٥ȥ k ϵ濴̶˸ñ̥٥ȥǤ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:im-1,1:jm,km)                 :: xyr_KGrad_wq
      !(out) ʬѤ줿 2 ڥȥǡ

      xyr_KGrad_wq =  cos(xyr_Lat)*xyr_GradLat_wq(wq) &
                    + sin(xyr_Lat)*xyr_wq(wq_RadDRad_wq(wq))/xyr_Rad

    end function xyr_KGrad_wq

    function wq_L2_wq(wq)
      !
      ! ϥڥȥǡ L^2 黻(=-ʿץ饷)Ѥ.
      !
      ! L^2 黻Ҥñ̵̾οʿץ饷εˤ. 
      !  ϥڥȥ бʻǡ˱黻 
      !
      !     L^2 = -1/cos^2ա^2/ߦ^2 - 1/cosա/ߦ(cosբ/ߦ)
      !
      ! ѤǡΥڥȥѴ֤.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wq_L2_wq
      !(out) L^2 黻ҤѤ줿 2 ڥȥǡ

      wq_L2_wq = -wa_Lapla_wa(wq)

    end function wq_L2_wq

    function wq_L2Inv_wq(wq)
      !
      ! ϥڥȥǡ L^2 黻Ҥεձ黻(-տʿץ饷)
      ! Ѥ.
      !
      ! ڥȥǡ L^2 黻ҤѤؿ wq_L2_wq εշ׻
      ! ԤؿǤ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wq_L2Inv_wq
      !(out) L^2 黻Ҥεձ黻Ѥ줿 2 ڥȥǡ

      wq_L2Inv_wq = -wa_LaplaInv_wa(wq)

    end function wq_L2Inv_wq

    function wq_QOperator_wq(wq)
      !
      ! ϥڥȥǡбʻǡ˱黻 
      !
      !    Q=(k-1/2(L2 k+ kL2)) 
      !
      ! ѤǡΥڥȥѴ֤.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wq_QOperator_wq
      !(out) Q 黻ҤѤ줿 2 ڥȥǡ

      wq_QOperator_wq = &
             wq_xyr(xyr_KGrad_wq(wq) - xyr_KGrad_wq(wq_L2_wq(wq))/2) &
           - wq_L2_wq(wq_xyr(xyr_KGrad_wq(wq)))/2

    end function wq_QOperator_wq

    function wr_RadRot_xyr_xyr(xyr_VLON,xyr_VLAT)  ! r(v)
      !
      ! ٥ȥα٤ư¥٥ȥ r(v) ׻.
      !
      !  1, 2 (v[], v[])줾٥ȥηʬ, ʬɽ.
      !
      !    r(v) = 1/cosաv[]/ߦ - 1/cosա(v[] cos)/ߦ
      !
      ! Υڥȥ ǡ֤.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_VLON
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_VLAT
      !(in) ٥ȥΰʬ

      real(8), dimension((nm+1)*(nm+1),km)     :: wr_RadRot_xyr_xyr
      !(out) ٥ȥα٤ư¥٥ȥ

      wr_RadRot_xyr_xyr = wa_DivLon_xya(xyr_VLAT) - wa_DivLat_xya(xyr_VLON)
      
    end function wr_RadRot_xyr_xyr

    function wr_RadRotRot_xyr_xyr_xyr(xyr_VLON,xyr_VLAT,xyr_VRAD) 
      ! 
      ! ٥ȥ v Ф r(ߢv) ׻.
      !
      !  1, 2, 3 (v[], v[], v[r])줾٥ȥηʬ, 
      ! ʬ, ưʬɽ. 
      !
      !    r(ߢv)  = 1/r /r (r( 1/cosաv[]/ߦ 
      !                                  + 1/cosա(v[] cos)/ߦ ) ) 
      !                     + L^2 v[r]/r 
      !
      ! Υڥȥǡ֤.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_VLON
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_VLAT
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_VRAD
      !(in) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),km)     :: wr_RadRotRot_xyr_xyr_xyr
      !(out) ٥ȥ v  r(ߢv) 

      wr_RadRotRot_xyr_xyr_xyr = &
                   wr_RotDRad_wr( &
                      wa_DivLon_xya(xyr_VLON)+ wa_DivLat_xya(xyr_VLAT)) &
             - wa_Lapla_wa(wr_xyr(xyr_VRAD/xyr_RAD))

    end function wr_RadRotRot_xyr_xyr_xyr

    function wq_RadRotRot_xyr_xyr_xyr(xyr_VLON,xyr_VLAT,xyr_VRAD) 
      ! 
      ! ٥ȥ v Ф r(ߢv) ׻.
      !
      !  1, 2, 3 (v[], v[], v[r])줾٥ȥηʬ, 
      ! ʬ, ưʬɽ. 
      !
      !    r(ߢv)  = 1/r /r (r( 1/cosաv[]/ߦ 
      !                                  + 1/cosա(v[] cos)/ߦ ) ) 
      !                     + L^2 v[r]/r 
      !
      ! Υڥȥǡ֤.
      !
      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_VLON
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_VLAT
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jm,km), intent(in) :: xyr_VRAD
      !(in) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),0:lm)     :: wq_RadRotRot_xyr_xyr_xyr
      !(out) ٥ȥ v  r(ߢv) 

      wq_RadRotRot_xyr_xyr_xyr = &
                   wq_RotDRad_wr( &
                      wa_DivLon_xya(xyr_VLON)+ wa_DivLat_xya(xyr_VLAT)) &
             - wa_Lapla_wa(wq_xyr(xyr_VRAD/xyr_RAD))

    end function wq_RadRotRot_xyr_xyr_xyr

    subroutine wq_Potential2Vector(&
         xyr_VLON,xyr_VLAT,xyr_VRAD,wq_TORPOT,wq_POLPOT)
      !
      ! ȥݥݥƥ󥷥릷,ɽȯ٥ȥ
      !
      !     v = x(r) + xx(r) 
      !
      ! γʬ׻
      !
      real(8), dimension(0:im-1,1:jm,km)     :: xyr_VLON
      !(out) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jm,km)     :: xyr_VLAT
      !(out) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jm,km)     :: xyr_VRAD
      !(out) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_TORPOT
      !(in) ȥݥƥ󥷥

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_POLPOT
      !(in) ݥݥƥ󥷥

      xyr_VLON =   xyr_RAD * xyr_GradLat_wq(wq_TORPOT) &
                 + xya_GradLon_wa(wr_RotDRad_wq(wq_POLPOT))
      xyr_VLAT = - xyr_RAD * xyr_GradLon_wq(wq_TORPOT) &
                 + xya_GradLat_wa(wr_RotDRad_wq(wq_POLPOT))
      xyr_VRAD = xyr_wq(wq_L2_wq(wq_POLPOT))/xyr_RAD

    end subroutine wq_Potential2Vector

    subroutine wq_Potential2Rotation(&
       xyr_RotVLON,xyr_RotVLAT,xyr_RotVRAD,wq_TORPOT,wq_POLPOT)
      !
      ! ȥݥݥƥ󥷥릷,ɽȯ٥ȥ
      !
      !     v = x(r) + xx(r) 
      !
      ! Ф, βž
      !
      !     xv = xx(r) + xxx(r) = xx(r) - x((^2)r)
      !
      ! ׻. 
      
      ! ٥ȥβž
      real(8), dimension(0:im-1,1:jm,km), intent(OUT) :: xyr_RotVLON
      !(out) žηʬ

      real(8), dimension(0:im-1,1:jm,km), intent(OUT) :: xyr_RotVLAT
      !(out) žΰʬ

      real(8), dimension(0:im-1,1:jm,km), intent(OUT) :: xyr_RotVRAD
      !(out) žưʬ

      ! ϥ٥ȥɽݥƥ󥷥
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_TORPOT
      !(in) ȥݥƥ󥷥

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_POLPOT
      !(in) ݥݥƥ󥷥

      call wq_Potential2Vector( &
           xyr_RotVLON,xyr_RotVLAT,xyr_RotVRAD, &
           -wq_Lapla_wq(wq_POLPOT), wq_TORPOT)

    end subroutine wq_Potential2Rotation

  !--------------- ݥ/ȥǥѥڥȥ ----------------

    function nmr_ToroidalEnergySpectrum_wq(wq_TORPOT)
      !
      ! ȥݥƥ󥷥뤫, ȥ륨ͥ륮
      ! Ĵȡȿ n, Ӿȿ m γʬ׻
      !
      !  * ȿ n, Ӿȿ m Υȥݥƥ󥷥Υڥȥʬ
      !    (n,m,r)ȿ n, Ӿȿ m ʬΥȥ륨ͥ륮
      !    ڥȥ  (1/2)n(n+1)4r^2|(n,m,r)|^2  ȷ׻.
      !
      !  * ƤΥͥ륮ڥȥʬ¤ưʬ(r^2νŤ̵)
      !    Ǥͥ륮.
      !    
      !  * ǡ¸ߤʤȿ n, Ӿȿ m ˤϷ»ͤǼ.
      !    wq_VMiss ˤäǤ (ͤ -999.0)
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_TORPOT
      !(in) ȥݥƥ󥷥

      real(8), dimension(0:nm,-nm:nm,km) :: nmr_ToroidalEnergySpectrum_wq
      !(out) ͥ륮ڥȥȥʬ

      real(8), dimension((nm+1)*(nm+1),km) ::wr_DATA   ! ΰ
      integer :: n, m

      nmr_ToroidalEnergySpectrum_wq = wq_VMiss

      wr_DATA = wr_wq(wq_TORPOT)

      do n=0,nm
         nmr_ToroidalEnergySpectrum_wq(n,0,:) &
              = 0.5 * n*(n+1)* (4*pi) * r_Rad**2 &
                * wr_DATA(l_nm(n,0),:)**2
         do m=1,n
            nmr_ToroidalEnergySpectrum_wq(n,m,:) &
              = 0.5 * n*(n+1)* (4*pi) * r_Rad**2 &
                * (wr_DATA(l_nm(n,m),:)**2+wr_DATA(l_nm(n,-m),:)**2)
            nmr_ToroidalEnergySpectrum_wq(n,-m,:) &
                 = nmr_ToroidalEnergySpectrum_wq(n,m,:) 
         enddo
      enddo

    end function nmr_ToroidalEnergySpectrum_wq

    function nr_ToroidalEnergySpectrum_wq(wq_TORPOT)
      !
      ! ȥݥƥ󥷥뤫, ȥ륨ͥ륮
      ! Ĵȡȿγʬ׻.
      !
      !  * ȿ n, Ӿȿ m Υȥݥƥ󥷥Υڥȥʬ
      !    (n,m,r)ȿ n ʬΥȥ륨ͥ륮ڥȥ
      !    [m=-n]^n(1/2)n(n+1)4r^2|(n,m,r)|^2 ȷ׻.
      !
      ! * ƤΥͥ륮ڥȥʬ¤ưʬ(r^2νŤ̵)
      !    Ǥͥ륮.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_TORPOT
      !(in) ȥݥƥ󥷥

      real(8), dimension(0:nm,km) :: nr_ToroidalEnergySpectrum_wq 
      !(out) ͥ륮ڥȥȥʬ

      real(8), dimension((nm+1)*(nm+1),km) ::wr_DATA   ! ΰ
      integer :: n, m

      wr_DATA = wr_wq(wq_TORPOT)
      do n=0,nm
         nr_ToroidalEnergySpectrum_wq(n,:) &
              = 0.5 * n*(n+1)* (4*pi) * r_Rad**2 * wr_Data(l_nm(n,0),:)**2
         do m=1,n
            nr_ToroidalEnergySpectrum_wq(n,:) &
                 = nr_ToroidalEnergySpectrum_wq(n,:) &
                 + 0.5 * n*(n+1)* (4*pi) * r_Rad**2  &
                 * 2* (wr_Data(l_nm(n,m),:)**2 + wr_Data(l_nm(n,-m),:)**2)
         enddo
      enddo

    end function nr_ToroidalEnergySpectrum_wq

    function nmr_PoloidalEnergySpectrum_wq(wq_POLPOT)
      !
      ! ݥݥƥ󥷥뤫, ݥ륨ͥ륮
      ! Ĵȡȿ n, Ӿȿ m γʬ׻.
      !
      !  * ȿ n, Ӿȿ m Υݥݥƥ󥷥Υڥȥʬ
      !    (n,m,r)ȿ n, Ӿȿ m ʬΥݥ륨ͥ륮
      !    ڥȥ 
      !
      !      (1/2)n(n+1)4{|d(r(n,m,r))/dr|^2 + n(n+1)|(n,m,r)|^2} 
      !
      !    ȷ׻.
      !
      !  * ƤΥͥ륮ڥȥʬ¤ưʬ(r^2νŤ̵)
      !    Ǥͥ륮.
      !
      !  * ǡ¸ߤʤȿ n, Ӿȿ m ˤϷ»ͤǼ.
      !    »ͤͤϥ⥸塼ѿ wq_VMiss ˤäǤ
      !    (ͤ -999.0)
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_POLPOT
      !(in) ݥݥƥ󥷥

      real(8), dimension(0:nm,-nm:nm,km) :: nmr_PoloidalEnergySpectrum_wq 
      !(out) ͥ륮ڥȥݥʬ


      real(8), dimension((nm+1)*(nm+1),km) ::wr_DATA1   ! ΰ
      real(8), dimension((nm+1)*(nm+1),km) ::wr_DATA2   ! ΰ
      integer :: n, m

      nmr_PoloidalEnergySpectrum_wq = wq_VMiss

      wr_Data1 = wr_wq(wq_POLPOT)
      wr_Data2 = wr_wq(wq_RadDRad_wq(wq_POLPOT)+wq_POLPOT)  ! d(r)/dr
                                                            ! = rd/dr+

      do n=0,nm
         nmr_PoloidalEnergySpectrum_wq(n,0,:) = &
                 + 0.5* n*(n+1)* (4*pi) &
                 *( wr_Data2(l_nm(n,0),:)**2  &
                   + n*(n+1)*wr_Data1(l_nm(n,0),:)**2 )
         do m=1,n
            nmr_PoloidalEnergySpectrum_wq(n,m,:) = &
                 + 0.5* n*(n+1)* (4*pi) &
                 *( wr_Data2(l_nm(n,m),:)**2 + wr_Data2(l_nm(n,-m),:)**2 &
                 + n*(n+1)* ( wr_Data1(l_nm(n,m),:)**2 + wr_Data1(l_nm(n,-m),:)**2))
            nmr_PoloidalEnergySpectrum_wq(n,-m,:) = &
                 nmr_PoloidalEnergySpectrum_wq(n,m,:)
         enddo
      enddo

    end function nmr_PoloidalEnergySpectrum_wq

    function nr_PoloidalEnergySpectrum_wq(wq_POLPOT)
      !
      ! ݥݥƥ󥷥뤫, ݥ륨ͥ륮
      ! Ĵȡȿγʬ׻
      !
      !  * ȿ n, Ӿȿ m Υݥݥƥ󥷥Υڥȥʬ
      !    (n,m,r)ȿ n ʬΥݥ륨ͥ륮ڥȥ
      !
      !      [m=-n]^n ((1/2)n(n+1)4{|d(r(n,m,r))/dr|^2 
      !                 + n(n+1)|(n,m,r)|^2} 
      !
      !    ȷ׻.
      !
      !  * ƤȿФƤΥͥ륮ڥȥʬ¤ưʬ
      !    (r^2νŤ̵)Ǥͥ륮.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_POLPOT
      !(in) ݥݥƥ󥷥

      real(8), dimension(0:nm,km) :: nr_PoloidalEnergySpectrum_wq
      !(out) ͥ륮ڥȥݥʬ

      real(8), dimension((nm+1)*(nm+1),km) ::wr_DATA1   ! ΰ
      real(8), dimension((nm+1)*(nm+1),km) ::wr_DATA2   ! ΰ
      integer :: n, m

      wr_Data1 = wr_wq(wq_POLPOT)
      wr_Data2 = wr_wq(wq_RadDRad_wq(wq_POLPOT)+wq_POLPOT)  ! d(r)/dr
                                                            ! = rd/dr+

      do n=0,nm
         nr_PoloidalEnergySpectrum_wq(n,:) &
              = 0.5* n*(n+1)* (4*pi) &
              *( wr_Data2(l_nm(n,0),:)**2  + n*(n+1)*wr_Data1(l_nm(n,0),:)**2 )
         do m=1,n
            nr_PoloidalEnergySpectrum_wq(n,:) &
                 = nr_PoloidalEnergySpectrum_wq(n,:) &
                 + 2 * 0.5* n*(n+1)* (4*pi) &
                 *( wr_Data2(l_nm(n,m),:)**2 + wr_Data2(l_nm(n,-m),:)**2 &
                 + n*(n+1)*(wr_Data1(l_nm(n,m),:)**2 +wr_Data1(l_nm(n,-m),:)**2))
         enddo
      enddo

    end function nr_PoloidalEnergySpectrum_wq

  !---------------  -----------------

    subroutine wq_BoundaryTau(wq,value,cond)
      !
      ! ڥȥǡ˥ǥꥯ졦Υޥ󶭳ŬѤ
      ! Chebyshev ֤ǤζŬ(ˡ)
      !
      ! ӥն֤ˤƶ٤⼡η
      ! ˡȤäƤ(ˡ).
      !
      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)      :: wq
              !(inout) ŬѤǡ. 줿֤ͤ. 

      real(8), dimension((nm+1)*(nm+1)), intent(in), optional   :: value
              !(in) Ǥ / ʬۤʿڥȥѴΤͿ. 
              !     ά/ 0 Ȥʤ. 

      character(len=1), intent(in), optional                    :: cond
              !(in) . ά 'D'
              !        D : ¦ǥꥯ
              !        N : ¦Υޥ

      if (.not. present(cond)) then
         if (present(value)) then
            call aq_BoundaryTau_D(wq,value)
         else
            call aq_BoundaryTau_D(wq)
         endif
         return
      endif

      select case(cond)
      case ('N')
         if (present(value)) then
            call aq_BoundaryTau_N(wq,value)
         else
            call aq_BoundaryTau_N(wq)
         endif
      case ('D')
         if (present(value)) then
            call aq_BoundaryTau_D(wq,value)
         else
            call aq_BoundaryTau_D(wq)
         endif
      case default
         call MessageNotify('E','wq_BoundaryTau','B.C. not supported')
      end select

    end subroutine wq_BoundaryTau

    subroutine wr_BoundaryGrid(wr,value,cond)
      !
      ! ڥȥǡ˥ǥꥯ졦Υޥ󶭳ŬѤ
      ! ¶֤ǤζŬ
      !
      ! ľ³ʻ֤ˤΰͤȶ褦
      ! ݤƤ(ˡ). 
      !
      real(8), dimension((nm+1)*(nm+1),km),intent(inout)      :: wr
              !(inout) ŬѤǡ. 줿֤ͤ. 

      real(8), dimension((nm+1)*(nm+1)), intent(in), optional   :: value
              !(in) Ǥ / ʬۤʿڥȥѴΤͿ. 
              !    ά/ 0 Ȥʤ. 

      character(len=1), intent(in), optional             :: cond
              !(in) . ά 'D'
              !        D : ¦ǥꥯ
              !        N : ¦Υޥ

      if (.not. present(cond)) then
         if (present(value)) then
            call ag_BoundaryGrid_D(wr,value)
         else
            call ag_BoundaryGrid_D(wr)
         endif
         return
      endif

      select case(cond)
      case ('N')
         if (present(value)) then
            call ag_BoundaryGrid_N(wr,value)
         else
            call ag_BoundaryGrid_N(wr)
         endif
      case ('D')
         if (present(value)) then
            call ag_BoundaryGrid_D(wr,value)
         else
            call ag_BoundaryGrid_D(wr)
         endif
      case default
         call MessageNotify('E','wr_BoundaryGrid','B.C. not supported')
      end select

    end subroutine wr_BoundaryGrid

    subroutine wq_TorBoundaryTau(wq_TORPOT,value,cond,new) 
      !
      ! ®٥ȥݥƥ󥷥ФƶŬѤ. 
      ! Chebyshev ֤ǤζŬ. 
      !
      ! ®٥ȥݥƥ󥷥릷ФͿ붭
      !
      !   * Ǵ :  = b(lon,lat). b ϶̤Ǥ®ʬ. 
      !                                   default  0(Ż߾).
      !
      !   * Ϥʤ : (/r)/r = 0.
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)      :: wq_TORPOT
              !(inout) ŬѤǡ. 줿֤ͤ. 

      real(8), dimension((nm+1)*(nm+1)), intent(in), optional :: value
              !(in) ξüǤΥȥݥƥ󥷥
              !     ǴλΤͭ

      character(len=1), intent(in), optional  :: cond
              !(in) 凉å. ά 'R'
              !     R    : ¦Ǵ
              !     F    : ¦Ϥʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp
      real(8), dimension((nm+1)*(nm+1),0:lm)  :: wq_data
      real(8), dimension((nm+1)*(nm+1),km)    :: wr_data
      logical                                 :: rigid        ! 

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: n, l, lend
      save    :: alu, kp, first

      if (.not. present(cond)) then
         rigid=.TRUE.
      else
         select case (cond)
         case ('R')
            rigid = .TRUE.
         case ('F')
            rigid = .FALSE.
         case default
            call MessageNotify('E','wq_TorBoundaryTau','B.C. not supported')
         end select
      endif

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu((nm+1)*(nm+1),0:lm,0:lm),kp((nm+1)*(nm+1),0:lm))

         alu = 0.0D0
         do l=0,lm
            alu(:,l,l)=1.0D0
         enddo

         ! ϳŪ

         do l=0,lm
            wq_data = 0.0 ; wq_data(:,l) = 1.0D0

            if ( rigid ) then          ! ϳŪǴ
               wr_data = wr_wq(wq_data)
            else                       ! ϳŪＫͳ٤
               wr_data = wr_wq(wq_RadDRad_wq(wq_data)- wq_data)/wr_Rad
            endif

            do n=1,(nm+1)**2
               if ( mod(nd(n),2) .eq. mod(lm,2) ) then
                  alu(n,lm,l) = wr_data(n,km)
               else
                  alu(n,lm-1,l) = wr_data(n,km)
               endif
            end do
         enddo

         ! طʤȤ 0 .
         do n=1,(nm+1)**2
            if ( mod(nd(n),2) .eq. mod(lm,2) ) then
               lend = lm
            else
               lend = lm-1
            endif

            do l=0,nd(n)-1
               alu(n,lend,l) = 0.0D0
            enddo
            do l=nd(n)+1,lm,2
               alu(n,lend,l) = 0.0D0
            enddo
         enddo

         call ludecomp(alu,kp)

         if ( rigid .AND. present(value) ) then 
            call MessageNotify('M','wq_TorBoundaryTau',&
                 'Toroidal potential at k=km was given by the optional variable.')
         else if ( rigid .AND. (.NOT.present(value)) ) then
            call MessageNotify('M','wq_TorBoundaryTau',&
                 'Toroidal potential at k=km was set to zero.')
         else if ( (.NOT. rigid) .AND. present(value) ) then
            call MessageNotify('W','wq_TorBoundaryTau',&
                 'Boundary value k=km cannot be set under stress-free condition.')
         endif

         call MessageNotify('M','wq_TorBoundaryTau',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      do n=1,(nm+1)**2
         if ( mod(nd(n),2) .eq. mod(lm,2) ) then
            lend = lm
         else
            lend = lm-1
         endif

         if ( rigid .AND. present(value) ) then
            wq_torpot(n,lend) = value(n)
         else
            wq_torpot(n,lend) = 0.0D0
         endif
      enddo

      wq_torpot = lusolve(alu,kp,wq_TORPOT)

    end subroutine wq_TorBoundaryTau

    subroutine wr_TorBoundaryGrid(wr_TORPOT,value,cond,new) 
      !
      ! ®٥ȥݥƥ󥷥ФƶŬѤ.
      ! ¶֤ǤζŬ
      !
      ! ľ³ʻ֤ˤΰͤȶ褦
      ! ݤƤ(ˡ). 
      !
      ! ®٥ȥݥƥ󥷥릷ФͿ붭
      !
      !   * Ǵ :  = b(lon,lat). b ϶̤Ǥ®ʬ. 
      !                                   default  0 (Ż߾).
      !
      !   * Ϥʤ : (/r)/r = 0.
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension((nm+1)*(nm+1),km),intent(inout)    :: wr_TORPOT
              !(inout) ŬѤǡ. 줿֤ͤ. 

      real(8), dimension((nm+1)*(nm+1)), intent(in), optional :: value
              !(in) ξüǤΥȥݥƥ󥷥
              !     ǴλΤͭ

      character(len=1), intent(in), optional  :: cond
              !(in) 凉å. ά 'R'
              !     R    : ¦Ǵ
              !     F    : ¦Ϥʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp
      real(8), dimension((nm+1)*(nm+1),0:lm)  :: wq_data
      real(8), dimension((nm+1)*(nm+1),km)    :: wr_data
      logical                                 :: rigid   ! 

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: k
      save    :: alu, kp, first

      if (.not. present(cond)) then
         rigid=.TRUE.
      else
         select case (cond)
         case ('R')
            rigid = .TRUE.
         case ('F')
            rigid = .FALSE.
         case default
            call MessageNotify('E','wr_TorBoundaryGrid','B.C. not supported')
         end select
      endif

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu((nm+1)*(nm+1),km,km),kp((nm+1)*(nm+1),km))

         alu = 0.0D0
         do k=1,km
            wr_data = 0.0D0
            wr_data(:,k)=1.0D0
            alu(:,:,k) = wr_data
         enddo

         if ( .not. rigid ) then
            do k=1,km
               wr_data = 0.0D0
               wr_data(:,k)=1.0D0
               wq_data = wq_wr(wr_data)
               wr_data = wr_wq(wq_RadDRad_wq(wq_data) - wq_data)/wr_Rad
               alu(:,km,k) = wr_data(:,km)
            enddo
         endif

         call ludecomp(alu,kp)

         if ( rigid .AND. present(value) ) then 
            call MessageNotify('M','wr_TorBoundaryGrid',&
                 'Toroidal potential at k=km was given by the optional variable.')
         else if ( rigid .AND. (.NOT.present(value)) ) then
            call MessageNotify('M','wr_TorBoundaryGrid',&
                 'Toroidal potential at k=km was set to zero.')
         else if ( (.NOT. rigid) .AND. present(value) ) then
            call MessageNotify('W','wr_TorBoundaryGrid',&
                 'Boundary value at k=km cannot be set under stress-free condition.')
         endif

         call MessageNotify('M','wr_TorBoundaryGrid',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      if ( rigid .AND. present(value) ) then
         wr_TorPot(:,km)  = value
      else
         wr_TorPot(:,km)  = 0.0D0
      endif

      wr_TorPot = lusolve(alu,kp,wr_TorPot)

    end subroutine wr_TorBoundaryGrid

    function wq_LaplaPol2PolTau_wq(wq,cond,new)
      !
      ! ®٥ݥݥƥ󥷥릵^2׻.
      !
      ! ڥȥ֤ǶŬѤƤ(ˡ). 
      !
      ! ®٥ݥݥƥ󥷥릵 f = ^2뼰
      !
      !   ^2 = f
      !      = const. at Boundary.
      !     ߦ/r = 0 at Boundary           (Ǵ) 
      !     or ^2/r^2 = 0 at Boundary    (Ϥʤ)
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm),intent(in)  :: wq
              !(in) Ϣ^2ʬ

      real(8), dimension((nm+1)*(nm+1),0:lm)  :: wq_LaplaPol2PolTau_wq
              !(out) ϥݥݥƥ󥷥ʬ

      character(len=1), intent(in), optional  :: cond
              !(in) 凉å. ά 'R'
              !     R    : ¦Ǵ
              !     F    : ¦Ϥʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu     ! ΰ׻
      integer, dimension(:,:), allocatable    :: kp      ! ΰ׻

      real(8), dimension(:,:,:), allocatable  :: alub    ! ׻
      integer, dimension(:,:), allocatable    :: kpb     ! ׻

      real(8), dimension((nm+1)*(nm+1),km)    :: wr_work
      real(8), dimension((nm+1)*(nm+1),0:lm)  :: wq_work
      logical                                 :: rigid   ! 

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: l,n, lend
      save    :: alu, kp, first
      save    :: alub, kpb

      if (.not. present(cond)) then
         rigid=.TRUE. 
      else
         select case (cond)
         case ('R')
            rigid = .TRUE.
         case ('F')
            rigid = .FALSE.
         case default
            call MessageNotify('E','wq_laplapol2pol_wq','B.C. not supported')
         end select
      endif

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         if ( allocated(alub) ) deallocate(alub)
         if ( allocated(kpb) ) deallocate(kpb)
         allocate(alu((nm+1)*(nm+1),0:lm,0:lm),kp((nm+1)*(nm+1),0:lm))
         allocate(alub((nm+1)*(nm+1),0:lm,0:lm),kpb((nm+1)*(nm+1),0:lm))


         !---- ΰ׻ѹ -----
         do l=0,lm
            wq_work = 0.0
            wq_work(:,l) = 1.0D0
            alu(:,:,l) = wq_Lapla_wq(wq_work)
         enddo

         ! 0 ʬΤȤ 1 .
         do n=1,(nm+1)**2
            do l=0,nd(n)-1
               alu(n,l,l) = 1.0D0
            enddo
            do l=nd(n)+1,lm,2
               alu(n,l,l) = 1.0D0
            enddo
         enddo

         ! alu(:,:,nd(n))  0 ʤΤ 1 򤤤Ƥ. 
         ! l=nd(n) ʬ϶Ƿ. 
         do n=1,(nm+1)**2
            if ( mod(nd(n),2) .eq. mod(lm,2) ) then
               alu(n,lm,nd(n)) = 1.0D0
            else
               alu(n,lm-1,nd(n)) = 1.0D0
            endif
         enddo

         call ludecomp(alu,kp)

         !---- ׻ѹ -----

         alub = 0.0D0
         do l=0,lm
            alub(:,l,l) = 1.0D0
         enddo

         do l=0,lm
            wq_work=0.0D0 ; wq_work(:,l)=1.0D0
            wr_work = wr_wq(wq_work)

            ! ưŪ. ή϶ǰ
            !     l=nd(n) ʬ򶭳Ƿ. 
            do n=1,(nm+1)**2
               alub(n,nd(n),l) = wr_work(n,km)
            enddo

            ! ϳŪǴ 
            !     l=lend ʬ򶭳Ƿ. 
            if ( rigid ) then
               wr_work=wr_wq(wq_RadDRad_wq(wq_work))/wr_Rad
            else
               wr_work=wr_wq(wq_RadDRad_wq(wq_RadDRad_wq(wq_work)) &
                                           -wq_RadDRad_wq(wq_work) )&
                            /wr_Rad**2
            endif
            
            do n=1,(nm+1)**2
               if ( mod(nd(n),2) .eq. mod(lm,2) ) then
                  lend = lm
               else
                  lend = lm-1
               endif
               alub(n,lend,l) = wr_work(n,km)
            enddo
         enddo

         ! طʤȤ 0 .
         do n=1,(nm+1)**2
            if ( mod(nd(n),2) .eq. mod(lm,2) ) then
               lend = lm
            else
               lend = lm-1
            endif

            do l=0,nd(n)-1
               alub(n,nd(n),l) = 0.0D0
               alub(n,lend,l) = 0.0D0
            enddo
            do l=nd(n)+1,lm,2
               alub(n,nd(n),l) = 0.0D0
               alub(n,lend,l) = 0.0D0
            enddo
         enddo

         call ludecomp(alub,kpb)

         if ( rigid ) then
            call MessageNotify('M','wq_LaplaPol2PolTau_wq',&
                              'Matrix to apply rigid b.c. newly produced.')
         else
            call MessageNotify('M','wq_LaplaPol2PolTau_wq',&
                              'Matrix to apply stress-free b.c. newly produced.')
         endif
      endif

      ! ΰ׻
      wq_work = wq

      wq_work = lusolve(alu,kp,wq_work)

      ! ׻
      do n=1,(nm+1)**2
         wq_work(n,nd(n)) = 0
         if ( mod(nd(n),2) .eq. mod(lm,2) ) then
            wq_work(n,lm)   = 0
         else
            wq_work(n,lm-1) = 0
         endif
      enddo

      wq_laplapol2polTau_wq = lusolve(alub,kpb,wq_work)

    end function wq_LaplaPol2PolTau_wq

    function wr_LaplaPol2Pol_wr(wr,cond,new)
      !
      ! ®٥ݥݥƥ󥷥릵^2׻.
      !
      ! ʻ֤ǶŬѤƤ. 
      !
      ! ®٥ݥݥƥ󥷥릵 f = ^2뼰
      !
      !   ^2 = f
      !      = const. at Boundary.
      !     ߦ/r = 0 at Boundary           (Ǵ) 
      !     or ^2/r^2 = 0 at Boundary    (Ϥʤ)
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      !  : δؿϴƤʤ. Ѷػ. 
      !
      real(8), dimension((nm+1)*(nm+1),km),intent(in)  :: wr
              !(in) Ϣ^2ʬ

      real(8), dimension((nm+1)*(nm+1),km)         :: wr_LaplaPol2Pol_wr
              !(out) ϥݥݥƥ󥷥ʬ

      character(len=1), intent(in), optional  :: cond
              !(in) 凉å. ά 'R'
              !     R    : ¦Ǵ
              !     F    : ¦Ϥʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(:,:,:), allocatable  :: alub
      integer, dimension(:,:), allocatable    :: kpb

      real(8), dimension((nm+1)*(nm+1),km)    :: wr_work
      logical                                 :: rigid   ! 

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: k
      save    :: alu, kp, first
      save    :: alub, kpb

      if (.not. present(cond)) then
         rigid=.TRUE. 
      else
         select case (cond)
         case ('R')
            rigid = .TRUE.
         case ('F')
            rigid = .FALSE.
         case default
            call MessageNotify('E','wr_laplapol2pol_wr','B.C. not supported')
         end select
      endif

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu((nm+1)*(nm+1),0:lm,0:lm),kp((nm+1)*(nm+1),0:lm))

         if ( allocated(alub) ) deallocate(alub)
         if ( allocated(kpb) ) deallocate(kpb)
         allocate(alub((nm+1)*(nm+1),km,km),kpb((nm+1)*(nm+1),km))

         !---- ΰ׻ѹ -----
         do k=1,km
            wr_work = 0.0D0 ; wr_work(:,k) = 1.0D0

            ! ƿʿȿ˴ؤΩμ
            alu(:,:,k) = wr_wq(wq_Lapla_wq(wq_wr(wr_work)))
         enddo

         do k=1,km
            wr_work=0.0D0 ; wr_work(:,k)=1.0D0
            alu(:,km,k)  = wr_work(:,km)
         enddo


         !---- ׻ ----
         alub = 0.0D0
         do k=1,km
            alub(:,k,k) = 1.0D0
         enddo

         ! ưŪ. ή϶ǰ
         !   k=km ͤ
         do k=1,km
            wr_work=0.0D0 ; wr_work(:,k)=1.0D0
            alub(:,km,k)  = wr_work(:,km)
         enddo

         ! ϳŪǴ 
         !   k=km-1 ͤ
         if ( rigid ) then
            do k=1,km
               wr_work = 0.0D0 ; wr_work(:,k) = 1.0D0
               wr_work=wr_wq(wq_RadDRad_wq(wq_wr(wr_work)))/wr_Rad
               alub(:,km-1,k) = wr_work(:,km)
            enddo
         else
            do k=1,km
               wr_work = 0.0D0 ; wr_work(:,k) = 1.0D0
               wr_work=wr_wq(wq_RadDRad_wq(wq_RadDRad_wq(wq_wr(wr_work))) &
                                          -wq_RadDRad_wq(wq_wr(wr_work)))&
                       /wr_Rad**2
               alub(:,km-1,k) = wr_work(:,km)
            enddo
         endif

         call ludecomp(alub,kpb)

         if ( rigid ) then
            call MessageNotify('M','wr_LaplaPol2Pol_wr',&
                              'Matrix to apply rigid b.c. newly produced.')
         else
            call MessageNotify('M','wr_LaplaPol2Pol_wr',&
                              'Matrix to apply stress-free b.c. newly produced.')
         endif
      endif

      wr_work         = wr
      wr_work         = lusolve(alu,kp,wr_work)

      wr_work(:,km-1) = 0.0D0               ! ϳŪ
      wr_work(:,km)   = 0.0D0               ! ưŪ

      wr_laplapol2pol_wr = lusolve(alub,kpb,wr_work)

    end function wr_LaplaPol2Pol_wr

    subroutine wq_TormagBoundaryTau(wq_TOR,new)
      
      ! ȥݥƥ󥷥ФƶŬѤ.
      ! Chebyshev ֤ǤζŬ
      !
      ! ӥն֤ˤƶ٤⼡ηˡ
      ! ȤäƤ(ˡ). ߤΤȤʪŵƳΤξΤ
      ! бƤ. ξ, ȥݥƥ󥷥ζ
      !
      ! ¦
      !    wq_psi = 0   at the outer boundary
      ! 
      ! Ǥ뤫 wq_Boundary бǽ, ΤӺƤ.
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)   :: wq_TOR
              !(inout) ŬѤǡ. 줿֤ͤ. 

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(:,:), allocatable    :: wq_I
      real(8), dimension(:,:), allocatable    :: wr_PSI

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: n, l, lend
      save    :: alu, kp, first

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         if ( allocated(wq_I) ) deallocate(wq_I)
         if ( allocated(wr_PSI) ) deallocate(wr_PSI)
         allocate(alu((nm+1)*(nm+1),0:lm,0:lm),kp((nm+1)*(nm+1),0:lm))
         allocate(wq_I((nm+1)*(nm+1),0:lm),wr_PSI((nm+1)*(nm+1),km))

         alu = 0.0D0
         do l=0,lm
            alu(:,l,l) = 1.0D0
         enddo

         do l=0,lm
            wq_I = 0.0 ; wq_I(:,l) = 1.0
            ! ŵƳ
            wr_PSI = wr_wq(wq_I)

            do n=1,(nm+1)**2
               if ( mod(nd(n),2) .eq. mod(lm,2) ) then
                  alu(n,lm,l) = wr_Psi(n,km)
                  lend = lm
               else
                  alu(n,lm-1,l) = wr_Psi(n,km)
               endif
            enddo
         enddo

         ! طʤȤ 0 .
         do n=1,(nm+1)**2
            if ( mod(nd(n),2) .eq. mod(lm,2) ) then
               lend = lm
            else
               lend = lm-1
            endif

            do l=0,nd(n)-1
               alu(n,lend,l) = 0.0D0
            enddo
            do l=nd(n)+1,lm,2
               alu(n,lend,l) = 0.0D0
            enddo
         enddo

         call ludecomp(alu,kp)

         deallocate(wq_I,wr_PSI)

         call MessageNotify('M','TormagBoundaryTau',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      do n=1,(nm+1)**2
         if ( mod(nd(n),2) .eq. mod(lm,2) ) then
            wq_TOR(n,lm)   = 0.0
         else
            wq_TOR(n,lm-1) = 0.0
         endif
      enddo
      wq_TOR = lusolve(alu,kp,wq_TOR)

    end subroutine wq_TormagBoundaryTau

    subroutine wr_TormagBoundaryGrid(wr_TOR,new)
      !
      ! ȥݥƥ󥷥ФƶŬѤ.
      ! ľ¶֤ǤζŬ.
      !
      ! ľ³ʻ֤ˤΰͤȶ褦
      ! ݤƤ(ˡ). 
      !
      ! ߤΤȤʪŵƳΤξΤбƤ. 
      ! ξ, ȥݥƥ󥷥ζ
      !
      ! ¦
      !    wq_psi = 0   at the outer boundary
      ! 
      ! ǤΤ wq_Boundary бǽ, ΤӺƤ
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension((nm+1)*(nm+1),km),intent(inout)   :: wr_TOR
              !(inout) ŬѤǡ. 줿֤ͤ. 
      
      logical, intent(IN), optional :: new
              !(in) (ߡ) true ȶ׻ѹŪ˿˺.
              !     default  false.

      wr_TOR(:,km)  = 0.0D0

    end subroutine wr_TormagBoundaryGrid

    subroutine wq_PolmagBoundaryTau(wq_POL,new)
      !
      ! ݥݥƥ󥷥ФƶŬѤ.
      ! Chebyshev ֤ǤζŬ
      !
      ! ӥն֤ˤƶ٤⼡ηˡ
      ! ȤäƤ(ˡ). ߤΤȤʪŵƳΤξΤ
      ! бƤ. ξ, ݥݥƥ󥷥γƿʿڥȥ
      ! ʬ h ˤƶ郎Ϳ,
      !
      !  * ¦ : dh/dr + (n+1)h/r = 0
      !
      ! Ǥ.  n  h οʿȿǤ. 
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)   :: wq_POL
              !(inout) ŬѤǡ. 줿֤ͤ. 

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(:,:), allocatable    :: wq_I
      real(8), dimension(:,:), allocatable    :: wr_PSI
      real(8), dimension(:,:), allocatable    :: wr_DPSIDR

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer  :: l, n, nn(2), lend
      save     :: alu, kp, first

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         if ( allocated(wq_I) ) deallocate(wq_I)
         if ( allocated(wr_PSI) ) deallocate(wr_PSI)
         if ( allocated(wr_DPSIDR) ) deallocate(wr_DPSIDR)

         allocate(alu((nm+1)*(nm+1),0:lm,0:lm),kp((nm+1)*(nm+1),0:lm))
         allocate(wq_I((nm+1)*(nm+1),0:lm))
         allocate(wr_PSI((nm+1)*(nm+1),km),wr_DPSIDR((nm+1)*(nm+1),km))

         alu = 0.0D0
         do l=0,lm
            alu(:,l,l) = 1.0D0
         enddo

         ! ŵƳ
         do l=0,lm
            wq_I = 0.0D0  ; wq_I(:,l) = 1.0D0
            wr_PSI = wr_wq(wq_I)
            wr_DPSIDR = wr_wq(wq_RadDRad_wq(wq_I))/wr_Rad

            do n=1,(nm+1)**2
               if ( mod(nd(n),2) .eq. mod(lm,2) ) then
                  lend = lm
               else
                  lend = lm-1
               endif
               nn=nm_l(n)
               alu(n,lend,l) = wr_DPSIDR(n,km) + (nn(1)+1) * wr_PSI(n,km)/r_RAD(km)
            enddo
         enddo

         ! طʤȤ 0 .
         do n=1,(nm+1)**2
            if ( mod(nd(n),2) .eq. mod(lm,2) ) then
               lend = lm
            else
               lend = lm-1
            endif

            do l=0,nd(n)-1
               alu(n,lend,l) = 0.0D0
            enddo
            do l=nd(n)+1,lm,2
               alu(n,lend,l) = 0.0D0
            enddo
         enddo

         call ludecomp(alu,kp)

         deallocate(wq_I,wr_PSI,wr_DPSIDR)

         call MessageNotify('M','PolmagBoundaryTau',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      do n=1,(nm+1)**2
         if ( mod(nd(n),2) .eq. mod(lm,2) ) then
            wq_POL(n,lm)   = 0.0
         else
            wq_POL(n,lm-1) = 0.0
         endif
      enddo
      wq_POL = lusolve(alu,kp,wq_POL)

    end subroutine wq_PolmagBoundaryTau

    subroutine wr_PolmagBoundaryGrid(wr_POL,new)
      !
      ! ݥݥƥ󥷥ФƶŬѤ.
      ! ľ¶֤ǤζŬ. 
      !
      ! ľ³ʻ֤ˤΰͤȶ褦
      ! ݤƤ(ˡ). 
      !
      ! ߤΤȤʪŵƳΤξΤбƤ. 
      ! ξ, ݥݥƥ󥷥γƿʿڥȥʬ h 
      ! ƶ郎Ϳ,
      !
      !  * ¦ : dh/dr + (n+1)h/r = 0
      !
      ! Ǥ.  n  h οʿȿǤ. 
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension((nm+1)*(nm+1),km),intent(inout)   :: wr_POL
              !(inout) ŬѤǡ. 줿֤ͤ. 

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(:,:), allocatable    :: wr_I
      real(8), dimension(:,:), allocatable    :: wr_PSI
      real(8), dimension(:,:), allocatable    :: wr_DPSIDR

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer  :: k, n, nn(2)
      save     :: alu, kp, first

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         if ( allocated(wr_I) ) deallocate(wr_I)
         if ( allocated(wr_PSI) ) deallocate(wr_PSI)
         if ( allocated(wr_DPSIDR) ) deallocate(wr_DPSIDR)

         allocate(alu((nm+1)*(nm+1),km,km),kp((nm+1)*(nm+1),km))
         allocate(wr_I((nm+1)*(nm+1),km))
         allocate(wr_PSI((nm+1)*(nm+1),km),wr_DPSIDR((nm+1)*(nm+1),km))

         do k=1,km
            wr_I = 0.0D0
            wr_I(:,k)=1.0D0
            alu(:,:,k) = wr_I                 ! ΰͤΤޤ.
         enddo

         ! ŵƳ
         do k=1,km
            wr_I = 0.0D0
            wr_I(:,k) = 1.0D0
            wr_PSI = wr_I
            wr_DPSIDR = wr_wq(wq_RadDRad_wq(wq_wr(wr_I)))/wr_Rad

            do n=1,(nm+1)*(nm+1)
               nn=nm_l(n)
               alu(n,km,k) = wr_DPSIDR(n,km) + (nn(1)+1) * wr_PSI(n,km)/r_RAD(km)
            enddo
         end do

         call ludecomp(alu,kp)

         deallocate(wr_I,wr_PSI,wr_DPSIDR)

         call MessageNotify('M','PolmagBoundaryGrid',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      wr_POL(:,km)  = 0.0D0
      wr_POL = lusolve(alu,kp,wr_POL)

    end subroutine wr_PolmagBoundaryGrid

end module wq_module_sjpack
