!-----------------------------------------------------------------------
! Copyright (c) 2008-2011 SPMODEL Development GroupAll rights reserved.
!-----------------------------------------------------------------------
!
!ɽ  wtu_module ƥȥץ :: ѴؿΥƥ
!
!  2008/01/13  ݹ
!      2008/07/05  ʿ ѹ
!      2011/08/18  ʿ use dc_test
!
program wtu_test_base

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wtu_module
  implicit none

  integer,parameter  :: im=32, jm=16         ! ʻ(, )
  integer,parameter  :: kmo=16, kmi=8        ! ʻ(ư, ư)
  integer,parameter  :: nm=10                ! ȿ(ʿ)
  integer,parameter  :: lmo=16, lmi=8        ! ȿ(ư,ư)
  real(8),parameter  :: ri=0.5D0, ro=1.5D0   ! ⳰Ⱦ

  real(8), dimension((nm+1)**2,0:lmo)    ::  wt_data
  real(8), dimension(0:im-1,1:jm,0:kmo)  ::  xyz_data
  real(8), dimension(0:im-1,1:jm,0:kmo)  ::  xyz_xi
  real(8), dimension((nm+1)**2,0:lmi)    ::  wu_data
  real(8), dimension(0:im-1,1:jm,0:kmi)  ::  xyr_data
  real(8), dimension(0:im-1,1:jm,0:kmi)  ::  xyr_xi
  real(8), parameter                     ::  eps = 1.0D-10
  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11
  real(8), parameter :: pi=3.1415926535897932385D0

  call MessageNotify('M','wtu_test_base', &
                         'wtu_module basic transformation functions tests')

  call wtu_Initial(im,jm,kmi,kmo,nm,lmi,lmo,ri,ro)

!===================== ΰΥƥ =========================
  call MessageNotify('M','wtu_test_base', &
       'Tests of transformation functions for a spherical shell')

  xyz_xi = (xyz_Rad - (ro+ri)/2)*2/(ro-ri)

  !---- Y_1^* Υƥ ----
  xyz_data = sqrt(3.0D0)*sin(xyz_Lat)*xyz_xi        ! Y_1^0 T_1
  wt_data= 0.0D0 ; wt_data(l_nm(1,0),1)=1.0D0

  call check2d(wt_data, wt_xyz(xyz_data), &
    'transform test of Y_1^0 T_1')

  call check3d(xyz_data, xyz_wt(wt_xyz(xyz_data)), &
    'inverse transform test of Y_1^0 T_1')

  xyz_data = sqrt(3.0D0/2)*cos(xyz_Lat)*cos(xyz_Lon)     ! Y_1^1 T_0
  wt_data= 0.0D0 ;  wt_data(l_nm(1,1),0)=1.0D0/sqrt(2.0D0)*2

  call check2d(wt_data, wt_xyz(xyz_data), &
    'transform test of Y_1^1 T_0')

  call check3d(xyz_data, xyz_wt(wt_xyz(xyz_data)), &
    'inverse transform test of Y_1^1 T_0')

  xyz_data = -sqrt(3.0D0/2)*cos(xyz_Lat)*sin(xyz_Lon)*(2*xyz_xi**2-1) !Y_1^{-1}T_2
  wt_data= 0.0D0 ;  wt_data(l_nm(1,-1),2)=1.0D0/sqrt(2.0D0)

  call check2d(wt_data, wt_xyz(xyz_data), &
    'transform test of Y_1^-1 T_2')

  call check3d(xyz_data, xyz_wt(wt_xyz(xyz_data)), &
    'inverse transform test of Y_1^-1 T_2')

  !---- Y_2^* Υƥ ----
  ! Y_2^0 T_3
  xyz_data = sqrt(5.0D0)*(3.0/2*sin(xyz_Lat)**2-1/2.0)*(4*xyz_xi**3-3*xyz_xi)
  wt_data= 0.0D0 ; wt_data(l_nm(2,0),3)=1.0D0

  call check2d(wt_data, wt_xyz(xyz_data), &
    'transform test of Y_2^0 T_3')

  call check3d(xyz_data, xyz_wt(wt_xyz(xyz_data)), &
    'inverse transform test of Y_2^0 T_3')

  !Y_2^1 T_4
  xyz_data = sqrt(5.0D0/6)*3.0*sin(xyz_Lat)*cos(xyz_Lat)*cos(xyz_Lon) &
            *(8*xyz_xi**4 - 8*xyz_xi**2 + 1 )
  wt_data= 0.0D0 ; wt_data(l_nm(2,1),4)=1.0D0/sqrt(2.0D0)

  call check2d(wt_data, wt_xyz(xyz_data), &
    'transform test of Y_2^1 T_4')

  call check3d(xyz_data, xyz_wt(wt_xyz(xyz_data)), &
    'inverse transform test of Y_2^1 T_4')

  ! Y_2^-2
  xyz_data = -sqrt(5.0D0/24)*3.0*cos(xyz_Lat)**2*sin(2*xyz_Lon) &
            *(16*xyz_xi**5-20*xyz_xi**3+5*xyz_xi)
  wt_data= 0.0D0 ; wt_data(l_nm(2,-2),5)=1.0D0/sqrt(2.0D0)

  call check2d(wt_data, wt_xyz(xyz_data), &
    'transform test of Y_2^-2 T_5')

  call check3d(xyz_data, xyz_wt(wt_xyz(xyz_data)), &
    'inverse transform test of Y_2^-2 T_5')

  !---- ŪؿΥƥ ----
  xyz_data = cos(2*xyz_Lon-pi/3) &
       *(sin(xyz_Lat)-1)**2*(sin(xyz_Lat)-0.5)*(sin(xyz_Lat)+1) &
       *exp(xyz_Rad)

  call check3d(xyz_data, xyz_wt(wt_xyz(xyz_data)), &
    'transform test of general function')

  call MessageNotify('M','Test of genral function', &
       'Test of general function succeeded!')

!===================== ΰΥƥ =========================
  call MessageNotify('M','wtu_test_base', &
       'Tests of transformation functions for a sphere')

  xyr_xi = 2*(xyr_Rad/ri)**2 - 1.0D0

  !---- Y_1^* Υƥ ----
  xyr_data = sqrt(3.0D0)*sin(xyr_Lat)*xyr_xi*xyr_Rad        ! Y_1^0 T_1
  wu_data= 0.0D0 ; wu_data(l_nm(1,0),1)=1.0D0


  call check2d(wu_data, wu_xyr(xyr_data), &
    'transform test of Y_1^0 T_1')

  call check3d(xyr_data, xyr_wu(wu_xyr(xyr_data)), &
    'inverse transform test of Y_1^0 T_1')

  xyr_data = sqrt(3.0D0/2)*cos(xyr_Lat)*cos(xyr_Lon)*xyr_Rad   ! Y_1^1 T_0
  wu_data= 0.0D0 ;  wu_data(l_nm(1,1),0)=1.0D0/sqrt(2.0D0)

  call check2d(wu_data, wu_xyr(xyr_data), &
    'transform test of Y_1^1 T_0')

  call check3d(xyr_data, xyr_wu(wu_xyr(xyr_data)), &
    'inverse transform test of Y_1^1 T_0')

  !Y_1^{-1}T_2
  xyr_data = -sqrt(3.0D0/2)*cos(xyr_Lat)*sin(xyr_Lon) &
               *(2*xyr_xi**2-1)*xyr_Rad
  wu_data= 0.0D0 ;  wu_data(l_nm(1,-1),2)=1.0D0/sqrt(2.0D0)

  call check2d(wu_data, wu_xyr(xyr_data), &
    'transform test of Y_1^-1 T_2')

  call check3d(xyr_data, xyr_wu(wu_xyr(xyr_data)), &
    'inverse transform test of Y_1^-1 T_2')

  !---- Y_2^* Υƥ ----
  ! Y_2^0 T_3
!!$  xyr_data = sqrt(5.0D0)*(3.0/2*sin(xyr_Lat)**2-1/2.0) &
!!$               *(4*xyr_xi**3-3*xyr_xi) * xyr_Rad**2
  xyr_data = sqrt(5.0D0)*(3.0/2*sin(xyr_Lat)**2-1/2.0) &
               *(4*xyr_xi**3-3*xyr_xi)
  wu_data= 0.0D0 ; wu_data(l_nm(2,0),3)=1.0D0

  call check2d(wu_data, wu_xyr(xyr_data), &
    'transform test of Y_2^0 T_3')

  call check3d(xyr_data, xyr_wu(wu_xyr(xyr_data)), &
    'inverse transform test of Y_2^0 T_3')

  !Y_2^1 T_4
!!$  xyr_data = sqrt(5.0D0/6)*3.0*sin(xyr_Lat)*cos(xyr_Lat)*cos(xyr_Lon) &
!!$            *(8*xyr_xi**4 - 8*xyr_xi**2 + 1 )* xyr_Rad**2
  xyr_data = sqrt(5.0D0/6)*3.0*sin(xyr_Lat)*cos(xyr_Lat)*cos(xyr_Lon) &
            *(8*xyr_xi**4 - 8*xyr_xi**2 + 1 )
  wu_data= 0.0D0 ; wu_data(l_nm(2,1),4)=1.0D0/sqrt(2.0D0)

  call check2d(wu_data, wu_xyr(xyr_data), &
    'transform test of Y_2^1 T_4')

  call check3d(xyr_data, xyr_wu(wu_xyr(xyr_data)), &
    'inverse transform test of Y_2^1 T_4')


  ! Y_2^-2
!!$  xyr_data = -sqrt(5.0D0/24)*3.0*cos(xyr_Lat)**2*sin(2*xyr_Lon) &
!!$            *(16*xyr_xi**5-20*xyr_xi**3+5*xyr_xi)* xyr_Rad**2
  xyr_data = -sqrt(5.0D0/24)*3.0*cos(xyr_Lat)**2*sin(2*xyr_Lon) &
            *(16*xyr_xi**5-20*xyr_xi**3+5*xyr_xi)
  wu_data= 0.0D0 ; wu_data(l_nm(2,-2),5)=1.0D0/sqrt(2.0D0)

  call check2d(wu_data, wu_xyr(xyr_data), &
    'transform test of Y_2^-2 T_5')

  call check3d(xyr_data, xyr_wu(wu_xyr(xyr_data)), &
    'inverse transform test of Y_2^-2 T_5')

  !---- ŪؿΥƥ ----
  xyr_data = cos(2*xyr_Lon-pi/3) &
       *(sin(xyr_Lat)-1)**2*(sin(xyr_Lat)-0.5)*(sin(xyr_Lat)+1) &
       *exp(xyr_Rad)

  call check3d(xyr_data, xyr_wu(wu_xyr(xyr_data)), &
    'transform test of general function')

  call MessageNotify('M','wtu_test_base', &
                         'wtu_base_module functions tests succeeded!')

contains
  subroutine check2d(sol, ans, mess)
    real(8) :: sol(:,:)
    real(8) :: ans(:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message = mess,                                           &
      answer = ans,                                             &
      check = sol,                                              &
      significant_digits = check_digits, ignore_digits = ignore &
      )

  end subroutine check2d

  subroutine check3d(sol, ans, mess)
    real(8) :: sol(:,:,:)
    real(8) :: ans(:,:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message = mess,                                           &
      answer = ans,                                             &
      check = sol,                                              &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check3d

end program wtu_test_base
