!------------------------------------------------------------------------
! Copyright(c) 2002-2011 SPMODEL Development Group. All rights reserved.!
!------------------------------------------------------------------------
!
!ɽ  wt_module ƥȥץ
!
!      wr_RotRad_wu Υƥ (1/r d/dr r)
!      wr_DivRad_wu Υƥ (1/r^2 d/dr r^2)
!
!  2008/01/01  ݹ
!      2008/06/28  ʿ  ѹ
!      2011/03/11  ʿ dc_test Ѥ褦˽
!
program wu_test_derivative1

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wu_module
  implicit none

  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=16         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=1.5d0             ! Ⱦ

  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_Data
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_Data1
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_xi
  ! Ƚ
  integer, parameter :: check_digits = 9
  integer, parameter :: ignore = -9
  integer, parameter :: nmin=3, nmax=10
  integer :: n

  call MessageNotify('M','wt_test_derivative1', &
       'wt_module derivative function test #1')

  call wu_Initial(im,jm,km,nm,lm,ra)

  write( 6,* ) 'Test for wr_RotRad_wu (even mode)'
  do n=nmin+1,nmax,2
     write(6,*) 'Test of n=',n
     xyr_Data = xyr_Rad**n
     xyr_Data1 = (n+1)*xyr_Rad**(n-1)
     xyr_Data = xyr_wr(wr_RotRad_wu(wu_xyr(xyr_Data)))
     call check3d(xyr_Data1, xyr_Data, 'RotRad Derivative')
  enddo

  write( 6,* ) 'Test for wr_RotRad_wu (odd mode)'
  do n=nmin,nmax,2
     write(6,*) 'Test of n=',n
     xyr_Data = xyr_Rad**n*cos(xyr_Lat)*sin(xyr_Lon)
     xyr_Data1 = (n+1)*xyr_Rad**(n-1)*cos(xyr_Lat)*sin(xyr_Lon)
     xyr_Data = xyr_wr(wr_RotRad_wu(wu_xyr(xyr_Data)))
     call check3d(xyr_Data1, xyr_Data, 'RotRad Derivative')
  enddo

  write( 6,* ) 'Test for wr_DivRad_wu(odd mode)'
  do n=nmin,nmax,2
     write(6,*) 'Test of n=',n
     xyr_Data = xyr_Rad**n * cos(xyr_Lat)*sin(xyr_Lon)
     xyr_Data1 = (n+2)*xyr_Rad**(n-1)*cos(xyr_Lat)*sin(xyr_Lon)
     xyr_Data = xyr_wr(wr_DivRad_wu(wu_xyr(xyr_Data)))
     call check3d(xyr_Data1, xyr_Data, 'RotRad Derivative')
  enddo

  write( 6,* ) 'Test for wr_DivRad_wu(even mode)'
  do n=nmin+1,nmax,2
     write(6,*) 'Test of n=',n
     xyr_Data = xyr_Rad**n
     xyr_Data1 = (n+2)*xyr_Rad**(n-1)
     xyr_Data = xyr_wr(wr_DivRad_wu(wu_xyr(xyr_Data)))
     call check3d(xyr_Data1, xyr_Data, 'RotRad Derivative')
  enddo
  call MessageNotify('M','wu_test_derivative1', &
       'wu_module derivative function test 1 succeeded!')

contains

  subroutine check3d(sol, ans, mess)
    real(8) :: sol(:,:,:)
    real(8) :: ans(:,:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message = mess,                                           &
      answer = ans,                                             &
      check = sol,                                              &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check3d

end program wu_test_derivative1
