/*
 *    clckst (written in C)
 *
 *    Copyright (C) 2000-2004 GFD Dennou Club. All rights reserved.
 *
 */

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include "../../../config.h"

#define TRUE   1             /* numeric value for true  */
#define FALSE  0             /* numeric value for false */

#ifndef CLOCKS_PER_SEC
#define CLOCKS_PER_SEC CLK_PER_SEC
#endif

#ifndef CLK_TCK
#define CLK_TCK CLK_RSL_TCK
#endif

static int lfirst = TRUE;
static clock_t time0;

void clckst_(void)
{
    time0 = clock();
    lfirst = FALSE;
}

void clckgt_(DCL_REAL *time)
{
    if (lfirst){
	fprintf (stderr, "*** Error in clckgt : ");
	fprintf (stderr, "Clckst must be called prior to this routine.\n");
	exit(1);
    }
    else{
	*time = (float) (clock() - time0) / (float) CLOCKS_PER_SEC;
    }
}

void clckdt_(DCL_REAL *dt0)
{
    *dt0 = 1.0 / CLK_TCK;
}
