#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "ruby.h"

#define RVAL2GOBJ(obj)  (rbgobj_instance_from_ruby_object(obj))
#define GOBJ2RVAL(gobj) (rbgobj_ruby_object_from_instance(gobj))

extern gpointer rbgobj_instance_from_ruby_object(VALUE obj);
extern VALUE rbgobj_ruby_object_from_instance(gpointer instance);


static VALUE
dcl_zgsdrw(self, drawable)
     VALUE self, drawable;
{
  extern void zgsdrw_(GtkWidget*);

  zgsdrw_( GTK_WIDGET(RVAL2GOBJ(drawable)) );

  return Qnil;
}

static VALUE
dcl_zgspmp(self, pixmap)
     VALUE self, pixmap;
{
  extern void zgspmp_(GdkPixmap*);

  GdkPixmap *c_pixmap = RVAL2GOBJ(pixmap);
  g_object_ref(G_OBJECT(c_pixmap));
  zgspmp_( (c_pixmap) );

  return Qnil;
}

static VALUE
dcl_zgqdrw(self)
     VALUE self;
{
  extern GtkWidget *zgqdrw_(void);

  return GOBJ2RVAL(zgqdrw_());

}

static VALUE
dcl_zgqpmp(self)
     VALUE self;
{
  extern GdkPixmap *zgqpmp_(void);

  return GOBJ2RVAL(zgqpmp_());

}

static VALUE
r_gtk_version(self)
     VALUE self;
{
  return rb_ary_new3(3,
		     INT2NUM(gtk_major_version),
		     INT2NUM(gtk_minor_version),
		     INT2NUM(gtk_micro_version));
}


void
Init_gtk()
{

  VALUE mNumRu, mDCLExt;

  rb_require("gtk2");
  rb_require("numru/dcl");

  mNumRu = rb_define_module("NumRu");
  mDCLExt = rb_define_module_under(mNumRu, "DCLExt");
  

  rb_define_module_function(mDCLExt, "gtk_version", r_gtk_version, 0);

  rb_define_module_function(mDCLExt, "zgsdrw", dcl_zgsdrw, 1);
  rb_define_module_function(mDCLExt, "zgspmp", dcl_zgspmp, 1);

  rb_define_module_function(mDCLExt, "zgqdrw", dcl_zgqdrw, 0);
  rb_define_module_function(mDCLExt, "zgqpmp", dcl_zgqpmp, 0);

}

