!--
!----------------------------------------------------------------------
!     Copyright (c) 2009 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wa_deriv_module_sjpack
!
!  spml/wa_deriv_module_sjpack ⥸塼ϵ̾Ǥήαư
!  ĴȡѤڥȥˡˤäƿͷ׻뤿 
!  ⥸塼 wa_module_sjpack β⥸塼Ǥ, ڥȥˡ
!  ʬ׻Τ Fortran90 ؿ󶡤. 
!
!  ̾ 1 إǥ w_deriv_module_sjpack ⥸塼¿إǥѤ
!  ĥΤǤ, ƱʣĤΥڥȥǡ, ʻǡ
!  ФѴԤ.
!
!   ISPACK  SJPACK  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
!
!  2009/09/06  ݹ wa_deriv_module  SJPACK Ѥ˲¤
!
!      
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
module wa_deriv_module_sjpack
  !
  != wa_deriv_module_sjpack
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: wa_deriv_module_sjpack.f90,v 1.2 2011-03-12 12:33:33 takepiro Exp $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  !  spml/wa_deriv_module_sjpack ⥸塼ϵ̾Ǥήαư
  !  ĴȡѤڥȥˡˤäƿͷ׻뤿 
  !  ⥸塼 wa_module_sjpack β⥸塼Ǥ, ڥȥˡ
  !  ʬ׻Τ Fortran90 ؿ󶡤. 
  !
  !  ̾ 1 إǥ w_deriv_module_sjpack ⥸塼¿إǥѤ
  !  ĥΤǤ, ƱʣĤΥڥȥǡ, ʻǡ
  !  ФѴԤ.
  !
  !   ISPACK  SJPACK  Fortran77 ֥롼ƤǤ. 
  !  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  !  ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
  !
  use dc_message, only : MessageNotify
  use w_base_module_sjpack, only : im, jm, nm=>nn
  use wa_base_module_sjpack, only : xya_wa, wa_xya
  use w_module_sjpack, only : w_xy, xy_w, w_Lapla_w, w_LaplaInv_w, &
                              w_DLon_w, w_Jacobian_w_w

  implicit none

  private
 
  public wa_Lapla_wa, wa_LaplaInv_wa          ! ץ饷ȵձ黻
  public wa_DLon_wa                           ! ʬ
  public xya_GradLon_wa, xya_GradLat_wa       ! ۷ʬ
  public wa_DivLon_xya, wa_DivLat_xya         ! ȯʬ
  public wa_Div_xya_xya                       ! ȯʬ
  public wa_Jacobian_wa_wa                    ! 䥳ӥ
  public xya_GradLambda_wa, xya_GradMu_wa     ! ۷ʬ(,̺ɸ)
  public wa_DivLambda_xya, wa_DivMu_xya       ! ȯʬ(,̺ɸ)

  contains

  !--------------- ʬ׻ -----------------
    function wa_Lapla_wa(wa_data)
      !
      ! ϥڥȥǡ˥ץ饷
      !
      !    ^2 = 1/cos^2ա^2/ߦ^2 + 1/cosա/ߦ(cosբ/ߦ)
      !
      ! Ѥ(¿).
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ. 
      !
      real(8), intent(in)  :: wa_data(:,:)
      !(in) ϥڥȥǡ
      real(8)              :: wa_lapla_wa((nm+1)*(nm+1),size(wa_data,2))
      !(out) ϥڥȥǡΥץ饷
      integer :: k

      do k=1,size(wa_data,2)
         wa_Lapla_wa(:,k) = w_Lapla_w(wa_data(:,k))
      enddo
      
    end function wa_Lapla_wa

    function wa_LaplaInv_wa(wa_data)
      !
      ! ϥڥȥǡ˵եץ饷
      !
      !    ^{-2}
      !      =[1/cos^2ա^2/ߦ^2 + 1/cosա/ߦ(cosբ/ߦ)]^{-1}
      !
      ! Ѥ(¿).
      !
      ! ڥȥǡεեץ饷Ȥ, бʻǡ
      ! եץ饷ѤǡΥڥȥѴΤȤǤ. 
      !
      real(8), intent(in)  :: wa_data(:,:)
      !(in) ϥڥȥǡ
      real(8)              :: wa_LaplaInv_wa((nm+1)*(nm+1),size(wa_data,2))
      !(out) ڥȥǡεեץ饷
      integer :: k

      do k=1,size(wa_data,2)
         wa_LaplaInv_wa(:,k) = w_LaplaInv_w(wa_data(:,k))
      enddo

    end function wa_LaplaInv_wa

    function wa_DLon_wa(wa_data)
      !
      ! ڥȥǡ˷ʬ /ߦ Ѥ(¿).
      !
      ! ڥȥǡηʬȤ, бʻǡ
      ! ʬ/ߦˤѤǡΥڥȥѴΤȤǤ.
      ! 
      real(8), intent(in)  :: wa_data(:,:)
      !(in) ϥڥȥǡ
      real(8)              :: wa_DLon_wa((nm+1)*(nm+1),size(wa_data,2))
      !(out) ڥȥǡηʬ
      integer :: l,k

      do k=1,size(wa_data,2)
         wa_DLon_wa(:,k) = w_DLon_w(wa_Data(:,k))
      enddo

    end function wa_DLon_wa

    function xya_GradLon_wa(wa_data)
      !
      ! ڥȥǡ˸۷ʬ 1/cosա/ߦ 
      ! Ѥʻǡ֤(¿).
      !
      real(8), intent(in)  :: wa_data(:,:)
      !(in) ϥڥȥǡ
      real(8)              :: xya_GradLon_wa(0:im-1,1:jm,size(wa_data,2))
      !(out) ڥȥǡ۷ʬʻǡ

      xya_GradLon_wa = xya_wa(wa_data,ipow=1,iflag=-1)

    end function xya_GradLon_wa

    function xya_GradLat_wa(wa_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ
      ! ʻǡѴ֤(¿).
      !
      real(8), intent(in)  :: wa_data(:,:)
      !(in) ϥڥȥǡ
      real(8)              :: xya_GradLat_wa(0:im-1,1:jm,size(wa_data,2))
      !(out) ڥȥǡ۷ʬʻǡ

      xya_GradLat_wa = xya_wa(wa_data,ipow=1,iflag=1)

    end function xya_GradLat_wa

    function wa_DivLon_xya(xya_data)
      !
      ! ʻǡȯʬ 1/cosա/ߦ Ѥ
      ! ڥȥǡѴ֤(¿).
      !
      real(8), intent(in)  :: xya_data(0:,:,:)
      !(in) ϳʻǡ
      real(8)              :: wa_DivLon_xya((nm+1)**2,size(xya_data,3))
      !(out) ʻǡȯʬڥȥǡ

      wa_DivLon_xya = wa_xya(xya_data,ipow=1,iflag=-1)

    end function wa_DivLon_xya

    function wa_DivLat_xya(xya_data)
      !
      ! ʻǡȯʬ 1/cosա(f cos)/ߦ Ѥ
      ! ڥȥǡѴ֤(¿).
      !
      real(8), intent(in)  :: xya_data(0:,:,:)
      !(in) ϳʻǡ
      real(8)              :: wa_DivLat_xya((nm+1)**2,size(xya_data,3))
      !(out) ʻǡȯʬڥȥǡ

      wa_DivLat_xya = wa_xya(xya_data,ipow=1,iflag=1)

    end function wa_DivLat_xya

    function wa_Div_xya_xya(xya_u,xya_v)
      !
      ! 2 Ĥϳʻǡ٥ȥʬȤȯ׻, 
      ! ڥȥǡȤ֤(¿).
      !
      real(8), intent(in)  :: xya_u(0:,:,:)
      !(in) ٥ȥʬγʻǡ
      real(8), intent(in)  :: xya_v(0:,:,:)
      !(in) ٥ȥʬγʻǡ
      real(8)              :: wa_Div_xya_xya((nm+1)**2,size(xya_u,3))
      !(out) 2 Ĥϳʻǡ٥ȥʬȤȯΥڥȥǡ

      wa_Div_xya_xya = wa_DivLon_xya(xya_u) + wa_DivLat_xya(xya_v)

    end function wa_Div_xya_xya

    function wa_Jacobian_wa_wa(wa_a,wa_b)
      ! 2 ĤΥڥȥǡ˥䥳ӥ
      !
      !   J(f,g) = f/ߦˡg/ߦ - g/ߦˡf/ߦ
      !          = f/ߦˡ1/cosաg/ߦ
      !             - g/ߦˡ1/cosաf/ߦ
      !
      ! Ѥ(¿).
      !
      real(8), intent(in) :: wa_a(:,:)
      !(in) 1ܤϥڥȥǡ
      real(8), intent(in) :: wa_b(:,:)
      !(in) 2ܤϥڥȥǡ
      real(8)             :: wa_Jacobian_wa_wa((nm+1)**2,size(wa_a,2))
      !(out) 2 ĤΥڥȥǡΥ䥳ӥ
      integer :: k

      do k=1,size(wa_a,2)
         wa_Jacobian_wa_wa(:,k) = w_Jacobian_w_w(wa_a(:,k),wa_b(:,k))
      end do
    end function wa_Jacobian_wa_wa


  !--------------- ʬ׻ (,̺ɸ) -----------------
    function xya_GradLambda_wa(wa_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ(¿).
      !
      real(8), intent(in)  :: wa_data(:,:)
      !(in) ϥڥȥǡ
      real(8)              :: xya_GradLambda_wa(0:im-1,1:jm,size(wa_data,2))
      !(out) ڥȥǡ۷ʬʻǡ

      xya_GradLambda_wa = xya_wa(wa_data,ipow=0,iflag=-1)

    end function xya_GradLambda_wa

    function xya_GradMu_wa(wa_data)
      !
      ! ڥȥǡ˸۷ʬ (1-^2)/ߦ  (=sin)
      ! ѤƳʻǡѴ֤(¿).
      !
      real(8), intent(in)  :: wa_data(:,:)
      !(in) ϥڥȥǡ
      real(8)              :: xya_GradMu_wa(0:im-1,1:jm,size(wa_data,2))
      !(out) ڥȥǡ۷ʬʻǡ

      xya_GradMu_wa = xya_wa(wa_data,ipow=0,iflag=1)

    end function xya_GradMu_wa

    function wa_DivLambda_xya(xya_data)
      !
      ! ʻǡȯʬ 1/(1-^2)/ߦ (=sin) 
      ! ѤƥڥȥǡѴ֤(¿).
      !
      real(8), intent(in)  :: xya_data(0:,:,:)
      !(in) ϳʻǡ
      real(8)              :: wa_DivLambda_xya((nm+1)**2,size(xya_data,3))
      !(out) ʻǡȯʬڥȥǡ

      wa_DivLambda_xya = wa_xya(xya_data,ipow=2,iflag=-1)

    end function wa_DivLambda_xya

    function wa_DivMu_xya(xya_data)
      !
      ! ʻǡȯʬ /ߦ (=sin)Ѥ
      ! ڥȥǡѴ֤(¿).
      !
      real(8), intent(in)  :: xya_data(0:,:,:)
      !(in) ϳʻǡ
      real(8)              :: wa_DivMu_xya((nm+1)**2,size(xya_data,3))
      !(out) ʻǡȯʬڥȥǡ

      wa_DivMu_xya = wa_xya(xya_data,ipow=2,iflag=1)

    end function wa_DivMu_xya

end module wa_deriv_module_sjpack

