!------------------------------------------------------------------------
! Copyright(c) 2008-2011 SPMODEL Development Group. All rights reserved.!
!------------------------------------------------------------------------
!
!ɽ  wu_module ƥȥץ
!
!      ȥݥƥ󥷥ζ
!
!  2008/01/02  ݹ
!      2007/11/11  ݹ  顼åɲ
!      2008/06/28  ʿ  ѹ
!      2011/03/11  ʿ dc_test Ѥ褦˽
!
program wu_test_torvelbc

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wu_module

  implicit none

  integer,parameter  :: im=32, jm=16, km=32  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=32         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=1.0d0             ! Ⱦ

  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_TorVel0
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_TorVel
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_True
  real(8), dimension((nm+1)**2,0:lm)       :: wu_TorVel
  character(len=1), dimension(2),parameter :: BCond=(/'F','R'/)

  real(8), parameter :: pi=3.1415926535897932385D0
  integer, parameter :: check_digits = 14
  integer, parameter :: ignore = -15
  integer :: l

  call MessageNotify('M','wu_test_torvelbc', &
       'wu_module  wu_TorBoundaryGrid subroutine test')

  call wu_initial(im,jm,km,nm,lm,ra)

  do l=1,2
     ! P_10
     !xyr_TorVel = sin(xyr_lat) * cos( pi*(xyr_rad-ri)/(ro-ri) )
     ! P_1_1
     !xyr_TorVel = cos(xyr_lat)*cos(xyr_lon)* cos( pi*(xyr_rad-ri)/(ro-ri) )
     xyr_TorVel  = 2.0d0*sin(xyr_lat)**2 * (xyr_rad-ra)**2 * xyr_Rad**2
     xyr_TorVel0 = xyr_TorVel
     wu_TorVel   = wu_xyr(xyr_TorVel)
     call wu_TorBoundaryGrid(wu_TorVel,cond=BCond(l),new=.true.)
     xyr_TorVel = xyr_wu(wu_TorVel)
     ! å
     call check3d(xyr_TorVel0(:,:,1:km), xyr_TorVel(:,:,1:km), &
       'test of internal value')
     ! üå
     if( BCond(l) == 'F' ) then
       xyr_Torvel0 = xyr_wr(wr_DRad_wu(wu_Torvel)- (wr_wu(wu_Torvel)/wr_Rad))
     else
       xyr_Torvel0 = xyr_Torvel
     endif
     xyr_True = 0.0d0
     call check2d(xyr_True(:,:,0), xyr_Torvel0(:,:,0), &
       BCond(l)//' at Top Boundart')
  enddo

  call MessageNotify('M','wu_test_torvelbc', &
    'wu_module  wu_TorgBoundaryGrid subroutine test succeeded!')


contains
  subroutine check3d(sol3, ans3, mess)
    real(8) :: sol3(:,:,:)
    real(8) :: ans3(:,:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans3,                                &
      check              = sol3,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check3d

  subroutine check2d(sol2, ans2, mess)
    real(8) :: sol2(:,:)
    real(8) :: ans2(:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans2,                                &
      check              = sol2,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check2d

  subroutine check1d(sol1, ans1, mess)
    real(8) :: sol1(:)
    real(8) :: ans1(:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans1,                                &
      check              = sol1,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check1d

end program wu_test_torvelbc

