!----------------------------------------------------------------------
!     Copyright (c) 2009--2012 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wtq_mpi_module_sjpack ƥȥץ :: ڥȥؿΥƥ
!
!  2009/09/25  ݹ 
!      2011/09/14  ݹ   MPI 
!      2011/09/14  ݹ   wtq_mpi_module Ѥ˲¤
!      2012/04/02  ݹ   wtq_mpi_module_sjpack Ѥ˲¤
!
program wtq_mpi_sjpack_spectrum_wt

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wtq_mpi_module_sjpack
  use mpi
  implicit none

  integer,parameter  :: im=32, jm=16         ! ʻ(, , ư)
  integer,parameter  :: kmo=16, kmi=10       ! ʻ(ư, ư)
  integer,parameter  :: nm=10                ! ȿ(ʿ)
  integer,parameter  :: lmo=10, lmi=16       ! ȿ(ư, ư)
  real(8),parameter  :: ri=0.5, ro=1.5       ! ⳰Ⱦ

  real(8), dimension(0:im-1,1:jm,0:kmo) ::  xyz_Torvel
  real(8), dimension((nm+1)**2,0:lmo)   ::  wt_Torvel

  real(8), dimension(0:im-1,1:jm,0:kmo) ::  xyz_Polvel
  real(8), dimension((nm+1)**2,0:lmo)   ::  wt_Polvel

  real(8), dimension(0:im-1,1:jm,0:kmo) ::  xyz_Vlon
  real(8), dimension(0:im-1,1:jm,0:kmo) ::  xyz_Vlat
  real(8), dimension(0:im-1,1:jm,0:kmo) ::  xyz_Vrad

  real(8), dimension(0:nm,-nm:nm,0:kmo) ::  nmz_EkTor
  real(8), dimension(0:nm,-nm:nm,0:kmo) ::  nmz_EkPol
  real(8), dimension(0:nm,0:kmo)        ::  nz_EkTor
  real(8), dimension(0:nm,0:kmo)        ::  nz_EkPol

  real(8), dimension(0:kmo)             ::  z_Data

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  real(8) :: PI
  integer :: n,m
  integer :: iproc, np, ierr

 !---------------- MPI  ---------------------
  call MPI_INIT(IERR)
  call MPI_COMM_RANK(MPI_COMM_WORLD,IPROC,IERR)
  call MPI_COMM_SIZE(MPI_COMM_WORLD,NP,IERR)

  PI = 4.0D0*Atan(1.0D0)

  call wtq_mpi_Initial(im,jm,kmi,kmo,nm,lmi,lmo,ri,ro)

  call MessageNotify('M','wtq_mpi_module_sjpack_spectrum_wt_test',&
                         'wtq_mpi_module_sjpack wt-spectrum functions tests.') 

  ! (2Y_1^0+3Y_2^1) * r
  xyz_Torvel =( 2*sqrt(3.0D0)*sin(xyz_Lat) &
              + 3*sqrt(5.0D0/6)*3.0*sin(xyz_Lat)*cos(xyz_Lat)*cos(xyz_Lon) )&
              * xyz_Rad

  ! (3*Y_1^0 + 2Y_1^1 + 2Y_2^0 +Y_2^-2) * r^2
  xyz_Polvel =( 3*sqrt(3.0D0)*sin(xyz_Lat) & 
                + 2* sqrt(3.0D0/2)*cos(xyz_Lat)*cos(xyz_Lon) &
                + 2*sqrt(5.0D0)*(3.0/2*sin(xyz_Lat)**2-1/2.0) &
                - sqrt(5.0D0/24)*3.0*cos(xyz_Lat)**2*sin(2*xyz_Lon) ) &
              * xyz_Rad**2

  wt_Torvel = wt_xyz(xyz_Torvel)
  wt_Polvel = wt_xyz(xyz_Polvel)

  !--------- Energy spectrum ---------
  nmz_EkTor=wt_VMiss
  nmz_EkPol=wt_VMiss

  do n=0,nm
     do m=-n,n
        nmz_EkTor(n,m,:) = 0.0D0
        nmz_EkPol(n,m,:) = 0.0D0
     enddo
  enddo

  nmz_EkTor(1,0,:) = 4.0D0 * z_Rad**2 * (4*pi)*z_Rad**2
  nmz_EkTor(2,1,:) = 2*3*(3.0D0/2)**2/2 * z_Rad**2 * (4*pi)*z_Rad**2 
  nmz_EkTor(2,-1,:)= nmz_EkTor(2,1,:)

  nmz_EkPol(1,0,:) = 9.0D0 * (9*z_Rad**4 + 2.0D0*z_Rad**4) * (4*pi)
  nmz_EkPol(1,1,:) = 1*2*(2/2)**2/2 &
       * (9*z_Rad**4 + 1*2* z_Rad**4) * (4*pi)
  nmz_EkPol(1,-1,:)= nmz_EkPol(1,1,:)
  nmz_EkPol(2,0,:) = 12.0D0 *(9*z_Rad**4 + 6.0D0*z_Rad**4) * (4*pi)
  nmz_EkPol(2,-2,:)= 2*3*(1.0D0/2)**2/2 &
       *(9*z_Rad**4 + 2*3* z_Rad**4 ) * (4*pi)
  nmz_EkPol(2,2,:) = nmz_EkPol(2,-2,:)

  call AssertEqual(&
    message='nmz_ToroidalEnergySpectrum_wt',                      &
    answer = nmz_ToroidalEnergySpectrum_wt(wt_Torvel),            &
    check =  nmz_EkTor,                                           &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='nmz_PoloidalEnergySpectrum_wt',                      &
    answer = nmz_PoloidalEnergySpectrum_wt(wt_Polvel),            &
    check =  nmz_EkPol,                                           &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  nz_EkTor = 0.0D0
  nz_EkTor(1,:) = 4.0D0 * z_Rad**2 * (4*pi)*z_Rad**2 
  nz_EkTor(2,:) = 2 * 3 *(3.0D0/2)**2 * z_Rad**2 * (4*pi)*z_Rad**2 

  nz_EkPol = 0.0D0
  nz_EkPol(1,:) = (9.0D0+1*2*(2/2)**2/2*2 )*(9*z_Rad**4+2*z_Rad**4)*(4*pi)
  nz_EkPol(2,:) = (12.0D0+2*3*(1.0D0/2)**2)*(9*z_Rad**4+2*3*z_Rad**4)*(4*pi)

  call AssertEqual(&
    message='nz_ToroidalEnergySpectrum_wt',                       &
    answer = nz_ToroidalEnergySpectrum_wt(wt_Torvel),             &
    check =  nz_EkTor,                                            &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='nz_PoloidalEnergySpectrum_wt',                       &
    answer = nz_PoloidalEnergySpectrum_wt(wt_Polvel),             &
    check =  nz_EkPol,                                            &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call wt_Potential2Vector(xyz_Vlon,xyz_Vlat,xyz_Vrad,wt_Torvel,wt_Polvel)

  nmz_EkTor = nmz_ToroidalEnergySpectrum_wt(wt_Torvel)
  nmz_EkPol = nmz_PoloidalEnergySpectrum_wt(wt_Polvel)

  z_Data = 0.0D0
  do n=0,nm
     do m=-n,n
        z_Data = z_Data + nmz_EkTor(n,m,:) + nmz_EkPol(n,m,:)
     enddo
  enddo

  call AssertEqual(&
    message='Total energy by nmz-spectrum',                        &
    answer = IntLonLatRad_xyz(xyz_VLon**2+xyz_VLat**2+xyz_VRad**2)/2.0D0, &
    check =  IntRad_z(z_Data/z_Rad**2),                           &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  nz_EkTor = nz_ToroidalEnergySpectrum_wt(wt_Torvel)
  nz_EkPol = nz_PoloidalEnergySpectrum_wt(wt_Polvel)

  call AssertEqual(&
    message='Total energy by nz-spectrum',                        &
    answer = IntLonLatRad_xyz(xyz_VLon**2+xyz_VLat**2+xyz_VRad**2)/2.0D0, &
    check =   IntRad_z(sum(nz_EkTor,1)/z_Rad**2) &
            + IntRad_z(sum(nz_EkPol,1)/z_Rad**2), &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','wtq_mpi_module_sjpack_spectrum_wt_test',&
                         'wtq_mpi_module_sjpack spectrum functions tests suceeded!') 

 !------ MPIνλ ------

  call MPI_FINALIZE(IERR)

end program wtq_mpi_sjpack_spectrum_wt
