!----------------------------------------------------------------------
!     Copyright (c) 2012 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  w_integrale_module ƥȥץ :: ʬʿѴؿΥƥ
!
!  2012/04/03  ݹ
!
program wa_integral_mpi_module_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wa_mpi_module
  use mpi
  implicit none

  integer, parameter :: im=128, jm=64, nm=42, km=2

  real(8), dimension(0:im-1,jm,km) ::  xya_data            ! δؿ
  real(8), dimension(im,km)        ::  xa_idata            ! ʬʿѤ
  real(8), dimension(jm,km)        ::  ya_idata            ! ʬʿѤ
  real(8), dimension(km)           ::  a_idata             ! ʬʿѤ
  real(8), allocatable             ::  xva_data(:,:,:)     ! δؿ
  real(8), allocatable             ::  va_idata(:,:)       ! ʬʿѤ

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  real(8) :: pi
  integer :: iproc, np, ierr

 !---------------- MPI  ---------------------
  call MPI_INIT(IERR)
  call MPI_COMM_RANK(MPI_COMM_WORLD,IPROC,IERR)
  call MPI_COMM_SIZE(MPI_COMM_WORLD,NP,IERR)

  pi = atan(1.0D0)*4.0D0

  call MessageNotify('M','wa_integral_mpi_module_test', &
                         'wa_integral_mpi_module function tests') 

  call wa_mpi_Initial( nm, im, jm, km )

  allocate(xva_data(0:im-1,jc,km))
  allocate(va_idata(jc,km))


  !---- ʬΥƥ(ΰ) ----
  xya_data(:,:,1) = sin(xy_Lat)**2*(1-cos(xy_Lon)**2)
  xya_data(:,:,2) = sin(xy_Lat)**4*(1-sin(xy_Lon)**2)

  a_idata(1) = 2*pi/3       ! a_IntLonLat_xya
  a_idata(2) = 2*pi/5       ! a_IntLonLat_xya
  call AssertEqual(&
    message='a_IntLonLat_xya',                                    &
    answer = a_IntLonLat_xya(xya_data),                           &
    check =  a_idata,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  ya_idata(:,1) = pi*sin(y_Lat)**2       ! y_IntLon_xya
  ya_idata(:,2) = pi*sin(y_Lat)**4       ! y_IntLon_xya
  call AssertEqual(&
    message='ya_IntLon_xya',                                      &
    answer = ya_IntLon_xya(xya_data),                             &
    check =  ya_idata,                                            &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call AssertEqual(&
    message='a_IntLat_ya',                                        &
    answer = a_IntLat_ya(ya_idata),                               &
    check =  a_idata,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xa_idata(:,1) = 2.0D0/3*(1-cos(x_Lon)**2)       ! x_IntLat_xya
  xa_idata(:,2) = 2.0D0/5*(1-sin(x_Lon)**2)       ! x_IntLat_xya

  call AssertEqual(&
    message='xa_IntLat_xya',                                      &
    answer = xa_IntLat_xya(xya_data),                             &
    check =  xa_idata,                                            &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call AssertEqual(&
    message='a_IntLon_xa',                                        &
    answer = a_IntLon_xa(xa_idata),                               &
    check =  a_idata,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- ʿѤΥƥ(ΰ) ----
  xya_data(:,:,1) = sin(xy_Lat)**2*(1-cos(xy_Lon)**2)
  xya_data(:,:,2) = sin(xy_Lat)**4*(1-sin(xy_Lon)**2)

  a_idata(1) = 1.0D0/6       ! AvrLonLat_xya
  a_idata(2) = 1.0D0/10      ! AvrLonLat_xya
  call AssertEqual(&
    message='a_AvrLonLat_xya',                                    &
    answer = a_AvrLonLat_xya(xya_data),                           &
    check =  a_idata,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  ya_idata(:,1) = 0.5*sin(y_Lat)**2       ! y_AvrLon_xya
  ya_idata(:,2) = 0.5*sin(y_Lat)**4       ! y_AvrLon_xya
  call AssertEqual(&
    message='ya_AvrLon_xya',                                      &
    answer = ya_AvrLon_xya(xya_data),                             &
    check =  ya_idata,                                            &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call AssertEqual(&
    message='a_AvrLat_ya',                                        &
    answer = a_AvrLat_ya(ya_idata),                               &
    check =  a_idata,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xa_idata(:,1) = 1.0D0/3*(1-cos(x_Lon)**2)       ! x_AvrLat_xya
  xa_idata(:,2) = 1.0D0/5*(1-sin(x_Lon)**2)       ! x_AvrLat_xya

  call AssertEqual(&
    message='xa_AvrLat_xya',                                      &
    answer = xa_AvrLat_xya(xya_data),                             &
    check =  xa_idata,                                            &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call AssertEqual(&
    message='a_AvrLon_xa',                                        &
    answer = a_AvrLon_xa(xa_idata),                               &
    check =  a_idata,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- ʬΥƥ(ʬΰ) ----
  xva_data(:,:,1) = sin(xv_Lat)**2*(1-cos(xv_Lon)**2)
  xva_data(:,:,2) = sin(xv_Lat)**4*(1-sin(xv_Lon)**2)

  a_idata(1) = 2*pi/3       ! a_IntLonLat_xva
  a_idata(2) = 2*pi/5       ! a_IntLonLat_xva
  call AssertEqual(&
    message='a_IntLonLat_xva',                                    &
    answer = a_IntLonLat_xva(xva_data),                           &
    check =  a_idata,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  va_idata(:,1) = pi*sin(v_Lat)**2       ! v_IntLon_xva
  va_idata(:,2) = pi*sin(v_Lat)**4       ! v_IntLon_xva
  call AssertEqual(&
    message='va_IntLon_xva',                                      &
    answer = va_IntLon_xva(xva_data),                             &
    check =  va_idata,                                            &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call AssertEqual(&
    message='a_IntLat_va',                                        &
    answer = a_IntLat_va(va_idata),                               &
    check =  a_idata,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xa_idata(:,1) = 2.0D0/3*(1-cos(x_Lon)**2)       ! x_IntLat_xva
  xa_idata(:,2) = 2.0D0/5*(1-sin(x_Lon)**2)       ! x_IntLat_xva

  call AssertEqual(&
    message='xa_IntLat_xva',                                      &
    answer = xa_IntLat_xva(xva_data),                             &
    check =  xa_idata,                                            &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call AssertEqual(&
    message='a_IntLon_xa',                                        &
    answer = a_IntLon_xa(xa_idata),                               &
    check =  a_idata,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- ʿѤΥƥ(ʬΰ) ----
  xva_data(:,:,1) = sin(xv_Lat)**2*(1-cos(xv_Lon)**2)
  xva_data(:,:,2) = sin(xv_Lat)**4*(1-sin(xv_Lon)**2)

  a_idata(1) = 1.0D0/6       ! AvrLonLat_xva
  a_idata(2) = 1.0D0/10      ! AvrLonLat_xva
  call AssertEqual(&
    message='a_AvrLonLat_xva',                                    &
    answer = a_AvrLonLat_xva(xva_data),                           &
    check =  a_idata,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  va_idata(:,1) = 0.5*sin(v_Lat)**2       ! v_AvrLon_xva
  va_idata(:,2) = 0.5*sin(v_Lat)**4       ! v_AvrLon_xva
  call AssertEqual(&
    message='va_AvrLon_xva',                                      &
    answer = va_AvrLon_xva(xva_data),                             &
    check =  va_idata,                                            &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call AssertEqual(&
    message='a_AvrLat_va',                                        &
    answer = a_AvrLat_va(va_idata),                               &
    check =  a_idata,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xa_idata(:,1) = 1.0D0/3*(1-cos(x_Lon)**2)       ! x_AvrLat_xva
  xa_idata(:,2) = 1.0D0/5*(1-sin(x_Lon)**2)       ! x_AvrLat_xva

  call AssertEqual(&
    message='xa_AvrLat_xva',                                      &
    answer = xa_AvrLat_xva(xva_data),                             &
    check =  xa_idata,                                            &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call AssertEqual(&
    message='a_AvrLon_xa',                                        &
    answer = a_AvrLon_xa(xa_idata),                               &
    check =  a_idata,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )


  call MessageNotify('M','wa_integral_mpi_module_test', &
       'wa_integral_mpi_module function tests succeded!') 

 !------ MPIνλ ------

  call MPI_FINALIZE(IERR)

end program wa_integral_mpi_module_test

