************************************************************************
* ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING
* Copyright (C) 1998--2013 Keiichi Ishioka <ishioka@gfd-dennou.org>
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
* 02110-1301 USA.
************************************************************************
************************************************************************
*     FLPACK: FILTERING PACKAGE (VERSION 0.0)      95/02/22 BY K.ISHIOKA
************************************************************************
      SUBROUTINE FLCEN4(C1,C2)
*-----------------------------------------------------------------------
*     CHANGE ENDIAN FOR 4BYTE VARIABLE (BIG ENDIAN <-> LITTLE ENDIAN)
*-----------------------------------------------------------------------
      CHARACTER C1*4,C2*4

      DO I1=1,4
        I2=5-I1
        C2(I2:I2)=C1(I1:I1)
      END DO

      END
************************************************************************
      SUBROUTINE FLCEN8(C1,C2)
*-----------------------------------------------------------------------
*     CHANGE ENDIAN FOR 8BYTE VARIABLE (BIG ENDIAN <-> LITTLE ENDIAN)
*-----------------------------------------------------------------------
      CHARACTER C1*8,C2*8

      DO I1=1,8
        I2=9-I1
        C2(I2:I2)=C1(I1:I1)
      END DO

      END
************************************************************************
      SUBROUTINE FLCECA(C1,C2)
*-----------------------------------------------------------------------
*     EBCDIC -> ASCII
*-----------------------------------------------------------------------
      CHARACTER C1*1,C2*1
      INTEGER IT(0:255)
      DATA IT/
     &   0,  1,  2,  3,128,  9,129,127,130,131,132, 11, 12, 13, 14, 15,
     &  16, 17, 18, 19,133,134,  8,135, 24, 25,136,137, 28, 29, 30, 31,
     & 138,139,140,141,142, 10, 23, 27,143,144,145,146,147,  5,  6,  7,
     & 148,149, 22,150,151,152,153,  4,154,155,156,157, 20, 21,158, 26,
     &  32,159,160,161,162,163,164,165,166,167, 91, 46, 60, 40, 43, 33,
     &  38,168,169,170,171,172,173,174,175,176, 93, 36, 42, 41, 59, 94,
     &  45, 47,177,178,179,180,181,182,183,184,124, 44, 37, 95, 62, 63,
     & 185,186,187,188,189,190,191,192,193, 96, 58, 35, 64, 39, 61, 34,
     & 194, 97, 98, 99,100,101,102,103,104,105,195,196,197,198,199,200,
     & 201,106,107,108,109,110,111,112,113,114,202,203,204,205,206,207,
     & 208,126,115,116,117,118,119,120,121,122,209,210,211,212,213,214,
     & 215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,
     & 123, 65, 66, 67, 68, 69, 70, 71, 72, 73,231,232,233,234,235,236,
     & 125, 74, 75, 76, 77, 78, 79, 80, 81, 82,237,238,239,240,241,242,
     &  92,243, 83, 84, 85, 86, 87, 88, 89, 90,244,245,246,247,248,249,
     &  48, 49, 50, 51, 52, 53, 54, 55, 56, 57,250,251,252,253,254,255/
      SAVE

      C2=CHAR(IT(ICHAR(C1)))

      END
************************************************************************
      SUBROUTINE FLCACE(C1,C2)
*-----------------------------------------------------------------------
*     ASCII -> EBCDIC
*-----------------------------------------------------------------------
      CHARACTER C1*1,C2*1
      DIMENSION IT(0:255)
      DATA IT/
     &   0,  1,  2,  3, 55, 45, 46, 47, 22,  5, 37, 11, 12, 13, 14, 15,
     &  16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31,
     &  64, 79,127,123, 91,108, 80,125, 77, 93, 92, 78,107, 96, 75, 97,
     & 240,241,242,243,244,245,246,247,248,249,122, 94, 76,126,110,111,
     & 124,193,194,195,196,197,198,199,200,201,209,210,211,212,213,214,
     & 215,216,217,226,227,228,229,230,231,232,233, 74,224, 90, 95,109,
     & 121,129,130,131,132,133,134,135,136,137,145,146,147,148,149,150,
     & 151,152,153,162,163,164,165,166,167,168,169,192,106,208,161,  7,
     &   4,  6,  8,  9, 10, 20, 21, 23, 26, 27, 32, 33, 34, 35, 36, 40,
     &  41, 42, 43, 44, 48, 49, 51, 52, 53, 54, 56, 57, 58, 59, 62, 65,
     &  66, 67, 68, 69, 70, 71, 72, 73, 81, 82, 83, 84, 85, 86, 87, 88,
     &  89, 98, 99,100,101,102,103,104,105,112,113,114,115,116,117,118,
     & 119,120,128,138,139,140,141,142,143,144,154,155,156,157,158,159,
     & 160,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,
     & 185,186,187,188,189,190,191,202,203,204,205,206,207,218,219,220,
     & 221,222,223,225,234,235,236,237,238,239,250,251,252,253,254,255/
      SAVE

      C2=CHAR(IT(ICHAR(C1)))

      END
************************************************************************
      SUBROUTINE FLCKCA(C1,C2)
*-----------------------------------------------------------------------
*     EBCDIK -> ASCII
*-----------------------------------------------------------------------
      CHARACTER C1*1,C2*1
      INTEGER IT(0:255)
      DATA IT/
     &   0,  1,  2,  3,128,  9,129,127,130,131,132, 11, 12, 13, 14, 15,
     &  16, 17, 18, 19,133,134,  8,135, 24, 25,136,137, 28, 29, 30, 31,
     & 138,139,140,141,142, 10, 23, 27,143,144,145,146,147,  5,  6,  7,
     & 148,149, 22,150,151,152,153,  4,154,155,156,157, 20, 21,158, 26,
     &  32,161,162,163,164,165,166,167,168,169, 91, 46, 60, 40, 43, 33,
     &  38,170,171,172,173,174,175,159,176, 97, 93, 92, 42, 41, 59, 94,
     &  45, 47, 98, 99,100,101,102,103,104,105,124, 44, 37, 95, 62, 63,
     & 106,107,108,109,110,111,112,113,114, 96, 58, 35, 64, 39, 61, 34,
     & 115,177,178,179,180,181,182,183,184,185,186,116,187,188,189,190,
     & 191,192,193,194,195,196,197,198,199,200,201,117,118,202,203,204,
     & 119,126,205,206,207,208,209,210,211,212,213,120,214,215,216,217,
     & 121,122,160,224,225,226,227,228,229,230,218,219,220,221,222,223,
     & 123, 65, 66, 67, 68, 69, 70, 71, 72, 73,231,232,233,234,235,236,
     & 125, 74, 75, 76, 77, 78, 79, 80, 81, 82,237,238,239,240,241,242,
     &  36,243, 83, 84, 85, 86, 87, 88, 89, 90,244,245,246,247,248,249,
     &  48, 49, 50, 51, 52, 53, 54, 55, 56, 57,250,251,252,253,254,255/
      SAVE

      C2=CHAR(IT(ICHAR(C1)))

      END
************************************************************************
      SUBROUTINE FLCACK(C1,C2)
*-----------------------------------------------------------------------
*     ASCII -> EBCDIK
*-----------------------------------------------------------------------
      CHARACTER C1*1,C2*1
      INTEGER IT(0:255)
      DATA IT/
     &   0,  1,  2,  3, 55, 45, 46, 47, 22,  5, 37, 11, 12, 13, 14, 15,
     &  16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31,
     &  64, 79,127,123,224,108, 80,125, 77, 93, 92, 78,107, 96, 75, 97,
     & 240,241,242,243,244,245,246,247,248,249,122, 94, 76,126,110,111,
     & 124,193,194,195,196,197,198,199,200,201,209,210,211,212,213,214,
     & 215,216,217,226,227,228,229,230,231,232,233, 74, 91, 90, 95,109,
     & 121, 89, 98, 99,100,101,102,103,104,105,112,113,114,115,116,117,
     & 118,119,120,128,139,155,156,160,171,176,177,192,106,208,161,  7,
     &   4,  6,  8,  9, 10, 20, 21, 23, 26, 27, 32, 33, 34, 35, 36, 40,
     &  41, 42, 43, 44, 48, 49, 51, 52, 53, 54, 56, 57, 58, 59, 62, 87,
     & 178, 65, 66, 67, 68, 69, 70, 71, 72, 73, 81, 82, 83, 84, 85, 86,
     &  88,129,130,131,132,133,134,135,136,137,138,140,141,142,143,144,
     & 145,146,147,148,149,150,151,152,153,154,157,158,159,162,163,164,
     & 165,166,167,168,169,170,172,173,174,175,186,187,188,189,190,191,
     & 179,180,181,182,183,184,185,202,203,204,205,206,207,218,219,220,
     & 221,222,223,225,234,235,236,237,238,239,250,251,252,253,254,255/
      SAVE

      C2=CHAR(IT(ICHAR(C1)))

      END
************************************************************************
      SUBROUTINE FLRBRE(I1,I2)
*-----------------------------------------------------------------------
*     IBM(REAL*4) -> IEEE(REAL*4)
*-----------------------------------------------------------------------
      IX=ISHFT(ISHFT(I1,  8), -8)
      IY=ISHFT(ISHFT(I1,  1),-25)
      IZ=ISHFT(ISHFT(I1,-31), 31)

      NS=0
   10 IF(.NOT.BTEST(IX,23-NS).AND.NS.LE.3) THEN
        NS=NS+1
        GO TO 10
      END IF
      IY=IY*4-130-NS

      IF(I1.EQ.0) THEN
        I2=0
      ELSE IF(NS.EQ.4.OR.I1.EQ.IZ) THEN
        CALL FLDMSG('E','FLRBRE','THIS IS NOT A NUMBER.')
      ELSE IF(IY.GE.255) THEN
        I2=IOR(IZ,ISHFT(255,23))
      ELSE
        IF(IY.LE.0) THEN
          NS=NS+IY-1
          IY=0
        END IF
        IF(NS.LT.-24) THEN
          I2=IZ
        ELSE
          IX=IX+ISHFT(1,-NS-1)
          IY=ISHFT(IY,23)
          IX=IBCLR(ISHFT(IX,NS),23)
          I2=IOR(IOR(IX,IY),IZ)
        END IF
      END IF

      END
************************************************************************
      SUBROUTINE FLRERB(I1,I2)
*-----------------------------------------------------------------------
*     IEEE(REAL*4) -> IBM(REAL*4)
*-----------------------------------------------------------------------
      IX=ISHFT(ISHFT(I1,  9), -9)
      IY=ISHFT(ISHFT(I1,  1),-24)
      IZ=ISHFT(ISHFT(I1,-31), 31)

      IF(IBCLR(I1,31).EQ.0) THEN
        I2=0
      ELSE IF(IY.EQ.255) THEN
        IF(IX.EQ.0) THEN
          I2=IOR(IZ,IBCLR(-1,31))
        ELSE
          CALL FLDMSG('E','FLRERB','THIS IS NOT A NUMBER.')
        END IF
      ELSE
        IF(IY.EQ.0) THEN
          NS=1
   10     IF(.NOT.BTEST(IX,23-NS)) THEN
            NS=NS+1
            GO TO 10
          END IF
          IY=-NS+1
          IX=ISHFT(IX,NS)
        END IF
        NS=MOD(IY-254,4)
        IY=ISHFT((130+IY-NS)/4,24)
        IX=ISHFT(IBSET(IX,23)+ISHFT(1,-NS-1),NS)
        I2=IOR(IOR(IX,IY),IZ)
      END IF

      END
************************************************************************
      SUBROUTINE FLDBDE(I1,I2)
*-----------------------------------------------------------------------
*     IBM(REAL*8) -> IEEE(REAL*8)
*-----------------------------------------------------------------------
      DIMENSION I1(2),I2(2),IX(2)

      IX(1)=ISHFT(ISHFT(I1(1),8),-8)
      IX(2)=I1(2)
      IY=ISHFT(ISHFT(I1(1),  1),-25)
      IZ=ISHFT(ISHFT(I1(1),-31), 31)

      NS=0
   10 IF(.NOT.BTEST(IX(1),23-NS).AND.NS.LE.3) THEN
        NS=NS+1
        GO TO 10
      END IF
      IY=IY*4+766-NS

      IF(I1(1).EQ.0.AND.I1(2).EQ.0) THEN
        I2(1)=0
        I2(2)=0
      ELSE IF(NS.EQ.4.OR.I1(1).EQ.IZ) THEN
        CALL FLDMSG('E','FLDBDE','THIS IS NOT A NUMBER.')
      ELSE
        NS=NS-3
        CALL FL8ADD(IX,ISHFT(1,-NS-1))
        CALL FL8SFT(IX,NS)
        IF(BTEST(IX(1),21)) THEN
          CALL FL8SFT(IX,-1)
          IY=IY+1
        END IF
        IX(1)=IBCLR(IX(1),20)
        IY=ISHFT(IY,20)
        I2(1)=IOR(IOR(IX(1),IY),IZ)
        I2(2)=IX(2)
      END IF

      END
************************************************************************
      SUBROUTINE FLDEDB(I1,I2)
*-----------------------------------------------------------------------
*     IEEE(REAL*8) -> IBM(REAL*8)
*-----------------------------------------------------------------------
      DIMENSION I1(2),I2(2),IX(2)

      IX(1)=ISHFT(ISHFT(I1(1),12),-12)
      IX(2)=I1(2)
      IY=ISHFT(ISHFT(I1(1),  1),-21)
      IZ=ISHFT(ISHFT(I1(1),-31), 31)

      IF(I1(1).EQ.IZ.AND.I2(2).EQ.0) THEN
        I2(1)=0
        I2(2)=0
      ELSE IF(IY.EQ.2047) THEN
        IF(IX(1).EQ.0.AND.IX(2).EQ.0) THEN
          I2(1)=IOR(IZ,IBCLR(-1,31))
          I2(2)=-1
        ELSE
          CALL FLDMSG('E','FLDEDB','THIS IS NOT A NUMBER.')
        END IF
      ELSE
        NS=MOD(IY-2046,4)
        IY=(IY-766-NS)/4
        IX(1)=IBSET(IX(1),20)
        CALL FL8SFT(IX,NS+3)
        IF(IY.GE.128) THEN
          I2(1)=IOR(IZ,IBCLR(-1,31))
          I2(2)=-1
        ELSE IF(IY.LT.0) THEN
          I2(1)=0
          I2(2)=0
        ELSE
          IY=ISHFT(IY,24)
          I2(1)=IOR(IOR(IX(1),IY),IZ)
          I2(2)=IX(2)
        END IF
      END IF

      END
************************************************************************
      SUBROUTINE FLDBRE(I1,I2)
*-----------------------------------------------------------------------
*     IBM(REAL*8) -> IEEE(REAL*4)
*-----------------------------------------------------------------------
      DIMENSION I1(2),IX(2)

      IX(1)=ISHFT(ISHFT(I1(1),8),-8)
      IX(2)=I1(2)
      IY=ISHFT(ISHFT(I1(1),  1),-25)
      IZ=ISHFT(ISHFT(I1(1),-31), 31)

      NS=0
   10 IF(.NOT.BTEST(IX(1),23-NS).AND.NS.LE.3) THEN
        NS=NS+1
        GO TO 10
      END IF
      IY=IY*4-130-NS

      IF(I1(1).EQ.0.AND.I1(2).EQ.0) THEN
        I2=0
      ELSE IF(NS.EQ.4.OR.I1(1).EQ.IZ) THEN
        CALL FLDMSG('E','FLDBRE','THIS IS NOT A NUMBER.')
      ELSE IF(IY.GE.255) THEN
        I2=IOR(IZ,ISHFT(255,23))
      ELSE
        IF(IY.LE.0) THEN
          NS=NS+IY-1
          IY=0
        END IF
        IF(NS.LT.-24) THEN
          I2=IZ
        ELSE
          CALL FL8SFT(IX,NS)
          CALL FL8ADD(IX,IBSET(0,31))
          IF(BTEST(IX(1),24)) THEN
            CALL FL8SFT(IX,-1)
            IY=IY+1
          END IF
          IX(1)=IBCLR(IX(1),23)
          IY=ISHFT(IY,23)
          I2=IOR(IOR(IX(1),IY),IZ)
        END IF
      END IF

      END
************************************************************************
      SUBROUTINE FLREDB(I1,I2)
*-----------------------------------------------------------------------
*     IEEE(REAL*4) -> IBM(REAL*8)
*-----------------------------------------------------------------------
      DIMENSION I2(2),IX(2)

      IX(1)=ISHFT(ISHFT(I1,  9), -9)
      IX(2)=0
      IY=ISHFT(ISHFT(I1,  1),-24)
      IZ=ISHFT(ISHFT(I1,-31), 31)

      IF(I1.EQ.IZ) THEN
        I2(1)=0
        I2(2)=0
      ELSE IF(IY.EQ.255) THEN
        IF(IX(1).EQ.0) THEN
          I2(1)=IOR(IZ,IBCLR(-1,31))
          I2(2)=-1
        ELSE
          CALL FLDMSG('E','FLREDB','THIS IS NOT A NUMBER.')
        END IF
      ELSE
        IF(IY.EQ.0) THEN
          NS=1
   10     IF(.NOT.BTEST(IX(1),23-NS)) THEN
            NS=NS+1
            GO TO 10
          END IF
          IY=-NS+1
          IX(1)=ISHFT(IX(1),NS)
        ELSE
          IX(1)=IBSET(IX(1),23)
        END IF
        NS=MOD(IY-254,4)
        IY=ISHFT((130+IY-NS)/4,24)
        CALL FL8SFT(IX,NS)
        I2(1)=IOR(IOR(IX(1),IY),IZ)
        I2(2)=IX(2)
      END IF

      END
************************************************************************
      SUBROUTINE FLRBDE(I1,I2)
*-----------------------------------------------------------------------
*     IBM(REAL*4) -> IEEE(REAL*8)
*-----------------------------------------------------------------------
      DIMENSION I2(2),IX(2)

      IX(1)=ISHFT(ISHFT(I1,8),-8)
      IX(2)=0
      IY=ISHFT(ISHFT(I1,  1),-25)
      IZ=ISHFT(ISHFT(I1,-31), 31)

      NS=0
   10 IF(.NOT.BTEST(IX(1),23-NS).AND.NS.LE.3) THEN
        NS=NS+1
        GO TO 10
      END IF
      IY=IY*4+766-NS

      IF(I1.EQ.0) THEN
        I2(1)=0
        I2(2)=0
      ELSE IF(NS.EQ.4.OR.I1.EQ.IZ) THEN
        CALL FLDMSG('E','FLRBDE','THIS IS NOT A NUMBER.')
      ELSE
        NS=NS-3
        CALL FL8SFT(IX,NS)
        IX(1)=IBCLR(IX(1),20)
        IY=ISHFT(IY,20)
        I2(1)=IOR(IOR(IX(1),IY),IZ)
        I2(2)=IX(2)
      END IF

      END
************************************************************************
      SUBROUTINE FLDERB(I1,I2)
*-----------------------------------------------------------------------
*     IEEE(REAL*8) -> IBM(REAL*4)
*-----------------------------------------------------------------------
      DIMENSION I1(2),IX(2)

      IX(1)=ISHFT(ISHFT(I1(1),12),-12)
      IX(2)=I1(2)
      IY=ISHFT(ISHFT(I1(1),  1),-21)
      IZ=ISHFT(ISHFT(I1(1),-31), 31)

      IF(I1(1).EQ.IZ.AND.I1(2).EQ.0) THEN
        I2=0
      ELSE IF(IY.EQ.2047) THEN
        IF(IX(1).EQ.0.AND.IX(2).EQ.0) THEN
          I2=IOR(IZ,IBCLR(-1,31))
        ELSE
          CALL FLDMSG('E','FLDERB','THIS IS NOT A NUMBER.')
        END IF
      ELSE
        NS=MOD(IY-2046,4)
        IY=(IY-766-NS)/4
        IX(1)=IBSET(IX(1),20)
        CALL FL8SFT(IX,NS+3)
        CALL FL8ADD(IX,IBSET(0,31))
        IF(BTEST(IX(1),24)) THEN
          CALL FL8SFT(IX,-1)
          IY=IY+1
        END IF
        IF(IY.GE.128) THEN
          I2=IOR(IZ,IBCLR(-1,31))
        ELSE IF(IY.LT.0) THEN
          I2=0
        ELSE
          IY=ISHFT(IY,24)
          I2=IOR(IOR(IX(1),IY),IZ)
        END IF
      END IF

      END
************************************************************************
      SUBROUTINE FL8SFT(I,N)
*-----------------------------------------------------------------------
*     ISHFT IN INTEGER*8
*-----------------------------------------------------------------------
      DIMENSION I(2)

      IF(N.GE.0) THEN
        I(1)=IOR(ISHFT(I(1),N),ISHFT(I(2),N-32))
        I(2)=ISHFT(I(2),N)
      ELSE
        I(2)=IOR(ISHFT(I(2),N),ISHFT(I(1),N+32))
        I(1)=ISHFT(I(1),N)
      END IF

      END
************************************************************************
      SUBROUTINE FL8ADD(I,N)
*-----------------------------------------------------------------------
*     I=I+N IN INTEGER*8
*-----------------------------------------------------------------------
      DIMENSION I(2)

      I2=I(2)+N
      IF(BTEST(I(2),31).AND..NOT.BTEST(I2,31)) THEN
        I(1)=I(1)+1
      END IF
      I(2)=I2

      END
************************************************************************
      SUBROUTINE FLDMSG(CL,CS,CM)
*-----------------------------------------------------------------------
*     DUMP MESSAGES
*-----------------------------------------------------------------------
      CHARACTER CL*1,CS*(*),CM*(*)
      CHARACTER CSD*6,CMD*53
      DATA MMSG,IMSG/20,0/
      SAVE

      CSD=CS
      CMD=CM

      IF(CL.EQ.'E') THEN
        WRITE(6,'(A)') '***** ERROR ('//CSD//') ***  '//CMD
        STOP
      END IF

      IF(IMSG.LT.MMSG) THEN
        IF(CL.EQ.'W') THEN
          IMSG=IMSG+1
          WRITE(*,*) '*** WARNING ('//CSD//') ***  '//CMD
        ELSE IF(CL.EQ.'M') THEN
          IMSG=IMSG+1
          WRITE(*,*) '*** MESSAGE ('//CSD//') ***  '//CMD
        END IF
        IF(IMSG.EQ.MMSG) THEN
          WRITE(*,*) '+++ THE FOLLOWING MESSAGES ARE SUPRRESSED.'
        END IF
      END IF

      END
