#
# sgpk10.rb
#
# $Id: sgpk10.rb,v 1.1.1.1 2011/02/23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


nd = 12
DDEG = 360.0/nd
dd = 0.25

rx = NArray.sfloat(nd)
ry = NArray.sfloat(nd)

#-- data ---
for n in 0..nd-1
  rx[n] = dd*(n+1)*cos(PI/180*DDEG*n)
  ry[n] = dd*(n+1)*sin(PI/180*DDEG*n)
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sgopn iws

DCL::sgfrm

DCL::sgswnd(0.0, 10.0, 0.0, 10.0)
DCL::sgsvpt(0.0, 1.0, 0.0, 1.0)
DCL::sgstrn(1)
DCL::sgstrf

x1 = 3.0
y1 = 7.0
for n in 0..nd-1
  DCL::sglazu(x1, y1, x1+rx[n], y1+ry[n], 1, 2)
end

DCL::sglset('LPROP', false)
DCL::sgrset('CONST', 0.05)
x1 = 7.0
y1 = 7.0
for n in 0..nd-1
  DCL::sglazu(x1, y1, x1+rx[n], y1+ry[n], 1, 2)
end

for i in 1..8
  DCL::sgrset('ANGLE', 10.0*i)
  DCL::sglazu(i.to_f, 2.0, (i+1).to_f, 3.0, 1, 2)
end

DCL::sgcls

