#
# test03.rb
#
# $Id: test03.rb,v 1.1.1.1 2011/02/23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


nx = 37
ny = 37
xmin = 0
xmax = 360
ymin = -90
ymax = +90
drad = PI / 180
dz = 0.05
fact = 10
p = NArray.sfloat(nx, ny)
u = NArray.sfloat(nx, ny)
v = NArray.sfloat(nx, ny)
alon = NArray.sfloat(nx)
alat = NArray.sfloat(ny)

#-- data ---
alon = alon.indgen(xmin, (xmax-xmin)/(nx-1).to_f)
alat = alat.indgen(ymin, (ymax-ymin)/(ny-1).to_f)
for j in 0..ny-1
  for i in 0..nx-1
    slat = sin(alat[j]*drad)
    p[i,j] = cos(alon[i]*drad) * (1-slat**2) * sin(2*PI*slat) + dz
  end
end

rmiss = DCL::glrget('RMISS')
DCL::gllset('LMISS', true)

for j in 0..ny-1
  for i in 0..nx-1
    if (j == 0 || j == ny-1)
      u[i,j] = rmiss
      v[i,j] = rmiss
    else
      u[i,j] = (p[i,j-1] - p[i,j+1]) * fact
      v[i,j] = (p[DCL::imod(i+1,nx-1),j] - p[DCL::imod(i-1,nx-1),j]) * fact
    end
  end
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm
DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::grsvpt(0.1, 0.9, 0.1, 0.9)
DCL::grssim(0.4, 0.0, 0.0)
DCL::grsmpl(165.0, 60.0, 0.0)
DCL::grstxy(-180.0, 180.0, 0.0, 90.0)
DCL::grstrn(30)
DCL::grstrf
DCL::sglset('LCLIP', true)

DCL::umlset('LGRIDMJ', false)
DCL::umrset('DGRIDMN', 30.0)
DCL::umpmap('coast_world')
DCL::umpglb

DCL::udcntr(p)

for j in 0..ny-1
  for i in 0..nx-1
    if (!(u[i,j] == rmiss || v[i,j] == rmiss))
      DCL::sglazu(alon[i],alat[j],alon[i]+u[i,j],alat[j]+v[i,j], 1, 3)
    end
  end
end

DCL::grcls

