#
# uspk08.rb
#
# $Id: uspk08.rb,v 1.1.1.1 2011/02/23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


n = 200
t = NArray.sfloat(n)
z = NArray.sfloat(n)

#-----------------------------------------------------------------------
r = 0.2
a = 4.0
z.indgen(2.0, 2.0)
for i in 0..n-1
  r = a*r*(1.0-r)
  z2  = ((i-4).to_f/40.0)**2
  t[i] = 20.0*exp(-z2) + r*2.0
end

#-----------------------------------------------------------------------
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm

#      --- OMAJINAI ---
DCL::uslset('LYINV', true)
DCL::uzlset('LABELXT', true)
DCL::uscset('CYSPOS', 'B')

DCL::uscset('CXSIDE', 'T')
DCL::uscset('CYSIDE', 'L')

DCL::ussttl('TEMPERATURE', 'C|'+ DCL::csgi(4) + '"', 'DEPTH', 'm')
DCL::usgrph(t, z)

DCL::grcls

