/*
 * $Id: p_header,v 1.3 2015/03/18 03:27:42 horinout Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_gnsave(obj)
    VALUE obj;
{
    gnsave_();

    return Qnil;

}

static VALUE
dcl_gnrset(obj)
    VALUE obj;
{
    gnrset_();

    return Qnil;

}

static VALUE
dcl_gnsblk(obj, xb, nb)
    VALUE obj, xb, nb;
{
    real *i_xb;
    integer i_nb;

    if (TYPE(xb) == T_FLOAT) {
      xb = rb_Array(xb);
    }
    /* if ((TYPE(xb) != T_ARRAY) && 
           (rb_obj_is_kind_of(xb, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nb) != T_BIGNUM) || (TYPE(nb) != T_FIXNUM)) {
      nb = rb_funcall(nb, rb_intern("to_i"), 0);
    }

    i_nb = NUM2INT(nb);
    i_xb = dcl_obj2crealary(xb);


    gnsblk_(i_xb, &i_nb);

    dcl_freecrealary(i_xb);

    return Qnil;

}

static VALUE
dcl_gnqblk(obj)
    VALUE obj;
{
    real *o_xb;
    integer o_nb;
    VALUE xb;
    VALUE nb;

    o_xb= ALLOCA_N(real, (o_nb));

    gnqblk_(o_xb, &o_nb);

    {int array_shape[1] = {o_nb};
     xb = dcl_crealary2obj(o_xb, (o_nb), 1, array_shape);
    }
    nb = INT2NUM(o_nb);


    return rb_ary_new3(2, xb, nb);

}

static VALUE
dcl_gnlt(obj, rx)
    VALUE obj, rx;
{
    real i_rx;
    real o_bx;
    integer o_ip;
    VALUE bx;
    VALUE ip;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }

    i_rx = (real)NUM2DBL(rx);


    gnlt_(&i_rx, &o_bx, &o_ip);

    bx = rb_float_new((double)o_bx);
    ip = INT2NUM(o_ip);


    return rb_ary_new3(2, bx, ip);

}

static VALUE
dcl_gnle(obj, rx)
    VALUE obj, rx;
{
    real i_rx;
    real o_bx;
    integer o_ip;
    VALUE bx;
    VALUE ip;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }

    i_rx = (real)NUM2DBL(rx);


    gnle_(&i_rx, &o_bx, &o_ip);

    bx = rb_float_new((double)o_bx);
    ip = INT2NUM(o_ip);


    return rb_ary_new3(2, bx, ip);

}

static VALUE
dcl_gngt(obj, rx)
    VALUE obj, rx;
{
    real i_rx;
    real o_bx;
    integer o_ip;
    VALUE bx;
    VALUE ip;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }

    i_rx = (real)NUM2DBL(rx);


    gngt_(&i_rx, &o_bx, &o_ip);

    bx = rb_float_new((double)o_bx);
    ip = INT2NUM(o_ip);


    return rb_ary_new3(2, bx, ip);

}

static VALUE
dcl_gnge(obj, rx)
    VALUE obj, rx;
{
    real i_rx;
    real o_bx;
    integer o_ip;
    VALUE bx;
    VALUE ip;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }

    i_rx = (real)NUM2DBL(rx);


    gnge_(&i_rx, &o_bx, &o_ip);

    bx = rb_float_new((double)o_bx);
    ip = INT2NUM(o_ip);


    return rb_ary_new3(2, bx, ip);

}

static VALUE
dcl_rgnlt(obj, rx)
    VALUE obj, rx;
{
    real i_rx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }

    i_rx = (real)NUM2DBL(rx);


    o_rtn_val = rgnlt_(&i_rx);

    rtn_val = rb_float_new((double)o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_rgnle(obj, rx)
    VALUE obj, rx;
{
    real i_rx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }

    i_rx = (real)NUM2DBL(rx);


    o_rtn_val = rgnle_(&i_rx);

    rtn_val = rb_float_new((double)o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_rgnge(obj, rx)
    VALUE obj, rx;
{
    real i_rx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }

    i_rx = (real)NUM2DBL(rx);


    o_rtn_val = rgnge_(&i_rx);

    rtn_val = rb_float_new((double)o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_rgngt(obj, rx)
    VALUE obj, rx;
{
    real i_rx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }

    i_rx = (real)NUM2DBL(rx);


    o_rtn_val = rgngt_(&i_rx);

    rtn_val = rb_float_new((double)o_rtn_val);


    return rtn_val;

}
void
init_math1_gnmlib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "gnsave", dcl_gnsave, 0);
    rb_define_module_function(mDCL, "gnrset", dcl_gnrset, 0);
    rb_define_module_function(mDCL, "gnsblk", dcl_gnsblk, 2);
    rb_define_module_function(mDCL, "gnqblk", dcl_gnqblk, 0);
    rb_define_module_function(mDCL, "gnlt", dcl_gnlt, 1);
    rb_define_module_function(mDCL, "gnle", dcl_gnle, 1);
    rb_define_module_function(mDCL, "gngt", dcl_gngt, 1);
    rb_define_module_function(mDCL, "gnge", dcl_gnge, 1);
    rb_define_module_function(mDCL, "rgnlt", dcl_rgnlt, 1);
    rb_define_module_function(mDCL, "rgnle", dcl_rgnle, 1);
    rb_define_module_function(mDCL, "rgnge", dcl_rgnge, 1);
    rb_define_module_function(mDCL, "rgngt", dcl_rgngt, 1);
}
