=begin JA

= ޥɥ饤β

# *  (odakker)
#   * $Id: dc_args.rd,v 1.4 2007/08/31 05:10:53 odakker2 Exp $

=end JA
=begin EN

= Command line arguments interpretation

# *  (odakker)
#   * $Id: dc_args.rd,v 1.4 2007/08/31 05:10:53 odakker2 Exp $

=end EN


=begin JA

gt4f90io ˤϼ¹ԥץΥޥɥ饤Ϥ
륵֥롼󶡤⥸塼 
((<dc_args|URL:../code_reference/classes/dc_args.html>)) Ѱդ
Ƥޤ. Ѥȥץ¹ԻΥץ, 
إץåɽʤɤǽˤʤޤ. 

Ȥ, 
((<"Fortran 90/95 ѥ⥸塼: (1) ̷ѥ᥿"|URL:dc_types.htm>)) 
Ѥ((<ץץ|URL:diffusion_3.f90>))
ޥɥ饤Ϳ褦˽ץ򼨤ޤ 
(ɤ((<|URL:diffusion_7.f90>))). 
ֻ(顼Ǥʤϥܡ) dc_args ˴طƤսǤ.
ϢɬפȤʤ 
((<dc_types|URL:../code_reference/classes/dc_types.html>)),
((<dc_string|URL:../code_reference/classes/dc_string.html>)),
((<dc_message|URL:../code_reference/classes/dc_message.html>))
⥸塼󶡤Ƥǡȥ֥롼 use ʸǻȤƤޤ. 

=end JA
=begin EN

((<Dc_args|URL:../code_reference/classes/dc_args.html>)) module of gt4f90io
provides subroutines for interpretation of command line arguments.
By using dc_args, run time options and help message can be specified 
to user's program. 

For example, a sample program using the dc_args module
(((<diffusion_7.f90|URL:diffusion_7.f90>))) is shown here, which are
modified from ((<diffusion_3.f90|URL:diffusion_3.f90>)) in ((<"
Fortran 90/95 general-purpose modules: (1) Type parameter
specification"|URL:dc_types.htm.en>)).  Statements with colored font
(or bold font) are associated with the dc_message module.

=end EN


=begin HTML
<pre style="background-color: #FFFFFF; color: blue; border-style: groove; border-width: 2">
!= Sample program for gt4_history/gt4f90io
!
! * 2007/06/27 M.Odaka
! * 2006/10/25 Y.Morikawa
! * 2003/08/21 M.Odaka
! * 2001/02/27 S.Takehiro
!
! Solving diffusion equation
! \[
!     du/dt = \kappa d^2 u/dx^2
! \]
! for giving values of $u$ at $x=[0,1]$.
!
program diffusion_7

  use gt4_history                                   ! Access module (⥸塼)
  use dc_types, only : DP, STRING                   ! Access module (⥸塼)
  use dc_message, only: MessageNotify               ! Access module (⥸塼)
  <b><font color="red">use dc_string, only : StoA, StoI                  ! Access module (⥸塼)
  use dc_args,  only : ARGS, Open, Debug, Help, Strict, Close, Option
                                                    ! Access module (⥸塼)</font></b>

  integer, parameter     :: nx=30                   ! Grid number (åɿ)
  integer, parameter     :: nt=200                  ! Time step number (֥ƥå׿)
  integer, parameter     :: ndisp=10                ! Output interval (ϴֳ)
  real(DP), parameter    :: dx=1.0/(nx-1)           ! Grid interval (åɴֳ)
  real(DP), parameter    :: dt=0.0005               ! Time step (ֳִ)
  real(DP), dimension(nx):: x=(/(dx*(i-1),i=1,nx)/) ! X coordinate (ɸѿ)
  real(DP), dimension(nx):: temp                    ! Temperature ()
  real(DP), parameter    :: kappa=1.0               ! Diffusion coefficient (ǮȻ)
  <b><font color="red">type(ARGS)             :: arg                     ! Command line argument ()
  logical                :: OPT_step                ! logical parameter (ѿ)
  character(STRING)      :: VAL_step                ! Value of command line argument ()</font></b>

  <b><font color="red">call Open(arg)                             ! Initialize variable 'arg'
                                             ! (ν) 
  call Option(arg, StoA('-S', '--step'), OPT_step, VAL_step, &amp;
    &amp;         help="Specify time step (nt) [default value is 200]." )
                                             ! Set "-S/--step" option
                                             ! ("-S/--step" ץ)

  call Debug(arg)                            ! Set debug option
                                             ! (ǥХåץμư)
  call Help(arg)                             ! Set help option
                                             ! إץץμư
  call Strict(arg)                           ! Set exception handling
                                             ! (̵ʥץ˷ٹɽ)

  if (OPT_step) then
     nt = StoI(VAL_step)                     ! Set "nt" specified by command line argument 
                                             ! (ͤ)

     call MessageNotify( "M", "diffusion_7", &amp;
       &amp;                 "Time step is %d", i=(/nt/) )
                                             ! Message dump
                                             ! (åν)
  end if

  call Close(arg)                            ! Finalize variable 'arg'
                                             ! (λѽλ)</font></b>


  tinit = 0.0                                       ! 

  temp = exp(-((x-0.5)/0.1)**2)                     ! 

  call HistoryCreate( &amp;                             ! ҥȥ꡼
    &amp; file='diffusion_7.nc', title='Diffusion equation', &amp;
    &amp; source='Sample program of gt4_history/gt4f90io',   &amp;
    &amp; institution='GFD_Dennou Club davis project',       &amp;
    &amp; dims=(/'x','t'/), dimsizes=(/nx,0/),               &amp;
    &amp; longnames=(/'X-coordinate','time        '/),       &amp;
    &amp; units=(/'m','s'/),                                 &amp;
    &amp; origin=real(tinit), interval=real(ndisp*dt) )

  call HistoryPut('x',x)                            ! ѿ

  call HistoryAddVariable( &amp;                        ! ѿ
    &amp; varname='temp', dims=(/'x','t'/), &amp;
    &amp; longname='temperature', units='K', xtype='double')

  call HistoryAddAttr('temp','gt_graph_tick_all',1)
  call HistoryAddAttr('temp','gt_graph_contour_spacing',(/0.0,1.0,0.01/))
  call HistoryAddAttr('temp','+gt_user_davis_kappa',kappa)

  call HistoryPut('temp',temp)                      ! ѿ

  do it=1,nt
    temp(2:nx-1) = temp(2:nx-1) &amp;                   ! ʬ
      &amp; + kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt

    if ( mod(it,ndisp) == 0 ) then
      call HistoryPut('temp',temp)                  ! ѿ
    endif
  enddo

  call HistoryClose
  stop
end program diffusion_7
</pre>
=end HTML


=begin JA

ΥץǤϥޥɥ饤󥪥ץǷ׻ƥå׿Ǥ
褦ˤƤޤ. ޤ, ǥХå⡼ɤǤμ¹ 
( ((<Fortran90 ѥ饤֥: (4) ǥХå|URL:dc_trace.htm>)) ), 
إץåνϤ⥪ץǻǤޤ.

  * ׻ƥå׿λϥץ¹Ի

      $ ./a.out -S=<׻ƥå׿>

    ޤ

      $ ./a.out --step=<׻ƥå׿>

    Ȥޤ.

  * ǥХå⡼ɤǼ¹Ԥ

      &amp; ./a.out -D

    Ȥޤ. ǥХååϥǥեȤǤɸϤ˽Ϥޤ.

  * إץåνϤ

      $ a.out -H

    Ȥޤ. ΤȤץϰʲΤ褦ʥإץåɽ
    ƽλޤ. 

      Options::
       -S=VAL, --step=VAL
           Specify time step (nt) [default value is 200].

       -D=VAL, --debug=VAL
           call dc_trace#SetDebug (display a lot of messages for debug).
           VAL is unit number (default is standard output)

       -h=VAL, -H=VAL, --help=VAL
           display this help and exit. VAL is unit number (default is
           standard output)

=end JA
=begin EN

In this program, the time step number 'no' can be specified by command
line argument.
Execution in debug mode ( ((<"Fortran 90/95 general-purpose modules: (4) Debud support"|URL:dc_trace.htm>)) ), and help message can be also specified.


  * The time step number is specified as follows

      $ ./a.out -S=<time step number>

    or, 

      $ ./a.out --step=<time step number>


  * Debug option is specified as follows.

      $ ./a.out -D

    Debug messages are dumped to standard out.

  * Help message can be displayed as follows.

      $ a.out -H

    If the '-H' is given, following messages are displayed.

      Options::
       -S=VAL, --step=VAL
           Specify time step (nt) [default value is 200].

       -D=VAL, --debug=VAL
           call dc_trace#SetDebug (display a lot of messages for debug).
           VAL is unit number (default is standard output)

       -h=VAL, -H=VAL, --help=VAL
           display this help and exit. VAL is unit number (default is
           standard output)

=end EN


=begin JA

ʲǤ dc_args ⥸塼 ֥롼󤬹ԤäƤ뤳Ȥޤޤ.
ǰäƤʤ֥롼εǽޤܤ
((<ե󥹥ޥ˥奢|URL:../code_reference/classes/dc_args.html>)) 
򻲾ȤƤ.


: use dc_args

  ⥸塼λѤޤ. Fortran90 ᥤץƬˤ
  ޤ礦. Ǥ only ʸѤɬפʥǡȥ֥롼򻲾Ȥޤ. 

: types(ARGS)

  ¤ ARGS ѿʸǤ. Ϲ¤ ARGS ѿ˳Ǽޤ. 


: character(STRING)

  ̷ѥ᥿ STRING ѤʸѿʸǤ. ͤǼ
  ʸѿμ̷ѥ᥿, STRING ˤɬפޤ. 
  ̷ѥ᥿ STRING 
  ((<dc_types|URL:../code_reference/classes/dc_typs.html>)) ⥸塼
  󶡤ƤΤ,  ᥤץƬʬ, use ʸѤƻ
  ޤ. 


: Open(arg)

  ¤ ARGS ѿ arg νԤޤ.


: Option(arg, options, flag, [value], [help])

  ץϿȼԤޤ. ΰ̣ϰʲ̤Ǥ.

  * ((*arg*)) ʲΥץǼ빽¤ ARGS 
    ѿꤹǤ. 

  * ((*options*)) ϥץʸꤹǤ. 
    嵭Ǥ '-S'  '--step' ̤Ϳ褦ˤƤޤ 
    (((<StoA|URL:../code_reference/classes/dc_string.html#M000800>)) 
    ((<dc_string|URL:../code_reference/classes/dc_string.html>))
    ⥸塼ѰդƤ뷿ѴؿǤ). 
    
  * ((*flag*)) ϥץͿƤ뤫ݤȽꤹ뤿
    ѿꤹǤ.
    ((*options*)) ޥɥ饤Ϳ .true. ֤,
    Ǥʤ .false. ֤ޤ.

  * ((*[value]*)) ϥץͤꤵƤˤͤǼ
    ѿꤹǤ. 
 
  * ((*[help]*)) ϥץ˴ؤإץåꤹǤ.
    ֥롼 Help ѤݤˤΥåϤޤ.


: Debug(arg)

  ǥХåץ -D  --debug ưꤷޤ.     


: Help(arg)

  إץץ -H  --help ưꤷޤ.
  Υ֥롼Ȥϻ Option, Debug ֥롼Ƥ
  ɬפޤ.


: Strict(arg, [severe]) 

  ץͿ줿ʸ Option ֥롼ꤵƤʤ
  ˷ٹ֤ޤ.  ((*[severe]*))  .true. ˤƤ
  顼֤ץλޤ. 
  Υ֥롼Ȥϻ Option, Debug, Help ֥롼
  Ƥɬפޤ.


: Close(arg)

  ¤ ARGS ѿ arg λѤλޤ.
  

=end JA
=begin EN

Summary of dc_args module and its subroutines used in the sample
program are as follows. In detail, please see ((<gt4f90io reference
manual|URL:../code_reference/classes/dc_args.html>)).


: use dc_args

  Access dc_args module. This statement is located at the beginning
  of main program. In this case, ONLY option is used.


: types(ARGS)

  Definition of ARGS derived data type variable.
  Information of command line arguments is stored this type variable.


: character(STRING)

  Definition of character literal constant with STRING type parameter.
  The type parameter of character literal constant which store
  the value of command line arguments must be STRING.  
  The type parameter STRING is provided by 
  ((<dc_types|URL:../code_reference/classes/dc_typs.html>)) module.
  This module is accessed at the beginning of main program


: Open(arg)

  Initialize ARGS derived data type variable 'arg'.


: Option(arg, options, flag, [value], [help])

  Define command line options. Descriptions of each argument are as follows.  

  * ((*arg*)) specifies ARGS derived data type variable which store 
    information of command line arguments.

  * ((*options*)) specifies string of command line option.
    In this case, '-S' and  '--step' are specified,
    (((<StoA|URL:../code_reference/classes/dc_string.html#M000800>)) is 
    type translation function provided by 
    ((<dc_string|URL:../code_reference/classes/dc_string.html>))
    module. 
    
  * ((*flag*)) is logical argument for judgement whether command line option 
    is specified or not.
    If ((*options*)) is specified as command line option, 
    return value of ((*flag*)) is '.true.', If not, return value 
    ((*flag*)) is '.false.'

  * ((*[value]*)) is optional argument which store the value of
    command line option.
 
  * ((*[help]*)) is optional argument which specifies help message.
    This message is displayed when -H or --help options are specified.


: Debug(arg)

  Set debug option (-D/--debug) automatically.


: Help(arg)

  Set help option (-H/--help) automatically.
  To call this subroutine, Option and Debug subroutine must be 
  called previously.


: Strict(arg, [severe]) 

  Show warning message if specified command line argument is not defined
  by Option subroutine. 
  If the argument ((*[severe]*)) is '.true.' program is terminated.
  To call this subroutine, Option, Debug and Help subroutine must be 
  called previously.


: Close(arg)

  Finalize ARGS derived data type variable 'arg'.

  

=end EN



=begin HTML
<hr /> <small>
  $Id: dc_args.rd,v 1.4 2007/08/31 05:10:53 odakker2 Exp $
</small>
=end HTML

 LocalWords:  HTML hr dc args
