!== sysdep.f90 - module providing interface for system dependent procedures
!
! Authors::   Eizi TOYODA, Yasuhiro MORIKAWA
! Version::   $Id: sysdep.f90,v 1.4 2006/11/17 17:16:00 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20080217 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! This file provides sysdep
!

module sysdep
  !
  != module providing interface for system dependent procedures
  !
  ! Υ⥸塼ϥƥ˰¸³˴ؤ
  ! 󥿥ե󶡤ޤ
  ! ȡΥ⥸塼Ǥϥƥ˰¸륵֥롼ȴؿ
  ! 󥿥եʤƤޤ
  ! μ³б̾ĤեˤƼƤޤ
  ! (ʤ <tt>sysdep</tt> ǻϤޤ̾Υե뷲ˤơǤ)
  !
  ! äơ̾μ³äȤơμ³μϼºݤˤ
  ! ʣΥեˤƹԤƤǽΤǵĤƤ
  !
  !  sysdep ⥸塼¾Υ⥸塼˰¸ޤ
  !
  !
  ! It provides interface for system dependent procedures.
  ! In other words, there is interface declaration of a function and
  ! subroutines whose feature is regarded as system dependent.
  ! Implementation of these procedures are given in files with 
  ! corresponding name (i.e. that begins with <tt>sysdep</tt>-).
  !
  ! Note that a procedure with one name may have several implementations.
  !
  ! The sysdep has no dependence to other modules.
  !
  private
  public:: AbortProgram, SysdepArgGet, SysdepArgCount, SysdepEnvGet

  interface AbortProgram
    subroutine SysdepAbort(string)
      character(len = *):: string
    end subroutine SysdepAbort
  end interface

  interface

    integer function SysdepArgCount()
    end function SysdepArgCount

    subroutine SysdepArgGet(index, value)
      integer, intent(in):: index
      character(len = *):: value
    end subroutine SysdepArgGet

    subroutine SysdepEnvGet(env, str)
      character(len = *), intent(in)  :: env
      character(len = *), intent(out) :: str
    end subroutine SysdepEnvGet

  end interface

end module sysdep
