!= gt4_historyauto Υƥȥץ
!= Test program of "gt4_historyauto"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: histauto.f90,v 1.3 2008-07-20 17:59:37 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20080720 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved. 
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

program histauto
  use dc_trace, only: SetDebug
  use dc_types, only: DP
  use dc_test, only: AssertEqual
  use gt4_historyauto, only: HistoryAutoCreate, &
    & HistoryAutoAddAttr, HistoryAutoAddWeight, HistoryAutoPutAxis, &
    & HistoryAutoClose, HistoryAutoPut, HistoryAutoProgress, &
    & HistoryAutoAddVariable
  implicit none

  integer:: i, j
  logical:: err
  character(*), parameter:: source = 'histauto.f90'
  character(*), parameter:: institution = 'gtool4 project'
  
continue

  call SetDebug

  ! ܥƥ
  ! Basic test
  !
  call HistoryAutoCreate( &
    &       title = 'Test01 for gt4_historyauto', & ! (in)
    &      source = source, &                       ! (in)
    & institution = institution, &                  ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 2, 3, 4, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm  ',  'm  ',  'm  ',  'sec'  /) )  ! (in)

  call HistoryAutoAddVariable( &
    & 'u', (/'x   ', 'time'/), 'u', 'm s-1', & ! (in)
    & file = 'xhistauto/test01-u.nc' )         ! (in) optional

  call HistoryAutoAddVariable( &
    & 'v', (/'y   ', 'z   ', 'time'/), 'v', 'm s-1', & ! (in)
    & file = 'xhistauto/test01-v.nc', &                ! (in) optional
    & average = .true., xtype = 'double' )             ! (in) optional

  do i = 1, 10
    call HistoryAutoPut( 'u', (/ 1.0, 2.0 /) * i )
    call HistoryAutoPut( 'v', (/ ( real(j), j = 1, 12 ) /) * i )
    call HistoryAutoProgress
  end do

  call HistoryAutoPut( 'w', (/ 1.0, 2.0 /), err = err )
  call AssertEqual( 'HistoryAutoPut error handling test 1-1', &
    & answer = .true., check = err )

  call HistoryAutoClose


  ! ϥߥ󥰼ưåƥ
  ! Output timing automatically checking test
  !
  call HistoryAutoCreate( &
    &       title = 'Test02 for gt4_historyauto', & ! (in)
    &      source = source, &                       ! (in)
    & institution = institution, &                  ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 2, 3, 4, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm  ',  'm  ',  'm  ',  'min'  /), & ! (in)
    &  file_prefix = 'xhistauto/test02-', &               ! (in) optional
    &     interval = 1.0, &                               ! (in) optional
    & current_time = 30.0, &                              ! (in) optional
    &   delta_time = 10.0 )                               ! (in) optional

  call HistoryAutoAddVariable( &
    & 'u', (/'x   ', 'time'/), 'u', 'm s-1' ) ! (in)

  call HistoryAutoAddVariable( &
    & 'v', (/'y   ', 'z   ', 'time'/), 'v', 'm s-1', & ! (in)
    & average = .true., xtype = 'double' )             ! (in) optional

  do i = 1, 19
!    write(*,*) i, (i - 1) * 10 + 30, ((i - 1) * 10 + 30) / 60.0
    call HistoryAutoPut( 'u', (/ 1.0, 2.0 /) * i )
    call HistoryAutoPut( 'v', (/ ( real(j), j = 1, 12 ) /) * i )
!    write(*,*) '---------------'
    call HistoryAutoProgress
  end do

  call HistoryAutoClose

  ! ɸǡ, ɸŤ, °ƥ
  ! Axes data, axes weights, attributes settings test
  !
  call HistoryAutoCreate( &
    &       title = 'Test03 for gt4_historyauto', & ! (in)
    &      source = source, &                       ! (in)
    & institution = institution, &                  ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 2, 3, 4, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm   ', 'm   ', 'deg.', 'sec ' /), & ! (in)
    &    xtypes = (/ 'double' /), &                       ! (in) optional
    &  file_prefix = 'xhistauto/test03-' )                ! (in) optional

  call HistoryAutoPutAxis( &
    & dim = 'y', array = (/ -2.0, 0.0, 3.0 /) )  ! (in)

  call HistoryAutoAddWeight( &
    & dim = 'y', weight = (/ 1.5, 2.5, 3.5 /) )  ! (in)

  call HistoryAutoPutAxis( &
    & dim = 'z', array = (/ 0.0, 20.0, 50.0, 90.0 /) )  ! (in)

  call HistoryAutoAddWeight( &
    & dim = 'z', &                                   ! (in)
    & weight = (/ 10.0, 25.0, 45.0, 20.0 /) * 2.0, & ! (in)
    & units = 'deg.*2' , xtype = 'double' )          ! (in) optional

  call HistoryAutoAddAttr( &
    & varname = 'x', attrname = 'test_attr', &   ! (in)
    & value = 'test_attr_value' )                ! (in)

  call HistoryAutoAddVariable( &
    & 'u', (/'x   ', 'y   ', 'z   ', 'time'/), 'u', 'm s-1' ) ! (in)

  do i = 1, 3
    call HistoryAutoPut( 'u', (/ ( real(j), j = 1, 24 ) /) * i )
    call HistoryAutoProgress
  end do

  call HistoryAutoClose


  ! NAMELIST Ѥ, ƥ 1
  ! Output settings test 1 with NAMELIST
  !
  call HistoryAutoCreate( &
    &       title = 'Test04 for gt4_historyauto', & ! (in)
    &      source = source, &                       ! (in)
    & institution = institution, &                  ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 2, 3, 4, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm  ',  'm  ',  'm  ',  'hrs'  /), & ! (in)
    & namelist_filename = 'histauto_nml04.nml', &         ! (in) optional
    &     interval = 1.0, &                               ! (in) optional
    & current_time = 60.0, &                              ! (in) optional
    &   delta_time = 30.0 )                               ! (in) optional

  call HistoryAutoAddVariable( &
    & 'u1', (/'x   ', 'time'/), 'u1', 'm s-1' ) ! (in)

  call HistoryAutoAddVariable( &
    & 'u2', (/'y   ', 'time'/), 'u2', 'm s-1' ) ! (in)

  call HistoryAutoAddVariable( &
    & 'u3', (/'z   ', 'time'/), 'u3', 'm s-1' ) ! (in)

  call HistoryAutoAddVariable( &
    & 'v', (/'y   ', 'time'/), 'v', 'm s-1', & ! (in)
    & average = .true. )                       ! (in) optional

  call HistoryAutoAddVariable( &
    & 'w', (/'z   ', 'time'/), 'z', 'm s-1', & ! (in)
    & xtype = 'double' )                       ! (in) optional

  do i = 1, 41
    call HistoryAutoPut( 'u1', (/ ( real(j), j = 1, 2 ) /) * i )
    call HistoryAutoPut( 'u2', (/ ( real(j), j = 1, 3 ) /) * i )
    call HistoryAutoPut( 'u3', (/ ( real(j), j = 1, 4 ) /) * i )
    call HistoryAutoPut( 'v', (/ ( real(j), j = 1, 3 ) /) * i )
    call HistoryAutoPut( 'w', (/ ( real(j), j = 1, 4 ) /) * i )
    call HistoryAutoProgress
  end do

  call HistoryAutoClose

end program histauto
