!= gt4_historyauto_h Υƥȥץ
!= Test program of "gt4_historyauto_h"
!
! Authors::   Takeshi HORINOUCHI, Yasuhiro MORIKAWA
! Version::   $Id: histauto_h.f90,v 1.1 2008-07-13 12:14:34 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20080810 $
! Copyright:: Copyright (C) GFD Dennou Club, 2004-2008. All rights reserved. 
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

program histauto_h
  use gt4_historyauto_h
  implicit none
  type(GT4_REAL1D)        :: spcoordvars(2)
  type(GT4_NAMED_REALARY) :: ancilcrdvars(2)
  type(GT4_ATTRIBUTE)     :: attrs(1)
  integer,parameter :: nx=7,ny=5
  real :: val(nx,ny),lon(nx,ny),lat(nx,ny)
  real :: dt = 6.0, time
  integer :: i,j,kt
  
  spcoordvars(1) = init_gt4_real1d( (/(1.0*i,i=0,nx-1)/) )
  spcoordvars(2) = init_gt4_real1d( (/(1.0*i,i=0,ny-1)/) )
  
  lon = reshape( (/ ((10.0*(i-j),i=0,nx-1), j=0,ny-1) /), (/nx,ny/) )
  lat = reshape( (/ ((10.0*(i+j),i=0,nx-1), j=0,ny-1) /), (/nx,ny/) )
  
  attrs(1) = init_gt4_attribute('coordinates', cval='lon lat')
  
  ancilcrdvars(1) = init_gt4_named_realary('lon',2,(/'x','y'/),nx*ny,lon, &
    & 'longitude', 'degrees_east')
  ancilcrdvars(2) = init_gt4_named_realary('lat',2,(/'x','y'/),nx*ny,lat, &
    & 'latitude', 'degrees_north')
  
  !<< HistoryAutoCreate full version & HistoryAutoCopyCreate >>
  
  call HistoryAutoCreate( name='u', longname='U velocity', units='m.s-1', &
    & file='xhistauto/tmp.nc',  &
    & slfst=(/1,1/), sllst=(/0,0/), slstp=(/2,2/), &
    & time_to_start=0.0, put_interval=60.0, dt=dt, &
    & newfile_interval=-999.0, &
    & attrs=attrs, aryshape=(/nx,ny/), &
    & dims=(/'x','y','t'/), axlongnames=(/'x','y','t'/), &
    & axunits=(/'m','m','s'/), axxtypes=(/'','',''/), &
    & spcoordvars=spcoordvars, ancilcrdvars=ancilcrdvars, &
    & title='*test*', source='hori', institution='KU', &
    & proc='' )
  call HistoryAutoCopyCreate( name='v', longname='V velocity', units='m.s-1' )
  call HistoryAutoCopyCreate( name='w', longname='W velocity', units='m.s-1', &
    & file='xhistauto/tmp3.nc' )
  
  ! << HistoryAutoCommon and HistoryAutoSetGrid to set common data in a run >>
  
  call HistoryAutoSetRunInfo(title='*test*', source='hori', institution='KU',&
    & proc='')
  
  call HistoryAutoSetGrid(grid_label='surface', aryshape=(/nx,ny/), &
    & dims=(/'x','y','t'/), axlongnames=(/'x','y','t'/), &
    & axunits=(/'m','m','s'/), axxtypes=(/'','',''/), &
    & coord1=spcoordvars(1)%ary, coord2=spcoordvars(2)%ary, &
    & ancilcrdvars=ancilcrdvars )
  
  ! << HistoryAutoCreate2 using both the SetRunInfo and SetGrid setting >>
  
  call HistoryAutoCreate( name='u', longname='U velocity', units='m.s-1', &
    & file='xhistauto/tmp1.nc',  &
    & slfst=(/1,1/), sllst=(/0,0/), slstp=(/2,2/), &
    & time_to_start=0.0, put_interval=60.0, dt=dt, &
    & newfile_interval=-999.0, &
    & attrs=attrs, &
    & grid_label='surface' )
  
  ! << HistoryAutoCreate1 using only the SetRunInfo setting >>
  
  call HistoryAutoCreate( name='u', longname='U velocity', units='m.s-1', &
    & file='xhistauto/tmp2.nc', &
    & slfst=(/2,2/), sllst=(/0,0/), slstp=(/3,3/), &
    & time_to_start=0.0, put_interval=36.0, dt=dt, &
    & newfile_interval=120.0, &
    & aryshape=(/nx,ny/), &
    & dims=(/'x','y','t'/), axlongnames=(/'x','y','t'/), &
    & axunits=(/'m','m','s'/), axxtypes=(/'','',''/), &
    & spcoordvars=spcoordvars  )
  call HistoryAutoCopyCreate( name='w', longname='W velocity', units='m.s-1' )
  
  do kt=0,50
    val = reshape( (/ ((i+j-2.0,i=1,nx), j=1,ny) /), (/nx,ny/) ) * max(kt,1)
    time = dt*kt
    if (HistoryAutoWhetherPutNow('u',time)) print *, time
    call HistoryAutoPut('u',val,    time)
    call HistoryAutoPut('v',val-3,  time)
    call HistoryAutoPut('w',val/10, time)
  enddo
  
end program histauto_h
