program dc_args_test
  use dc_types
  use dc_string, only: StoA, JoinChar
  use dc_args, only: ARGS, Open, Close, &
    & Option, Put_Line, Debug, Help, Strict, Get, HelpMsg, Size
  use dc_test, only: Compare
  implicit none
  type(ARGS) :: arg
  logical :: OPT_size
  logical :: OPT_namelist
  character(STRING) :: VAL_namelist, char
  character(TOKEN), pointer :: argv(:) => null()
continue

  call Open(arg)
  call HelpMsg(arg, 'Title', 'dcargs $Revision: 1.3 $ :: Test program of dc_args')
  call HelpMsg(arg, 'Usage', 'dcargs [Options] arg1, arg2, ...')
  call Option(arg, StoA('-s', '--size'), &
    & OPT_size, help="Return number of arguments")
  call Option(arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help="Namelist filename")
  call HelpMsg(arg, 'DESCRIPTION', &
    & '(1) Define type "HASH". ' // &
    & '(2) Open the variable. ' // &
    & '(3) set HelpMsg. ' // &
    & '(4) set Options. ' // &
    & '(5) call Debug. ' // &
    & '(6) call Help. ' // &
    & '(7) call Strict.')
  call HelpMsg(arg, 'Copyright', &
    & 'Copyright (C) GFD Dennou Club, 2006. All rights reserved.')
  call Debug(arg)
  call Help(arg)
  call Strict(arg)
  call Get(arg, argv)

  call Compare('Number of arguments test', 3, size(arg))

  call Compare('Short option test 1', .true., OPT_size)

  call Compare('Long option test 1', .true., OPT_namelist)
  call Compare('Long option test 2', 'test.nml', VAL_namelist)

  char = trim(JoinChar(argv))

  call Compare('Strings of arguments test', 'arg1, arg2, arg3', char)

  deallocate(argv)
  call Close(arg)

end program dc_args_test
