!== dc_error.f90 - 顼
!
! Authors::   Eizi TOYODA, Yasuhiro MORIKAWA
! Version::   $Id: dc_error.f90,v 1.8 2006/06/04 12:48:43 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20060725 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! This file provides dc_error
!
module dc_error
  !
  != 顼ѥ⥸塼
  !
  !== 
  !
  ! ץʤɬ顼μ갷Τ˵ꤹ٤ΤǤ
  ! 顼ȤʤؤϤŬڤǤȤ
  ! Ԥư򤹤뤳ȤǤʤȤä֤ؤޤ
  !
  ! gt4f90io 饤֥꤬桼󶡤³
  ! (³Ȥϥ֥롼ޤϴؿ) ϤۤȤɤξ硢
  ! ʲ 2 ĤΤ줫ǸƤӽФ˥顼𤷤ޤ
  !
  ! * 顼ȯŬڤʥåɽƥץཪλ
  ! * ξάǤ err Ϳ줿ϡ
  !   顼ˤϤ <tt>.true.</tt> ˤޤ
  !   err ά줿ϾƱ
  !
  ! νϤ٤ dc_error ⥸塼 StoreError
  ! ֥롼ǹԤäƤޤѻͤʤɤ˴ؤƤ StoreError
  ! 򻲾ȤƤ
  !
  !
  !== 顼ɰ
  !
  ! gt4f90io 饤֥˥ɤɲäץޤŬڤ
  ! 顼ɤ StoreError ƤӽФ褦ˤʤФʤޤ
  ! ǡ 顼ɤɬפ뤫ɤ
  ! Ƚꤹ뤿ˡ 顼ɤͤбåޤ
  ! 顼ɥˡ˥åѤ뤿ˤϡ
  ! <b><tt>NF_E</tt></b> ǻϤޤ̾ˤĤƤ netcdf_f77
  ! ⥸塼Ѥ뤫 include 'netcdf.inc' ԤʸԤϿ侩ޤˡ
  ! <b><tt>GT_E</tt></b> ǻϤޤ̾ˤĤƤ dc_error
  ! ⥸塼ѤƤ
  ! ޤ <b><tt>USR_E</tt></b> ǻϤޤ̾ϳơΥ桼
  ! ɤ顼ɤǤ
  !
  ! 顼ǤϤʤ֤ɽ󥨥顼ɤ
  ! DC_NOERR ( 0) Ǥ
  !
  ! 顼ɤοͤߤΤϡʥ顼ɤ
  ! Ƥݤλؿˤ򼨤Ǥ
  ! ɤǤϥ顼ɤˡ˥åͿ٤Ǥꡢ
  ! ͤϡɥɤ뤳Ȥϸ˿ǲ
  !
  !=== Ѥʤ
  !
  ! ͤϥ顼ɤȤƻѤޤ
  !
  ! NetCDF 饤֥ libc Υ顼 errno ֤ǽꡢ
  ! errno οͤˤϰܿʤᡢƤͤ errno
  ! λͤΤͽ󤵤Ƥ٤Ǥ
  !
  !=== 󥨥顼
  !
  ! ʲ󥨥顼ɤ˴ؤƤ dc_error ⥸塼Ѥ뤳Ȥ
  ! ѤƤ
  !
  ! <b></b> :: <b>  [ ˡ˥å ]</b>
  !
  ! 0       :: [ <b>DC_NOERR       </b> ]
  !
  !
  !=== netCDF ˴ؤ륨顼
  !
  ! ʲΥ顼ɤ˴ؤƤ netcdf_f77 ⥸塼Ѥ뤳Ȥ
  ! ѤƤ
  !
  ! <b></b> :: <b>  [ ˡ˥å ] 顼å </b>
  !
  ! 0       :: [ <b>NF_NOERR       </b> ]
  !            <b></b> :: No Error  (󥨥顼ɤǤ)
  !
  ! -33     :: [ <b>NF_EBADID      </b> ]
  !            <b></b> :: Not a netCDF id:
  !
  ! -34     :: [ <b>NF_ENFILE      </b> ] 
  !            <b></b> :: Too many netCDF files open:
  !
  ! -35     :: [ <b>NF_EEXIST      </b> ] 
  !            <b></b> :: netCDF file exists && NC_NOCLOBBER:
  !
  ! -36     :: [ <b>NF_EINVAL      </b> ] 
  !            <b></b> :: Invalid argument:
  !
  ! -37     :: [ <b>NF_EPERM       </b> ] 
  !            <b></b> :: Write to read only:
  !
  ! -38     :: [ <b>NF_ENOTINDEFINE</b> ] 
  !            <b></b> :: Operation not allowed in data mode
  !
  ! -39     :: [ <b>NF_EINDEFINE   </b> ] 
  !            <b></b> :: Operation not allowed in define mode
  !
  ! -40     :: [ <b>NF_EINVALCOORDS</b> ] 
  !            <b></b> :: Index exceeds dimension bound
  !
  ! -41     :: [ <b>NF_EMAXDIMS    </b> ] 
  !            <b></b> :: NC_MAX_DIMS exceeded
  !
  ! -42     :: [ <b>NF_ENAMEINUSE  </b> ] 
  !            <b></b> :: String match to name in use
  !
  ! -43     :: [ <b>NF_ENOTATT     </b> ] 
  !            <b></b> :: Attribute not found
  !
  ! -44     :: [ <b>NF_EMAXATTS    </b> ] 
  !            <b></b> :: NC_MAX_ATTRS exceeded
  !
  ! -45     :: [ <b>NF_EBADTYPE    </b> ] 
  !            <b></b> :: Not a netCDF data type or _FillValue type mismatch
  !
  ! -46     :: [ <b>NF_EBADDIM     </b> ] 
  !            <b></b> :: Invalid dimension id or name
  !
  ! -47     :: [ <b>NF_EUNLIMPOS   </b> ] 
  !            <b></b> :: NC_UNLIMITED in the wrong index
  !
  ! -48     :: [ <b>NF_EMAXVARS    </b> ] 
  !            <b></b> :: NC_MAX_VARS exceeded
  !
  ! -49     :: [ <b>NF_ENOTVAR     </b> ] 
  !            <b></b> :: Variable not found
  !
  ! -50     :: [ <b>NF_EGLOBAL     </b> ] 
  !            <b></b> :: Action prohibited on NC_GLOBAL varid
  !
  ! -51     :: [ <b>NF_ENOTNC      </b> ] 
  !            <b></b> :: Not a netCDF file
  !
  ! -52     :: [ <b>NF_ESTS        </b> ] 
  !            <b></b> :: In Fortran, string too short
  !
  ! -53     :: [ <b>NF_EMAXNAME    </b> ] 
  !            <b></b> :: NC_MAX_NAME exceeded
  !
  ! -54     :: [ <b>NF_EUNLIMIT    </b> ] 
  !            <b></b> :: NC_UNLIMITED size already in use
  !
  ! -55     :: [ <b>NF_ENORECVARS  </b> ] 
  !            <b></b> :: NC_rec op when there are no record vars
  !
  ! -56     :: [ <b>NF_ECHAR       </b> ] 
  !            <b></b> :: Attempt to convert between text & numbers
  !
  ! -57     :: [ <b>NF_EEDGE       </b> ] 
  !            <b></b> :: Edge+start exceeds dimension bound
  !
  ! -58     :: [ <b>NF_ESTRIDE     </b> ] 
  !            <b></b> :: Illegal stride
  !
  ! -59     :: [ <b>NF_EBADNAME    </b> ] 
  !            <b></b> :: Attribute or variable name contains illegal characters
  !
  ! -60     :: [ <b>NF_ERANGE      </b> ] 
  !            <b></b> :: Numeric conversion not representable
  !
  ! -61     :: [ <b>NF_ENOMEM      </b> ] 
  !            <b></b> :: Memory allocation (malloc) failure
  !
  ! -62-99:: <b>               </b>
  !            <b></b> :: ( netCDF γĥ gtool4 ͽΰ)
  !
  !
  !=== gt4f90io Υǡ¤˴ؤ륨顼
  !
  ! ʲΥ顼ɤ˴ؤƤ dc_error ⥸塼Ѥ뤳Ȥ
  ! ѤƤ
  !
  ! <b></b> :: <b>  [ ˡ˥å ] 顼å </b>
  !
  ! -100    :: [ <b>GT_EFAKE           </b> ]
  !            <b></b> :: function not implemented
  !
  ! -101    :: [ <b>GT_ENOMOREDIMS     </b> ]
  !            <b></b> :: dimension number %d is out of range
  !
  ! -102    :: [ <b>GT_EDIMNODIM       </b> ]
  !            <b></b> :: dimension variable has no dimension
  !
  ! -103    :: [ <b>GT_EDIMMULTIDIM    </b> ]
  !            <b></b> :: dimension variable has many dimensions
  !
  ! -104    :: [ <b>GT_EDIMOTHERDIM    </b> ]
  !            <b></b> :: dimension variable has another dimension
  !
  ! -105    :: [ <b>GT_EBADDIMNAME     </b> ]
  !            <b></b> :: <i>string_c</i> ޤ <i>string_s</i>:
  !                       unknown dimension name
  !
  ! -106    :: [ <b>GT_ENOTVAR         </b> ]
  !            <b></b> :: variable not opened
  !
  ! -107    :: [ <b>GT_ENOMEM          </b> ]
  !            <b></b> :: allocate/deallocate error
  !
  ! -108    :: [ <b>GT_EOTHERFILE      </b> ]
  !            <b></b> :: specified dimensional variable not on the same file
  !
  ! -109    :: [ <b>GT_EARGSIZEMISMATCH</b> ]
  !            <b></b> :: arguments (<i>string_c</i>) array size mismatch
  !
  ! -110    :: [ <b>GT_ENOMATCHDIM     </b> ]
  !            <b></b> :: dimension matching failed
  !
  ! -111    :: [ <b>GT_ELIMITED        </b> ]
  !            <b></b> :: variable already limited
  !
  ! -112    :: [ <b>GT_EBADVAR         </b> ]
  !            <b></b> :: variable type not supported
  !
  ! -113    :: [ <b>GT_ECHARSHORT      </b> ]
  !            <b></b> :: character length not enough
  !
  ! -114    :: [ <b>GT_ENOUNLIMITDIM   </b> ]
  !            <b></b> :: NC_UNLIMITED dimension is not found
  !
  ! -115    :: [ <b>GT_EBADATTRNAME    </b> ]
  !            <b></b> :: invalid attribute name
  !
  ! -116    :: [ <b>GT_EBADHISTORY     </b> ]
  !            <b></b> :: invalid GT_HISTORY variable
  !
  ! -117    :: [ <b>GT_EBADALLOCATESIZE</b> ]
  !            <b></b> :: invalid allocated size
  !
  ! -118    :: [ <b>GT_ERANKMISMATCH</b> ]
  !            <b></b> :: rank of data and argument is mismatch (<i>string_c</i>)
  !
  ! -299  :: <b>                     </b>
  !            <b></b> :: ( gtdata ؤΥ顼åΤͽ)
  !
  !=== GrADS Ϥ˴ؤ륨顼
  !
  ! ʲΥ顼ɤ˴ؤƤ dc_error ⥸塼Ѥ뤳Ȥ
  ! ѤƤ
  !
  ! <b></b> :: <b>  [ ˡ˥å ] 顼å </b>
  !
  ! -300    :: [ <b>GR_ENOTGR          </b> ]
  !            <b></b> :: invalid GrADS file
  !
  ! -399  :: <b>                     </b>
  !            <b></b> :: ( GrADS 󥿡եؤ
  !                       顼åΤͽ)
  !
  !=== gt4f90io ˴ؤͽ󤷤Ƥ륨顼
  !
  ! ʲΥ顼ɤϺγĥͤͽ󤷤ƤʬǤ
  !
  ! <b></b> :: <b>  [ ˡ˥å ] 顼å </b>
  !
  ! -400-999  :: <b>                     </b>
  !                <b></b> :: ( gt4f90io 
  !                           顼åΤͽ)
  !
  !=== 桼ѥ顼
  !
  ! ʲΥ顼ɤޤ -1000 ⾮顼ɤϡ
  ! gt4f90io ξ̤ΥץबѤ륨顼ɤȤƶƤޤ
  !
  ! <b></b> :: <b>  [ ˡ˥å ] 顼å </b>
  !
  ! -1000   :: [ <b>USR_ECHAR          </b> ]
  !            <b></b> :: <i>string_c</i>
  !
  ! -1001   :: [ <b>USR_EINT           </b> ]
  !            <b></b> :: <i>string_c</i> (<i>string_i</i>)
  !
  !

  use netcdf_f77, only: NF_ENOTVAR, NF_EINVAL
  implicit none
  private
  public :: NF_ENOTVAR, NF_EINVAL

  ! 顼ݻ

  integer, public, parameter   :: DC_NOERR  = 0
  integer, private, save       :: errno     = DC_NOERR
  integer, private, save       :: cause_int = DC_NOERR
  character(80), private, save :: cause_string = ""
  character(80), private, save :: cause_location = ""

  ! Υ顼ֹ libc ƥ२顼åΤ
  ! Ƥ롣ƥ¸礭礭ʿͤ
  ! ѤΤǶΰݤΤϺǤ롣
  !
  ! Υ顼ֹ netCDF ȤäƤ롣γĥ⸫ǡ
  ! -99 ޤǤϻȤʤ֤

  integer, parameter, public:: GT_EFAKE = -100

  !
  ! -101 ʲ: ǡ¤Υ顼
  !
  integer, parameter, public:: GT_ENOMOREDIMS      = -101
  integer, parameter, public:: GT_EDIMNODIM        = -102
  integer, parameter, public:: GT_EDIMMULTIDIM     = -103
  integer, parameter, public:: GT_EDIMOTHERDIM     = -104
  integer, parameter, public:: GT_EBADDIMNAME      = -105
  integer, parameter, public:: GT_ENOTVAR          = -106
  integer, parameter, public:: GT_ENOMEM           = -107
  integer, parameter, public:: GT_EOTHERFILE       = -108
  integer, parameter, public:: GT_EARGSIZEMISMATCH = -109
  integer, parameter, public:: GT_ENOMATCHDIM      = -110
  integer, parameter, public:: GT_ELIMITED         = -111
  integer, parameter, public:: GT_EBADVAR          = -112
  integer, parameter, public:: GT_ECHARSHORT       = -113
  integer, parameter, public:: GT_ENOUNLIMITDIM    = -114
  integer, parameter, public:: GT_EBADATTRNAME     = -115
  integer, parameter, public:: GT_EBADHISTORY      = -116
  integer, parameter, public:: GT_EBADALLOCATESIZE = -117
  integer, parameter, public:: GT_ERANKMISMATCH    = -118

  !
  ! -300 ʲ: GrADS ϤΥ顼
  !
  integer, parameter, public:: GR_ENOTGR = -300

  !
  ! -1000 ʲ: 桼
  !
  integer, parameter, public:: USR_ECHAR = -1000
  integer, parameter, public:: USR_EINT  = -1001

  public:: StoreError, DumpError, GetErrorMessage, ErrorCode
  !
  ! === ³ѻ ===
  !
  ! 캹ؤ褦˳ؿˤƤ

  interface
    subroutine DumpError()
    end subroutine DumpError
  end interface

contains

  integer function ErrorCode() result(result)
    !
    ! ꤵƤ륨顼ɤ֤ޤ
    !
    result = errno
  end function ErrorCode

  subroutine GetErrorMessage(msg)
    !
    ! ꤵƤ륨顼ɤбå֤ޤ
    !
    use netcdf_f77, only: nf_strerror
    use dc_string , only: toChar
    character(len = *), intent(out):: msg
    character(len = 180):: message
  continue
    select case(errno)
    case(GT_EFAKE)
      msg = " function not implemented"
      !
      ! -101 ʲ: ǡ¤Υ顼
      !
    case(GT_ENOMOREDIMS)
      write(message, "(': dimension number', i4, ' is out of range')") cause_int
      msg = trim(message)
    case(GT_EBADDIMNAME)
      msg = '(' // trim(cause_string) // '): unknown dimension name'
    case(GT_ENOTVAR)
      msg = " variable not opened"
    case(GT_ENOMEM)
      msg = " allocate/deallocate error"
    case(GT_EDIMNODIM)
      msg = " dimension variable has no dimension"
    case(GT_EDIMMULTIDIM)
      msg = " dimension variable has many dimensions"
    case(GT_EDIMOTHERDIM)
      msg = " dimension variable has another dimension"
    case(GT_EOTHERFILE)
      msg = " specified dimensional variable not on the same file"
    case(GT_EARGSIZEMISMATCH)
      msg = " arguments (" // trim(cause_string) //") array size mismatch"
    case(GT_ENOMATCHDIM)
      msg = " dimension matching failed"
    case(GT_ELIMITED)
      msg = " variable already limited"
    case(GT_EBADVAR)
      msg = " variable type not supported"
    case(GT_ECHARSHORT)
      msg = " character length not enough"
    case(GT_ENOUNLIMITDIM)
      msg = " NC_UNLIMITED dimension is not found"
    case(GT_EBADATTRNAME)
      msg = " invalid attribute name"
    case(GT_EBADALLOCATESIZE)
      msg = " invalid allocated size"
    case(GT_ERANKMISMATCH)
      msg = " rank of data and argument are mismatch (" // trim(cause_string) // ")"
      !
      ! -300 ʲ: GrADS ϤΥ顼
      !
    case(GR_ENOTGR)
      msg = " invalid GrADS file"
      !
      ! -1000 ʲ: 桼
      !
    case(USR_ECHAR)
      msg = trim(cause_string)
    case(USR_EINT)
      msg = trim(cause_string) // ' (' // trim(toChar(cause_int)) // ')'
    case default
      goto 999
    end select
    msg =  '*** ERROR (Code ' // trim(toChar(errno))  // &
      & ') [' // trim(cause_location) // '] ***  ' // &
      & trim(msg)
    return

999 continue
    if (len(cause_string) > 0) then
      message = nf_strerror(errno)
      msg =  '*** ERROR (Code ' // trim(toChar(errno)) // &
        & ') [' // trim(cause_location)             // &
        & '('   // trim(cause_string) // ')] ***  ' // &
        & trim(message)
    else if (cause_int /= 0) then
      message = nf_strerror(errno)
      msg =  '*** ERROR (Code ' // trim(toChar(errno)) // &
        & ') [' // trim(cause_location)             // &
        & '('   // trim(toChar(cause_int)) // ')] ***  ' // &
        & trim(message)
    else
      message = nf_strerror(errno)
      msg =  '*** ERROR (Code ' // trim(toChar(errno))  // &
        & ') [' // trim(cause_location) // '] ***  ' // &
        & trim(message)
    endif
  end subroutine GetErrorMessage

  subroutine StoreError(number, where, err, cause_c, cause_i)
    !
    !== ŵŪ饤֥ؿΤ˺줿顼ؿ
    !
    ! ɬפʰ2ĤǤꡢ1 number Υ顼ɡ
    ! 2 where ʸǥ顼ȯ³̾Ϳޤ
    ! ǥեȤǤϰʲηʸɸ ɽƥץ
    ! Ͻλޤ 顼å error_message
    ! ϥ顼ɤ鼫ưŪ˷ޤޤ
    ! бɽ顼ɰˤΤǻȤƤ
    !
    !     
    !     *** ERROR (Code number) [where] ***  error_message
    !     
    !     *** ERROR (Code number) [where(cause_c)] ***  error_message
    !
    ! ʤgt4f90io  饤֥곰 桼顼ѥġ
    ! Ȥ StoreError Ѥ뤳ȤꤷUSR_ECHAR  USR_EINT
    ! ѰդƤޤ Υ顼ɤѤȡ
    ! StoreError ϰʲηʸ "*" ˽Ϥƥץ
    ! λޤ ʤ°פ˻ȤåѡȤ 
    ! dc_message ⥸塼ѰդƤΤǤ⻲ȤƤ
    !
    !     
    !     *** ERROR (Code USR_ECHAR) [where] ***  cause_c
    !     
    !     *** ERROR (Code USR_EINT) [where] ***  cause_c (cause_i)
    !
    !--
    !== ȯԸ
    !
    ! 顼ֹ number  errno ˳Ǽ롣ƱտŪ
    ! where, cause_i  cause_location, cause_string,
    ! cause_int ˳Ǽ롣 
    ! err ͿƤ硢err  number  0 ξˤʤ롣
    ! number  0 ʤ¨롣
    ! err ͿƤʤХ顼å * ˽Ϥ
    ! ץλ롣
    !++

    use dc_string, only: assignment(=)
    integer,            intent(in)            :: number  ! 顼
    character(len = *), intent(in)            :: where   ! 顼ȯĽ
    logical,            intent(out), optional :: err
                                         ! ѿͿ줿ϡ
                                         ! 顼ˤϤ <tt>.true.</tt>
                                         ! ˤޤѿά졢
                                         ! ĥ顼ȯ
                                         ! åɽƥץ
                                         ! λޤ
    character(len = *), intent(in),  optional :: cause_c ! ʸå
    integer,            intent(in),  optional :: cause_i ! å
  continue
    errno = number
    cause_location = where
    if (present(cause_c)) then
      cause_string = trim(cause_c)
    else
      cause_string = ""
    endif
    if (present(cause_i)) cause_int = cause_i
    if (present(err)) then
      err = (number /= DC_NOERR)
      return
    endif
    if (number == DC_NOERR) return
    call DumpError
  end subroutine StoreError

end module dc_error

subroutine DumpError()
  !
  ! GetErrorMessage 饨顼å塢
  !  sysdep#AbortProgram Ϥƥץλޤ
  !
  use dc_types, only: STRING
  use dc_string, only: put_line
  use dc_error, only: GetErrorMessage
  use sysdep, only: AbortProgram
  character(len = STRING):: message
continue
  call GetErrorMessage(message)
  call AbortProgram(message)
end subroutine DumpError
