!== Formatted output conversion
!
! Authors::   Yasuhiro MORIKAWA, Eizi TOYODA
! Version::   $Id: dcstringsprintf.f90,v 1.5 2006/07/17 15:46:47 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20060818 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
! C  sprintf(3) Τ褦ʸեޥåȤ֤ޤ
!  C  sprintf(3) Ȥʬ㤦ΤǤդ
!
!== Formatter
!
! dc_string#CPrintf, dc_string#Printf ΥեޥåȰ
! ѤؼҤ <b><tt>%</tt></b> ǻϤޤޤ
! ʲ̤Ǥ
!
! <b><tt>ؼ</tt></b> ::
!    <tt>б</tt> :: ǡμȽϷ
!
! <b><tt>%d, %D</tt></b> ::
!    <tt>i(:)</tt>       :: ǡ (10 ʿ)  20  ɽ
!
! <b><tt>%o, %O</tt></b> ::
!    <tt>i(:)</tt>       :: 8 ʿǡ 20 ɽ
!
! <b><tt>%x, %X</tt></b> :: 
!    <tt>i(:)</tt>       :: 16 ʿǡ 20 ɽ
!
! <b><tt>%f, %F</tt></b> :: 
!    <tt>d(:)</tt>       :: ټ¿ǡ 80η 40ɽ
!
! <b><tt>%r, %R</tt></b> :: 
!    <tt>r(:)</tt>       :: ñټ¿ǡ 80η 40ɽ
!
! <b><tt>%b, %B</tt></b> :: 
!    <tt>L(:)</tt>       :: ǡ TF ɽ
!
! <b><tt>%y, %Y</tt></b> :: 
!    <tt>L(:)</tt>       :: ǡ yesno ɽ
!
! <b><tt>%s, %S</tt></b> :: 
!    <tt>s(:)</tt>       :: VSTRINGǡ
!
! <b><tt>%c, %C</tt></b> :: 
!    <tt>c1c2c3</tt> :: ʸǡ (ѿ)
!
! <b><tt>%a, %A</tt></b> :: 
!    <tt>ca</tt>         :: ʸǡ ()
!
!
! ʸǡ (ѿ) ʳϡ1ĤηΥǡ򤤤ĤǤͿ뤳ȤǽǤ
! ʸǡ (ѿ)  c1c2c3 ˤ줾 1
! ĤŤĤʸǡͿ뤳ȤǤޤ
! +ca+ Ѥ dc_string#StoA ʻѤǤ
!
! ޤեޥåȻҤȤ <b><tt>%*</tt></b> Ϳ뤳Ȥǡ
! ʣΥǡ٤˽Ϥ뤳ȤǽǤ
! ξ硢ĤΥǡ٤˽Ϥ뤫 <tt>n(:)</tt>
! Ϳɬפޤ
!
!== Example
!
!=== dc_string#CPrintf ѤϤ
!
!      use dc_types,  only: STRING
!      use dc_string, only: CPrintf
!      character(len = STRING) :: output, color="RED", size="Large"
!      integer, parameter      :: n1 = 2, n2 = 3
!      integer                 :: int = 10, arrayI1(n1), arrayI2(n2), i
!      real                    :: arrayR(n1)
!      logical                 :: eq
!   
!      do, i = 1, n1
!        arrayI1(i) = 123 * i ; arrayR(i)  = 1.23 * i
!      enddo
!      do, i = 1, n2
!        arrayI2(i) = 345 * i
!      enddo
!      eq = (maxval(arrayI1) == minval(arrayI2))
!      output = CPrintf(fmt="color=%c size=%c int=%d I1=%*d I2=%*d R=%*r equal=%y", &
!        &              c1=trim(color), c2=trim(size), i=(/int, arrayI1, arrayI2/), &
!        &              r=(/arrayR/), L=(/eq/), n=(/n1, n2, n1/))
!   
!      write(*,*) trim(output)
!
! ʸǡʳΤΤϴŪ1󤷤ˤȤʤᡢ
! ¿ϤˤȹߴؿǤ pack ؿ
! ѤɤǤ礦ʲˤ򵭤ޤ
!
!      use dc_types,  only: STRING
!      use dc_string, only: CPrintf
!      character(len = STRING) :: output
!      integer                 :: i,j,k
!      integer, parameter      :: n1 = 2, n2 = 3, n3 = 4
!      real                    :: array(n1,n2,n3)
!   
!      do, i = 1, n1
!        do, j = 1, n2 
!          do, k = 1, n3
!            array(i,j,k) = i * 0.1 + j * 1.0 + k * 10.0
!          enddo
!        enddo
!      enddo
!      output = CPrintf('array=<%*r>', &
!        &              r=(/pack(array(:,:,:), .true.)/), n=(/size(array(:,:,:))/))
!      write(*,*) trim(output)
!
!=== dc_string#Printf ѤϤ
!
!      use dc_types,  only: STRING
!      use dc_string, only: Printf
!      character(len = STRING) :: output, color="RED", size="Large"
!      integer, parameter      :: n1 = 2, n2 = 3
!      integer                 :: int = 10, arrayI1(n1), arrayI2(n2), i
!      real                    :: arrayR(n1)
!      logical                 :: eq
!
!      do, i = 1, n1
!        arrayI1(i) = 123 * i   ; arrayR(i)  = 1.23 * i
!      enddo
!      do, i = 1, n2
!        arrayI2(i) = 345 * i
!      enddo
!      eq = (maxval(arrayI1) == minval(arrayI2))
!
!      ! ֹ 6 (ɸ) ľܽϤ
!      call Printf(unit=6, &
!        &         fmt="color=%c size=%c int=%d I1=%*d I2=%*d R=%*r equal=%y", &
!        &         c1=trim(color), c2=trim(size), i=(/int, arrayI1, arrayI2/), &
!        &         r=(/arrayR/), L=(/eq/), n=(/n1, n2, n1/))
!
!      ! ʸ output Ϥ
!      call Printf(unit=output, &
!        &         fmt="color=%c size=%c int=%d I1=%*d I2=%*d R=%*r equal=%y", &
!        &         c1=trim(color), c2=trim(size), i=(/int, arrayI1, arrayI2/), &
!        &         r=(/arrayR/), L=(/eq/), n=(/n1, n2, n1/))
!      write(*,*) trim(output)


subroutine DCStringSPrintf(unit, fmt, i, r, d, L, s, n, c1, c2, c3, ca)
  !
  ! եޥåʸ fmt ˽äѴ줿ʸ unit ֤ޤ
  ! 2 fmt ˤϻؼҤޤʸͿޤ
  ! ؼҤˤϡ<tt>%</tt>פѤޤ
  ! <tt>%</tt> Ѥ <tt>%%</tt>פȵҤޤ
  ! ؼҤ˴ؤƤξܺ٤ dcstringsprintf.f90 򻲾Ȥ
  !
  use dcstring_base, only: VSTRING, assignment(=) !:nodoc:
  use dc_types,      only: DP
  implicit none
  character(*),     intent(out)         :: unit
  character(*),     intent(in)          :: fmt
  integer,          intent(in), optional:: i(:), n(:)
  real,             intent(in), optional:: r(:)
  real(DP),         intent(in), optional:: d(:)
  logical,          intent(in), optional:: L(:)
  type(VSTRING),    intent(in), optional:: s(:)
  character(*),     intent(in), optional:: c1, c2, c3
  character(*),     intent(in), optional:: ca(:)

  ! 嵭Υ
  integer:: ni, nr, nd, nl, ns, nc, na, nn
  integer:: ucur       ! unit ˽񤫤줿ʸ
  integer:: endp       ! ˽줿 fmt ʸ
  integer:: cur        ! ʸ fmt(cur:cur) Ǥ
  integer:: ptr        ! fmt 鸡򤹤Ȥ˻
  integer:: repeat     ! % ޤ %* ꤵ줿֤
  integer:: m          ! 1:repeat ϰϤư롼ѿ
  integer:: stat       ! 顼
  character(80):: cbuf ! read/write ʸΥХåե
continue
  ni = 0;  nr = 0;  nd = 0;  nl = 0;  ns = 0;  nc = 0;  na = 0;  nn = 0
  unit = ""
  ucur = 0
  endp = 0
  MainLoop: do
    cur = endp + 1
    if (cur > len(fmt)) exit MainLoop
    !
    ! ƥž̤Ǥʸ fmt(cur:endp-1) ȯ
    !
    endp = cur - 1 + scan(fmt(cur: ), '%')
    if (endp > cur) then
      call append(unit, ucur, fmt(cur:endp-1), stat)
      if (stat /= 0) exit MainLoop
    else if (endp == cur - 1) then
      call append(unit, ucur, fmt(cur: ), stat)
      exit MainLoop
    endif
    !
    ! % 񼰻ʸޤǤ fmt(cur:endp) Ȥ
    !
    cur = endp + 1
    endp = cur - 1 + scan(fmt(cur: ), 'DdOoXxFfRrBbYySsCcAa%')
    if (endp < cur) then
      call append(unit, ucur, fmt(cur-1: ), stat)
      exit MainLoop
    endif
    cbuf = fmt(cur:endp-1)
    !
    ! %* 硢n(:) Ϥ줿鷫֤
    !
    if (cbuf(1:1) == '*') then
      nn = nn + 1
      if (nn > size(n)) then
        repeat = 1
      else
        repeat = n(nn)
      endif
    else if (cbuf == '') then
      repeat = 1
    else
      ptr = verify(cbuf, " 0123456789")
      if (ptr > 0) cbuf(ptr: ) = " "
      read(cbuf, "(I80)", iostat=ptr) repeat
    endif
    PercentRepeat: do, m = 1, repeat
      if (m > 1) then
        call append(unit, ucur, ", ", stat)
        if (stat /= 0) exit MainLoop
      endif
      select case(fmt(endp:endp))
      case('d', 'D')
        if (.not. present(i)) cycle MainLoop
        ni = ni + 1;  if (ni > size(i)) cycle MainLoop
        write(cbuf, "(i20)") i(ni)
        call append(unit, ucur, trim(adjustl(cbuf)), stat)
        if (stat /= 0) exit MainLoop
      case('o', 'O')
        if (.not. present(i)) cycle MainLoop
        ni = ni + 1;  if (ni > size(i)) cycle MainLoop
        write(cbuf, "(o20)") i(ni)
        call append(unit, ucur, trim(adjustl(cbuf)), stat)
        if (stat /= 0) exit MainLoop
      case('x', 'X')
        if (.not. present(i)) cycle MainLoop
        ni = ni + 1;  if (ni > size(i)) cycle MainLoop
        write(cbuf, "(z20)") i(ni)
        call append(unit, ucur, trim(adjustl(cbuf)), stat)
        if (stat /= 0) exit MainLoop
      case('f', 'F')
        if (.not. present(d)) cycle MainLoop
        nd = nd + 1;  if (nd > size(d)) cycle MainLoop
        write(cbuf, "(g80.40)") d(nd)
        cbuf = adjustl(cbuf)
        ptr = verify(cbuf, " 0", back=.TRUE.)
        if (ptr > 0) cbuf(ptr+1: ) = " "
        call append(unit, ucur, trim(adjustl(cbuf)), stat)
        if (stat /= 0) exit MainLoop
      case('r', 'R')
        if (.not. present(r)) cycle MainLoop
        nr = nr + 1;  if (nr > size(r)) cycle MainLoop
        write(cbuf, "(g80.40)") r(nr)
        cbuf = adjustl(cbuf)
        ptr = verify(cbuf, " 0", back=.TRUE.)
        if (ptr > 0) cbuf(ptr+1: ) = " "
        call append(unit, ucur, trim(adjustl(cbuf)), stat)
        if (stat /= 0) exit MainLoop
      case('b', 'B')
        if (.not. present(L)) cycle MainLoop
        nl = nl + 1;  if (nl > size(L)) cycle MainLoop
        write(cbuf, "(L1)") L(nl)
        call append(unit, ucur, trim(adjustl(cbuf)), stat)
        if (stat /= 0) exit MainLoop
      case('y', 'Y')
        if (.not. present(L)) cycle MainLoop
        nl = nl + 1;  if (nl > size(L)) cycle MainLoop
        if (L(nl)) then
          call append(unit, ucur, "yes", stat)
          if (stat /= 0) exit MainLoop
        else
          call append(unit, ucur, "no", stat)
          if (stat /= 0) exit MainLoop
        endif
      case('s', 'S')
        if (.not. present(S)) cycle MainLoop
        ns = ns + 1;  if (ns > size(S)) cycle MainLoop
        call append(unit, ucur, s(ns)%body(1: s(ns)%len), stat)
        if (stat /= 0) exit MainLoop
      case('c', 'C')
        nc = nc + 1
        if (nc == 1) then
          if (.not. present(c1)) cycle PercentRepeat
          call append(unit, ucur, c1, stat)
          if (stat /= 0) exit MainLoop
        else if (nc == 2) then
          if (.not. present(c2)) cycle PercentRepeat
          call append(unit, ucur, c2, stat)
          if (stat /= 0) exit MainLoop
        else if (nc == 3) then
          if (.not. present(c3)) cycle PercentRepeat
          call append(unit, ucur, c3, stat)
          if (stat /= 0) exit MainLoop
        endif
      case('a', 'A')
        if (.not. present(ca)) cycle MainLoop
        na = na + 1;  if (na > size(ca)) cycle MainLoop
        call append(unit, ucur, trim(adjustl(ca(na))), stat)
        if (stat /= 0) exit MainLoop
      case('%')
        call append(unit, ucur, '%', stat)
        if (stat /= 0) exit MainLoop
      end select
    enddo PercentRepeat
  enddo MainLoop
  return
contains

  subroutine append(unitx, ucur, val, stat)
    !
    ! unitx  val ղáκݡunitx κʸĹۤ
    ! ˤ stat = 2 ֤
    !
    character(*), intent(inout):: unitx ! ǽŪ֤ʸ
    integer,      intent(inout):: ucur ! unitx ʸ
    character(*), intent(in)   :: val  ! unitx ղäʸ
    integer,      intent(out)  :: stat ! ơ
    integer                    :: wrsz ! val ʸ
    continue
    ! unitx κĹۤˤ stat = 2 ֤
    if (ucur >= len(unitx)) then
      stat = 2
      ! ν
    else
      ! unitx Ĺۤθ unitx  val ղä롣
      wrsz = min(len(val), len(unitx) - ucur)
      unitx(1+ucur: wrsz+ucur) = val(1: wrsz)
      ucur = ucur + wrsz
      stat = 0
      if (wrsz < len(val)) stat = 1
    endif
  end subroutine append

end subroutine DCStringSPrintf
