!= 顼
!
!= Error handling
!
! Authors::   Eizi TOYODA, Yasuhiro MORIKAWA
! Version::   $Id: dc_error.f90,v 1.16 2007/06/16 06:20:25 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20070615 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
module dc_error
  !
  != 顼ѥ⥸塼
  !
  != Error handling module
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ץʤɬ顼μ갷Τ˵ꤹ٤ΤǤ
  ! 顼ȤʤؤϤŬڤǤȤ
  ! Ԥư򤹤뤳ȤǤʤȤä֤ؤޤ
  !
  ! gt4f90io 饤֥꤬桼󶡤³
  ! (³Ȥϥ֥롼ޤϴؿ) ϤۤȤɤξ硢
  ! ʲ 2 ĤΤ줫ǸƤӽФ˥顼𤷤ޤ
  !
  ! * 顼ȯŬڤʥåɽƥץཪλ
  ! * ξάǤ *err* Ϳ줿ϡ
  !   顼ˤϤ <tt>.true.</tt> ˤޤ
  !   err ά줿ϾƱ
  !
  ! νϤ٤ *dc_error* ⥸塼 *StoreError*
  ! ֥롼ǹԤäƤޤѻͤʤɤ˴ؤƤ *StoreError*
  ! 򻲾ȤƤ
  !
  !
  ! Error handling about parts of programs should be regulated definitely.
  ! Error means that input to the part of program is invalid, or
  ! expected operation can not be done, etc.
  !
  ! Procedures (procedures is generic name of subroutines and functions)
  ! provided to users by gt4f90io library almost report error to invoker
  ! in the following two manner.
  !
  ! * When error occurs, the program display appropriate messages and 
  !   aborts.
  ! * If logical optional argument *err* is given, the argument *err* become
  !   <tt>.true.</tt> when error occurs. If *err* is abbreviated, 
  !   the operation is same as above.
  !
  ! *StoreError* subroutine in *dc_error* module handle above all operations.
  ! See *StoreError* about the interfase of it.
  !
  !
  !== 顼ɰ
  !== Error code list
  !
  ! gt4f90io 饤֥˥ɤɲäץޤŬڤ
  ! 顼ɤ *StoreError* ƤӽФ褦ˤʤФʤޤ
  ! ǡ 顼ɤɬפ뤫ɤ
  ! Ƚꤹ뤿ˡ 顼ɤͤбå
  ! ʲ˰ޤ
  ! 顼ɥˡ˥åѤ뤿ˤϡ
  ! <b><tt>NF_E</tt></b> ǻϤޤ̾ˤĤƤ netcdf_f77
  ! ⥸塼Ѥ뤫 include 'netcdf.inc' ԤʸԤϿ侩ޤˡ
  ! <b><tt>GT_E</tt></b> ޤ <b><tt>DC_E</tt></b> 
  ! ǻϤޤ̾ˤĤƤ dc_error ⥸塼ѤƤ
  ! ޤ <b><tt>USR_ERRNO</tt></b> ֤꾮ͤϡ
  ! ơΥ桼Ŭ顼ɤ
  ! Ѥ뤿˶Ƥޤ
  !
  ! 顼ǤϤʤ֤ɽ󥨥顼ɤ *DC_NOERR* Ǥ
  !
  ! 顼ɤοͤߤΤϡʥ顼ɤ
  ! Ƥݤλؿˤ򼨤Ǥ
  ! ɤˤϥ顼ɤˡ˥åͿ٤Ǥꡢ
  ! ͤϡɥɤ뤳Ȥϸ˿ǲ
  !
  !
  ! Programmers who add codes to gt4f90io library must call 
  ! *StoreError* with appropriate error code. 
  ! And so values of error code and corresponding messages are listed 
  ! as follows to figure out if a new error code is needed to declared. 
  ! To use error codes mnemonic, 
  ! require "netcdf_f77" module or include "netcdf.inc" (deprecated) 
  ! about error codes with prefix <b><tt>NF_E</tt></b>, or 
  ! require "dc_error" module 
  ! about error codes with prefix <b><tt>GT_E</tt></b> and 
  ! <b><tt>DC_E</tt></b>. 
  ! Error codes smaller than <b><tt>USR_ERRNO</tt></b> are saved 
  ! as user-defined error codes.
  !
  ! Non error code that indicates normal (error-free) situation is 
  ! *DC_NOERR*.
  !
  ! List of numerical values of error codes 
  ! issues a guideline about declaration of new error codes. 
  ! Give not numerical value but mnemonic of error code to source code.
  !
  !=== Ѥʤ
  !=== Unused codes
  !
  ! ͤϥ顼ɤȤƻѤޤ
  !
  ! NetCDF 饤֥ libc Υ顼 errno ֤ǽꡢ
  ! errno οͤˤϰܿʤᡢƤͤ errno
  ! λͤΤͽ󤵤Ƥ٤Ǥ
  !
  ! Positive integer is not used as error codes.
  !
  ! NetCDF library might return "libc" error code "error". 
  ! Numerical value of "errno" is no portable, so positive integer 
  ! should be reserved for "errno".
  !
  !=== 󥨥顼
  !=== Non error code
  !
  ! ʲ󥨥顼ɤ˴ؤƤ dc_error ⥸塼Ѥ뤳Ȥ
  ! ѤƤ
  !
  ! Use following non error code by refering this "dc_error" module. 
  !
  ! <b>. Number</b> :: <b>  [ ˡ˥å. Mnemonic ]</b>
  !
  ! 0       :: [ <b>DC_NOERR       </b> ]
  !
  !
  !=== netCDF ˴ؤ륨顼
  !=== Error codes for netCDF
  !
  ! ʲΥ顼ɤ˴ؤƤ netcdf_f77 ⥸塼Ѥ뤳Ȥ
  ! ѤƤ
  !
  ! Use following error codes by refering this "netcdf_f77" module. 
  !
  ! <b>. Number</b> :: <b>  [ ˡ˥å. Mnemonic ] 顼å. Error message</b>
  !
  ! 0       :: [ <b>NF_NOERR       </b> ]
  !            <b></b> :: No Error  (󥨥顼ɤǤ)
  !
  ! -33     :: [ <b>NF_EBADID      </b> ]
  !            <b></b> :: Not a netCDF id:
  !
  ! -34     :: [ <b>NF_ENFILE      </b> ] 
  !            <b></b> :: Too many netCDF files open:
  !
  ! -35     :: [ <b>NF_EEXIST      </b> ] 
  !            <b></b> :: netCDF file exists && NC_NOCLOBBER:
  !
  ! -36     :: [ <b>NF_EINVAL      </b> ] 
  !            <b></b> :: Invalid argument:
  !
  ! -37     :: [ <b>NF_EPERM       </b> ] 
  !            <b></b> :: Write to read only:
  !
  ! -38     :: [ <b>NF_ENOTINDEFINE</b> ] 
  !            <b></b> :: Operation not allowed in data mode
  !
  ! -39     :: [ <b>NF_EINDEFINE   </b> ] 
  !            <b></b> :: Operation not allowed in define mode
  !
  ! -40     :: [ <b>NF_EINVALCOORDS</b> ] 
  !            <b></b> :: Index exceeds dimension bound
  !
  ! -41     :: [ <b>NF_EMAXDIMS    </b> ] 
  !            <b></b> :: NC_MAX_DIMS exceeded
  !
  ! -42     :: [ <b>NF_ENAMEINUSE  </b> ] 
  !            <b></b> :: String match to name in use
  !
  ! -43     :: [ <b>NF_ENOTATT     </b> ] 
  !            <b></b> :: Attribute not found
  !
  ! -44     :: [ <b>NF_EMAXATTS    </b> ] 
  !            <b></b> :: NC_MAX_ATTRS exceeded
  !
  ! -45     :: [ <b>NF_EBADTYPE    </b> ] 
  !            <b></b> :: Not a netCDF data type or _FillValue type mismatch
  !
  ! -46     :: [ <b>NF_EBADDIM     </b> ] 
  !            <b></b> :: Invalid dimension id or name
  !
  ! -47     :: [ <b>NF_EUNLIMPOS   </b> ] 
  !            <b></b> :: NC_UNLIMITED in the wrong index
  !
  ! -48     :: [ <b>NF_EMAXVARS    </b> ] 
  !            <b></b> :: NC_MAX_VARS exceeded
  !
  ! -49     :: [ <b>NF_ENOTVAR     </b> ] 
  !            <b></b> :: Variable not found
  !
  ! -50     :: [ <b>NF_EGLOBAL     </b> ] 
  !            <b></b> :: Action prohibited on NC_GLOBAL varid
  !
  ! -51     :: [ <b>NF_ENOTNC      </b> ] 
  !            <b></b> :: Not a netCDF file
  !
  ! -52     :: [ <b>NF_ESTS        </b> ] 
  !            <b></b> :: In Fortran, string too short
  !
  ! -53     :: [ <b>NF_EMAXNAME    </b> ] 
  !            <b></b> :: NC_MAX_NAME exceeded
  !
  ! -54     :: [ <b>NF_EUNLIMIT    </b> ] 
  !            <b></b> :: NC_UNLIMITED size already in use
  !
  ! -55     :: [ <b>NF_ENORECVARS  </b> ] 
  !            <b></b> :: NC_rec op when there are no record vars
  !
  ! -56     :: [ <b>NF_ECHAR       </b> ] 
  !            <b></b> :: Attempt to convert between text & numbers
  !
  ! -57     :: [ <b>NF_EEDGE       </b> ] 
  !            <b></b> :: Edge+start exceeds dimension bound
  !
  ! -58     :: [ <b>NF_ESTRIDE     </b> ] 
  !            <b></b> :: Illegal stride
  !
  ! -59     :: [ <b>NF_EBADNAME    </b> ] 
  !            <b></b> :: Attribute or variable name contains illegal characters
  !
  ! -60     :: [ <b>NF_ERANGE      </b> ] 
  !            <b></b> :: Numeric conversion not representable
  !
  ! -61     :: [ <b>NF_ENOMEM      </b> ] 
  !            <b></b> :: Memory allocation (malloc) failure
  !
  ! -62-99:: <b>               </b>
  !            <b></b> :: ( netCDF γĥΤ gt4f90io ͽΰ.
  !                       Reserved area for future extensions of netCDF)
  !
  !=== gt4f90io Υǡ¤ (gtdata) ˴ؤ륨顼
  !=== Error codes for data structure of gt4f90io (gtdata)
  !
  ! ʲΥ顼ɤ˴ؤƤ dc_error ⥸塼Ѥ뤳Ȥ
  ! ѤƤ
  !
  ! Use following error codes by refering this "dc_error" module. 
  !
  ! <b>. Number</b> :: <b>  [ ˡ˥å. Mnemonic ] 顼å. Error message</b>
  !
  ! -100    :: [ <b>GT_EFAKE           </b> ]
  !            <b></b> :: function not implemented
  !
  ! -101    :: [ <b>GT_ENOMOREDIMS     </b> ]
  !            <b></b> :: dimension number %d is out of range
  !
  ! -102    :: [ <b>GT_EDIMNODIM       </b> ]
  !            <b></b> :: dimension variable has no dimension
  !
  ! -103    :: [ <b>GT_EDIMMULTIDIM    </b> ]
  !            <b></b> :: dimension variable has many dimensions
  !
  ! -104    :: [ <b>GT_EDIMOTHERDIM    </b> ]
  !            <b></b> :: dimension variable has another dimension
  !
  ! -105    :: [ <b>GT_EBADDIMNAME     </b> ]
  !            <b></b> :: <i>cause_c</i>: unknown dimension name
  !
  ! -106    :: [ <b>GT_ENOTVAR         </b> ]
  !            <b></b> :: variable not opened
  !
  ! -107    :: [ <b>GT_ENOMEM          </b> ]
  !            <b></b> :: allocate/deallocate error
  !
  ! -108    :: [ <b>GT_EOTHERFILE      </b> ]
  !            <b></b> :: specified dimensional variable not on the same file
  !
  ! -109    :: [ <b>GT_EARGSIZEMISMATCH</b> ]
  !            <b></b> :: arguments (<i>cause_c</i>) array size mismatch
  !
  ! -110    :: [ <b>GT_ENOMATCHDIM     </b> ]
  !            <b></b> :: dimension matching failed
  !
  ! -111    :: [ <b>GT_ELIMITED        </b> ]
  !            <b></b> :: variable already limited
  !
  ! -112    :: [ <b>GT_EBADVAR         </b> ]
  !            <b></b> :: variable type not supported
  !
  ! -113    :: [ <b>GT_ECHARSHORT      </b> ]
  !            <b></b> :: character length not enough
  !
  ! -114    :: [ <b>GT_ENOUNLIMITDIM   </b> ]
  !            <b></b> :: NC_UNLIMITED dimension is not found
  !
  ! -115    :: [ <b>GT_EBADATTRNAME    </b> ]
  !            <b></b> :: invalid attribute name
  !
  ! -116    :: [ <b>GT_EBADHISTORY     </b> ]
  !            <b></b> :: invalid GT_HISTORY variable
  !
  ! -117    :: [ <b>GT_EBADALLOCATESIZE</b> ]
  !            <b></b> :: invalid allocated size
  !
  ! -118    :: [ <b>GT_ERANKMISMATCH</b> ]
  !            <b></b> :: rank of data and argument is mismatch (<i>cause_c</i>)
  !
  ! -299  :: <b>                     </b>
  !            <b></b> :: ( gtdata ؤγĥΤͽ.
  !                       Reserved area for future extensions of gtdata layer)
  !
  !=== GrADS ǡϤ˴ؤ륨顼
  !=== Error codes for GrADS data I/O
  !
  ! ʲΥ顼ɤ˴ؤƤ dc_error ⥸塼Ѥ뤳Ȥ
  ! ѤƤ
  !
  ! Use following error codes by refering this "dc_error" module. 
  !
  ! <b>. Number</b> :: <b>  [ ˡ˥å. Mnemonic ] 顼å. Error message</b>
  !
  ! -300    :: [ <b>GR_ENOTGR          </b> ]
  !            <b></b> :: invalid GrADS file
  !
  ! -399  :: <b>                     </b>
  !            <b></b> :: ( GrADS data ؤγĥΤͽ.
  !                       Reserved area for future extensions of GrADS data I/O layer)
  !
  !=== DC 桼ƥƥѥ顼
  !=== Error codes for DC utilities
  !
  ! ʲΥ顼ɤ˴ؤƤ dc_error ⥸塼Ѥ뤳Ȥ
  ! ѤƤ
  !
  ! Use following error codes by refering this "dc_error" module. 
  !
  ! <b>. Number</b> :: <b>  [ ˡ˥å. Mnemonic ] 顼å. Error message</b>
  !
  ! -400    :: [ <b>DC_ENOTINIT          </b> ]
  !            <b></b> :: object (<i>cause_c</i>) is not initialized
  !
  ! -401    :: [ <b>DC_EALREADYINIT      </b> ]
  !            <b></b> :: object (<i>cause_c</i>) is already initialized
  !
  ! -402    :: [ <b>DC_EBADUNIT</b> ]
  !            <b></b> :: unit (<i>cause_c</i>) is invalid
  !
  ! -403    :: [ <b>DC_EBADCALTYPE</b> ]
  !            <b></b> :: calendar type (<i>cause_i</i>) is invalid
  !
  ! -404    :: [ <b>DC_EBADTIMEZONE</b> ]
  !            <b></b> :: time zone (<i>cause_c</i>) is invalid
  !
  ! -405-499  :: <b>                     </b>
  !                <b></b> :: ( DC 桼ƥƥγĥΤͽ.
  !                           Reserved area for future extensions of DC utilities)
  !
  !=== gt4f90io ξγĥΤͽ󤷤Ƥ륨顼
  !=== Reserved error codes for future extensions of gt4f90io
  !
  ! ʲΥ顼ɤϺγĥͤͽ󤷤ƤʬǤ
  !
  ! Following error codes are reserved for future extensions.
  !
  ! <b>. Number</b> :: <b>  [ ˡ˥å. Mnemonic ] 顼å. Error message</b>
  !
  ! -500-999  :: <b>                     </b>
  !                <b></b> :: ( gt4f90io γĥΤͽ.
  !                           Reserved area for future extensions of gt4f90io)
  !
  !=== 桼ѥ顼
  !=== User-defined error codes
  !
  ! -1000 ⾮顼ɤϡ
  ! gt4f90io ξ̤ΥץबѤ륨顼ɤȤƶƤޤ
  !
  ! Error codes smaller than -1000 are saved for as user-defined error codes 
  ! used by upper programs.
  !
  ! <b>. Number</b> :: <b>  [ ˡ˥å. Mnemonic ] 顼å. Error message</b>
  !
  ! -1000 :: [ <b>USR_ERRNO           </b> ]
  !            <b></b> :: <i>cause_c</i> (<i>cause_i</i>)
  !

  use netcdf_f77, only: NF_ENOTVAR, NF_EINVAL
  implicit none
  private
  public :: NF_ENOTVAR, NF_EINVAL

  ! 顼ݻ

  integer, public, parameter   :: DC_NOERR  = 0
  integer, private, save       :: errno     = DC_NOERR
  integer, private, save       :: cause_int = DC_NOERR
  logical, private, save       :: cause_int_valid = .false.
  character(80), private, save :: cause_string = ""
  character(80), private, save :: cause_location = ""

  ! Υ顼ֹ libc ƥ२顼åΤ
  ! Ƥ롣ƥ¸礭礭ʿͤ
  ! ѤΤǶΰݤΤϺǤ롣
  !
  ! Υ顼ֹ netCDF ȤäƤ롣γĥ⸫ǡ
  ! -99 ޤǤϻȤʤ֤

  integer, parameter, public:: GT_EFAKE = -100

  !
  ! -101 ʲ: ǡ¤Υ顼
  !
  integer, parameter, public:: GT_ENOMOREDIMS      = -101
  integer, parameter, public:: GT_EDIMNODIM        = -102
  integer, parameter, public:: GT_EDIMMULTIDIM     = -103
  integer, parameter, public:: GT_EDIMOTHERDIM     = -104
  integer, parameter, public:: GT_EBADDIMNAME      = -105
  integer, parameter, public:: GT_ENOTVAR          = -106
  integer, parameter, public:: GT_ENOMEM           = -107
  integer, parameter, public:: GT_EOTHERFILE       = -108
  integer, parameter, public:: GT_EARGSIZEMISMATCH = -109
  integer, parameter, public:: GT_ENOMATCHDIM      = -110
  integer, parameter, public:: GT_ELIMITED         = -111
  integer, parameter, public:: GT_EBADVAR          = -112
  integer, parameter, public:: GT_ECHARSHORT       = -113
  integer, parameter, public:: GT_ENOUNLIMITDIM    = -114
  integer, parameter, public:: GT_EBADATTRNAME     = -115
  integer, parameter, public:: GT_EBADHISTORY      = -116
  integer, parameter, public:: GT_EBADALLOCATESIZE = -117
  integer, parameter, public:: GT_ERANKMISMATCH    = -118

  !
  ! -300 ʲ: GrADS ϤΥ顼
  !
  integer, parameter, public:: GR_ENOTGR = -300

  !
  ! -400 ʲ: dc 桼ƥƥΥ顼
  !
  integer, parameter, public:: DC_ENOTINIT     = -400
  integer, parameter, public:: DC_EALREADYINIT = -401
  integer, parameter, public:: DC_EBADUNIT     = -402
  integer, parameter, public:: DC_EBADCALTYPE  = -403
  integer, parameter, public:: DC_EBADTIMEZONE = -404

  !
  ! -1000 ʲ: 桼
  !
  integer, parameter, public:: USR_ERRNO = -1000

  public:: StoreError, DumpError, GetErrorMessage, ErrorCode
  !
  ! === ³ѻ ===
  !
  ! 캹ؤ褦˳ؿˤƤ

  interface
    subroutine DumpError()
    end subroutine DumpError
  end interface

contains

  integer function ErrorCode() result(result)
    !
    ! ꤵƤ륨顼ɤ֤ޤ
    !
    ! Return an error code specified currently.
    !
    result = errno
  end function ErrorCode

  subroutine GetErrorMessage(msg)
    !
    ! ꤵƤ륨顼ɤбå֤ޤ
    !
    ! Return messages corresponding to an error code specified currently.
    !
    use netcdf_f77, only: nf_strerror
    character(len = *), intent(out):: msg
    character(len = 180):: message
    character(len = 20):: errno_c
    character(len = 20):: cause_int_c
  continue
    select case(errno)
    case(GT_EFAKE)
      msg = " function not implemented"
      !
      ! -101 ʲ: ǡ¤Υ顼
      ! -101 or less: Error of data structure
      !
    case(GT_ENOMOREDIMS)
      write(message, "(': dimension number', i4, ' is out of range')") cause_int
      msg = trim(message)
    case(GT_EBADDIMNAME)
      msg = '(' // trim(cause_string) // '): unknown dimension name'
    case(GT_ENOTVAR)
      msg = " variable not opened"
    case(GT_ENOMEM)
      msg = " allocate/deallocate error"
    case(GT_EDIMNODIM)
      msg = " dimension variable has no dimension"
    case(GT_EDIMMULTIDIM)
      msg = " dimension variable has many dimensions"
    case(GT_EDIMOTHERDIM)
      msg = " dimension variable has another dimension"
    case(GT_EOTHERFILE)
      msg = " specified dimensional variable not on the same file"
    case(GT_EARGSIZEMISMATCH)
      msg = " arguments (" // trim(cause_string) //") array size mismatch"
    case(GT_ENOMATCHDIM)
      msg = " dimension matching failed"
    case(GT_ELIMITED)
      msg = " variable already limited"
    case(GT_EBADVAR)
      msg = " variable type not supported"
    case(GT_ECHARSHORT)
      msg = " character length not enough"
    case(GT_ENOUNLIMITDIM)
      msg = " NC_UNLIMITED dimension is not found"
    case(GT_EBADATTRNAME)
      msg = " invalid attribute name"
    case(GT_EBADALLOCATESIZE)
      msg = " invalid allocated size"
    case(GT_ERANKMISMATCH)
      msg = " rank of data and argument are mismatch (" // trim(cause_string) // ")"
      !
      ! -300 ʲ: GrADS ϤΥ顼
      ! -300 or less: Error of GrADS I/O
      !
    case(GR_ENOTGR)
      msg = " invalid GrADS file"
      !
      ! -400 ʲ: DC 桼ƥƥΥ顼
      ! -400 or less: Error of DC utilities
      !
    case(DC_ENOTINIT)
      msg = " object (" // trim(cause_string) //") is not initialized"
    case(DC_EALREADYINIT)
      msg = ' object (' // trim(cause_string) // ') is already initialized'
    case(DC_EBADUNIT)
      msg = " unit (" // trim(cause_string) //") is invalid"
    case(DC_EBADCALTYPE)
      write(message, "(' calendar type (', i4, ') is invalid')") cause_int
      msg = trim(message)
    case(DC_EBADTIMEZONE)
      msg = " time zone (" // trim(cause_string) //") is invalid"
      !
      ! -1000 ʲ: 桼
      ! -1000 or less: User-defined error
      !
    case(:USR_ERRNO)
      if (len(trim(adjustl(cause_string))) < 1) then
        cause_string = 'Unknown error'
      end if
      if (cause_int_valid) then
        write(cause_int_c, "(i8)") cause_int
        msg = trim(cause_string) // ' (' // trim(adjustl(cause_int_c)) // ')'
      else
        msg = trim(cause_string)
      end if
    case default
      goto 999
    end select
    write(errno_c, "(i8)") errno
    msg =  '*** ERROR (Code ' // trim(adjustl(errno_c))  // &
      & ') [' // trim(cause_location) // '] ***  ' // &
      & trim(msg)
    return

999 continue
    if (len(cause_string) > 0) then
      message = nf_strerror(errno)
      write(errno_c, "(i8)") errno
      msg =  '*** ERROR (Code ' // trim(adjustl(errno_c)) // &
        & ') [' // trim(cause_location)             // &
        & '('   // trim(cause_string) // ')] ***  ' // &
        & trim(message)
    else if (cause_int_valid) then
      message = nf_strerror(errno)
      write(errno_c, "(i8)") errno
      write(cause_int_c, "(i8)") cause_int
      msg =  '*** ERROR (Code ' // trim(adjustl(errno_c)) // &
        & ') [' // trim(cause_location)             // &
        & '('   // trim(adjustl(cause_int_c)) // ')] ***  ' // &
        & trim(message)
    else
      message = nf_strerror(errno)
      write(errno_c, "(i8)") errno
      msg =  '*** ERROR (Code ' // trim(adjustl(errno_c))  // &
        & ') [' // trim(cause_location) // '] ***  ' // &
        & trim(message)
    endif
  end subroutine GetErrorMessage

  subroutine StoreError(number, where, err, cause_c, cause_i)
    !
    !== ŵŪ饤֥³Τ˺줿顼֥롼
    !== Error handling subroutine for typical procedures of library
    !
    ! ɬפʰ2ĤǤꡢ1 *number* ˤΥ顼ɡ
    ! 2 *where* ˤʸǥ顼ȯ³̾Ϳޤ
    ! ǥեȤǤϰʲηʸɸϤɽƥץ
    ! Ͻλޤ 顼å error_message
    ! ϥ顼ɤ鼫ưŪ˷ޤޤ
    ! бɽ顼ɰˤΤǻȤƤ
    !
    ! Number of necessary arguments is two. Give integer error code 
    ! to first argument *number*, and procedure name where the error
    ! occurs to second argument *where*. By default, like a following 
    ! string is displayed to standard output, and the program aborts
    ! Error message <error_message> is determined by error code automatically.
    ! See error code list.
    !
    !     
    !     *** ERROR (Code number) [where] ***  error_message
    !     
    !     *** ERROR (Code number) [where(cause_c)] ***  error_message
    !
    ! ʤgt4f90io Υ饤֥곰桼顼ѥġ
    ! Ȥ StoreError Ѥ뤳Ȥꤷ<b><tt>USR_ERRNO</tt></b> 
    ! ֤꾮
    ! 顼ɤ϶Ƥޤ<b><tt>USR_ERRNO</tt></b>
    ! 꾮ͤ򥨥顼ɤͿ,
    ! StoreError ϰʲηʸɸϤ˽Ϥƥץ
    ! λޤ°פ˻ȤåϤӥ顼ȯ
    ! Υ⥸塼Ȥ *dc_message* ѰդƤΤ
    ! ⻲ȤƤ
    !
    ! In addition, for usage that users call StoreError as an error 
    ! handling tool from the outside of gt4f90io library, 
    ! error codes smaller than <b><tt>USR_ERRNO</tt></b> is saved.
    ! When error codes smaller than <b><tt>USR_ERRNO</tt></b> is given,
    ! StoreError displays like a following string to standard output, 
    ! and stops the program.
    ! *dc_message* module is prepared too. This module can be used 
    ! more easily for message output and rise of error.
    !
    !     
    !     *** ERROR (Code number) [where] ***  cause_c
    !     
    !     *** ERROR (Code number) [where] ***  cause_c (cause_i)
    !
    !--
    !== ȯԸ
    !
    ! 顼ֹ number  errno ˳Ǽ롣ƱտŪ
    ! where, cause_i  cause_location, cause_string,
    ! cause_int ˳Ǽ롣 
    ! err ͿƤ硢err  number  DC_NOERR ξˤʤ롣
    ! number  DC_NOERR ʤ¨롣
    ! err ͿƤʤХ顼å * ˽Ϥ
    ! ץλ롣
    !++

    integer,            intent(in)            :: number
                              ! 顼ɡ 
                              ! Error code
    character(len = *), intent(in)            :: where
                              ! 顼ȯĽꡣ 
                              ! Place where error occurs
    logical,            intent(out), optional :: err
                              ! 㳰ѥե饰
                              ! ǥեȤǤϡ*number* 󥨥顼
                              ! ʳͤͿ줿硢顼å
                              ! ɽƥץ϶λޤ
                              !  *err* Ϳ硢
                              ! ץ϶λ
                              ! *err*  .true. ޤ
                              !
                              ! Exception handling flag. 
                              ! By default, when error code (excluding 
                              ! non error code) is given to *number*, 
                              ! the program display error message and aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    character(len = *), intent(in),  optional :: cause_c
                              ! ʸå 
                              ! Character message
    integer,            intent(in),  optional :: cause_i
                              ! å 
                              ! Integer message
  continue
    errno = number
    cause_location = where
    if (present(cause_c)) then
      cause_string = trim(cause_c)
    else
      cause_string = ""
    endif
    if (present(cause_i)) then
      cause_int = cause_i
      cause_int_valid = .true.
    else
      cause_int_valid = .false.
    end if
    if (present(err)) then
      err = (number /= DC_NOERR)
      return
    endif
    if (number == DC_NOERR) return
    call DumpError
  end subroutine StoreError

end module dc_error

subroutine DumpError()
  !
  ! GetErrorMessage 饨顼å塢
  !  sysdep#AbortProgram Ϥƥץλޤ
  !
  ! Get error messages from "GetErrorMessage", and put the messages 
  ! to sysdep#AbortProgram, and stop the program.
  !
  use dc_types, only: STRING
  use dc_error, only: GetErrorMessage
  use sysdep, only: AbortProgram
  character(len = STRING):: message
continue
  call GetErrorMessage(message)
  call AbortProgram(message)
end subroutine DumpError
