!== dc_message.f90 - åν
!
! Authors::   Yasuhiro MORIKAWA, Masatsugu ODAKA
! Version::   $Id: dc_message.f90,v 1.4 2007/01/08 06:30:37 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20070629 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! This file provides dc_message
!

module dc_message
  !
  !== Overview
  !
  !åνϤԤΥ֥롼󷲤ĥ⥸塼Ǥ
  !{dcl  MSGDMP.f}[http://www.gfd-dennou.org/arch/dcl/dcl-f77doc/rc1/math1/node26.html]
  !ξ̸ߴȤƤѤ뤳ȤꤷƤޤ
  !ߡ֤ɸϤ˸ꤵƤޤ
  !
  !
  !== Output Form
  !
  ! ܥ⥸塼Υ֥롼ˤäưʲΤ褦ʷΥå
  ! Ϥޤ
  !
  !    
  !    *** MESSAGE [where] ***  message
  !    
  !    *** WARNING [where] ***  message
  !    
  !    *** ERROR (Code number) [where] *** message
  !



  private
  public:: MessageNotify

  interface MessageNotify
    module procedure MessageNotifyC
    module procedure MessageNotifyI
  end interface

contains

  subroutine MessageNotifyC(level, where, message, &
    & i, r, d, L, n, c1, c2, c3)
    !
    !=== åνϤӥ顼ˤ뽪λ
    !
    ! åɸϤؽϤѤޤ
    !
    ! ʸѿ where ˤϥץ̾ (֥롼̾) ʤɡ
    ! ץΤɤǥåϤΤ򼨤ΤͿޤ
    !
    ! ʸѿ message ˤϡϤʸͿޤ
    ! ץѿ i, r, d, L, s, n, c1, c2, c3 ղäޤ
    ! ܺ٤˴ؤƤ dc_string#CPrintf 򻲾ȤƲ
    !
    ! ʸѿ level ϽϤåμǡ
    ! <b><tt>"W"</tt></b> (ޤ<b><tt>"Warning"</tt></b>
    ! ʤ <b><tt>"W"</tt></b> ǻϤޤʸ)
    ! Ϳ<b>ٹ</b>Ǥ뤳Ȥ
    ! <b><tt>"E"</tt></b> (ޤ<b><tt>"Error"</tt></b>
    ! ʤ <b><tt>"E"</tt></b> ǻϤޤʸ) Ϳ
    ! <b>顼 (åϸץλ) </b>Ǥ뤳Ȥ
    ! ʳʸ ( <b><tt>"M"</tt></b>
    ! Ϳ뤳ȤꤷƤޤ)
    ! Ϳ<b>̾Υå</b>Ǥ뤳Ȥꤷޤ
    ! <b><tt>"E"</tt></b>Ϳϥåϸ塢ץ
    ! λޤ顼ɤ dc_error#USR_ERRNO Ȥʤޤ
    !

    use dc_types  ,only: STRING, DP
    use dc_string ,only: UChar, StrHead, Printf, CPrintf
    use dc_error  ,only: StoreError, USR_ERRNO

    implicit none

    character(*), intent(in)          :: level ! "E", "W", "M" Τɤ줫Ϳ롣
    character(*), intent(in)          :: where ! ץ̾³̾
    character(*), intent(in)          :: message ! å
    integer     , intent(in), optional:: i(:), n(:)
    real        , intent(in), optional:: r(:)
    real(DP)    , intent(in), optional:: d(:)
    logical     , intent(in), optional:: L(:)
    character(*), intent(in), optional:: c1, c2, c3

    character(string)        :: msg
  continue

    if (   StrHead(  'ERROR', trim( UChar(level) )  )   ) then
      msg = Cprintf(message, &
        &           i=i, r=r, d=d, L=L, n=n, c1=c1, c2=c2, c3=c3)
      call StoreError(USR_ERRNO, where, cause_c=msg)

    elseif (   StrHead(  'WARNING', trim( UChar(level) )  )   ) then
      msg = Cprintf(message, &
        &           i=i, r=r, d=d, L=L, n=n, c1=c1, c2=c2, c3=c3)
      msg=' *** WARNING [' // trim(where) // '] ***  '// trim(msg)
      call Printf(fmt='%c', c1=msg)

    else
      msg = Cprintf(message, &
        &           i=i, r=r, d=d, L=L, n=n, c1=c1, c2=c2, c3=c3)
      msg=' *** MESSAGE [' // trim(where) // '] ***  ' // trim(msg)
      call Printf(fmt='%c', c1=msg)

    endif

    return
  end subroutine MessageNotifyC

  subroutine MessageNotifyI(number, where, message, &
    & i, r, d, L, n, c1, c2, c3)
    !
    !=== åνϤӥ顼ˤ뽪λ
    !
    ! Ūˤ⤦ MessageNotify (ޤ dc_message#MessageNotifyC)
    ! ƱͤǤ裱˿ͷѿ
    ! number Ȥޤ number ϥ顼ɤȤơ
    ! Τޤ dc_error#StoreError ˰Ϥޤ
    ! 顼ɤ˴ؤƤ (dc_error 򻲾Ȥ)
    !
    use dc_types  ,only: DP
    use dc_string ,only: CPrintf
    use dc_error  ,only: StoreError, USR_ERRNO

    implicit none

    integer,      intent(in)          :: number    ! 顼 (dc_error )
    character(*), intent(in)          :: where
    character(*), intent(in), optional:: message
    integer     , intent(in), optional:: i(:), n(:)
    real        , intent(in), optional:: r(:)
    real(DP)    , intent(in), optional:: d(:)
    logical     , intent(in), optional:: L(:)
    character(*), intent(in), optional:: c1, c2, c3

  continue

    if (.not. present(message)) then
      call StoreError(number, where)

    else
      call StoreError(number, where,  &
        &             cause_c=CPrintf( message, &
        &             i=i, r=r, d=d, L=L, n=n, c1=c1, c2=c2, c3=c3 )  )
    endif

    return
  end subroutine MessageNotifyI

end module dc_message
